#pragma once


namespace ActiveBasic{ namespace IDE{

/*
struct ImageReferenceType
{
	enum EnumType
	{
		File = 0,
		Resource,
	};
};

struct IMAGECTRLINFO
{
	ImageReferenceType::EnumType type;
	std::string path;
};
*/

}}


//C[W^Cv
#define IMGTYPE_FILE	0
#define IMGTYPE_RES		1

struct IMAGECTRLINFO{
	int type;
	char *path;
};

class CHILDINFO
{
public:
	char *IdName;
	POINT pos;
	SIZE size;
	char *caption;
	DWORD style;
	DWORD ExStyle;
	int Control;

	IMAGECTRLINFO ImageCtrlInfo;
};
class WindowInfo
{
public:
	WindowInfo()
		: caption( NULL )
		, MenuID( NULL )
		, IconResName( NULL )
		, ClassName( NULL )
		, CallBackName( NULL )
	{
	}

	void SetName( const std::string &name )
	{
		this->name = name;
	}
	const std::string &GetName() const
	{
		return name;
	}

	void SetHandleName( const std::string &handleName )
	{
		this->handleName = handleName;
	}
	const std::string &GetHandleName() const
	{
		return handleName;
	}

	//EBhEf[^
	POINT pos;
	SIZE size;
	char *caption;
	DWORD style;
	DWORD ExStyle;
	char *MenuID;
	int id;
	int bgColor;
	LOGFONT LogFont;
	char *IconResName;
	char *ClassName;
	char *CallBackName;
	long type;
	char *filepath;

	//qEBhEǗ
	std::vector<CHILDINFO *> childWindowInfos;

	//c[
	HTREEITEM hTreeItem;

private:
	std::string name;
	std::string handleName;
};

class WindowInfos
	: public std::vector<WindowInfo *>
{
public:
	WindowInfos()
	{
	}
	~WindowInfos()
	{
	}

	void Clear()
	{
		WindowInfos &windowInfos = *this;
		BOOST_FOREACH( WindowInfo *pWindowInfo, windowInfos )
		{
			delete pWindowInfo;
		}
		this->clear();
	}
	void Erase( int index )
	{
		WindowInfos::iterator it = this->begin();
		for( int i=0; i!=index ;i++, it++ )
		{
			delete *it;
		}
		this->erase( it );
	}
};
