#include "stdafx.h"

#include "Common.h"

void Rad_UndoCommand(int WndNum){
	extern HINSTANCE hInst;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	DWORD dw;
	char *temporary;
	RAD_UNDOSTATE *pUndoState;

	pUndoState=&MdiInfo[WndNum].MdiRadInfo->undo;
	i=pUndoState->NowPos-1;
	if(i==-1) i=MAX_UNDONUM-1;
	if(!pUndoState->Command[i]){
		MessageBeep(0);
		return;
	}
	pUndoState->NowPos=i;

	WindowInfo *pWindowInfo = GetWndInfo(MdiInfo[WndNum].path);
	int WndInfoNum = GetWndInfoNum(MdiInfo[WndNum].path);
	switch(pUndoState->Command[pUndoState->NowPos]){
		case RAD_UNDO_INSERTITEM:
			DeleteDlgItem(WndNum,WndInfoNum,pUndoState->SelectItemNum[pUndoState->NowPos],0);
			MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]=-1;
			break;
		case RAD_UNDO_DELETEITEM:
			CHILDINFO *pChildInfo;
			RECT rect;
			pChildInfo=(CHILDINFO *)pUndoState->lpdwData[pUndoState->NowPos];
			rect.left=pChildInfo->pos.x;
			rect.top=pChildInfo->pos.y;
			rect.right=pChildInfo->pos.x+pChildInfo->size.cx;
			rect.bottom=pChildInfo->pos.y+pChildInfo->size.cy;
			InsertDlgItem(WndNum,WndInfoNum,pUndoState->SelectItemNum[pUndoState->NowPos],
				&pChildInfo->pos,&pChildInfo->size,
				pChildInfo->IdName,pChildInfo->caption,pChildInfo->style,pChildInfo->ExStyle,pChildInfo->Control,pChildInfo->ImageCtrlInfo.type,pChildInfo->ImageCtrlInfo.path,0);
			break;
		case RAD_UNDO_NAME:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				RAD_UNDOSTATE_NAME *names;
				names=(RAD_UNDOSTATE_NAME *)pUndoState->lpdwData[pUndoState->NowPos];

				temporary=pWindowInfo->name;
				pWindowInfo->name=names->name;
				names->name=temporary;
				GlobalFree(MdiInfo[WndNum].path);
				MdiInfo[WndNum].path=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(pWindowInfo->name)+1);
				lstrcpy(MdiInfo[WndNum].path,pWindowInfo->name);

				temporary=pWindowInfo->HandleName;
				pWindowInfo->HandleName=names->HandleName;
				names->HandleName=temporary;

				temporary=pWindowInfo->CallBackName;
				pWindowInfo->CallBackName=names->CallBackName;
				names->CallBackName=temporary;
			}
			else{
				temporary=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->IdName;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->IdName=(char *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_CAPTION:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				temporary=pWindowInfo->caption;
				pWindowInfo->caption=(char *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			}
			else{
				temporary=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->caption;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->caption=(char *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_FONT:
			LOGFONT *pLogFont,lf;
			pLogFont=(LOGFONT *)pUndoState->lpdwData[pUndoState->NowPos];
			lf=pWindowInfo->LogFont;
			pWindowInfo->LogFont=*pLogFont;
			*pLogFont=lf;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_BGCOLOR:
			dw=pWindowInfo->bgColor;
			pWindowInfo->bgColor=pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=dw;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_WINDOWMENU:
			temporary=pWindowInfo->MenuID;
			pWindowInfo->MenuID=(char *)pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_ICONRES:
			temporary=pWindowInfo->IconResName;
			pWindowInfo->IconResName=(char *)pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_STYLE:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				dw=pWindowInfo->style;
				pWindowInfo->style=pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			else{
				dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->style;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->style=pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_EXSTYLE:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				dw=pWindowInfo->ExStyle;
				pWindowInfo->ExStyle=pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			else{
				dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ExStyle;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ExStyle=pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_POSITION:
			POINTANDSIZE PointAndSize,*pReadPointAndSize;
			pReadPointAndSize=(POINTANDSIZE *)pUndoState->lpdwData[pUndoState->NowPos];
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				PointAndSize.size=pWindowInfo->size;
				pWindowInfo->size=pReadPointAndSize->size;
			}
			else{
				PointAndSize.pos=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->pos;
				PointAndSize.size=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->size;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->pos=pReadPointAndSize->pos;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->size=pReadPointAndSize->size;
			}
			*pReadPointAndSize=PointAndSize;
			DrawRadWindow(WndNum,pWindowInfo);
			SetStatusText(NULL);

			//T|[g_CAO̓eZbg
			SetSupportDlgData( WndNum, *pWindowInfo );
			break;
		case RAD_UNDO_IMAGESTATE:
			IMAGECTRLINFO *pImageCtrlInfo;
			pImageCtrlInfo=(IMAGECTRLINFO *)pUndoState->lpdwData[pUndoState->NowPos];

			dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ImageCtrlInfo.type;
			pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ImageCtrlInfo.type=pImageCtrlInfo->type;
			pImageCtrlInfo->type=dw;

			dw=(DWORD)pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ImageCtrlInfo.path;
			pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ImageCtrlInfo.path=pImageCtrlInfo->path;
			pImageCtrlInfo->path=(char *)dw;

			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_TYPE:
			dw=pWindowInfo->type;
			pWindowInfo->type=pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=dw;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
	}

	ProjectInfo.ModifyOfMaterial=1;

	ResetState_UndoMenu();
}
void Rad_RedoCommand(int WndNum){
	extern HINSTANCE hInst;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	DWORD dw;
	char *temporary;
	RAD_UNDOSTATE *pUndoState;
	CHILDINFO *pChildInfo;
	RECT rect;

	pUndoState=&MdiInfo[WndNum].MdiRadInfo->undo;
	if(!pUndoState->Command[pUndoState->NowPos]){
		MessageBeep(0);
		return;
	}

	WindowInfo *pWindowInfo = GetWndInfo(MdiInfo[WndNum].path);
	int WndInfoNum = GetWndInfoNum(MdiInfo[WndNum].path);
	switch(pUndoState->Command[pUndoState->NowPos]){
		case RAD_UNDO_INSERTITEM:
			pChildInfo=(CHILDINFO *)pUndoState->lpdwData[pUndoState->NowPos];
			rect.left=pChildInfo->pos.x;
			rect.top=pChildInfo->pos.y;
			rect.right=pChildInfo->pos.x+pChildInfo->size.cx;
			rect.bottom=pChildInfo->pos.y+pChildInfo->size.cy;
			InsertDlgItem(WndNum,WndInfoNum,pUndoState->SelectItemNum[pUndoState->NowPos],
				&pChildInfo->pos,&pChildInfo->size,
				pChildInfo->IdName,pChildInfo->caption,pChildInfo->style,pChildInfo->ExStyle,pChildInfo->Control,pChildInfo->ImageCtrlInfo.type,pChildInfo->ImageCtrlInfo.path,0);
			break;
		case RAD_UNDO_DELETEITEM:
			DeleteDlgItem(WndNum,WndInfoNum,pUndoState->SelectItemNum[pUndoState->NowPos],0);
			MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]=-1;
			break;
		case RAD_UNDO_NAME:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				RAD_UNDOSTATE_NAME *names;
				names=(RAD_UNDOSTATE_NAME *)pUndoState->lpdwData[pUndoState->NowPos];

				temporary=pWindowInfo->name;
				pWindowInfo->name=names->name;
				names->name=temporary;
				GlobalFree(MdiInfo[WndNum].path);
				MdiInfo[WndNum].path=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(pWindowInfo->name)+1);
				lstrcpy(MdiInfo[WndNum].path,pWindowInfo->name);

				temporary=pWindowInfo->HandleName;
				pWindowInfo->HandleName=names->HandleName;
				names->HandleName=temporary;

				temporary=pWindowInfo->CallBackName;
				pWindowInfo->CallBackName=names->CallBackName;
				names->CallBackName=temporary;
			}
			else{
				temporary=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->IdName;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->IdName=(char *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_CAPTION:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				temporary=pWindowInfo->caption;
				pWindowInfo->caption=(char *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			}
			else{
				temporary=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->caption;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->caption=(char *)pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_FONT:
			LOGFONT *pLogFont,lf;
			pLogFont=(LOGFONT *)pUndoState->lpdwData[pUndoState->NowPos];
			lf=pWindowInfo->LogFont;
			pWindowInfo->LogFont=*pLogFont;
			*pLogFont=lf;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_BGCOLOR:
			dw=pWindowInfo->bgColor;
			pWindowInfo->bgColor=pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=dw;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_WINDOWMENU:
			temporary=pWindowInfo->MenuID;
			pWindowInfo->MenuID=(char *)pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_ICONRES:
			temporary=pWindowInfo->IconResName;
			pWindowInfo->IconResName=(char *)pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temporary;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
		case RAD_UNDO_STYLE:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				dw=pWindowInfo->style;
				pWindowInfo->style=pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			else{
				dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->style;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->style=pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_EXSTYLE:
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				dw=pWindowInfo->ExStyle;
				pWindowInfo->ExStyle=pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			else{
				dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ExStyle;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ExStyle=pUndoState->lpdwData[pUndoState->NowPos];
				pUndoState->lpdwData[pUndoState->NowPos]=dw;
			}
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_POSITION:
			POINTANDSIZE PointAndSize,*pReadPointAndSize;
			pReadPointAndSize=(POINTANDSIZE *)pUndoState->lpdwData[pUndoState->NowPos];
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==SELECT_WINDOW){
				PointAndSize.size=pWindowInfo->size;
				pWindowInfo->size=pReadPointAndSize->size;
			}
			else{
				PointAndSize.pos=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->pos;
				PointAndSize.size=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->size;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->pos=pReadPointAndSize->pos;
				pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->size=pReadPointAndSize->size;
			}
			*pReadPointAndSize=PointAndSize;
			DrawRadWindow(WndNum,pWindowInfo);
			SetStatusText(NULL);

			//T|[g_CAO̓eZbg
			SetSupportDlgData( WndNum, *pWindowInfo );
			break;
		case RAD_UNDO_IMAGESTATE:
			IMAGECTRLINFO *pImageCtrlInfo;
			pImageCtrlInfo=(IMAGECTRLINFO *)pUndoState->lpdwData[pUndoState->NowPos];

			dw=pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ImageCtrlInfo.type;
			pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ImageCtrlInfo.type=pImageCtrlInfo->type;
			pImageCtrlInfo->type=dw;

			dw=(DWORD)pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ImageCtrlInfo.path;
			pWindowInfo->childWindowInfos[pUndoState->SelectItemNum[pUndoState->NowPos]]->ImageCtrlInfo.path=pImageCtrlInfo->path;
			pImageCtrlInfo->path=(char *)dw;

			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			DrawRadWindow(WndNum,pWindowInfo);
			break;
		case RAD_UNDO_TYPE:
			dw=pWindowInfo->type;
			pWindowInfo->type=pUndoState->lpdwData[pUndoState->NowPos];
			pUndoState->lpdwData[pUndoState->NowPos]=dw;
			if(pUndoState->SelectItemNum[pUndoState->NowPos]==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0])
				ChangePropertyWindow(WndNum,WndInfoNum);
			break;
	}

	pUndoState->NowPos++;
	if(pUndoState->NowPos==MAX_UNDONUM) pUndoState->NowPos=0;

	ProjectInfo.ModifyOfMaterial=1;

	ResetState_UndoMenu();
}
void Rad_DeleteUndoData(int WndNum,int pos){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	RAD_UNDOSTATE *pUndoState;

	pUndoState=&MdiInfo[WndNum].MdiRadInfo->undo;
	switch(pUndoState->Command[pos]){
		case RAD_UNDO_INSERTITEM:
		case RAD_UNDO_DELETEITEM:
			CHILDINFO *pChildInfo;
			pChildInfo=(CHILDINFO *)pUndoState->lpdwData[pos];
			HeapDefaultFree(pChildInfo->IdName);
			HeapDefaultFree(pChildInfo->caption);
			if(pChildInfo->Control==CT_IMAGEBOX){
				//C[W {bNX̏ꍇ
				HeapDefaultFree(pChildInfo->ImageCtrlInfo.path);
			}
			HeapDefaultFree(pChildInfo);
			break;
		case RAD_UNDO_NAME:
			if(pUndoState->SelectItemNum[pos]==SELECT_WINDOW){
				RAD_UNDOSTATE_NAME *names;
				names=(RAD_UNDOSTATE_NAME *)pUndoState->lpdwData[pos];
				HeapDefaultFree(names->name);
				HeapDefaultFree(names->HandleName);
				HeapDefaultFree(names->CallBackName);
				HeapDefaultFree(names);
			}
			else HeapDefaultFree((void *)pUndoState->lpdwData[pos]);
			break;
		case RAD_UNDO_CAPTION:
			HeapDefaultFree((void *)pUndoState->lpdwData[pos]);
			break;
		case RAD_UNDO_FONT:
			HeapDefaultFree((void *)pUndoState->lpdwData[pos]);
			break;
		case RAD_UNDO_WINDOWMENU:
			if(pUndoState->lpdwData[pos])
				HeapDefaultFree((void *)pUndoState->lpdwData[pos]);
			break;
		case RAD_UNDO_ICONRES:
			if(pUndoState->lpdwData[pos])
				HeapDefaultFree((void *)pUndoState->lpdwData[pos]);
			break;
		case RAD_UNDO_POSITION:
			HeapDefaultFree((void *)pUndoState->lpdwData[pos]);
			break;
		case RAD_UNDO_IMAGESTATE:
			IMAGECTRLINFO *pImageCtrlInfo;
			pImageCtrlInfo=(IMAGECTRLINFO *)pUndoState->lpdwData[pos];
			HeapDefaultFree(pImageCtrlInfo->path);
			HeapDefaultFree(pImageCtrlInfo);
			break;
	}
	pUndoState->Command[pos]=0;
}
void Rad_NoticeChanging(int WndNum,int Command,int SelectItemNum,DWORD dwData){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	char *temporary,*temp2;
	RAD_UNDOSTATE *pUndoState;

	pUndoState=&MdiInfo[WndNum].MdiRadInfo->undo;

	//Redoꂽꍇ̕svȃf[^폜
	for(i=pUndoState->NowPos;;i++){
		if(i==MAX_UNDONUM) i=0;
		if(pUndoState->Command[i]==0) break;
		Rad_DeleteUndoData(WndNum,i);
	}

	pUndoState->Command[pUndoState->NowPos]=Command;
	pUndoState->SelectItemNum[pUndoState->NowPos]=SelectItemNum;
	switch(Command){
		case RAD_UNDO_INSERTITEM:
		case RAD_UNDO_DELETEITEM:
			CHILDINFO *pChildInfo,*pSaveChildInfo;
			pChildInfo=(CHILDINFO *)dwData;
			pSaveChildInfo=(CHILDINFO *)HeapAlloc(hHeap,0,sizeof(CHILDINFO));
			pSaveChildInfo->IdName=(char *)HeapAlloc(hHeap,0,lstrlen(pChildInfo->IdName)+1);
			lstrcpy(pSaveChildInfo->IdName,pChildInfo->IdName);
			pSaveChildInfo->pos=pChildInfo->pos;
			pSaveChildInfo->size=pChildInfo->size;
			pSaveChildInfo->caption=(char *)HeapAlloc(hHeap,0,lstrlen(pChildInfo->caption)+1);
			lstrcpy(pSaveChildInfo->caption,pChildInfo->caption);
			pSaveChildInfo->style=pChildInfo->style;
			pSaveChildInfo->ExStyle=pChildInfo->ExStyle;
			pSaveChildInfo->Control=pChildInfo->Control;
			if(pChildInfo->Control==CT_IMAGEBOX){
				//C[W {bNX̏ꍇ
				pSaveChildInfo->ImageCtrlInfo.type=pChildInfo->ImageCtrlInfo.type;
				pSaveChildInfo->ImageCtrlInfo.path=(char *)HeapAlloc(hHeap,0,lstrlen(pChildInfo->ImageCtrlInfo.path)+1);
				lstrcpy(pSaveChildInfo->ImageCtrlInfo.path,pChildInfo->ImageCtrlInfo.path);
			}
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pSaveChildInfo;
			break;
		case RAD_UNDO_NAME:
			if(SelectItemNum==SELECT_WINDOW){
				RAD_UNDOSTATE_NAME *names,*SaveNames;
				names=(RAD_UNDOSTATE_NAME *)dwData;
				SaveNames=(RAD_UNDOSTATE_NAME *)HeapAlloc(hHeap,0,sizeof(RAD_UNDOSTATE_NAME));
				SaveNames->name=(char *)HeapAlloc(hHeap,0,lstrlen(names->name)+1);
				lstrcpy(SaveNames->name,names->name);
				SaveNames->HandleName=(char *)HeapAlloc(hHeap,0,lstrlen(names->HandleName)+1);
				lstrcpy(SaveNames->HandleName,names->HandleName);
				SaveNames->CallBackName=(char *)HeapAlloc(hHeap,0,lstrlen(names->CallBackName)+1);
				lstrcpy(SaveNames->CallBackName,names->CallBackName);
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)SaveNames;
			}
			else{
				temporary=(char *)dwData;
				temp2=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
				lstrcpy(temp2,temporary);
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temp2;
			}
			break;
		case RAD_UNDO_CAPTION:
			temporary=(char *)dwData;
			temp2=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(temp2,temporary);
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temp2;
			break;
		case RAD_UNDO_FONT:
			LOGFONT *pLogFont,*pSaveLogFont;
			pLogFont=(LOGFONT *)dwData;
			pSaveLogFont=(LOGFONT *)HeapAlloc(hHeap,0,sizeof(LOGFONT));
			*pSaveLogFont=*pLogFont;
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pSaveLogFont;
			break;
		case RAD_UNDO_BGCOLOR:
			pUndoState->lpdwData[pUndoState->NowPos]=dwData;
			break;
		case RAD_UNDO_WINDOWMENU:
		case RAD_UNDO_ICONRES:
			if(!dwData) pUndoState->lpdwData[pUndoState->NowPos]=0;
			else{
				temporary=(char *)dwData;
				temp2=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
				lstrcpy(temp2,temporary);
				pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)temp2;
			}
			break;
		case RAD_UNDO_STYLE:
		case RAD_UNDO_EXSTYLE:
			pUndoState->lpdwData[pUndoState->NowPos]=dwData;
			break;
		case RAD_UNDO_POSITION:
			POINTANDSIZE *pPointAndSize,*pSavePointAndSize;
			pPointAndSize=(POINTANDSIZE *)dwData;
			pSavePointAndSize=(POINTANDSIZE *)HeapAlloc(hHeap,0,sizeof(POINTANDSIZE));
			pSavePointAndSize->pos=pPointAndSize->pos;
			pSavePointAndSize->size=pPointAndSize->size;
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pSavePointAndSize;
			break;
		case RAD_UNDO_IMAGESTATE:
			IMAGECTRLINFO *pImageCtrlInfo,*pSaveImageCtrlInfo;
			pImageCtrlInfo=(IMAGECTRLINFO *)dwData;
			pSaveImageCtrlInfo=(IMAGECTRLINFO *)HeapAlloc(hHeap,0,sizeof(IMAGECTRLINFO));
			pSaveImageCtrlInfo->type=pImageCtrlInfo->type;
			pSaveImageCtrlInfo->path=(char *)HeapAlloc(hHeap,0,lstrlen(pImageCtrlInfo->path)+1);
			lstrcpy(pSaveImageCtrlInfo->path,pImageCtrlInfo->path);
			pUndoState->lpdwData[pUndoState->NowPos]=(DWORD)pSaveImageCtrlInfo;
			break;
		case RAD_UNDO_TYPE:
			pUndoState->lpdwData[pUndoState->NowPos]=dwData;
			break;
	}

	pUndoState->NowPos++;
	if(pUndoState->NowPos==MAX_UNDONUM) pUndoState->NowPos=0;
	if(pUndoState->Command[pUndoState->NowPos]){
		//ԌÂ؂̂Ă
		Rad_DeleteUndoData(WndNum,pUndoState->NowPos);
	}

	ProjectInfo.ModifyOfMaterial=1;

	ResetState_UndoMenu();
}
