#pragma once

struct PROJECTINFO{
	DWORD dwModuleType;

	char name[MAX_PATH];
	char dir[MAX_PATH];

	DWORD dwVersion;

	CDBFileInfo *pobj_DBFileInfo;

	char ResourceFileName[MAX_PATH];

	int NumberOfMenu;
	MENU_INFO *pMenuInfo;
	HTREEITEM hMenuTreeItem;

	std::vector<WINDOW_INFO> windowInfos;
	HTREEITEM hWindowTreeItem;

	RESOURCEINFO res;

	DWORD dwOption;
	char lpszOutput_Release[MAX_PATH];
	char lpszOutput_Debug[MAX_PATH];

	//}jtFXg
	char szManifestPath[MAX_PATH];

	//fobO
	char szCmdLine[8192];
	char szExePath[MAX_PATH];

	//u[N|Cg
	CDBBreakPoint *pobj_DBBreakPoint;

	_int8 ModifyOfMaterial;
	_int8 ModifuOfResource;
	_int8 modify;
};

namespace ActiveBasic{ namespace IDE{

class Project
{
	std::string name;
	ActiveBasic::Common::TargetModuleType::EnumType moduleType;
public:
	void Open( const std::string &projectFileName );
	void Close() const;
	void Save() const;
};
typedef std::vector<Project *> Projects;

class ProjectManager
{
	Projects projects;
	Project *pCurrentProject;
public:
	ProjectManager()
		: pCurrentProject( NULL )
	{
	}
	~ProjectManager()
	{
		if( IsOpenedProject() )
		{
			throw;
		}
	}
	const Project &GetCurrentProject() const
	{
		return *pCurrentProject;
	}
	Project &GetCurrentProject()
	{
		return *pCurrentProject;
	}

	bool IsOpenedProject() const
	{
		return !projects.empty();
	}
	void OpenProject( const std::string &projectFileName );
	void CloseProject( const std::string &projectName );

	void CloseAllProjects();
};


}}

extern ActiveBasic::IDE::ProjectManager projectManager;
extern PROJECTINFO ProjectInfo;
