#include "stdafx.h"

#include "Common.h"

using namespace ActiveBasic::IDE;

#if defined(JPN)
//{
#include "pj_msg_jpn.h"
#else
//p
#include "pj_msg_eng.h"
#endif

HWND hProjectViewTab;
HWND hProcedureTreeView,hMaterialTreeView;
HIMAGELIST hProcedureTreeViewImageList,hMaterialTreeViewImageList;
WNDPROC OldProcedureTreeViewProc,OldMaterialTreeViewProc;
WNDPROC OldTabProc;

LRESULT CALLBACK ProcedureTreeViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	if(message==WM_CHAR&&wParam==VK_RETURN){
		SendMessage(hProjectViewTab,WM_COMMAND,IDM_PROCEDURETREE_SHOW,0);
		//ftHg̃bZ[Wƃr[vĂ܂̂Ŕ
		return 0;
	}
	else if(message==WM_LBUTTONDBLCLK){
		SendMessage(hProjectViewTab,WM_COMMAND,IDM_PROCEDURETREE_SHOW,0);
		return 0;
	}
	return CallWindowProc(OldProcedureTreeViewProc,hwnd,message,wParam,lParam);
}
LRESULT CALLBACK MaterialTreeViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	if(message==WM_CHAR&&wParam==VK_RETURN){
		SendMessage(hProjectViewTab,WM_COMMAND,IDM_MATERIALTREE_OPEN,0);
		//ftHg̃bZ[Wƃr[vĂ܂̂Ŕ
		return 0;
	}
	if(message==WM_KEYDOWN&&wParam==VK_DELETE) SendMessage(hProjectViewTab,WM_COMMAND,IDM_MATERIALTREE_DELETE,0);
	return CallWindowProc(OldMaterialTreeViewProc,hwnd,message,wParam,lParam);
}
LRESULT CALLBACK TabProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern LPSTR DefFileFilter;
	extern PROJECTINFO ProjectInfo;
	int i,i2,WndNum;
	char str[MAX_PATH],temporary[MAX_PATH];
	HWND hTree,hChild;
	HTREEITEM hTreeItem,hTreeItem2;
	TV_HITTESTINFO tvHitTestInfo;
	TVITEM tvItem;

	switch(message){
		case WM_CONTEXTMENU:
			i=TabCtrl_GetCurSel(hwnd);
			if(i==0){
				//t@Cc[
				POINT pos;
				pos.x=LOWORD(lParam);
				pos.y=HIWORD(lParam);
				pobj_FileTree->ContextMenu(&pos);
				return 0;
			}
			else if(i==1) hTree=hProcedureTreeView;
			else if(i==2) hTree=hMaterialTreeView;
			tvHitTestInfo.pt.x=LOWORD(lParam);
			tvHitTestInfo.pt.y=HIWORD(lParam);
			ScreenToClient(hTree,&tvHitTestInfo.pt);
			hTreeItem=TreeView_HitTest(hTree,&tvHitTestInfo);
			if(hTreeItem){
				TreeView_SelectItem(hTree,hTreeItem);
				if(i==1){
					extern HMENU hProcedureTreeMenuBase;
					if(TreeView_GetRoot(hTree)!=hTreeItem)
						TrackPopupMenu(GetSubMenu(hProcedureTreeMenuBase,1),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
				}
				else if(i==2){
					extern HMENU hMaterialTreeMenuBase;
					hTreeItem2=TreeView_GetRoot(hTree);
					for(i2=0;;i2++){
						if(hTreeItem2==hTreeItem) break;
						hTreeItem2=TreeView_GetNextSibling(hTree,hTreeItem2);
						if(!hTreeItem2) break;
					}
					if(hTreeItem2){
						if(i2==0)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,0),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						else if(i2==1)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,2),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						else if(i2==2)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,4),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						else if(i2==3)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,6),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						else if(i2==4)
							TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,8),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
					}
					else{
						hTreeItem=TreeView_GetNextItem(hTree,hTreeItem,TVGN_PARENT);
						hTreeItem2=TreeView_GetRoot(hTree);
						for(i2=0;;i2++){
							if(hTreeItem2==hTreeItem) break;
							hTreeItem2=TreeView_GetNextSibling(hTree,hTreeItem2);
							if(!hTreeItem2) break;
						}
						if(hTreeItem2){
							if(i2==0)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,1),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
							else if(i2==1)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,3),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
							else if(i2==2)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,5),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
							else if(i2==3)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,7),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
							else if(i2==4)
								TrackPopupMenu(GetSubMenu(hMaterialTreeMenuBase,9),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
						}
					}
				}
			}
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){

				case IDM_PROCEDURETREE_SHOW:
					extern BOOL bSearchingClasses;
					if(bSearchingClasses){
						pobj_ClassTreeView->bShowSwitch=1;
						break;
					}

					hTreeItem=TreeView_GetSelection(hProcedureTreeView);
					for(i=0;i<pobj_ClassTreeView->NumberOfProcedures;i++){
						if(pobj_ClassTreeView->pProcInfo[i].hTreeItem==hTreeItem){

							if( ProjectInfo.name[0] ){
								// Ώۃt@CJ
								lstrcpy(temporary,
									ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[pobj_ClassTreeView->pProcInfo[i].FileNum]->m_path);
								GetFullPath(temporary,ProjectInfo.dir);
								hChild=OpenFileWithExtension(temporary);
							}
							else{
								hChild = GetWindow(hClient,GW_CHILD);
							}

							//vV[W̍sI
							//ResetScrollbarĕ`掞ɌĂяôŁAĕ`悷
							WndNum=GetWndNum(hChild);
							InvalidateRect(MdiInfo[WndNum].pMdiTextEdit->hEdit,NULL,0);
							UpdateWindow(MdiInfo[WndNum].pMdiTextEdit->hEdit);
							TextEdit_SelectOneLine(WndNum,pobj_ClassTreeView->pProcInfo[i].code_pos,TRUE);

							//^C}[Zbg
							// tH[JXGfB^ɃZbg邽
							// ^C~Ox点SetFocussKv
							SetTimer(hwnd,100,10,NULL);

							break;
						}
					}

					break;

				case IDM_MATERIALTREE_INSERTCURSOR:
					Project_CursorResInsert();
					break;
				case IDM_MATERIALTREE_INSERTBITMAP:
					Project_BitmapResInsert();
					break;
				case IDM_MATERIALTREE_INSERTICON:
					Project_IconResInsert();
					break;
				case IDM_MATERIALTREE_INSERTMENU:
					Project_Menu_Insert();
					break;
				case IDM_MATERIALTREE_INSERTWINDOW:
					Project_Window_Insert();
					break;
				case IDM_MATERIALTREE_OPEN:
					hTreeItem=TreeView_GetSelection(hMaterialTreeView);
					for(i=0;i<static_cast<int>(ProjectInfo.windowInfos.size());i++){
						if(ProjectInfo.windowInfos[i].hTreeItem==hTreeItem){
							NewRadWindow( ProjectInfo.windowInfos[i] );
							break;
						}
					}
					for(i=0;i<ProjectInfo.NumberOfMenu;i++){
						if(ProjectInfo.pMenuInfo[i].hTreeItem==hTreeItem){
							NewMenuWindow(&ProjectInfo.pMenuInfo[i]);
							break;
						}
					}
					for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
						if(ProjectInfo.res.pIconResInfo[i].hTreeItem==hTreeItem){
							lstrcpy(temporary,ProjectInfo.res.pIconResInfo[i].path);
							GetFullPath(temporary,ProjectInfo.dir);
							NewIconEditWindow(temporary);
							break;
						}
					}
					break;
				case IDM_MATERIALTREE_DELETE:
					hTreeItem=TreeView_GetSelection(hMaterialTreeView);
					for(i=0;i<ProjectInfo.res.NumberOfCursorRes;i++){
						if(ProjectInfo.res.pCursorResInfo[i].hTreeItem==hTreeItem){

							//"%s J[\vWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETECURSOR,ProjectInfo.res.pCursorResInfo[i].IdName);
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Cursor_Delete(i);
							break;
						}
					}
					for(i=0;i<ProjectInfo.res.NumberOfBitmapRes;i++){
						if(ProjectInfo.res.pBitmapResInfo[i].hTreeItem==hTreeItem){

							//"%s rbg}bvvWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETEBITMAP,ProjectInfo.res.pBitmapResInfo[i].IdName);
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Bitmap_Delete(i);
							break;
						}
					}
					for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
						if(ProjectInfo.res.pIconResInfo[i].hTreeItem==hTreeItem){

							//"%s ACRvWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETEICON,ProjectInfo.res.pIconResInfo[i].IdName);
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Icon_Delete(i);
							break;
						}
					}
					for(i=0;i<ProjectInfo.NumberOfMenu;i++){
						if(ProjectInfo.pMenuInfo[i].hTreeItem==hTreeItem){

							//"%s j[vWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETEMENU,ProjectInfo.pMenuInfo[i].IdName);
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Menu_Delete(i);
							break;
						}
					}
					for(i=0;i<static_cast<int>(ProjectInfo.windowInfos.size());i++){
						if(ProjectInfo.windowInfos[i].hTreeItem==hTreeItem){

							//"%s EBhEvWFNg폜܂B낵łH"
							sprintf(str,STRING_PJ_CHECK_DELETEWINDOW,ProjectInfo.windowInfos[i].name);
							if(IDCANCEL==MessageBox(hOwner,str,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

							Project_Window_Delete(i);
							break;
						}
					}
					break;
				case IDM_MENUTREE_RENAMEID:
					extern char NewIdName[MAX_PATH];
					hTreeItem=TreeView_GetSelection(hMaterialTreeView);
					for(i=0;i<ProjectInfo.res.NumberOfCursorRes;i++){
						if(ProjectInfo.res.pCursorResInfo[i].hTreeItem==hTreeItem){
							Project_Cursor_RenameID(i);
							break;
						}
					}
					for(i=0;i<ProjectInfo.res.NumberOfBitmapRes;i++){
						if(ProjectInfo.res.pBitmapResInfo[i].hTreeItem==hTreeItem){
							Project_Bitmap_RenameID(i);
							break;
						}
					}
					for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
						if(ProjectInfo.res.pIconResInfo[i].hTreeItem==hTreeItem){
							Project_Icon_RenameID(i);
						}
					}
					for(i=0;i<ProjectInfo.NumberOfMenu;i++){
						if(ProjectInfo.pMenuInfo[i].hTreeItem==hTreeItem){
							if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,(DLGPROC)DlgProject_MenuID_Input,(long)ProjectInfo.pMenuInfo[i].IdName)) break;

							//d`FbN
							for(i2=0;i2<ProjectInfo.NumberOfMenu;i2++){
								if(i2==i) continue;
								if(lstrcmp(NewIdName,ProjectInfo.pMenuInfo[i2].IdName)==0){
									//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
									sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
									MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
									return 0;
								}
							}

							HeapDefaultFree(ProjectInfo.pMenuInfo[i].IdName);
							ProjectInfo.pMenuInfo[i].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(NewIdName)+1);
							lstrcpy(ProjectInfo.pMenuInfo[i].IdName,NewIdName);

							tvItem.hItem=hTreeItem;
							tvItem.mask=TVIF_TEXT;
							tvItem.pszText=ProjectInfo.pMenuInfo[i].IdName;
							tvItem.cchTextMax=lstrlen(ProjectInfo.pMenuInfo[i].IdName)+1;
							TreeView_SetItem(hMaterialTreeView,&tvItem);

							ProjectInfo.ModifyOfMaterial=1;

							TreeView_SortChildren(hMaterialTreeView,
								TreeView_GetParent(hMaterialTreeView,hTreeItem),
								0);
							break;
						}
					}
					break;
				case IDM_MATERIALTREE_ICON_SETMAIN:
					RESITEMINFO TempIconResInfo;
					hTreeItem=TreeView_GetSelection(hMaterialTreeView);
					for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
						if(ProjectInfo.res.pIconResInfo[i].hTreeItem==hTreeItem){
							if(i==0) break;

							TempIconResInfo=ProjectInfo.res.pIconResInfo[i];
							for(;i>0;i--)
								ProjectInfo.res.pIconResInfo[i]=ProjectInfo.res.pIconResInfo[i-1];
							ProjectInfo.res.pIconResInfo[0]=TempIconResInfo;

							tvItem.hItem=ProjectInfo.res.pIconResInfo[1].hTreeItem;
							tvItem.mask=TVIF_TEXT;
							tvItem.pszText=ProjectInfo.res.pIconResInfo[1].IdName;
							tvItem.cchTextMax=lstrlen(ProjectInfo.res.pIconResInfo[1].IdName)+1;
							TreeView_SetItem(hMaterialTreeView,&tvItem);

							tvItem.hItem=ProjectInfo.res.pIconResInfo[0].hTreeItem;
							tvItem.mask=TVIF_TEXT;
							sprintf(temporary,"%s (Main)",ProjectInfo.res.pIconResInfo[0].IdName);
							tvItem.pszText=temporary;
							tvItem.cchTextMax=lstrlen(temporary)+1;
							TreeView_SetItem(hMaterialTreeView,&tvItem);

							ProjectInfo.ModifuOfResource=1;
							break;
						}
					}
					break;
			}
			break;
		case WM_TIMER:
			KillTimer(hwnd,wParam);

			//tH[JXGfB^ɃZbg
			SetFocus(GetWindow(GetWindow(hClient,GW_CHILD),GW_CHILD));
			break;
		case WM_NOTIFY:
			NMHDR *hdr;
			hdr=(NMHDR *)lParam;
			if(hdr->code==NM_DBLCLK){
				if(hdr->hwndFrom==hProcedureTreeView) SendMessage(hwnd,WM_COMMAND,IDM_PROCEDURETREE_SHOW,0);
				else if(hdr->hwndFrom==hMaterialTreeView) SendMessage(hwnd,WM_COMMAND,IDM_MATERIALTREE_OPEN,0);
			}
			if(hdr->code==TVN_ITEMEXPANDEDW||hdr->code==TVN_ITEMEXPANDED){
				NMTREEVIEW *nmTreeView;
				TVITEM tvItem;
				nmTreeView=(NMTREEVIEW *)lParam;
				tvItem.mask=TVIF_HANDLE|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
				tvItem.hItem=nmTreeView->itemNew.hItem;
				TreeView_GetItem(nmTreeView->hdr.hwndFrom,&tvItem);
				if(tvItem.iImage==0||tvItem.iImage==1){
					if(nmTreeView->action==TVE_EXPAND){
						tvItem.iImage=1;
						tvItem.iSelectedImage=1;
					}
					else if(nmTreeView->action==TVE_COLLAPSE){
						tvItem.iImage=0;
						tvItem.iSelectedImage=0;
					}
					tvItem.hItem=nmTreeView->itemNew.hItem;
					TreeView_SetItem(nmTreeView->hdr.hwndFrom,&tvItem);
				}
			}
			break;
	}
	return CallWindowProc(OldTabProc,hwnd,message,wParam,lParam);
}
void ResizeProjectView_ToolWindow(void){
	extern HWND hProjectView_ToolWindow;
	RECT rect;
	GetClientRect(hProjectView_ToolWindow,&rect);
	SendMessage(hProjectView_ToolWindow,WM_SIZE,0,MAKELONG(rect.right,rect.bottom));
}
LRESULT CALLBACK ProjectView_ToolWindowProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HWND hProjectView;
	switch(message){
		case WM_SIZE:
			MoveWindow(hProjectView,0,0,
				LOWORD(lParam),
				HIWORD(lParam),1);
			return 0;
		case WM_CLOSE:
			SendMessage(hOwner,WM_COMMAND,IDM_PROJECTVIEW,0);
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}
void ShowFileView(){
	TabCtrl_SetCurSel(hProjectViewTab,0);
	ShowWindow(pobj_FileTree->hTree,SW_SHOW);
	ShowWindow(hProcedureTreeView,SW_HIDE);
	ShowWindow(hMaterialTreeView,SW_HIDE);
}
void ShowClassView(){
	TabCtrl_SetCurSel(hProjectViewTab,1);
	ShowWindow(pobj_FileTree->hTree,SW_HIDE);
	ShowWindow(hMaterialTreeView,SW_HIDE);
	ShowWindow(hProcedureTreeView,SW_SHOW);
}
void ShowMaterialView(){
	TabCtrl_SetCurSel(hProjectViewTab,2);
	ShowWindow(pobj_FileTree->hTree,SW_HIDE);
	ShowWindow(hProcedureTreeView,SW_HIDE);
	ShowWindow(hMaterialTreeView,SW_SHOW);
}
LRESULT CALLBACK ProjectViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HINSTANCE hInst,hResInst;
	extern PROJECTINFO ProjectInfo;
	extern HWND hTabOfProjectView;
	extern HFONT hStatusFont;
	extern HWND hProjectView_ToolWindow;
	RECT rect;
	HWND hButton;

	switch(message){
		case WM_CREATE:
			hProjectViewTab=CreateWindow(WC_TABCONTROL,NULL,
				WS_CHILD | WS_CLIPCHILDREN | WS_VISIBLE,
				0,0,0,0,hwnd,0,hInst,0);
			SendMessage(hProjectViewTab,WM_SETFONT,(long)hStatusFont,0);

			hButton=CreateWindow("BUTTON","",WS_CHILD|WS_VISIBLE,
				0,0,30,13,
				hwnd,(HMENU)IDC_CLIP,hInst,0);
			SendMessage(hButton,WM_SETFONT,(long)hStatusFont,0);

			OldTabProc=(WNDPROC)GetWindowLongPtr(hProjectViewTab,GWLP_WNDPROC);
			SetWindowLongPtr(hProjectViewTab,GWLP_WNDPROC,(long)TabProc);

			//^uݒ
			TC_ITEM tcItem;
			tcItem.mask=TCIF_TEXT;
			tcItem.pszText="File";
			TabCtrl_InsertItem(hProjectViewTab,0,&tcItem);
			tcItem.mask=TCIF_TEXT;
			tcItem.pszText="Class";
			TabCtrl_InsertItem(hProjectViewTab,1,&tcItem);
			tcItem.mask=TCIF_TEXT;
			tcItem.pszText="Material";
			TabCtrl_InsertItem(hProjectViewTab,2,&tcItem);

			//t@Cc[r[쐬
			pobj_FileTree=new CFileTree(hProjectViewTab);

			//NXc[r[쐬
			hProcedureTreeView=CreateWindowEx(WS_EX_CLIENTEDGE,WC_TREEVIEW,"",
				WS_CHILD|TVS_HASLINES|TVS_HASBUTTONS|TVS_LINESATROOT|TVS_SHOWSELALWAYS,
				0,0,0,0,
				hProjectViewTab,0,hInst,0);
			OldProcedureTreeViewProc=(WNDPROC)GetWindowLongPtr(hProcedureTreeView,GWLP_WNDPROC);
			SetWindowLongPtr(hProcedureTreeView,GWLP_WNDPROC,(long)ProcedureTreeViewProc);
			//C[WXgǂݍ݁Aݒ
			hProcedureTreeViewImageList=ImageList_Create(16,16,ILC_COLOR24|ILC_MASK,8,0);
			ImageList_AddIcon(hProcedureTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_FOLDER_CLOSE)));
			ImageList_AddIcon(hProcedureTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_FOLDER_OPEN)));
			ImageList_AddIcon(hProcedureTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_PROCEDURE)));
			ImageList_AddIcon(hProcedureTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_PROGRAM_FOLDER)));
			ImageList_AddIcon(hProcedureTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_MEMBER_PUBLIC_VARIABLE)));
			ImageList_AddIcon(hProcedureTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_MEMBER_PUBLIC_FUNCTION)));
			ImageList_AddIcon(hProcedureTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_MEMBER_PRIVATE_VARIABLE)));
			ImageList_AddIcon(hProcedureTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_MEMBER_PRIVATE_FUNCTION)));
			TreeView_SetImageList(hProcedureTreeView,hProcedureTreeViewImageList,TVSIL_NORMAL);

			//}eAc[r[쐬
			hMaterialTreeView=CreateWindowEx(WS_EX_CLIENTEDGE,WC_TREEVIEW,"",
				WS_CHILD|TVS_HASLINES|TVS_HASBUTTONS|TVS_LINESATROOT|TVS_SHOWSELALWAYS,
				0,0,0,0,
				hProjectViewTab,0,hInst,0);
			OldMaterialTreeViewProc=(WNDPROC)GetWindowLongPtr(hMaterialTreeView,GWLP_WNDPROC);
			SetWindowLongPtr(hMaterialTreeView,GWLP_WNDPROC,(long)MaterialTreeViewProc);
			//C[WXgǂݍ݁Aݒ
			hMaterialTreeViewImageList=ImageList_Create(16,16,ILC_COLOR24|ILC_MASK,3,0);
			ImageList_AddIcon(hMaterialTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_FOLDER_CLOSE)));
			ImageList_AddIcon(hMaterialTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_FOLDER_OPEN)));
			ImageList_AddIcon(hMaterialTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_WINDOW)));
			ImageList_AddIcon(hMaterialTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_MENU)));
			ImageList_AddIcon(hMaterialTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_FILE_ICON)));
			ImageList_AddIcon(hMaterialTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_FILE_BMP)));
			ImageList_AddIcon(hMaterialTreeViewImageList,LoadIcon(hResInst,MAKEINTRESOURCE(IDI_FILE_CURSOR)));
			TreeView_SetImageList(hMaterialTreeView,hMaterialTreeViewImageList,TVSIL_NORMAL);

			ShowWindow(pobj_FileTree->hTree,SW_SHOW);
			GetClientRect(hwnd,&rect);
			SendMessage(hwnd,WM_SIZE,0,MAKELONG(rect.right,rect.bottom));
			return 0;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_CLIP:
					if(pobj_nv->bClipProjectView==0){
						pobj_nv->bClipProjectView=1;

						SetWindowLongPtr(hwnd,GWL_EXSTYLE,WS_EX_STATICEDGE);
						SetParent(hwnd,hOwner);
						ResizeOwnerWnd();

						ShowWindow(hProjectView_ToolWindow,SW_HIDE);
					}
					else{
						pobj_nv->bClipProjectView=0;

						SetWindowLongPtr(hwnd,GWL_EXSTYLE,0);

						SetParent(hwnd,hProjectView_ToolWindow);

						ResizeOwnerWnd();
						ResizeProjectView_ToolWindow();

						ShowWindow(hProjectView_ToolWindow,SW_SHOW);
					}
					return 0;
			}
			break;
		case WM_NOTIFY:
			NMHDR *hdr;
			hdr=(NMHDR *)lParam;
			if(hdr->hwndFrom==hProjectViewTab&&hdr->code==TCN_SELCHANGE){
				switch( TabCtrl_GetCurSel(hProjectViewTab) ){
					case 0:
						ShowFileView();
						break;
					case 1:
						ShowClassView();
						break;
					case 2:
						ShowMaterialView();
						break;
				}
			}
			return 0;
		case WM_PAINT:
			PAINTSTRUCT ps;
			HDC hdc;
			HFONT hOldFont;
			SIZE size;
			HBRUSH hBrush,hOldBrush;
			HPEN hPen,hOldPen;
			char temporary[MAX_PATH];

			if(pobj_nv->bClipProjectView==0) break;

			hBrush=CreateSolidBrush(GetSysColor(COLOR_3DSHADOW));
			hPen=CreatePen(PS_SOLID,0,GetSysColor(COLOR_3DSHADOW));

			hdc=BeginPaint(hwnd,&ps);

			hOldFont=(HFONT)SelectObject(hdc,hStatusFont);
			if( ProjectInfo.name[0] ){
				sprintf(temporary,"%s \'%s\'",STRING_PROJECT,ProjectInfo.name);
			}
			else{
				lstrcpy( temporary, "݂̃hLg" );
			}

			GetTextExtentPoint32(hdc,temporary,lstrlen(temporary),&size);
			GetClientRect(hwnd,&rect);
			rect.left++;
			rect.top++;
			rect.right--;
			rect.bottom=size.cy+2;

			hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
			hOldPen=(HPEN)SelectObject(hdc,hPen);
			Rectangle(hdc,rect.left,rect.top,rect.right,rect.bottom);
			SelectObject(hdc,hOldBrush);
			SelectObject(hdc,hPen);

			rect.top++;
			rect.bottom--;
			SetBkMode(hdc,OPAQUE);
			SetBkColor(hdc,GetSysColor(COLOR_3DSHADOW));
			SetTextColor(hdc,GetSysColor(COLOR_3DHILIGHT));
			DrawText(hdc,temporary,lstrlen(temporary),&rect,DT_CENTER|DT_VCENTER|DT_SINGLELINE);

			EndPaint(hwnd,&ps);

			DeleteObject(hBrush);
			DeleteObject(hPen);
			return 0;
		case WM_SIZE:
			if(pobj_nv->bClipProjectView){
				MoveWindow(hProjectViewTab,
					LEVER_THICK,
					LEVER_THICK+11,
					LOWORD(lParam)-LEVER_THICK*2,
					HIWORD(lParam)-LEVER_THICK*2-21,1);

				GetClientRect(hProjectViewTab,&rect);
				TabCtrl_AdjustRect(hProjectViewTab,FALSE,&rect);
				rect.left-=2;
				rect.right++;
				rect.bottom++;

				pobj_FileTree->resize(rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top);
				MoveWindow(hProcedureTreeView,
					rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,1);
				MoveWindow(hMaterialTreeView,
					rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,1);

				GetClientRect(GetDlgItem(hwnd,IDC_CLIP),&rect);
				MoveWindow(GetDlgItem(hwnd,IDC_CLIP),LOWORD(lParam)-rect.right,HIWORD(lParam)-rect.bottom,rect.right,rect.bottom,1);
				InvalidateRect(GetDlgItem(hwnd,IDC_CLIP),NULL,0);
			}
			else{
				MoveWindow(hProjectViewTab,0,0,
					LOWORD(lParam),
					HIWORD(lParam)-15,1);

				GetClientRect(hProjectViewTab,&rect);
				TabCtrl_AdjustRect(hProjectViewTab,FALSE,&rect);

				pobj_FileTree->resize(rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top);
				MoveWindow(hProcedureTreeView,
					rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,1);
				MoveWindow(hMaterialTreeView,
					rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,1);

				GetClientRect(GetDlgItem(hwnd,IDC_CLIP),&rect);
				MoveWindow(GetDlgItem(hwnd,IDC_CLIP),LOWORD(lParam)-rect.right,HIWORD(lParam)-rect.bottom,rect.right,rect.bottom,1);
			}
			return 0;
		case WM_CLOSE:
			SendMessage(hOwner,WM_COMMAND,IDM_PROJECTVIEW,0);
			return 0;
		case WM_DESTROY:
			delete pobj_FileTree;
			ImageList_Destroy(hProcedureTreeViewImageList);
			ImageList_Destroy(hMaterialTreeViewImageList);
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}

void Project_File_Insert(char *path){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	char temporary[MAX_PATH],temp2[MAX_PATH];

	GetRelationalPath(path,ProjectInfo.dir);

	//d`FbN
	if(ProjectInfo.pobj_DBFileInfo->dupli_check(path)){
		//"\"%s\" t@C͊ɃvWFNgɑ݂܂B"
		sprintf(temporary,STRING_DUPLICATIONERROR_FILE_IN_PROJECT,path);
		MessageBox(hOwner,temporary,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
		return;
	}


	//////////////////////
	//c[r[ɒǉ
	HTREEITEM hTreeItem;
	_splitpath(path,0,0,temporary,temp2);
	lstrcat(temporary,temp2);
	hTreeItem=pobj_FileTree->insert(temporary);


	//ProjectInfo.ppobj_DBFileInfoIuWFNgɒǉ
	ProjectInfo.pobj_DBFileInfo->add(path,hTreeItem);


	ProjectInfo.modify=1;

	//t@CɂNXr[̍ĕ\
	ResetClassTree(-1);
}
void Project_File_Delete(HTREEITEM hTreeItem){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;

	if(ProjectInfo.pobj_DBFileInfo->IsMainFile(hTreeItem)){
		//"̃t@C̓vWFNg̃C t@CłBvWFNg폜邱Ƃ͂ł܂B"
		MessageBox(hOwner,STRING_ERROR_CANT_MAINFILE,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	//c[r[폜
	TreeView_DeleteItem(pobj_FileTree->hTree,hTreeItem);

	//ProjectInfo.pobj_DBFileInfoIuWFNg폜
	ProjectInfo.pobj_DBFileInfo->del(hTreeItem);

	ProjectInfo.modify=1;

	//t@CɂNXr[̍ĕ\
	ResetClassTree(-1);
}

void MakeNewProject(){
	extern HANDLE hHeap;
	extern NEWPROJECTINFO NewProjectInfo;
	int i;
	char buffer[GENERAL_SIZE],dir[MAX_PATH],temporary[MAX_PATH],*pTemp;
	HANDLE hFind;
	WIN32_FIND_DATA wfd;

	//ɃvWFNgJĂꍇ͕
	extern PROJECTINFO ProjectInfo;
	if(ProjectInfo.name[0]){
		if(!CloseProject()) return;
	}

	//[NfBNg쐬
	i=lstrlen(pobj_nv->ProjectSaveDir);
	if(pobj_nv->ProjectSaveDir[i-1]=='\\'&&pobj_nv->ProjectSaveDir[i-2]!=':') pobj_nv->ProjectSaveDir[i-1]=0;
	sprintf(dir,"%s\\%s\\",pobj_nv->ProjectSaveDir,NewProjectInfo.name);
	i=0;
	while(!(dir[i]==':'||(dir[i-1]=='\\'&&dir[i]=='\\'))) i++;
	if(dir[i]==':') i++;
	else{
		i++;
		while(dir[i]!='\\') i++;
	}
	for(i++;;i++){
		if(dir[i]=='\\'){
			lstrcpy(temporary,dir);
			temporary[i]=0;
			hFind=FindFirstFile(temporary,&wfd);
			if(hFind==INVALID_HANDLE_VALUE){
				if(!CreateDirectory(temporary,NULL)){
					MessageBox(hOwner,"fBNg쐬ł܂ł",APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
					return;
				}
			}
			else FindClose(hFind);
		}
		if(dir[i]=='\0') break;
	}


	//////////////////////////////////////
	// vWFNgt@Ci*.pjj쐬
	//////////////////////////////////////

	// o͐gq
	const std::string outputFileExt
		= ( NewProjectInfo.dwTypeID == IDC_DLL ) ? ".dll"
		: ( NewProjectInfo.dwTypeID == IDC_SLL ) ? ".lib"
		: ".exe";

	//擪̒
	lstrcpy(buffer,"\' ActiveBasic Project file.\r\n\r\n");
	i=lstrlen(buffer);

	//vWFNg̃tH[}bgo[W
	sprintf(buffer+i,"#VERSION=%d\r\n\r\n",PROJECT_VERSION);
	i+=lstrlen(buffer+i);

	//W[^CviEXEȂ0ADLLȂ1j
	ActiveBasic::Common::TargetModuleType::EnumType moduleType
		= ( NewProjectInfo.dwTypeID == IDC_DLL ) ? ActiveBasic::Common::TargetModuleType::Dll
		: ( NewProjectInfo.dwTypeID == IDC_SLL ) ? ActiveBasic::Common::TargetModuleType::Sll
		: ActiveBasic::Common::TargetModuleType::Exe;
	lstrcpy(buffer+i,( (std::string)"#MODULETYPE=" + Jenga::Common::ToString( static_cast<int>(moduleType) ) + "\r\n\r\n" ).c_str());
	i+=lstrlen(buffer+i);

	//vWFNg
	sprintf(buffer+i,"#NAME=%s\r\n\r\n",NewProjectInfo.name);
	i+=lstrlen(buffer+i);

	lstrcpy(buffer+i,"#PLATFORM=32\r\n\r\n");
	i+=lstrlen(buffer+i);

	//RADEBhE̐
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE||
		NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX)
		lstrcpy(buffer+i,"#USEWINDOW=1\r\n\r\n");
	else lstrcpy(buffer+i,"#USEWINDOW=0\r\n\r\n");
	i+=lstrlen(buffer+i);

	//vWFNgIvV
	sprintf(buffer+i,"#OPTION=&H%08x\r\n\r\n",NewProjectInfo.dwOption);
	i+=lstrlen(buffer+i);

	//o͐iReleasej
	sprintf(buffer+i,"#OUTPUT_RELEASE=.\\%s%s\r\n\r\n",NewProjectInfo.name, outputFileExt.c_str());
	i+=lstrlen(buffer+i);

	//o͐iDebugj
	sprintf(buffer+i,"#OUTPUT_DEBUG=.\\%s_debug%s\r\n\r\n",NewProjectInfo.name, outputFileExt.c_str());
	i+=lstrlen(buffer+i);

	//}jtFXg
	sprintf(buffer+i,"#MANIFEST=%s.manifest.xml\r\n\r\n",NewProjectInfo.name);
	i+=lstrlen(buffer+i);

	//fobOpiR}hCj
	lstrcpy(buffer+i,"#DEBUG_CMD_LINE=\r\n\r\n");
	i+=lstrlen(buffer+i);

	//fobOpiDLLp̎st@Cj
	lstrcpy(buffer+i,"#DEBUG_EXE_PATH=\r\n\r\n");
	i+=lstrlen(buffer+i);

	//\[Xt@C
	lstrcpy(buffer+i,"#RESOURCE=0\r\n\r\n");
	i+=lstrlen(buffer+i);

	//\[Xt@C
	sprintf(buffer+i,"#SOURCE\r\n%s.ab\r\n",NewProjectInfo.name);
	i+=lstrlen(buffer+i);
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE||
		NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		lstrcpy(buffer+i,"MainWnd.ab\r\n");
		i+=lstrlen(buffer+i);
	}
	if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		lstrcpy(buffer+i,"dx_graphics.sbp\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_input.sbp\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"dx_music.sbp\r\n");
		i+=lstrlen(buffer+i);
	}

	//ۑ
	sprintf(temporary,"%s%s.pj",dir,NewProjectInfo.name);
	if(hFind=FindFirstFile(temporary,&wfd)){
		if(hFind!=INVALID_HANDLE_VALUE){
			FindClose(hFind);

			//"w肵fBNgɂ͂łɃvWFNg݂܂B㏑܂H"
			if(MessageBox(hOwner,STRING_ERROR_PROJECT_OVERWRITE,APPLICATION_NAME,MB_YESNO|MB_ICONEXCLAMATION)==IDNO) return;
		}
	}
	if(!WriteBuffer(temporary,buffer,i)) return;


	///////////////////////////////////////////
	//CvOt@Ci*.abj쐬
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"'---------------------------\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'  Window Message Loop\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'---------------------------\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"Dim msgMain As MSG, iResult As Long\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"Do\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tiResult=GetMessage(msgMain,0,0,0)\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tIf iResult=0 or iResult=-1 Then Exit Do\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tTranslateMessage(msgMain)\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tDispatchMessage(msgMain)\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"Loop\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"' Call destructores and exit process\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"End\r\n");
		i+=lstrlen(buffer+i);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_PROMPTBASE){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"#N88BASIC\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'  vOs܂\r\n\r\n");
		i+=lstrlen(buffer+i);
		if(NewProjectInfo.ShowHelloWorld){
			lstrcpy(buffer+i,"Print \"Hello World!\"\r\n");
			i+=lstrlen(buffer+i);
		}
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DOSPROMPTBASE){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"#console\r\n\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'  vOs܂\r\n\r\n");
		i+=lstrlen(buffer+i);
		if(NewProjectInfo.ShowHelloWorld){
			lstrcpy(buffer+i,"Print \"Hello World!\"\r\n");
			i+=lstrlen(buffer+i);
		}
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_NOBASE){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"'  vOs܂\r\n\r\n");
		i+=lstrlen(buffer+i);
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		const std::string mainExeDirectXAbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\dx\\main_exe_directx.abp";
		pTemp = ReadBuffer( mainExeDirectXAbpPath );

		//#name#vWFNgɒu
		pTemp=PermutationWndPgmTemplate(pTemp,NewProjectInfo.name,0,0,0);
	}
	else if(NewProjectInfo.dwTypeID==IDC_DLL){
		sprintf(buffer,"#include \"%s.idx\"\r\n\r\n",NewProjectInfo.name);
		i=lstrlen(buffer);
		lstrcpy(buffer+i,"'-------------------------------------------------------------------\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'  - ̃t@Cɂ́ADLL̍\vfLq܂B\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'        iF֐`AO[oϐA萔`Ȃǁj\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'        GNX|[gKvȊ֐ɂ́A\"Export\" Cqw肵܂B\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'        iFFunction Export FuncName() As Longj\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"'-------------------------------------------------------------------\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"Function Export DllMain(hinstDLL As HINSTANCE, fdwReason As DWord, lpvReserved As VoidPtr) As Long\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t'DLLGg|Cg\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tSelect Case fdwReason\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\tCase DLL_PROCESS_ATTACH\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\t\t'DLLvZXԂɃ[hꂽɎs܂B\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\t\t_System_StartupProgram()\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\t\tDllMain=1\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\tCase DLL_PROCESS_DETACH\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\t\t\t_System_Call_Destructor_of_GlobalObject()\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\tEnd Select\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"End Function\r\n");
		i+=lstrlen(buffer+i);
		lstrcpy(buffer+i,"\r\n");
		i+=lstrlen(buffer+i);
	}
	else if( NewProjectInfo.dwTypeID == IDC_SLL )
	{
		buffer[0] = 0;
	}

	//ۑ
	if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		sprintf(temporary,"%s%s.ab",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));

		HeapDefaultFree(pTemp);
	}
	else{
		sprintf(temporary,"%s%s.ab",dir,NewProjectInfo.name);
		if(!WriteBuffer(temporary,buffer,lstrlen(buffer))) return;
	}


	/////////////////////
	// MainWnd.ab쐬
	/////////////////////

	std::string mainWndSbpPath = "";
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE)
	{
		mainWndSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\MainWnd_exe_windowbase.sbp";
	}
	else if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX)
	{
		mainWndSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\MainWnd_exe_directx.sbp";
	}

	if( !mainWndSbpPath.empty() ){
		pTemp = ReadBuffer( mainWndSbpPath );

		//#name#vWFNgɒu
		pTemp=PermutationWndPgmTemplate(pTemp,
			NewProjectInfo.name,
			"MainWnd",
			"hMainWnd",
			"MainWndProc");

		if(NewProjectInfo.ShowHelloWorld){
			//Hello World!\
			i=0;
			lstrcpy(buffer+i,"\r\nSub MainWnd_Paint(hDC As HDC)\r\n");
			i+=lstrlen(buffer+i);
			lstrcpy(buffer+i,"\tDim rect As RECT\r\n");
			i+=lstrlen(buffer+i);
			lstrcpy(buffer+i,"\tGetClientRect(hMainWnd,rect)\r\n");
			i+=lstrlen(buffer+i);
			lstrcpy(buffer+i,"\tDrawText(hDC,\"Hello World!\",-1,rect,DT_CENTER or DT_VCENTER or DT_SINGLELINE)\r\n");
			i+=lstrlen(buffer+i);
			lstrcpy(buffer+i,"End Sub\r\n");
			i+=lstrlen(buffer+i);

			pTemp=(char *)HeapReAlloc(hHeap,0,pTemp,lstrlen(pTemp)+lstrlen(buffer)+1);
			lstrcat(pTemp,buffer);
		}

		sprintf(temporary,"%sMainWnd.ab",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));

		HeapDefaultFree(pTemp);
	}


	if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		///////////////////////////
		// DirextXΉAv̂Ƃ
		///////////////////////////

		//dx_graphics.sbpRs[
		const std::string dxGraphicsSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\dx\\dx_graphics.sbp";
		pTemp = ReadBuffer( dxGraphicsSbpPath );
		sprintf(temporary,"%sdx_graphics.sbp",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));
		HeapDefaultFree(pTemp);

		//dx_input.sbpRs[
		const std::string dxInputSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\dx\\dx_input.sbp";
		pTemp = ReadBuffer( dxInputSbpPath );
		sprintf(temporary,"%sdx_input.sbp",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));
		HeapDefaultFree(pTemp);

		//dx_music.sbpRs[
		const std::string dxMusicSbpPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\dx\\dx_music.sbp";
		pTemp = ReadBuffer( dxMusicSbpPath );
		sprintf(temporary,"%sdx_music.sbp",dir,NewProjectInfo.name);
		WriteBuffer(temporary,pTemp,lstrlen(pTemp));
		HeapDefaultFree(pTemp);

		//dx9abm.dllRs[
		sprintf(temporary,"%sRuntime\\dx9abm.dll",pj_editor_Dir);
		sprintf(buffer,"%sdx9abm.dll",dir,NewProjectInfo.name);
		CopyFile(temporary,buffer,0);
	}


	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE||
		NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX){
		/////////////////////////////////////////
		// EBhE`t@Ci*.wndj쐬
		/////////////////////////////////////////
		std::vector<WINDOW_INFO> windowInfos;
		windowInfos.push_back( WINDOW_INFO() );
		windowInfos.back().name="MainWnd";
		windowInfos.back().HandleName="hMainWnd";
		windowInfos.back().pos.x=CW_USEDEFAULT;
		windowInfos.back().pos.y=CW_USEDEFAULT;
		windowInfos.back().size.cx=480;
		windowInfos.back().size.cy=360;
		windowInfos.back().caption=NewProjectInfo.name;
		if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE)
			windowInfos.back().style=WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX|WS_MAXIMIZEBOX|WS_VISIBLE;
		else if(NewProjectInfo.dwTypeID==IDC_EXE_DIRECTX)
			windowInfos.back().style=WS_OVERLAPPED|WS_THICKFRAME|WS_SYSMENU;
		windowInfos.back().ExStyle=0;
		windowInfos.back().MenuID=0;
		windowInfos.back().id=0;
		windowInfos.back().bgColor=COLOR_3DFACE;
		GetDefaultWindowFont(&windowInfos.back().LogFont);
		windowInfos.back().IconResName=0;
		windowInfos.back().ClassName="NORMAL";
		windowInfos.back().CallBackName="MainWndProc";
		windowInfos.back().type=WNDTYPE_DEFAULT;
		windowInfos.back().filepath="MainWnd.ab";
		windowInfos.back().NumberOfChildWindows=0;
		sprintf(temporary,"%s%s.wnd",dir,NewProjectInfo.name);

		ProjectInfo.NumberOfMenu=0;
		SaveWindowFile( temporary, windowInfos );
	}


	////////////////////////
	// [Nt@C쐬
	////////////////////////
	lstrcpy(buffer,"case4\r\n\r\n");
	if(NewProjectInfo.dwTypeID==IDC_EXE_WINDOWBASE){
		lstrcat(buffer,"rad,MainWnd\r\n\r\n");
	}
	else{
		sprintf(buffer+lstrlen(buffer),"text,\"%s.ab\",0,0,0,0\r\n\r\n",NewProjectInfo.name);
	}
	lstrcat(buffer,"0\r\n0\r\n0\r\n0,0");
	//ۑ
	sprintf(temporary,"%s%s.wrk",dir,NewProjectInfo.name);
	if(!WriteBuffer(temporary,buffer,lstrlen(buffer))) return;


	//}jtFXg쐬
	char temp2[MAX_PATH];
	const std::string manifestTempXmlPath = ActiveBasic::Common::Environment::GetAbdevSystemDirPath() + "\\manifest_temp.xml";
	sprintf(temp2,"%s%s.manifest.xml",dir,NewProjectInfo.name);
	CopyFile( manifestTempXmlPath.c_str(), temp2, 0 );


	sprintf(temporary,"%s%s.pj",dir,NewProjectInfo.name);
	OpenProject(temporary);
	SaveProject();
}
void SetTreeViewForProjectInfo(){
	extern HANDLE hHeap;
	extern HWND hProjectView;
	extern PROJECTINFO ProjectInfo;
	int i;
	char temporary[MAX_PATH];
	TV_INSERTSTRUCT tv;

	sprintf(temporary,"%s ",ProjectInfo.name);
	lstrcat(temporary,STRING_PROJECT);
	SetWindowText(hProjectView,temporary);

	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;

	//t@C c[
	ProjectInfo.pobj_DBFileInfo->ResetTree();

	//֐c[
	ResetClassTree(-1);

	/////////////////////
	// }eA c[

	//Cursor\[X tH_
	sprintf(temporary,"Cursor %s",STRING_RESOURCE);
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText=temporary;
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	ProjectInfo.res.hCursorTreeItem=tv.hParent;
	for(i=0;i<ProjectInfo.res.NumberOfCursorRes;i++){
		tv.item.iImage=6;
		tv.item.iSelectedImage=6;
		tv.item.pszText=ProjectInfo.res.pCursorResInfo[i].IdName;
		ProjectInfo.res.pCursorResInfo[i].hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);
	}

	//Bitmap\[X tH_
	sprintf(temporary,"Bitmap %s",STRING_RESOURCE);
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText=temporary;
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	ProjectInfo.res.hBitmapTreeItem=tv.hParent;
	for(i=0;i<ProjectInfo.res.NumberOfBitmapRes;i++){
		tv.item.iImage=5;
		tv.item.iSelectedImage=5;
		tv.item.pszText=ProjectInfo.res.pBitmapResInfo[i].IdName;
		ProjectInfo.res.pBitmapResInfo[i].hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);
	}

	//Icon\[X tH_
	sprintf(temporary,"Icon %s",STRING_RESOURCE);
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText=temporary;
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	ProjectInfo.res.hIconTreeItem=tv.hParent;
	for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
		tv.item.iImage=4;
		tv.item.iSelectedImage=4;
		if(i==0){
			sprintf(temporary,"%s (Main)",ProjectInfo.res.pIconResInfo[i].IdName);
			tv.item.pszText=temporary;
		}
		else tv.item.pszText=ProjectInfo.res.pIconResInfo[i].IdName;
		ProjectInfo.res.pIconResInfo[i].hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);
	}

	//MenutH_
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText="Menu";
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	ProjectInfo.hMenuTreeItem=tv.hParent;
	for(i=0;i<ProjectInfo.NumberOfMenu;i++){
		tv.item.iImage=3;
		tv.item.iSelectedImage=3;
		tv.item.pszText=ProjectInfo.pMenuInfo[i].IdName;
		ProjectInfo.pMenuInfo[i].hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);
	}

	//WindowtH_
	tv.hParent=TVI_ROOT;
	tv.item.iImage=0;
	tv.item.iSelectedImage=0;
	tv.item.pszText="Window";
	tv.hParent=TreeView_InsertItem(hMaterialTreeView,&tv);
	ProjectInfo.hWindowTreeItem=tv.hParent;
	BOOST_FOREACH( WINDOW_INFO &windowInfo, ProjectInfo.windowInfos )
	{
		tv.item.iImage=2;
		tv.item.iSelectedImage=2;
		tv.item.pszText = windowInfo.name;
		windowInfo.hTreeItem=TreeView_InsertItem(hMaterialTreeView,&tv);
	}
}
void OpenProject(char *path){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	char *buffer,temporary[MAX_PATH],temp2[MAX_PATH];

	//ɃvWFNgJĂꍇ͕
	if(ProjectInfo.name[0]){
		if(!CloseProject()) return;
	}
	memset(&ProjectInfo,0,sizeof(PROJECTINFO));

	//vWFNg̍ƃfBNg擾
	_splitpath(path,ProjectInfo.dir,temporary,0,0);
	lstrcat(ProjectInfo.dir,temporary);

	//t@CJAۑ̏fBNgZbg
	lstrcpy(pobj_nv->DefSaveDir,ProjectInfo.dir);


	//////////////////////////////////////////
	// \[Xf[^p̈m
	ProjectInfo.res.pCursorResInfo=(RESITEMINFO *)HeapAlloc(hHeap,0,1);
	ProjectInfo.res.NumberOfCursorRes=0;
	ProjectInfo.res.pBitmapResInfo=(RESITEMINFO *)HeapAlloc(hHeap,0,1);
	ProjectInfo.res.NumberOfBitmapRes=0;
	ProjectInfo.res.pIconResInfo=(RESITEMINFO *)HeapAlloc(hHeap,0,1);
	ProjectInfo.res.NumberOfIconRes=0;


	//////////////////////////////////////////
	//vWFNgt@Ci*.pjjI[v
	buffer=ReadBuffer(path);
	if(!buffer) return;

	//
	ProjectInfo.pobj_DBFileInfo=new CDBFileInfo();
	bool isUseWindow = false;
	for(i=0;;i++){
		if(buffer[i]=='\0') break;
		if(buffer[i]=='\r'&&buffer[i+1]=='\n'&&buffer[i+2]=='#'){
			for(i+=3,i2=0;;i++,i2++){
				if(!IsVariableChar(buffer[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(lstrcmpi(temporary,"VERSION")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				ProjectInfo.dwVersion=GetValue(temporary);
			}
			else if(lstrcmpi(temporary,"MODULETYPE")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				ProjectInfo.dwModuleType=atoi(temporary);
			}
			else if(lstrcmpi(temporary,"NAME")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						ProjectInfo.name[i2]=0;
						break;
					}
					ProjectInfo.name[i2]=buffer[i];
				}
			}
			else if(lstrcmpi(temporary,"PLATFORM")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				i2=atoi(temporary);
				extern HWND hSelectCompilerCombo;
				if(i2==32){
					//vbgtH[Win32I
					SendMessage(hSelectCompilerCombo,CB_SETCURSEL,0,0);
				}
				else if(i2==64){
					//vbgtH[Win64I
					SendMessage(hSelectCompilerCombo,CB_SETCURSEL,1,0);
				}
				SendMessage(hSelectCompilerCombo,WM_COMMAND,MAKELONG(0,CBN_SELCHANGE),0);
			}
			else if(lstrcmpi(temporary,"USEWINDOW")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				if( atoi(temporary) > 0 )
				{
					isUseWindow = true;
				}
			}
			else if(lstrcmpi(temporary,"OPTION")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				ProjectInfo.dwOption=GetValue(temporary);
			}
			else if(lstrcmpi(temporary,"OUTPUT_RELEASE")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(ProjectInfo.lpszOutput_Release,temporary);
			}
			else if(lstrcmpi(temporary,"OUTPUT_DEBUG")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(ProjectInfo.lpszOutput_Debug,temporary);
			}
			else if(lstrcmpi(temporary,"MANIFEST")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(ProjectInfo.szManifestPath,temporary);
			}
			else if(lstrcmpi(temporary,"DEBUG_CMD_LINE")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(ProjectInfo.szCmdLine,temporary);
			}
			else if(lstrcmpi(temporary,"DEBUG_EXE_PATH")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				lstrcpy(ProjectInfo.szExePath,temporary);
			}
			else if(lstrcmpi(temporary,"RESOURCE")==0&&buffer[i]=='='){
				for(i++,i2=0;;i++,i2++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						temporary[i2]=0;
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
					temporary[i2]=buffer[i];
				}
				if(temporary[0]!='\0'&&(!(temporary[0]=='0'&&temporary[1]=='\0'))){
					lstrcpy(ProjectInfo.ResourceFileName,temporary);
					GetResourceData();
				}
				else{
					sprintf(ProjectInfo.ResourceFileName,"%s.rc",ProjectInfo.name);
				}
			}
			else if(lstrcmpi(temporary,"SOURCE")==0&&buffer[i]=='\r'&&buffer[i+1]=='\n'){
				while(1){
					for(i+=2,i2=0;;i++,i2++){
						if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
							temporary[i2]=0;
							break;
						}
						temporary[i2]=buffer[i];
					}
					if(temporary[0]=='\0') break;
					ProjectInfo.pobj_DBFileInfo->add(temporary,0);

					if(buffer[i]=='\0') break;
				}
			}
			else{
				//sȃp[^͖
				for(i++;;i++){
					if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
						if(buffer[i]=='\r'&&buffer[i+1]=='\n') i-=2;
						break;
					}
				}
			}
			if(buffer[i]=='\0') break;
		}
	}
	HeapDefaultFree(buffer);

	//Âo[Wt@Cl
	if(ProjectInfo.dwVersion<=4){
		if(ProjectInfo.dwModuleType==MT_DLL)
			sprintf(ProjectInfo.lpszOutput_Release,".\\%s.dll",ProjectInfo.name);
		else sprintf(ProjectInfo.lpszOutput_Release,".\\%s.exe",ProjectInfo.name);
		sprintf(ProjectInfo.lpszOutput_Debug,".\\%s_debug.exe",ProjectInfo.name);
	}

	//u[N|Cg
	ProjectInfo.pobj_DBBreakPoint=new CDBBreakPoint();


	if( isUseWindow )
	{
		/////////////////////////////////////////////
		//EBhE`t@Ci*.wndjI[v
		sprintf(temp2,"%s%s.wnd",ProjectInfo.dir,ProjectInfo.name);
		if(!OpenWindowFile(temp2)) return;
	}
	else{
		ProjectInfo.windowInfos.clear();

		ProjectInfo.NumberOfMenu=0;
		ProjectInfo.pMenuInfo=(MENU_INFO *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
	}


	//vWFNg r[ݒA\
	extern HWND hProjectView;
	SetTreeViewForProjectInfo();
	if(!IsWindowVisible(hProjectView)) SendMessage(hOwner,WM_COMMAND,IDM_PROJECTVIEW,0);


	//j[Ԃݒ
	ResetState_DocMenu();


	//////////////////////////////////////////
	//[Nt@Ci*.wrkjI[v
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HTREEITEM hTreeItem;
	HANDLE hFind;
	WIN32_FIND_DATA wfd;
	HWND hChild;
	int WndNum;
	sprintf(temp2,"%s%s.wrk",ProjectInfo.dir,ProjectInfo.name);
	hFind=FindFirstFile(temp2,&wfd);
	if(hFind!=INVALID_HANDLE_VALUE){
		FindClose(hFind);
		buffer=ReadBuffer(temp2);
		if(!buffer) return;

		//́Af
		memcpy(temporary,buffer,5);
		temporary[5]=0;
		if(lstrcmp(temporary,"case4")==0){

			LockWindowUpdate(hOwner);
			for(i=9,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					if(i2!=0){
						temporary[i2]=0;
						for(i3=0;;i3++){
							if(temporary[i3]==','||temporary[i3]=='\0') break;
						}
						if(temporary[i3]=='\0') goto EndToSetWorkFile;
						lstrcpy(temp2,temporary+i3+1);
						temporary[i3]=0;
						if(lstrcmpi(temporary,"text")==0){
							if(temp2[0]!='\"') goto EndToSetWorkFile;

							//t@CJ
							i2=1;
							for(i3=0;;i2++,i3++){
								if(temp2[i2]=='\"'||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							GetFullPath(temporary,ProjectInfo.dir);
							hChild=OpenFileWithExtension(temporary);
							WndNum=GetWndNum(hChild);
							if(WndNum==-1){
								goto EndToSetWorkFile;
							}

							//ResetScrollbarĕ`掞ɌĂяôŁAĕ`悷
							InvalidateRect(MdiInfo[WndNum].pMdiTextEdit->hEdit,NULL,0);
							UpdateWindow(MdiInfo[WndNum].pMdiTextEdit->hEdit);

							if(temp2[i2]=='\0') goto EndToSetWorkFile;
							if(temp2[i2+1]!=',') goto EndToSetWorkFile;

							//ȑÕXN[ʒu𕜌
							SCROLLINFO si;
							POINT pos;
							for(i2+=2,i3=0;;i2++,i3++){
								if(temp2[i2]==','||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							sscanf(temporary,"%d",&pos.x);
							if(temp2[i2]=='\0') goto EndToSetWorkFile;
							for(i2++,i3=0;;i2++,i3++){
								if(temp2[i2]==','||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							sscanf(temporary,"%d",&pos.y);
							si.cbSize=sizeof(SCROLLINFO);
							si.fMask=SIF_POS;
							si.nPos=pos.x;
							SetScrollInfo(MdiInfo[WndNum].pMdiTextEdit->hEdit,SB_HORZ,&si,1);
							si.nPos=pos.y;
							SetScrollInfo(MdiInfo[WndNum].pMdiTextEdit->hEdit,SB_VERT,&si,1);

							if(temp2[i2]=='\0') goto EndToSetWorkFile;

							//LbgʒuZbg
							for(i2++,i3=0;;i2++,i3++){
								if(temp2[i2]==','||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							sscanf(temporary,"%d",&pos.x);
							if(temp2[i2]=='\0') goto EndToSetWorkFile;
							for(i2++,i3=0;;i2++,i3++){
								if(temp2[i2]==','||temp2[i2]=='\0'){
									temporary[i3]=0;
									break;
								}
								temporary[i3]=temp2[i2];
							}
							sscanf(temporary,"%d",&pos.y);
							TextEdit_SetSel(WndNum,pos.x,pos.y);
						}
						else if(lstrcmpi(temporary,"rad")==0){
							for(i3=0;i3<static_cast<int>(ProjectInfo.windowInfos.size());i3++){
								if(lstrcmpi(ProjectInfo.windowInfos[i3].name,temp2)==0){
									NewRadWindow( ProjectInfo.windowInfos[i3] );
									break;
								}
							}
						}
						else if(lstrcmpi(temporary,"menu")==0){
							for(i3=0;i3<ProjectInfo.NumberOfMenu;i3++){
								if(lstrcmpi(ProjectInfo.pMenuInfo[i3].IdName,temp2)==0){
									NewMenuWindow(&ProjectInfo.pMenuInfo[i3]);
									break;
								}
							}
						}
						else if(lstrcmpi(temporary,"icon")==0){
							for(i3=0;i3<ProjectInfo.res.NumberOfIconRes;i3++){
								if(lstrcmpi(ProjectInfo.res.pIconResInfo[i3].path,temp2)==0){
									GetFullPath(temp2,ProjectInfo.dir);
									NewIconEditWindow(temp2);
									break;
								}
							}
						}
						i++;
						i2=-1;
						continue;
					}
					else break;
				}
				temporary[i2]=buffer[i];
			}

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			sscanf(temporary,"%d",&i2);

			switch( i2 ){
				case 0:
					ShowFileView();
					break;
				case 1:
					ShowClassView();
					break;
				case 2:
					ShowMaterialView();
					break;
			}

			if(buffer[i]=='\0') goto EndToSetWorkFile;

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(temporary[0]=='1') TreeView_Expand(pobj_FileTree->hTree,TreeView_GetRoot(pobj_FileTree->hTree),TVE_EXPAND);

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(temporary[0]=='1') TreeView_Expand(hProcedureTreeView,TreeView_GetRoot(hProcedureTreeView),TVE_EXPAND);

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			hTreeItem=TreeView_GetRoot(hMaterialTreeView);
			i2=0;
			while(hTreeItem){
				i2=GetOneParameter(temporary,i2,temp2);
				if(GetValue(temp2)) TreeView_Expand(hMaterialTreeView,hTreeItem,TVE_EXPAND);
				hTreeItem=TreeView_GetNextSibling(hMaterialTreeView,hTreeItem);
			}
		}
		else if(lstrcmp(temporary,"case3")==0){
			////////////////////////////////////////
			// ÂtH[}bg̃[Nt@C

			LockWindowUpdate(hOwner);
			for(i=9,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					if(i2!=0){
						temporary[i2]=0;
						for(i3=0;;i3++){
							if(temporary[i3]==','||temporary[i3]=='\0') break;
						}
						if(temporary[i3]=='\0') goto EndToSetWorkFile;
						lstrcpy(temp2,temporary+i3+1);
						temporary[i3]=0;
						if(lstrcmpi(temporary,"text")==0){
							for(i3=0;;i3++){
								if(temp2[i3]==','||temp2[i3]=='\0') break;
							}
							if(temp2[i3]=='\0') goto EndToSetWorkFile;
							lstrcpy(temporary,temp2+i3+1);
							temp2[i3]=0;
							GetFullPath(temporary,ProjectInfo.dir);
							sscanf(temp2,"%d",&i3);

							//t@CJ
							hChild=OpenFileWithExtension(temporary);
							WndNum=GetWndNum(hChild);

							//LbgʒuZbg
							TextEdit_SetSel(WndNum,i3,i3);
						}
						else if(lstrcmpi(temporary,"rad")==0){
							for(i3=0;i3<static_cast<int>(ProjectInfo.windowInfos.size());i3++){
								if(lstrcmpi(ProjectInfo.windowInfos[i3].name,temp2)==0){
									NewRadWindow( ProjectInfo.windowInfos[i3] );
									break;
								}
							}
						}
						else if(lstrcmpi(temporary,"menu")==0){
							for(i3=0;i3<ProjectInfo.NumberOfMenu;i3++){
								if(lstrcmpi(ProjectInfo.pMenuInfo[i3].IdName,temp2)==0){
									NewMenuWindow(&ProjectInfo.pMenuInfo[i3]);
									break;
								}
							}
						}
						else if(lstrcmpi(temporary,"icon")==0){
							for(i3=0;i3<ProjectInfo.res.NumberOfIconRes;i3++){
								if(lstrcmpi(ProjectInfo.res.pIconResInfo[i3].path,temp2)==0){
									GetFullPath(temp2,ProjectInfo.dir);
									NewIconEditWindow(temp2);
									break;
								}
							}
						}
						i++;
						i2=-1;
						continue;
					}
					else break;
				}
				temporary[i2]=buffer[i];
			}

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			sscanf(temporary,"%d",&i2);

			switch( i2 ){
				case 0:
					ShowFileView();
					break;
				case 1:
					ShowClassView();
					break;
				case 2:
					ShowMaterialView();
					break;
			}

			if(buffer[i]=='\0') goto EndToSetWorkFile;

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(temporary[0]=='1') TreeView_Expand(pobj_FileTree->hTree,TreeView_GetRoot(pobj_FileTree->hTree),TVE_EXPAND);

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			if(temporary[0]=='1') TreeView_Expand(hProcedureTreeView,TreeView_GetRoot(hProcedureTreeView),TVE_EXPAND);

			for(i+=2,i2=0;;i++,i2++){
				if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=buffer[i];
			}
			hTreeItem=TreeView_GetRoot(hMaterialTreeView);
			i2=0;
			while(hTreeItem){
				i2=GetOneParameter(temporary,i2,temp2);
				if(GetValue(temp2)) TreeView_Expand(hMaterialTreeView,hTreeItem,TVE_EXPAND);
				hTreeItem=TreeView_GetNextSibling(hMaterialTreeView,hTreeItem);
			}
		}
EndToSetWorkFile:
		LockWindowUpdate(NULL);
		HeapDefaultFree(buffer);
	}


	//EBhE ^CgύX
	sprintf(temporary,"%s - %s",ProjectInfo.name,APPLICATION_NAME);
	SetWindowText(hOwner,temporary);


	ProjectInfo.modify=0;
	ProjectInfo.ModifyOfMaterial=0;
	ProjectInfo.ModifuOfResource=0;
}
BOOL ProjectModifyCheck(BOOL bRun){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,WndNum,sw;
	HWND hChild;
	char temporary[MAX_PATH];
	if(ProjectInfo.modify||ProjectInfo.ModifyOfMaterial||ProjectInfo.ModifuOfResource){
		if(bRun==0||pobj_nv->bSaveCheckProject){
			//"\"%s\" vWFNg͕ύXĂ܂Bۑ܂H"
			sprintf(temporary,STRING_MODIFYCHECK_PROJECT,ProjectInfo.name);
			i=MessageBox(hOwner,temporary,APPLICATION_NAME,MB_YESNOCANCEL|MB_ICONEXCLAMATION);

			if(i==IDCANCEL) return 0;
			if(i==IDYES) SaveProject();
		}
		else SaveProject();
		return 1;
	}
	hChild=GetWindow(hClient,GW_CHILD);
	while(hChild){
		WndNum=GetWndNum(hChild);
		sw=0;
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
			if( MdiInfo[WndNum].pMdiTextEdit->IsModified() ){
				for(i=0;i<ProjectInfo.pobj_DBFileInfo->iNum;i++){
					ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i]->GetFullPath(temporary);
					if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0) sw=1;
				}
			}
		}
		else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
			if(MdiInfo[WndNum].MdiIconEditInfo->bModify){
				for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
					lstrcpy(temporary,ProjectInfo.res.pIconResInfo[i].path);
					GetFullPath(temporary,ProjectInfo.dir);
					if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0) sw=1;
				}
			}
		}

		if(sw){
			if(bRun==0||pobj_nv->bSaveCheckProject){
				//"\"%s\" vWFNg͕ύXĂ܂Bۑ܂H"
				sprintf(temporary,STRING_MODIFYCHECK_PROJECT,ProjectInfo.name);
				i=MessageBox(hOwner,temporary,APPLICATION_NAME,MB_YESNOCANCEL|MB_ICONEXCLAMATION);

				if(i==IDCANCEL) return 0;
				if(i==IDYES) SaveProject();
			}
			else SaveProject();
			return 1;
		}
		hChild=GetNextWindow(hChild,GW_HWNDNEXT);
	}
	return 2;
}
_int8 CloseProject(void){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,WndNum;
	HWND hChild,hCloseChild;
	char temporary[MAX_PATH];


	//ۑmF
	i=ProjectModifyCheck(0);
	if(i==0) return 0;
	else if(i==2) MakeWorkFile();

	//vWFNgɊւMDIEBhEׂĕ
	hChild=GetWindow(hClient,GW_CHILD);
	while(hChild){
		hCloseChild=hChild;
		hChild=GetNextWindow(hChild,GW_HWNDNEXT);
		WndNum=GetWndNum(hCloseChild);
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
			for(i=0;i<ProjectInfo.pobj_DBFileInfo->iNum;i++){
				ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i]->GetFullPath(temporary);
				if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0){

					//ύXtOItɂ
					MdiInfo[WndNum].pMdiTextEdit->UnModify();

					SendMessage(hCloseChild,WM_CLOSE,0,0);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
			BOOST_FOREACH( const WINDOW_INFO &windowInfo, ProjectInfo.windowInfos )
			{
				if(lstrcmp(MdiInfo[WndNum].path, windowInfo.name)==0){
					SendMessage(hCloseChild,WM_CLOSE,0,0);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum].DocType==WNDTYPE_MENU){
			for(i=0;i<ProjectInfo.NumberOfMenu;i++){
				if(lstrcmp(MdiInfo[WndNum].path,ProjectInfo.pMenuInfo[i].IdName)==0){
					SendMessage(hCloseChild,WM_CLOSE,0,0);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
			for(i=0;ProjectInfo.res.NumberOfIconRes;i++){
				lstrcpy(temporary,ProjectInfo.res.pIconResInfo[i].path);
				GetFullPath(temporary,ProjectInfo.dir);
				if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0){
					SendMessage(hCloseChild,WM_CLOSE,0,0);
					break;
				}
			}
		}
	}

	//t@C̃
	delete ProjectInfo.pobj_DBFileInfo;

	//u[N|Cg̃IuWFNg
	delete ProjectInfo.pobj_DBBreakPoint;

	//EBhẼ
	BOOST_FOREACH( WINDOW_INFO &windowInfo, ProjectInfo.windowInfos )
	{
		HeapDefaultFree(windowInfo.name);
		HeapDefaultFree(windowInfo.HandleName);
		HeapDefaultFree(windowInfo.caption);
		HeapDefaultFree(windowInfo.ClassName);
		HeapDefaultFree(windowInfo.CallBackName);
		HeapDefaultFree(windowInfo.filepath);
		if(windowInfo.MenuID)
			HeapDefaultFree(windowInfo.MenuID);
		if(windowInfo.IconResName)
			HeapDefaultFree(windowInfo.IconResName);

		//qEBhẼ
		for(i2=0;i2<windowInfo.NumberOfChildWindows;i2++){
			HeapDefaultFree(windowInfo.pChildInfo[i2].IdName);
			HeapDefaultFree(windowInfo.pChildInfo[i2].caption);
			if(windowInfo.pChildInfo[i2].Control==CT_IMAGEBOX){
				//C[W {bNX̏ꍇ
				HeapDefaultFree(windowInfo.pChildInfo[i2].ImageCtrlInfo.path);
			}
		}
		HeapDefaultFree(windowInfo.pChildInfo);
	}
	ProjectInfo.windowInfos.clear();

	//j[̃
	HeapMenuDataFree(ProjectInfo.pMenuInfo,ProjectInfo.NumberOfMenu,0);
	HeapDefaultFree(ProjectInfo.pMenuInfo);

	//\[X̃
	for(i=0;i<ProjectInfo.res.NumberOfCursorRes;i++){
		HeapDefaultFree(ProjectInfo.res.pCursorResInfo[i].IdName);
		HeapDefaultFree(ProjectInfo.res.pCursorResInfo[i].path);
	}
	HeapDefaultFree(ProjectInfo.res.pCursorResInfo);
	for(i=0;i<ProjectInfo.res.NumberOfBitmapRes;i++){
		HeapDefaultFree(ProjectInfo.res.pBitmapResInfo[i].IdName);
		HeapDefaultFree(ProjectInfo.res.pBitmapResInfo[i].path);
	}
	HeapDefaultFree(ProjectInfo.res.pBitmapResInfo);
	for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
		HeapDefaultFree(ProjectInfo.res.pIconResInfo[i].IdName);
		HeapDefaultFree(ProjectInfo.res.pIconResInfo[i].path);
	}
	HeapDefaultFree(ProjectInfo.res.pIconResInfo);

	//vWFNg r[\ɂ
	extern HWND hProjectView;
	if(IsWindowVisible(hProjectView)) SendMessage(hOwner,WM_COMMAND,IDM_PROJECTVIEW,0);
	SetWindowText(hProjectView,"Project View");

	TreeView_DeleteAllItems(pobj_FileTree->hTree);
	TreeView_DeleteAllItems(hProcedureTreeView);
	TreeView_DeleteAllItems(hMaterialTreeView);

	//EBhE ^CgύX
	SetWindowText(hOwner,APPLICATION_NAME);

	ProjectInfo.name[0]=0;

	//j[Ԃݒ
	ResetState_DocMenu();

	return 1;
}
void MakeWorkFile(void){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,WndNum;
	char temporary[MAX_PATH],buffer[32767];
	HWND hChild;
	CHARRANGE CharRange;

	//[Nt@Ci*.wrkj쐬
	lstrcpy(buffer,"case4\r\n\r\n");
	i2=lstrlen(buffer);


	///////////////////////
	//MDIEBhE̕
	hChild=GetWindow(GetWindow(hClient,GW_CHILD),GW_HWNDLAST);
	while(hChild){
		WndNum=GetWndNum(hChild);
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
			for(i=0;i<ProjectInfo.pobj_DBFileInfo->iNum;i++){
				ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i]->GetFullPath(temporary);
				if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0){
					TextEdit_GetSel(WndNum,&CharRange);

					SCROLLINFO si;
					POINT pos;
					si.cbSize=sizeof(SCROLLINFO);
					si.fMask=SIF_POS;
					GetScrollInfo(MdiInfo[WndNum].pMdiTextEdit->hEdit,SB_HORZ,&si);
					pos.x=si.nPos;
					GetScrollInfo(MdiInfo[WndNum].pMdiTextEdit->hEdit,SB_VERT,&si);
					pos.y=si.nPos;

					sprintf(buffer+i2,"text,\"%s\",%d,%d,%d,%d\r\n",
						ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i]->m_path,
						pos.x,
						pos.y,
						CharRange.cpMin,
						CharRange.cpMax);
					i2+=lstrlen(buffer+i2);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
			BOOST_FOREACH( WINDOW_INFO &windowInfo, ProjectInfo.windowInfos )
			{
				if(lstrcmpi(MdiInfo[WndNum].path,windowInfo.name)==0){
					sprintf(buffer+i2,"rad,%s\r\n",MdiInfo[WndNum].path);
					i2+=lstrlen(buffer+i2);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum].DocType==WNDTYPE_MENU){
			for(i=0;i<ProjectInfo.NumberOfMenu;i++){
				if(lstrcmpi(MdiInfo[WndNum].path,ProjectInfo.pMenuInfo[i].IdName)==0){
					sprintf(buffer+i2,"menu,%s\r\n",MdiInfo[WndNum].path);
					i2+=lstrlen(buffer+i2);
					break;
				}
			}
		}
		else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
			for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
				lstrcpy(temporary,ProjectInfo.res.pIconResInfo[i].path);
				GetFullPath(temporary,ProjectInfo.dir);
				if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0){
					sprintf(buffer+i2,"icon,%s\r\n",ProjectInfo.res.pIconResInfo[i].path);
					i2+=lstrlen(buffer+i2);
					break;
				}
			}
		}
		hChild=GetNextWindow(hChild,GW_HWNDPREV);
	}
	lstrcpy(buffer+i2,"\r\n");
	i2+=2;


	//////////////////////////
	//c[r[̓WJ
	sprintf(buffer+i2,"%d\r\n",TabCtrl_GetCurSel(hProjectViewTab));
	i2+=lstrlen(buffer+i2);
	TVITEM tvItem;
	memset(&tvItem,0,sizeof(TVITEM));
	tvItem.mask=TVIF_HANDLE|TVIF_STATE;
	tvItem.hItem=TreeView_GetRoot(pobj_FileTree->hTree);
	TreeView_GetItem(pobj_FileTree->hTree,&tvItem);
	if(tvItem.state&TVIS_EXPANDED) i=1;
	else i=0;
	sprintf(buffer+i2,"%d\r\n",i);
	i2+=lstrlen(buffer+i2);

	tvItem.hItem=TreeView_GetRoot(hProcedureTreeView);
	TreeView_GetItem(hProcedureTreeView,&tvItem);
	if(tvItem.state&TVIS_EXPANDED) i=1;
	else i=0;
	sprintf(buffer+i2,"%d\r\n",i);
	i2+=lstrlen(buffer+i2);

	tvItem.hItem=TreeView_GetRoot(hMaterialTreeView);
	while(tvItem.hItem){
		TreeView_GetItem(hMaterialTreeView,&tvItem);
		if(tvItem.state&TVIS_EXPANDED) i=1;
		else i=0;
		sprintf(buffer+i2,"%d",i);
		i2+=lstrlen(buffer+i2);

		tvItem.hItem=TreeView_GetNextSibling(hMaterialTreeView,tvItem.hItem);
		if(tvItem.hItem){
			lstrcpy(buffer+i2,",");
			i2+=lstrlen(buffer+i2);
		}
	}


	//ۑ
	sprintf(temporary,"%s%s.wrk",ProjectInfo.dir,ProjectInfo.name);
	WriteBuffer(temporary,buffer,i2);
}
void SaveProject(void){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3,WndNum;
	char temporary[MAX_PATH],buffer[32767];
	HWND hChild;

	//"vWFNgۑ..."
	SetStatusText(STRING_PROJECT_SAVING);

	//vWFNgt@C̃o[Wݒ
	ProjectInfo.dwVersion=PROJECT_VERSION;

	hChild=GetWindow(hClient,GW_CHILD);
	while(hChild){
		WndNum=GetWndNum(hChild);
		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
			if( MdiInfo[WndNum].pMdiTextEdit->IsModified() ){
				for(i=0;i<ProjectInfo.pobj_DBFileInfo->iNum;i++){
					ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i]->GetFullPath(temporary);
					if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0){
						SaveDocument(hChild,NULL);
						break;
					}
				}
			}
		}
		if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
			if(MdiInfo[WndNum].MdiIconEditInfo->bModify){
				for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
					lstrcpy(temporary,ProjectInfo.res.pIconResInfo[i].path);
					GetFullPath(temporary,ProjectInfo.dir);
					if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0){
						SaveDocument(hChild,NULL);
						break;
					}
				}
			}
		}
		hChild=GetNextWindow(hChild,GW_HWNDNEXT);
	}


	//////////////////////////////////////
	//vWFNgt@Ci*.pjj쐬
	lstrcpy(buffer,"\' ActiveBasic Project file.\r\n\r\n");
	i2=lstrlen(buffer);
	sprintf(buffer+i2,"#VERSION=%d\r\n\r\n",ProjectInfo.dwVersion);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#MODULETYPE=%d\r\n\r\n",ProjectInfo.dwModuleType);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#NAME=%s\r\n\r\n",ProjectInfo.name);
	i2+=lstrlen(buffer+i2);
	extern HWND hSelectCompilerCombo;
	if(SendMessage(hSelectCompilerCombo,CB_GETCURSEL,0,0)==0){
		sprintf(buffer+i2,"#PLATFORM=32\r\n\r\n",ProjectInfo.name);
		i2+=lstrlen(buffer+i2);
	}
	else{
		sprintf(buffer+i2,"#PLATFORM=64\r\n\r\n",ProjectInfo.name);
		i2+=lstrlen(buffer+i2);
	}
	sprintf(buffer+i2,"#USEWINDOW=%d\r\n\r\n",ProjectInfo.windowInfos.size());
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#OPTION=&H%08x\r\n\r\n",ProjectInfo.dwOption);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#OUTPUT_RELEASE=%s\r\n\r\n",ProjectInfo.lpszOutput_Release);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#OUTPUT_DEBUG=%s\r\n\r\n",ProjectInfo.lpszOutput_Debug);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#MANIFEST=%s\r\n\r\n",ProjectInfo.szManifestPath);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#DEBUG_CMD_LINE=%s\r\n\r\n",ProjectInfo.szCmdLine);
	i2+=lstrlen(buffer+i2);
	sprintf(buffer+i2,"#DEBUG_EXE_PATH=%s\r\n\r\n",ProjectInfo.szExePath);
	i2+=lstrlen(buffer+i2);
	if(ProjectInfo.ResourceFileName[0]){
		sprintf(buffer+i2,"#RESOURCE=%s\r\n\r\n",ProjectInfo.ResourceFileName);
		i2+=lstrlen(buffer+i2);
	}
	else{
		lstrcpy(buffer+i2,"#RESOURCE=0\r\n\r\n");
		i2+=lstrlen(buffer+i2);
	}
	sprintf(buffer+i2,"#SOURCE\r\n");
	i2+=lstrlen(buffer+i2);
	for(i=0;i<ProjectInfo.pobj_DBFileInfo->iNum;i++){
		sprintf(buffer+i2,"%s\r\n",ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i]->m_path);
		i2+=lstrlen(buffer+i2);
	}

	//ۑ
	sprintf(temporary,"%s%s.pj",ProjectInfo.dir,ProjectInfo.name);
	WriteBuffer(temporary,buffer,i2);


	//////////////////////////////////
	// \[Xt@Ci*.rcAresource.abj쐬
	if(ProjectInfo.ResourceFileName[0]){
		i2=0;
		i3=101;
		for(i=0;i<ProjectInfo.res.NumberOfCursorRes;i++,i3++){
			sprintf(buffer+i2,"Const %s=%d\r\n",
				ProjectInfo.res.pCursorResInfo[i].IdName,
				i3);
			i2+=lstrlen(buffer+i2);
		}
		for(i=0;i<ProjectInfo.res.NumberOfBitmapRes;i++,i3++){
			sprintf(buffer+i2,"Const %s=%d\r\n",
				ProjectInfo.res.pBitmapResInfo[i].IdName,
				i3);
			i2+=lstrlen(buffer+i2);
		}
		for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++,i3++){
			sprintf(buffer+i2,"Const %s=%d\r\n",
				ProjectInfo.res.pIconResInfo[i].IdName,
				i3);
			i2+=lstrlen(buffer+i2);
		}

		//ۑiresource.abj
		lstrcpy(temporary,"resource.ab");
		GetFullPath(temporary,ProjectInfo.dir);
		WriteBuffer(temporary,buffer,i2);

		i2=0;
		for(i=0;i<ProjectInfo.res.NumberOfCursorRes;i++){
			sprintf(buffer+i2,"%s CURSOR \"%s\"\r\n",
				ProjectInfo.res.pCursorResInfo[i].IdName,
				ProjectInfo.res.pCursorResInfo[i].path);
			i2+=lstrlen(buffer+i2);
		}
		for(i=0;i<ProjectInfo.res.NumberOfBitmapRes;i++){
			sprintf(buffer+i2,"%s BITMAP \"%s\"\r\n",
				ProjectInfo.res.pBitmapResInfo[i].IdName,
				ProjectInfo.res.pBitmapResInfo[i].path);
			i2+=lstrlen(buffer+i2);
		}
		for(i=0;i<ProjectInfo.res.NumberOfIconRes;i++){
			sprintf(buffer+i2,"%s ICON \"%s\"\r\n",
				ProjectInfo.res.pIconResInfo[i].IdName,
				ProjectInfo.res.pIconResInfo[i].path);
			i2+=lstrlen(buffer+i2);
		}

		//}jtFXg
		if(ProjectInfo.dwOption&PJ_OP_RC_MANIFEST){
			sprintf(buffer+i2,"CREATEPROCESS_MANIFEST_RESOURCE_ID RT_MANIFEST \"%s\"\r\n",
				ProjectInfo.szManifestPath);
			i2+=lstrlen(buffer+i2);
		}

		//ۑ
		lstrcpy(temporary,ProjectInfo.ResourceFileName);
		GetFullPath(temporary,ProjectInfo.dir);
		WriteBuffer(temporary,buffer,i2);
	}


	///////////////////////////////////////
	//CfbNXt@Ci*.idxj쐬
	buffer[0]=0;
	lstrcpy(buffer,"' CfbNX vO\r\n");
	i2=lstrlen(buffer);
	if(ProjectInfo.dwOption&PJ_OP_SOURCE_MASK){
		if(ProjectInfo.dwOption&PJ_OP_STRICT){
			/* #strictfBNeBu͍͎gĂȂ
			lstrcpy(buffer+i2,"\r\n");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"#strict");
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"\r\n");
			i2+=lstrlen(buffer+i2);
			*/
		}
		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"'Win32API̒`t@C\r\n");
		i2+=lstrlen(buffer+i2);
		if(ProjectInfo.dwOption&PJ_OP_MMSYSTEM){
			lstrcpy(buffer+i2,"#include <api_mmsys.sbp>\r\n");
			i2+=lstrlen(buffer+i2);
		}
		if(ProjectInfo.dwOption&PJ_OP_COMMCTRL){
			lstrcpy(buffer+i2,"#include <api_commctrl.sbp>\r\n");
			i2+=lstrlen(buffer+i2);
		}
		if(ProjectInfo.dwOption&PJ_OP_RICHEDIT){
			lstrcpy(buffer+i2,"#include <api_richedit.sbp>\r\n");
			i2+=lstrlen(buffer+i2);
		}
		if(ProjectInfo.dwOption&PJ_OP_WINSOCK){
			lstrcpy(buffer+i2,"#include <api_winsock2.sbp>\r\n");
			i2+=lstrlen(buffer+i2);
		}
	}
	if( !ProjectInfo.windowInfos.empty() )
	{
		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"'RADc[EBhEvO\r\n");
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"#include \"Callback.wbp\"\r\n");
		i2+=lstrlen(buffer+i2);
	}
	if(ProjectInfo.pobj_DBFileInfo->iNum>1){
		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"'vWFNg̃vO t@C\r\n");
		i2+=lstrlen(buffer+i2);
		for(i=1;i<ProjectInfo.pobj_DBFileInfo->iNum;i++){
			//Ct@C͊܂܂Ȃ
			sprintf(buffer+i2,"#include \"%s\"\r\n",ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i]->m_path);
			i2+=lstrlen(buffer+i2);
			lstrcpy(buffer+i2,"_ClearNamespaceImported\r\n");
			i2+=lstrlen(buffer+i2);
		}
	}
	if( !ProjectInfo.windowInfos.empty() )
	{
		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"'RADc[EBhEvO\r\n");
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"#include \"MakeWindow.wbp\"\r\n");
		i2+=lstrlen(buffer+i2);
	}
	if(ProjectInfo.ResourceFileName[0]){
		//\[Xt@C܂܂ꍇ
		lstrcpy(buffer+i2,"\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"'\[Xt@C\r\n");
		i2+=lstrlen(buffer+i2);
		lstrcpy(buffer+i2,"#include \"resource.ab\"\r\n");
		i2+=lstrlen(buffer+i2);
		sprintf(buffer+i2,"#resource \"%s.rc\"\r\n",ProjectInfo.name);
		i2+=lstrlen(buffer+i2);
	}

	//ۑ
	sprintf(temporary,"%s%s.idx",ProjectInfo.dir,ProjectInfo.name);
	WriteBuffer(temporary,buffer,i2);


	if( !ProjectInfo.windowInfos.empty() )
	{
		/////////////////////////////////////////////////////
		//EBhE֘At@Ci*.wndj쐬Aۑ
		if(ProjectInfo.ModifyOfMaterial){
			sprintf(temporary,"%s%s.wnd",ProjectInfo.dir,ProjectInfo.name);
			SaveWindowFile( temporary, ProjectInfo.windowInfos );
		}

		//.wbpt@C𐶐
		SaveWindowProgram();
	}


	MakeWorkFile();

	SetStatusText("");

	ProjectInfo.modify=0;
	ProjectInfo.ModifuOfResource=0;
}

BOOL SetProjectToRun(void){
	extern PROJECTINFO ProjectInfo;
	HANDLE hFind;
	WIN32_FIND_DATA wfd;

	if(ProjectInfo.pobj_DBFileInfo->iNum==0){
		//"vO t@CvWFNgɑ݂܂B"
		MessageBox(hOwner,STRING_ERROR_NOFILE,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
		return 0;
	}

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	hFind=FindFirstFile( ActiveBasic::Common::Environment::GetCompilerExePath( selectingPlatform ).c_str(), &wfd );
	if(hFind==INVALID_HANDLE_VALUE){
		//"BasicCompiler.exe ܂"
		MessageBox(hOwner,STRING_ERROR_NOBASICCOMPILER,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
		return 0;
	}
	FindClose(hFind);

	//vWFNg\̃o[WႤ́Aĕۑ
	if(ProjectInfo.dwVersion<PROJECT_VERSION)
		ProjectInfo.ModifyOfMaterial=1;

	//ۑmF
	if(!ProjectModifyCheck(1)) return 0;

	return 1;
}
BOOL IsNeedCompileForProject(BOOL bDebug){
	extern PROJECTINFO ProjectInfo;
	int i2;
	char temporary[MAX_PATH];
	HANDLE hFind,hFile;
	WIN32_FIND_DATA wfd;
	FILETIME SourceTime,ExeTime;

	if(bDebug) lstrcpy(temporary,ProjectInfo.lpszOutput_Debug);
	else lstrcpy(temporary,ProjectInfo.lpszOutput_Release);
	GetFullPath(temporary,ProjectInfo.dir);

	hFind=FindFirstFile(temporary,&wfd);
	if(hFind==INVALID_HANDLE_VALUE) return 1;
	FindClose(hFind);

	hFile=CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	GetFileTime(hFile,NULL,NULL,&ExeTime);
	CloseHandle(hFile);

	for(i2=0;i2<ProjectInfo.pobj_DBFileInfo->iNum;i2++){
		ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i2]->GetFullPath(temporary);
		hFile=CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		GetFileTime(hFile,NULL,NULL,&SourceTime);
		CloseHandle(hFile);

		if(SourceTime.dwHighDateTime>ExeTime.dwHighDateTime||
			SourceTime.dwHighDateTime==ExeTime.dwHighDateTime&&
			SourceTime.dwLowDateTime>ExeTime.dwLowDateTime) return 1;
	}
	if( !ProjectInfo.windowInfos.empty() )
	{
		//CallBack.wbp
		lstrcpy(temporary,"CallBack.wbp");
		GetFullPath(temporary,ProjectInfo.dir);
		hFile=CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		GetFileTime(hFile,NULL,NULL,&SourceTime);
		CloseHandle(hFile);
		if(SourceTime.dwHighDateTime>ExeTime.dwHighDateTime||
			SourceTime.dwHighDateTime==ExeTime.dwHighDateTime&&
			SourceTime.dwLowDateTime>ExeTime.dwLowDateTime) return 1;

		//MakeWindow.wbp
		lstrcpy(temporary,"MakeWindow.wbp");
		GetFullPath(temporary,ProjectInfo.dir);
		hFile=CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		GetFileTime(hFile,NULL,NULL,&SourceTime);
		CloseHandle(hFile);
		if(SourceTime.dwHighDateTime>ExeTime.dwHighDateTime||
			SourceTime.dwHighDateTime==ExeTime.dwHighDateTime&&
			SourceTime.dwLowDateTime>ExeTime.dwLowDateTime) return 1;
	}
	return 0;
}
