#include "stdafx.h"

#include "common.h"

#if defined(JPN)
//{
#include "rad_msg_jpn.h"
#else
//p
#include "rad_msg_eng.h"
#endif

int bSupportDlg_NoChange;

LRESULT CALLBACK TestWindowProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	switch(message){
		case WM_CREATE:
			SetPosCenter(hwnd);
			break;
		case WM_KEYDOWN:
			if(wParam==VK_ESCAPE) DestroyWindow(hwnd);
			break;
		case WM_PAINT:
			break;
		case WM_CLOSE:
			DestroyWindow(hwnd);
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}

void ShowTestWindow(int WndInfoNum){
	extern HINSTANCE hInst;
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	static HWND hWnd;
	HWND hChild;
	HFONT *lphFont;
	HANDLE *lphImage;
	int i2,i3;
	char temporary[MAX_PATH];

	if(hWnd){
		OpenIcon(hWnd);

		_endthread();
		return;
	}

	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	if(pWindowInfo->style&WS_CHILD){
		//"`ChEBhEeXg\邱Ƃ͂ł܂"
		MessageBox(hOwner,STRING_RAD_ERROR_CANT_CHILDTEST,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);

		_endthread();
		return;
	}

	lphFont=(HFONT *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,pWindowInfo->NumberOfChildWindows*sizeof(DWORD));
	lphImage=(HANDLE *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,pWindowInfo->NumberOfChildWindows*sizeof(DWORD));

	//eXgp̃CEBhE쐬
	hWnd=CreateWindowEx(pWindowInfo->ExStyle,
		"TestWindow",
		pWindowInfo->name,
		pWindowInfo->style|WS_VISIBLE,
		CW_USEDEFAULT,CW_USEDEFAULT,
		pWindowInfo->size.cx,pWindowInfo->size.cy,
		hOwner,NULL,hInst,NULL);

	//qEBhE쐬
	for(i2=0;i2<pWindowInfo->NumberOfChildWindows;i2++){
		if(pWindowInfo->pChildInfo[i2].Control==CT_UPDOWN){
			CreateUpDownControl(
				pWindowInfo->pChildInfo[i2].style,
				pWindowInfo->pChildInfo[i2].pos.x,pWindowInfo->pChildInfo[i2].pos.y,
				pWindowInfo->pChildInfo[i2].size.cx,pWindowInfo->pChildInfo[i2].size.cy,
				hWnd,0,hInst,
				0,0,100,0);
		}
		else{
			GetItemClassName(temporary,pWindowInfo->pChildInfo[i2].Control);
			hChild=CreateWindowEx(
				pWindowInfo->pChildInfo[i2].ExStyle,
				temporary,
				pWindowInfo->pChildInfo[i2].caption,
				pWindowInfo->pChildInfo[i2].style,
				pWindowInfo->pChildInfo[i2].pos.x,
				pWindowInfo->pChildInfo[i2].pos.y,
				pWindowInfo->pChildInfo[i2].size.cx,
				pWindowInfo->pChildInfo[i2].size.cy,
				hWnd,0,hInst,0);

			lphFont[i2]=CreateFontIndirect(&pWindowInfo->LogFont);
			SendMessage(hChild,WM_SETFONT,(long)lphFont[i2],0);

			if(pWindowInfo->pChildInfo[i2].Control==CT_IMAGEBOX){
				///////////////////////////
				// C[W {bNX̏ꍇ
				///////////////////////////
				if((pWindowInfo->pChildInfo[i2].style&0x000F)==SS_ICON){
					if(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.type==IMGTYPE_FILE)
						lstrcpy(temporary,pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path);
					else{
						for(i3=0;i3<ProjectInfo.res.NumberOfIconRes;i3++){
							if(lstrcmp(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path,
								ProjectInfo.res.pIconResInfo[i3].IdName)==0) break;
						}
						if(i3==ProjectInfo.res.NumberOfIconRes) temporary[0]=0;
						else lstrcpy(temporary,ProjectInfo.res.pIconResInfo[i3].path);
					}
					if(temporary[0]){
						GetFullPath(temporary,ProjectInfo.dir);
						lphImage[i2]=LoadImage(hInst,temporary,IMAGE_ICON,0,0,LR_DEFAULTSIZE|LR_LOADFROMFILE);

						SendMessage(hChild,STM_SETICON,(long)lphImage[i2],0);
					}
				}
				else if((pWindowInfo->pChildInfo[i2].style&0x000F)==SS_BITMAP){
					if(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.type==IMGTYPE_FILE)
						lstrcpy(temporary,pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path);
					else{
						for(i3=0;i3<ProjectInfo.res.NumberOfBitmapRes;i3++){
							if(lstrcmp(pWindowInfo->pChildInfo[i2].ImageCtrlInfo.path,
								ProjectInfo.res.pBitmapResInfo[i3].IdName)==0) break;
						}
						if(i3==ProjectInfo.res.NumberOfBitmapRes) temporary[0]=0;
						else lstrcpy(temporary,ProjectInfo.res.pBitmapResInfo[i3].path);
					}
					if(temporary[0]){
						GetFullPath(temporary,ProjectInfo.dir);
						lphImage[i2]=LoadImage(hInst,temporary,IMAGE_BITMAP,0,0,LR_DEFAULTSIZE|LR_LOADFROMFILE);

						SendMessage(hChild,STM_SETIMAGE,IMAGE_BITMAP,(long)lphImage[i2]);
					}
				}
			}
		}
	}

	MSG msg;
	while(GetMessage(&msg,NULL,0,0)){
		if(IsDialogMessage(hWnd,&msg)) continue;
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	//tHgnhj
	for(i2=0;i2<pWindowInfo->NumberOfChildWindows;i2++){
		if(lphFont[i2]) DeleteObject(lphFont[i2]);
	}
	HeapDefaultFree(lphFont);

	//C[Wnhj
	for(i2=0;i2<pWindowInfo->NumberOfChildWindows;i2++){
		if(lphImage[i2]){
			if((pWindowInfo->pChildInfo[i2].style&0x000F)==SS_ICON)
				DestroyIcon((HICON)lphImage[i2]);
			else if((pWindowInfo->pChildInfo[i2].style&0x000F)==SS_BITMAP)
				DeleteObject(lphImage[i2]);
		}
	}
	HeapDefaultFree(lphImage);

	hWnd=0;

	_endthread();
}

void SetSupportDlgData(int WndNum, const WINDOW_INFO &windowInfo )
{
	////////////////////////////////////
	// T|[g_CAO̓eZbg
	////////////////////////////////////
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern RADINFO RadInfo;
	char temporary[255];
	HWND hSupport;

	bSupportDlg_NoChange=1;

	hSupport=MdiInfo[WndNum].MdiRadInfo->hSupport;

	if(RadInfo.NowDragging>=FRAME_CHANGEPOS_START&&RadInfo.NowDragging<=FRAME_CHANGEPOS_END&&
		(!(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]!=-1&&MdiInfo[WndNum].MdiRadInfo->SelectingItem[1]!=-1))){
		sprintf(temporary,"%d",RadInfo.DraggingRect[0].left-MdiInfo[WndNum].MdiRadInfo->ClientPos.x);
		SetDlgItemText(hSupport,IDC_XPOS,temporary);

		sprintf(temporary,"%d",RadInfo.DraggingRect[0].top-MdiInfo[WndNum].MdiRadInfo->ClientPos.y);
		SetDlgItemText(hSupport,IDC_YPOS,temporary);

		sprintf(temporary,"%d",RadInfo.DraggingRect[0].right-RadInfo.DraggingRect[0].left);
		SetDlgItemText(hSupport,IDC_WIDTH,temporary);

		sprintf(temporary,"%d",RadInfo.DraggingRect[0].bottom-RadInfo.DraggingRect[0].top);
		SetDlgItemText(hSupport,IDC_HEIGHT,temporary);
	}
	else if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW){
		EnableWindow(GetDlgItem(hSupport,IDC_XPOS),0);
		EnableWindow(GetDlgItem(hSupport,IDC_YPOS),0);
		EnableWindow(GetDlgItem(hSupport,IDC_SPIN1),0);
		EnableWindow(GetDlgItem(hSupport,IDC_SPIN2),0);
		EnableWindow(GetDlgItem(hSupport,IDC_SPIN3),1);
		EnableWindow(GetDlgItem(hSupport,IDC_SPIN4),1);

		SetDlgItemText(hSupport,IDC_XPOS,"");
		SetDlgItemText(hSupport,IDC_YPOS,"");

		sprintf(temporary,"%d",windowInfo.size.cx);
		SetDlgItemText(hSupport,IDC_WIDTH,temporary);

		sprintf(temporary,"%d",windowInfo.size.cy);
		SetDlgItemText(hSupport,IDC_HEIGHT,temporary);
	}
	else{
		EnableWindow(GetDlgItem(hSupport,IDC_XPOS),1);
		EnableWindow(GetDlgItem(hSupport,IDC_YPOS),1);

		if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[1]!=-1){
			EnableWindow(GetDlgItem(hSupport,IDC_SPIN1),0);
			EnableWindow(GetDlgItem(hSupport,IDC_SPIN2),0);
			EnableWindow(GetDlgItem(hSupport,IDC_SPIN3),0);
			EnableWindow(GetDlgItem(hSupport,IDC_SPIN4),0);

			SetDlgItemText(hSupport,IDC_XPOS,"");
			SetDlgItemText(hSupport,IDC_YPOS,"");
			SetDlgItemText(hSupport,IDC_WIDTH,"");
			SetDlgItemText(hSupport,IDC_HEIGHT,"");
		}
		else{
			EnableWindow(GetDlgItem(hSupport,IDC_SPIN1),1);
			EnableWindow(GetDlgItem(hSupport,IDC_SPIN2),1);
			EnableWindow(GetDlgItem(hSupport,IDC_SPIN3),1);
			EnableWindow(GetDlgItem(hSupport,IDC_SPIN4),1);

			sprintf(temporary,"%d",windowInfo.pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.x);
			SetDlgItemText(hSupport,IDC_XPOS,temporary);

			sprintf(temporary,"%d",windowInfo.pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.y);
			SetDlgItemText(hSupport,IDC_YPOS,temporary);

			sprintf(temporary,"%d",windowInfo.pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].size.cx);
			SetDlgItemText(hSupport,IDC_WIDTH,temporary);

			sprintf(temporary,"%d",windowInfo.pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].size.cy);
			SetDlgItemText(hSupport,IDC_HEIGHT,temporary);
		}
	}

	bSupportDlg_NoChange=0;
}

BOOL CALLBACK DlgRadSupport(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	static BOOL bTimer;
	int i,i3;
	char temporary[255];
	POINTANDSIZE PointAndSize;
	RECT rect;

	switch(message){
		case WM_INITDIALOG:
			SendDlgItemMessage(hwnd,IDC_SPIN1,UDM_SETBUDDY,(long)GetDlgItem(hwnd,IDC_XPOS),0);
			SendDlgItemMessage(hwnd,IDC_SPIN2,UDM_SETBUDDY,(long)GetDlgItem(hwnd,IDC_YPOS),0);
			SendDlgItemMessage(hwnd,IDC_SPIN3,UDM_SETBUDDY,(long)GetDlgItem(hwnd,IDC_WIDTH),0);
			SendDlgItemMessage(hwnd,IDC_SPIN4,UDM_SETBUDDY,(long)GetDlgItem(hwnd,IDC_HEIGHT),0);

			SendDlgItemMessage(hwnd,IDC_SPIN1,UDM_SETRANGE32,0,0x7FFF);
			SendDlgItemMessage(hwnd,IDC_SPIN2,UDM_SETRANGE32,0,0x7FFF);
			SendDlgItemMessage(hwnd,IDC_SPIN3,UDM_SETRANGE32,0,0x7FFF);
			SendDlgItemMessage(hwnd,IDC_SPIN4,UDM_SETRANGE32,0,0x7FFF);
			return 0;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_TEST:
					_beginthread(
						(void (__cdecl *)(void *))ShowTestWindow,
						0,
						(void *)GetWndInfoNum(MdiInfo[GetWndNum(GetParent(hwnd))].path));
					return 1;
				case IDC_XPOS:
				case IDC_YPOS:
				case IDC_WIDTH:
				case IDC_HEIGHT:
					if(HIWORD(wParam)==EN_UPDATE){
						if(bSupportDlg_NoChange) return 1;

						if(bTimer) KillTimer(hwnd,0);

						bTimer=1;
						SetTimer(hwnd,0,650,NULL);
					}
					return 1;
			}
			break;
		case WM_TIMER:
			KillTimer(hwnd,0);
			bTimer=0;

			i=GetWndNum(GetParent(hwnd));
			WINDOW_INFO *pWindowInfo = GetWndInfo(MdiInfo[i].path);

			for(i3=0;;i3++){
				if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
				PointAndSize.pos=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos;
				PointAndSize.size=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size;
				Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[i3],(DWORD)&PointAndSize);
			}

			GetDlgItemText(hwnd,IDC_XPOS,temporary,255);
			if(temporary[0]){
				for(i3=0;;i3++){
					if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
					pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.x=atol(temporary);
				}
			}

			GetDlgItemText(hwnd,IDC_YPOS,temporary,255);
			if(temporary[0]){
				for(i3=0;;i3++){
					if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
					pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.y=atol(temporary);
				}
			}

			GetDlgItemText(hwnd,IDC_WIDTH,temporary,255);
			if(temporary[0]){
				if(MdiInfo[i].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
					pWindowInfo->size.cx=atol(temporary);
				else{
					for(i3=0;;i3++){
						if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
						pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size.cx=atol(temporary);
					}
				}
			}

			GetDlgItemText(hwnd,IDC_HEIGHT,temporary,255);
			if(temporary[0]){
				if(MdiInfo[i].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
					pWindowInfo->size.cy=atol(temporary);
				else{
					for(i3=0;;i3++){
						if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
						pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size.cy=atol(temporary);
					}
				}
			}

			//`
			DrawRadWindow(i,pWindowInfo);

			//XN[o[Zbg
			GetClientRect(MdiInfo[i].MdiRadInfo->hRad,&rect);
			ResetScrollbarOfRadEditor(i,rect.right,rect.bottom);

			return 1;
	}
	return 0;
}
