#pragma once

namespace ActiveBasic{ namespace IDE{

class Project
{
	std::string name;
	ActiveBasic::Common::TargetModuleType::EnumType moduleType;
public:
	void Open( const std::string &projectFileName );
	void Close() const;
	void Save() const;
};
typedef std::vector<Project *> Projects;

class ProjectManager
{
	Projects projects;
	Project *pCurrentProject;
public:
	ProjectManager()
		: pCurrentProject( NULL )
	{
	}
	~ProjectManager()
	{
		if( IsOpenedProject() )
		{
			throw;
		}
	}
	const Project &GetCurrentProject() const
	{
		return *pCurrentProject;
	}
	Project &GetCurrentProject()
	{
		return *pCurrentProject;
	}

	bool IsOpenedProject() const
	{
		return !projects.empty();
	}
	void OpenProject( const std::string &projectFileName );
	void CloseProject( const std::string &projectName );

	void CloseAllProjects();
};


}}
