#include "stdafx.h"


#include "common.h"

void NewRadWindow(int WndInfoNum){
	extern HINSTANCE hInst,hResInst;
	extern HWND hDocCombo;
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2;
	HWND hChild;
	RECT rect;
	MDICREATESTRUCT mdic;
	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	//łɎw肳ꂽt@CJĂꍇ
	hChild=GetWindow(hClient,GW_CHILD);
	while(hChild){
		i=GetWndNum(hChild);
		if(MdiInfo[i].DocType==WNDTYPE_RAD){
			if(lstrcmpi(MdiInfo[i].path,pWindowInfo->name)==0) break;
		}
		hChild=GetNextWindow(hChild,GW_HWNDNEXT);
	}
	if(hChild){
		BringWindowToTop(hChild);
		return;
	}

	mdic.szTitle=pWindowInfo->name;
	mdic.szClass="MDIClientWindow_Rad";
	mdic.hOwner=hInst;
	mdic.x=CW_USEDEFAULT;
	mdic.y=CW_USEDEFAULT;
	mdic.cx=CW_USEDEFAULT;
	mdic.cy=CW_USEDEFAULT;

	hChild=GetWindow(hClient,GW_CHILD);
	if(IsWindow(hChild)){
		if(IsZoomed(hChild)) mdic.style=WS_MAXIMIZE|WS_CLIPCHILDREN;
		else mdic.style=0;
	}
	else{
		if(pobj_nv->bMDIZoomed) mdic.style=WS_MAXIMIZE|WS_CLIPCHILDREN;
		else mdic.style=0;
	}

	mdic.lParam=0;
	hChild=(HWND)SendMessage(hClient,WM_MDICREATE,0,(long)&mdic);	//EBhE쐬


	//////////////////////
	// qEBhE쐬
	//////////////////////

	//c[EBhE쐬
	HWND hTools;
	hTools=CreateWindow("RadToolsWindow",NULL,
		WS_CHILD|WS_VSCROLL|WS_VISIBLE|WS_CLIPCHILDREN,
		0,0,0,0,
		hChild,NULL,hInst,NULL);

	//vpeBEBhE쐬
	HWND hProperty;
	hProperty=CreateWindowEx(WS_EX_CLIENTEDGE,"RadPropertyWindow",NULL,
		WS_CHILD|WS_VSCROLL|WS_VISIBLE|WS_CLIPCHILDREN,
		0,0,0,0,
		hChild,NULL,hInst,NULL);

	//RADEBhE쐬
	HWND hRad;
	hRad=CreateWindowEx(WS_EX_CLIENTEDGE,"RadWindow",NULL,
		WS_CHILD|WS_HSCROLL|WS_VSCROLL|WS_VISIBLE|WS_CLIPCHILDREN,
		0,0,0,0,
		hChild,NULL,hInst,NULL);

	//T|[gEBhE쐬
	HWND hSupport;
	hSupport=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_SUPPORT),hChild,(DLGPROC)DlgRadSupport);

	//EBhEIDo^
	HDC hdc;
	for(i=0;i<MAX_WNDNUM;i++){
		if(MdiInfo[i].hwnd==0){
			MdiInfo[i].hwnd=hChild;
			MdiInfo[i].DocType=WNDTYPE_RAD;
			MdiInfo[i].title=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(pWindowInfo->name)+1);
			lstrcpy(MdiInfo[i].title,pWindowInfo->name);
			MdiInfo[i].path=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(pWindowInfo->name)+1);
			lstrcpy(MdiInfo[i].path,pWindowInfo->name);


			////////////////////////////
			// MDIRADINFO\̂Zbg
			////////////////////////////

			MdiInfo[i].MdiRadInfo=(MDIRADINFO *)GlobalAlloc(GPTR,sizeof(MDIRADINFO));

			MdiInfo[i].MdiRadInfo->hTools=hTools;
			MdiInfo[i].MdiRadInfo->hProperty=hProperty;
			MdiInfo[i].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_WINDOW),hProperty,(DLGPROC)RadProperty_WindowProc);

			SCROLLINFO ScrollInfo;
			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_POS;
			ScrollInfo.nPos=0;
			SetScrollInfo(MdiInfo[i].MdiRadInfo->hProperty,SB_VERT,&ScrollInfo,1);

			MdiInfo[i].MdiRadInfo->hRad=hRad;

			MdiInfo[i].MdiRadInfo->hSupport=hSupport;

			hdc=GetDC(hRad);
			MdiInfo[i].MdiRadInfo->hBitmap=CreateCompatibleBitmap(hdc,ScreenX*2,ScreenY*2);
			MdiInfo[i].MdiRadInfo->hMemDC=CreateCompatibleDC(hdc);
			MdiInfo[i].MdiRadInfo->hOldBitmap=
				(HBITMAP)SelectObject(MdiInfo[i].MdiRadInfo->hMemDC,MdiInfo[i].MdiRadInfo->hBitmap);
			ReleaseDC(hRad,hdc);

			for(i2=0;i2<MAX_RAD_SELITEM;i2++) MdiInfo[i].MdiRadInfo->SelectingItem[i2]=-1;
			MdiInfo[i].MdiRadInfo->ButtonSelect=IDC_TOOL_MOUSE;

			//ύX
			MdiInfo[i].MdiRadInfo->undo.NowPos=0;
			memset(MdiInfo[i].MdiRadInfo->undo.Command,0,sizeof(int)*MAX_UNDONUM);


			DrawRadWindow(i,pWindowInfo);

			//T|[g_CAO̓eZbg
			SetSupportDlgData(i,WndInfoNum);

			break;
		}
	}

	ShowWindow(hSupport,SW_SHOW);

	//EBhEʒu
	GetClientRect(hChild,&rect);
	ResizeToRadToolWindows(i,rect.right,rect.bottom);

	i=SendMessage(hDocCombo,CB_ADDSTRING,0,(long)pWindowInfo->name);	//DocR{{bNXɒǉ
	SendMessage(hDocCombo,CB_SETCURSEL,i,0);

	//^uɒǉ
	pobj_MainTab->InsertItem( pWindowInfo->name, true );

	//j[Ԃݒ
	ResetState_DocMenu();

	SetFocus(hRad);
}

int InsertDlgItem(int WndNum,int WndInfoNum,int ItemNum,POINT *pPos,SIZE *pSize,char *IdName,char *caption,DWORD style_or_WndNum,DWORD ExStyle,int Control,int ImageType,char *ImagePath,DWORD dwInsertType){
	//dwInsertType
	//0 c ɖ߂A蒼
	//1 c ʏ̑}
	//2 c \t

	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,NewItemNum;
	char temporary[MAX_PATH];
	CHILDINFO *pChildInfo;

	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	pWindowInfo->pChildInfo=(CHILDINFO *)HeapReAlloc(hHeap,0,pWindowInfo->pChildInfo,(pWindowInfo->NumberOfChildWindows+1)*sizeof(WINDOW_INFO));
	if(ItemNum==-1)
		NewItemNum=pWindowInfo->NumberOfChildWindows;
	else{
		for(i=pWindowInfo->NumberOfChildWindows;i>ItemNum;i--)
			pWindowInfo->pChildInfo[i]=pWindowInfo->pChildInfo[i-1];
		NewItemNum=ItemNum;
	}
	pChildInfo=&pWindowInfo->pChildInfo[NewItemNum];

	//ID
	if(ItemNum==-1){
		for(i=lstrlen(IdName)-1;i>=0;i--){
			if(!('0'<=IdName[i]&&IdName[i]<='9')) break;
		}
		i++;

		if(IdName[i]!='\0'){
			i2=atoi(IdName+i)+1;
			if(dwInsertType==2) i2--;
			IdName[i]=0;
		}
		else{
			if(dwInsertType==2) i2=0;
			else i2=1;
		}

		if(i2==0) lstrcpy(temporary,IdName);
		else sprintf(temporary,"%s%d",IdName,i2);
SearchStart:
		for(i=0;i<pWindowInfo->NumberOfChildWindows;i++){
			if(i!=NewItemNum){
				if(lstrcmp(pWindowInfo->pChildInfo[i].IdName,temporary)==0){
					i2++;
					sprintf(temporary,"%s%d",IdName,i2);
					goto SearchStart;
				}
			}
		}
	}
	else lstrcpy(temporary,IdName);
	pChildInfo->IdName=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(pChildInfo->IdName,temporary);

	//ʒu
	pChildInfo->pos=*pPos;
	pChildInfo->size=*pSize;
	//ꍇ́Aŏ̑傫ɒ
	if(pChildInfo->size.cx<MIN_ITEM_X) pChildInfo->size.cx=MIN_ITEM_X;
	if(pChildInfo->size.cy<MIN_ITEM_Y) pChildInfo->size.cy=MIN_ITEM_Y;

	//eLXg
	if(ItemNum==-1){
		if(dwInsertType==1){
			if(caption[0]) sprintf(temporary,"%s%d",caption,i2);
			else temporary[0]=0;
		}
		else lstrcpy(temporary,caption);
	}
	else lstrcpy(temporary,caption);
	pChildInfo->caption=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(pChildInfo->caption,temporary);

	//X^C
	pChildInfo->style=style_or_WndNum;

	//gX^C
	pChildInfo->ExStyle=ExStyle;

	//NX
	pChildInfo->Control=Control;

	if(Control==CT_IMAGEBOX){
		//C[W {bNX̏ꍇ
		pChildInfo->ImageCtrlInfo.type=ImageType;
		if(!ImagePath)
			pChildInfo->ImageCtrlInfo.path=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
		else{
			pChildInfo->ImageCtrlInfo.path=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,lstrlen(ImagePath)+1);
			lstrcpy(pChildInfo->ImageCtrlInfo.path,ImagePath);
		}
	}

	//ύX
	if(dwInsertType!=0)
		Rad_NoticeChanging(WndNum,RAD_UNDO_INSERTITEM,NewItemNum,(DWORD)pChildInfo);

	pWindowInfo->NumberOfChildWindows++;

	DrawRadWindow(WndNum,pWindowInfo);
	return NewItemNum;
}
void DeleteDlgItem(int WndNum,int WndInfoNum,int ItemNum,BOOL bNoticeChanging){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i;

	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	//ύX
	if(bNoticeChanging)
		Rad_NoticeChanging(WndNum,RAD_UNDO_DELETEITEM,ItemNum,(DWORD)&pWindowInfo->pChildInfo[ItemNum]);

	//qEBhẼ
	HeapDefaultFree(pWindowInfo->pChildInfo[ItemNum].IdName);
	HeapDefaultFree(pWindowInfo->pChildInfo[ItemNum].caption);
	if(pWindowInfo->pChildInfo[ItemNum].Control==CT_IMAGEBOX){
		//C[W {bNX̏ꍇ
		HeapDefaultFree(pWindowInfo->pChildInfo[ItemNum].ImageCtrlInfo.path);
	}

	pWindowInfo->NumberOfChildWindows--;
	for(i=ItemNum;i<pWindowInfo->NumberOfChildWindows;i++)
		pWindowInfo->pChildInfo[i]=pWindowInfo->pChildInfo[i+1];
	if(ProjectInfo.windowInfos.size()==0) pWindowInfo->pChildInfo=(CHILDINFO *)HeapReAlloc(hHeap,0,pWindowInfo->pChildInfo,1);
	else pWindowInfo->pChildInfo=(CHILDINFO *)HeapReAlloc(hHeap,0,pWindowInfo->pChildInfo,pWindowInfo->NumberOfChildWindows*sizeof(CHILDINFO));

	DrawRadWindow(WndNum,pWindowInfo);


	//////////////////////////////
	//vpeBEBhEݒ
	DestroyWindow(MdiInfo[WndNum].MdiRadInfo->hProp_Dlg);
	MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_WINDOW),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_WindowProc);

	SCROLLINFO ScrollInfo;
	ScrollInfo.cbSize=sizeof(SCROLLINFO);
	ScrollInfo.fMask=SIF_POS;
	ScrollInfo.nPos=0;
	SetScrollInfo(MdiInfo[WndNum].MdiRadInfo->hProperty,SB_VERT,&ScrollInfo,1);

	RECT rect;
	GetClientRect(MdiInfo[WndNum].MdiRadInfo->hProperty,&rect);
	SendMessage(MdiInfo[WndNum].MdiRadInfo->hProperty,WM_SIZE,0,MAKELONG(rect.right,rect.bottom));
}

void CursorPos_GlobalToLocal(HWND hwnd,long *x,long *y){
	SCROLLINFO VertScrollInfo,HorzScrollInfo;

	VertScrollInfo.cbSize=sizeof(SCROLLINFO);
	VertScrollInfo.fMask=SIF_RANGE|SIF_POS;
	GetScrollInfo(hwnd,SB_VERT,&VertScrollInfo);
	HorzScrollInfo.cbSize=sizeof(SCROLLINFO);
	HorzScrollInfo.fMask=SIF_RANGE|SIF_POS;
	GetScrollInfo(hwnd,SB_HORZ,&HorzScrollInfo);

	*x-=HorzScrollInfo.nPos;
	*y-=VertScrollInfo.nPos;
}
void CursorPos_LocalToGlobal(HWND hwnd,long *x,long *y){
	SCROLLINFO VertScrollInfo,HorzScrollInfo;

	VertScrollInfo.cbSize=sizeof(SCROLLINFO);
	VertScrollInfo.fMask=SIF_RANGE|SIF_POS;
	GetScrollInfo(hwnd,SB_VERT,&VertScrollInfo);
	HorzScrollInfo.cbSize=sizeof(SCROLLINFO);
	HorzScrollInfo.fMask=SIF_RANGE|SIF_POS;
	GetScrollInfo(hwnd,SB_HORZ,&HorzScrollInfo);

	*x+=HorzScrollInfo.nPos;
	*y+=VertScrollInfo.nPos;
}
void DrawFrame(HWND hwnd,int WndNum,int WndInfoNum,RECT *NewRect,RECT *OldRect,BOOL bLA){
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	static int swLineStop;
	int i,sw;
	int x,y;
	HDC hdc;
	HPEN hPen,hOldPen;
	HBRUSH hOldBrush;
	RECT rect;

	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	hdc=GetDC(hwnd);

	sw=0;
	if(pobj_nv->bLineAdjust&&bLA){
		for(i=0;i<pWindowInfo->NumberOfChildWindows;i++){
			if(i==MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]) continue;
			if(pWindowInfo->pChildInfo[i].Control !=
				pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control) continue;

			if(NewRect->left<OldRect->left){
				if(pWindowInfo->pChildInfo[i].pos.x
											>
					NewRect->left - MdiInfo[WndNum].MdiRadInfo->ClientPos.x
					&&
					pWindowInfo->pChildInfo[i].pos.x-10
											<
					NewRect->left - MdiInfo[WndNum].MdiRadInfo->ClientPos.x){

					//Xgbv
					x=NewRect->right-NewRect->left;
					NewRect->left=pWindowInfo->pChildInfo[i].pos.x + MdiInfo[WndNum].MdiRadInfo->ClientPos.x;
					NewRect->right=NewRect->left+x;

					hPen=CreatePen(PS_SOLID,0,RGB(100,100,100));
					hOldPen=(HPEN)SelectObject(hdc,hPen);
					MoveToEx(hdc,NewRect->left,0,NULL);
					LineTo(hdc,NewRect->left,ScreenX);
					SelectObject(hdc,hOldPen);
					DeleteObject(hPen);

					swLineStop=1;
					sw=1;
				}
			}
			if(NewRect->top<OldRect->top){
				if(pWindowInfo->pChildInfo[i].pos.y
											>
					NewRect->top - MdiInfo[WndNum].MdiRadInfo->ClientPos.y
					&&
					pWindowInfo->pChildInfo[i].pos.y-10
											<
					NewRect->top - MdiInfo[WndNum].MdiRadInfo->ClientPos.y){

					//Xgbv
					y=NewRect->bottom-NewRect->top;
					NewRect->top=pWindowInfo->pChildInfo[i].pos.y + MdiInfo[WndNum].MdiRadInfo->ClientPos.y;
					NewRect->bottom=NewRect->top+y;

					hPen=CreatePen(PS_SOLID,0,RGB(100,100,100));
					hOldPen=(HPEN)SelectObject(hdc,hPen);
					MoveToEx(hdc,0,NewRect->top,NULL);
					LineTo(hdc,ScreenY,NewRect->top);
					SelectObject(hdc,hOldPen);
					DeleteObject(hPen);

					swLineStop=1;
					sw=1;
				}
			}
		}
	}

	//ȑȎIt[
	RectNaturalFormat(OldRect,&rect);
	x=rect.left;
	y=rect.top;
	CursorPos_GlobalToLocal(hwnd,&rect.left,&rect.top);
	CursorPos_GlobalToLocal(hwnd,&rect.right,&rect.bottom);
	if(swLineStop&&sw==0){
		BitBlt(hdc,0,0,ScreenX*2,ScreenY*2,
			MdiInfo[WndNum].MdiRadInfo->hMemDC,0,0,SRCCOPY);
		swLineStop=0;
	}
	else{
		BitBlt(hdc,rect.left-LEVER_THICK, rect.top-LEVER_THICK,
			rect.right-rect.left+LEVER_THICK*2, rect.bottom-rect.top+LEVER_THICK*2,
			MdiInfo[WndNum].MdiRadInfo->hMemDC,x-LEVER_THICK,y-LEVER_THICK,SRCCOPY);
	}

	//VIt[`
	RectNaturalFormat(NewRect,&rect);
	CursorPos_GlobalToLocal(hwnd,&rect.left,&rect.top);
	CursorPos_GlobalToLocal(hwnd,&rect.right,&rect.bottom);

	hPen=CreatePen(PS_DOT,0,RGB(0,0,0));
	SetBkMode(hdc,TRANSPARENT);
	hOldPen=(HPEN)SelectObject(hdc,hPen);
	hOldBrush=(HBRUSH)SelectObject(hdc,GetStockObject(NULL_BRUSH));
	Rectangle(hdc,rect.left,rect.top,rect.right,rect.bottom);
	SelectObject(hdc,hOldBrush);
	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);

	ReleaseDC(hwnd,hdc);

	*OldRect=*NewRect;
}
void GetSelectingRect(int WndNum,int WndInfoNum,int num,RECT *rect){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;

	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[num]==SELECT_WINDOW){
		//EBhEI
		rect->left=0;
		rect->top=0;
		rect->right=pWindowInfo->size.cx+(LEVER_THICK*2);
		rect->bottom=pWindowInfo->size.cy+(LEVER_THICK*2);
	}
	else{
		//qEBhEI
		rect->left=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[num]].pos.x-LEVER_THICK;
		rect->top=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[num]].pos.y-LEVER_THICK;
		rect->right=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[num]].pos.x+pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[num]].size.cx+LEVER_THICK;
		rect->bottom=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[num]].pos.y+pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[num]].size.cy+LEVER_THICK;
	}
}
void DrawSelectingRect(HWND hwnd,int WndNum,int WndInfoNum,int ButtonSelect){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern RADINFO RadInfo;
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	HDC hdc;
	HPEN hPen,hOldPen;
	HBRUSH hOldBrush;
	COLORREF rgb;
	RECT rect,tempRect;

	hdc=GetDC(hwnd);
	if(ButtonSelect==IDC_TOOL_MOUSE) rgb=RGB(255,60,30);
	else if(ButtonSelect==NON_TOOL) rgb=RGB(100,100,100);
	hPen=CreatePen(PS_SOLID,0,rgb);
	SetBkMode(hdc,TRANSPARENT);
	hOldPen=(HPEN)SelectObject(hdc,hPen);

	i=0;
	while(MdiInfo[WndNum].MdiRadInfo->SelectingItem[i]!=-1||i==0){
		GetSelectingRect(WndNum,WndInfoNum,i,&tempRect);
		RectNaturalFormat(&tempRect,&rect);
		CursorPos_GlobalToLocal(hwnd,&rect.left,&rect.top);
		CursorPos_GlobalToLocal(hwnd,&rect.right,&rect.bottom);

		//
		hOldBrush=(HBRUSH)SelectObject(hdc,GetStockObject(NULL_BRUSH));
		Rectangle(hdc,
			rect.left+2, rect.top+2,
			rect.right-2, rect.bottom-2);
		SelectObject(hdc,hOldBrush);


		hOldBrush=(HBRUSH)SelectObject(hdc,GetStockObject(WHITE_BRUSH));

		Rectangle(hdc,
			rect.left,rect.top,
			rect.left+5,rect.top+5);
		Rectangle(hdc,
			rect.left,rect.bottom-5,
			rect.left+5,rect.bottom);
		Rectangle(hdc,
			rect.right-5,rect.top,
			rect.right,rect.top+5);
		Rectangle(hdc,
			rect.right-5,rect.bottom-5,
			rect.right,rect.bottom);

		i2=(rect.right-rect.left)/2;
		i3=(rect.bottom-rect.top)/2;
		Rectangle(hdc,
			rect.left+i2-2,rect.top,
			rect.left+i2+3,rect.top+5);
		Rectangle(hdc,
			rect.left+i2-2,rect.bottom-5,
			rect.left+i2+3,rect.bottom);
		Rectangle(hdc,
			rect.left,rect.top+i3-2,
			rect.left+5,rect.top+i3+3);
		Rectangle(hdc,
			rect.right-5,rect.top+i3-2,
			rect.right,rect.top+i3+3);

		SelectObject(hdc,hOldBrush);

		//ړ̑It[̏p͈
		RadInfo.OldDraggingRect[i]=rect;

		i++;
	}

	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);

	ReleaseDC(hwnd,hdc);
}
void ChangePropertyWindow(int WndNum,int WndInfoNum){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	RECT rect;
	SCROLLINFO ScrollInfo;

	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	DestroyWindow(MdiInfo[WndNum].MdiRadInfo->hProp_Dlg);
	if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW){
		MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_WINDOW),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_WindowProc);

		ScrollInfo.cbSize=sizeof(SCROLLINFO);
		ScrollInfo.fMask=SIF_POS;
		ScrollInfo.nPos=0;
		SetScrollInfo(MdiInfo[WndNum].MdiRadInfo->hProperty,SB_VERT,&ScrollInfo,1);

		GetClientRect(MdiInfo[WndNum].MdiRadInfo->hProperty,&rect);
		SendMessage(MdiInfo[WndNum].MdiRadInfo->hProperty,WM_SIZE,0,MAKELONG(rect.right,rect.bottom));
	}
	else{
		if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_BUTTON)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_BUTTON),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_ButtonProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_CHECKBOX)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_CHECKBOX),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_CheckBoxProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_COMBOBOX)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_COMBOBOX),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_ComboBoxProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_EDIT)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_EDIT),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_EditProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_GROUPBOX)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_GROUPBOX),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_GroupBoxProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_HSCROLLBAR)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_SCROLLBAR),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_ScrollBarProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_IMAGEBOX)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_IMAGEBOX),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_ImageBoxProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_LISTBOX)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_LISTBOX),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_ListBoxProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_LISTVIEW)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_LISTVIEW),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_ListViewProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_PROGRESSBAR)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_PROGRESSBAR),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_ProgressBarProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_RADIOBUTTON)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_RADIOBUTTON),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_RadioButtonProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_STATIC)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_STATIC),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_StaticProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_TRACKBAR)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_TRACKBAR),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_TrackBarProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_TREEVIEW)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_TREEVIEW),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_TreeViewProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_UPDOWN)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_UPDOWN),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_UpDownProc);
		else if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_VSCROLLBAR)
			MdiInfo[WndNum].MdiRadInfo->hProp_Dlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_SCROLLBAR),MdiInfo[WndNum].MdiRadInfo->hProperty,(DLGPROC)RadProperty_ScrollBarProc);

		ScrollInfo.cbSize=sizeof(SCROLLINFO);
		ScrollInfo.fMask=SIF_POS;
		ScrollInfo.nPos=0;
		SetScrollInfo(MdiInfo[WndNum].MdiRadInfo->hProperty,SB_VERT,&ScrollInfo,1);

		GetClientRect(MdiInfo[WndNum].MdiRadInfo->hProperty,&rect);
		SendMessage(MdiInfo[WndNum].MdiRadInfo->hProperty,WM_SIZE,0,MAKELONG(rect.right,rect.bottom));
	}
}
int GetItemNumOnMouse(int WndNum,int WndInfoNum,int x,int y){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i;

	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	for(i=pWindowInfo->NumberOfChildWindows-1;i>=0;i--){
		if(pWindowInfo->pChildInfo[i].Control==CT_COMBOBOX&&
			(pWindowInfo->pChildInfo[i].style&0x000F)!=CBS_SIMPLE){
			//R{ {bNX̏ꍇ͕\^[QbgɑIi20pixelj
			if(x>=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[i].pos.x&&
				x<=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[i].pos.x+pWindowInfo->pChildInfo[i].size.cx&&
				y>=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[i].pos.y&&
				y<=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[i].pos.y+20){
				break;
			}
		}
		else if(pWindowInfo->pChildInfo[i].Control==CT_GROUPBOX){
			//O[v {bNX̏ꍇ͒
			if((
				x>=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[i].pos.x&&
				x<=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[i].pos.x+pWindowInfo->pChildInfo[i].size.cx&&
				y>=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[i].pos.y&&
				y<=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[i].pos.y+pWindowInfo->pChildInfo[i].size.cy
				)&&
				(!(
				x>=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[i].pos.x+LEVER_THICK*2&&
				x<=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[i].pos.x+pWindowInfo->pChildInfo[i].size.cx-LEVER_THICK*2&&
				y>=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[i].pos.y+LEVER_THICK*3&&
				y<=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[i].pos.y+pWindowInfo->pChildInfo[i].size.cy-LEVER_THICK*2
				))
				){
				break;
			}
		}
		else if(x>=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[i].pos.x&&
			x<=MdiInfo[WndNum].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[i].pos.x+pWindowInfo->pChildInfo[i].size.cx&&
			y>=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[i].pos.y&&
			y<=MdiInfo[WndNum].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[i].pos.y+pWindowInfo->pChildInfo[i].size.cy){
			break;
		}
	}
	return i;
}
void SelectItemNumOnMouse(int WndNum,int WndInfoNum,int x,int y){
	//}EXWƂɃRg[ACeI
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i;

	for(i=1;i<MAX_RAD_SELITEM;i++) MdiInfo[WndNum].MdiRadInfo->SelectingItem[i]=-1;
	i=GetItemNumOnMouse(WndNum,WndInfoNum,x,y);

	if(i==-1){
		if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]!=SELECT_WINDOW){
			MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]=SELECT_WINDOW;
			ChangePropertyWindow(WndNum,WndInfoNum);
		}
	}
	else{
		MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]=i;
		ChangePropertyWindow(WndNum,WndInfoNum);
	}

	SetStatusText(NULL);

	//T|[g_CAO̓eZbg
	SetSupportDlgData(WndNum,WndInfoNum);
}
void SetItemNumOnFrame(int WndNum,int WndInfoNum,RECT *pRect){
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2,sw;
	RECT rect;

	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	for(i=1;i<MAX_RAD_SELITEM;i++) MdiInfo[WndNum].MdiRadInfo->SelectingItem[i]=-1;
	RectNaturalFormat(pRect,&rect);
	if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW) sw=0;
	else sw=1;
	for(i=pWindowInfo->NumberOfChildWindows-1,i2=0;i>=0;i--){
		if(rect.left <= pWindowInfo->pChildInfo[i].pos.x+MdiInfo[WndNum].MdiRadInfo->ClientPos.x&&
			rect.top <= pWindowInfo->pChildInfo[i].pos.y+MdiInfo[WndNum].MdiRadInfo->ClientPos.y&&
			rect.right >= pWindowInfo->pChildInfo[i].pos.x+pWindowInfo->pChildInfo[i].size.cx+MdiInfo[WndNum].MdiRadInfo->ClientPos.x&&
			rect.bottom >= pWindowInfo->pChildInfo[i].pos.y+pWindowInfo->pChildInfo[i].size.cy+MdiInfo[WndNum].MdiRadInfo->ClientPos.y){
			MdiInfo[WndNum].MdiRadInfo->SelectingItem[i2]=i;
			i2++;
		}
	}
	if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]!=SELECT_WINDOW||
		(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW&&sw)){
		ChangePropertyWindow(WndNum,WndInfoNum);
	}
}
int GetStateOfDraggingFrame(int WndNum,int WndInfoNum,int x,int y){
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	RECT rect;

	WINDOW_INFO *pWindowInfo = &ProjectInfo.windowInfos[WndInfoNum];

	if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[1]!=-1){
		i=0;
		while(MdiInfo[WndNum].MdiRadInfo->SelectingItem[i]!=-1||i==0){
			GetSelectingRect(WndNum,WndInfoNum,i,&rect);

			if(x>=rect.left+LEVER_THICK&&x<=rect.right-LEVER_THICK&&
				y>=rect.top+LEVER_THICK&&y<=rect.bottom-LEVER_THICK){
				if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[i]].Control==CT_GROUPBOX){
					//O[v{bNX̏ꍇ͒
					if(!(x>=rect.left+LEVER_THICK*2&&x<=rect.right-LEVER_THICK*2&&
						y>=rect.top+LEVER_THICK*3&&y<=rect.bottom-LEVER_THICK*2)){
						return FRAME_INSIDE;
					}
				}
				else return FRAME_INSIDE;
			}
			i++;
		}
	}
	else{
		GetSelectingRect(WndNum,WndInfoNum,0,&rect);

		if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]!=SELECT_WINDOW){
			if(x>=rect.left+LEVER_THICK&&x<=rect.right-LEVER_THICK&&
				y>=rect.top+LEVER_THICK&&y<=rect.bottom-LEVER_THICK){
				if(pWindowInfo->pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].Control==CT_GROUPBOX){
					//O[v {bNX̏ꍇ͒
					if(!(x>=rect.left+LEVER_THICK*3&&x<=rect.right-LEVER_THICK*3&&
						y>=rect.top+LEVER_THICK*4&&y<=rect.bottom-LEVER_THICK*3)){
						return FRAME_INSIDE;
					}
				}
				else return FRAME_INSIDE;
			}
			else if(x>=rect.left&&x<=rect.left+LEVER_THICK&&
				y>=rect.top&&y<=rect.top+LEVER_THICK)				return FRAME_UPPER_LEFT;
			else if(x>=rect.right-LEVER_THICK&&x<=rect.right&&
				y>=rect.top&&y<=rect.top+LEVER_THICK)				return FRAME_UPPER_RIGHT;
			else if(x>=rect.left&&x<=rect.left+LEVER_THICK&&
				y>=rect.bottom-LEVER_THICK&&y<=rect.bottom)			return FRAME_LOWER_LEFT;
			else if(x>=rect.left&&x<=rect.left+LEVER_THICK&&
				y>=rect.top+LEVER_THICK&&y<=rect.bottom-LEVER_THICK)return FRAME_LEFT;
			else if(x>=rect.left+LEVER_THICK&&x<=rect.right-LEVER_THICK&&
				y>=rect.top&&y<=rect.top+LEVER_THICK)				return FRAME_UPPER;
		}
		if(x>=rect.right-LEVER_THICK&&x<=rect.right&&
			y>=rect.bottom-LEVER_THICK&&y<=rect.bottom)				return FRAME_LOWER_RIGHT;
		else if(x>=rect.right-LEVER_THICK&&x<=rect.right&&
			y>=rect.top+LEVER_THICK&&y<=rect.bottom-LEVER_THICK)	return FRAME_RIGHT;
		else if(x>=rect.left+LEVER_THICK&&x<=rect.right-LEVER_THICK&&
			y>=rect.bottom-LEVER_THICK&&y<=rect.bottom)				return FRAME_LOWER;
	}
	return 0;
}
void ResetScrollbarOfRadEditor(int WndNum,int weight,int height){
	extern PROJECTINFO ProjectInfo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	SCROLLINFO ScrollInfo;
	SIZE NeedSize;

	WINDOW_INFO *pWindowInfo = GetWndInfo(MdiInfo[WndNum].path);

	//KvȕA100sNZ]T
	NeedSize.cx=pWindowInfo->size.cx+(LEVER_THICK*2)+100;
	NeedSize.cy=pWindowInfo->size.cy+(LEVER_THICK*2)+100;

	ScrollInfo.cbSize=sizeof(SCROLLINFO);
	ScrollInfo.fMask=SIF_PAGE|SIF_RANGE|SIF_POS|SIF_DISABLENOSCROLL;

	//XN[o[̐ݒ
	GetScrollInfo(MdiInfo[WndNum].MdiRadInfo->hRad,SB_VERT,&ScrollInfo);
	ScrollInfo.nMin=0;
	if(height>NeedSize.cy) ScrollInfo.nMax=0;
	else{
		ScrollInfo.nMax=NeedSize.cy;
		ScrollInfo.nPage=height;
	}
	SetScrollInfo(MdiInfo[WndNum].MdiRadInfo->hRad,SB_VERT,&ScrollInfo,1);

	//XN[o[̐ݒ
	GetScrollInfo(MdiInfo[WndNum].MdiRadInfo->hRad,SB_VERT,&ScrollInfo);
	ScrollInfo.nMin=0;
	if(weight>NeedSize.cx) ScrollInfo.nMax=0;
	else{
		ScrollInfo.nMax=NeedSize.cx;
		ScrollInfo.nPage=weight;
	}
	SetScrollInfo(MdiInfo[WndNum].MdiRadInfo->hRad,SB_HORZ,&ScrollInfo,1);
}
LRESULT CALLBACK RadWindow(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	extern RADINFO RadInfo;
	int i,i2,i3,i4;
	char temporary[MAX_PATH],temp2[MAX_PATH];
	HWND hParent;
	HDC hdc;
	RECT rect;
	POINT mouse,pos;
	SIZE size;
	SCROLLINFO ScrollInfo,si2;
	PAINTSTRUCT ps;
	POINTANDSIZE PointAndSize;

	switch(message){
		case WM_LBUTTONDOWN:
			{
				SetCapture(hwnd);

				SetFocus(hwnd);
				mouse.x=LOWORD(lParam);
				mouse.y=HIWORD(lParam);
				CursorPos_LocalToGlobal(hwnd,&mouse.x,&mouse.y);

				i=GetWndNum(GetParent(hwnd));
				i2 = GetWndInfoNum(MdiInfo[i].path);
				WINDOW_INFO *pWindowInfo = GetWndInfo(MdiInfo[i].path);

				if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_MOUSE){
					if(((wParam&MK_CONTROL)||(wParam&MK_SHIFT))&&
						MdiInfo[i].MdiRadInfo->SelectingItem[0]!=SELECT_WINDOW){

						//ShiftL[ACtrlL[ɂ镡I
						for(i3=0;;i3++){
							if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1){
								MdiInfo[i].MdiRadInfo->SelectingItem[i3]=GetItemNumOnMouse(i,i2,mouse.x,mouse.y);
								InvalidateRect(hwnd,NULL,0);

								//T|[g_CAO̓eZbg
								SetSupportDlgData(i,i2);
								break;
							}
						}
					}
					else{
						RadInfo.NowDragging=GetStateOfDraggingFrame(i,i2,mouse.x,mouse.y);
						if(!RadInfo.NowDragging){
							SelectItemNumOnMouse(i,i2,mouse.x,mouse.y);
							InvalidateRect(hwnd,NULL,0);
							RadInfo.NowDragging=GetStateOfDraggingFrame(i,i2,mouse.x,mouse.y);
						}
						if(RadInfo.NowDragging){
							//ACeI𒆁BTCYAʒuύXJn

							if(MdiInfo[i].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW){
								RadInfo.DraggingRect[0].left=LEVER_THICK;
								RadInfo.DraggingRect[0].top=LEVER_THICK;
								RadInfo.DraggingRect[0].right=pWindowInfo->size.cx+LEVER_THICK;
								RadInfo.DraggingRect[0].bottom=pWindowInfo->size.cy+LEVER_THICK;
								RadInfo.DragStartRect[0]=RadInfo.DraggingRect[0];
							}
							else{
								i3=0;
								while(MdiInfo[i].MdiRadInfo->SelectingItem[i3]!=-1){
									RadInfo.DraggingRect[i3].left=MdiInfo[i].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.x;
									RadInfo.DraggingRect[i3].top=MdiInfo[i].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.y;
									RadInfo.DraggingRect[i3].right=MdiInfo[i].MdiRadInfo->ClientPos.x+pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.x+pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size.cx;
									RadInfo.DraggingRect[i3].bottom=MdiInfo[i].MdiRadInfo->ClientPos.y+pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.y+pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size.cy;
									RadInfo.DragStartRect[i3]=RadInfo.DraggingRect[i3];
									i3++;
								}
							}
						}
						else{
							//͈͑I

							RadInfo.NowDragging=SELECTING_FRAME;
							RadInfo.OldDraggingRect[0].left=LEVER_THICK;
							RadInfo.OldDraggingRect[0].top=LEVER_THICK;
							RadInfo.OldDraggingRect[0].right=pWindowInfo->size.cx+LEVER_THICK;
							RadInfo.OldDraggingRect[0].bottom=pWindowInfo->size.cy+LEVER_THICK;
						}
						RadInfo.DragStartPos.x=mouse.x;
						RadInfo.DragStartPos.y=mouse.y;
					}
					SetCursorByState(RadInfo.NowDragging);
				}
				else{
					RadInfo.DraggingRect[0].left=mouse.x;
					RadInfo.DraggingRect[0].top=mouse.y;
					RadInfo.NowDragging=ITEM_MAKING;
				}
				return 0;
			}
		case WM_LBUTTONUP:
			{
				ReleaseCapture();

				SetFocus(hwnd);
				mouse.x=(int)(short)LOWORD(lParam);
				mouse.y=(int)(short)HIWORD(lParam);
				CursorPos_LocalToGlobal(hwnd,&mouse.x,&mouse.y);

				hParent=GetParent(hwnd);
				i=GetWndNum(hParent);
				i2 = GetWndInfoNum(MdiInfo[i].path);
				WINDOW_INFO *pWindowInfo = GetWndInfo(MdiInfo[i].path);

				if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_MOUSE){
					if(RadInfo.NowDragging){
						if(RadInfo.DragStartPos.x==mouse.x&&RadInfo.DragStartPos.y==mouse.y){
							RadInfo.NowDragging=0;
							InvalidateRect(hwnd,NULL,0);
							ResetState_EditMenu();
							return 0;
						}

						if(MdiInfo[i].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW){
							if(RadInfo.NowDragging==SELECTING_FRAME){
								SetItemNumOnFrame(i,i2,&RadInfo.DraggingRect[0]);
								InvalidateRect(hwnd,NULL,1);
							}
							else{
								//EBhEg̒
								PointAndSize.size=pWindowInfo->size;
								Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&PointAndSize);
								pWindowInfo->size.cx=RadInfo.DraggingRect[0].right-LEVER_THICK;
								pWindowInfo->size.cy=RadInfo.DraggingRect[0].bottom-LEVER_THICK;
								DrawRadWindow(i,pWindowInfo);
								InvalidateRect(hwnd,NULL,1);

								GetClientRect(hwnd,&rect);
								ResetScrollbarOfRadEditor(i,rect.right,rect.bottom);
							}
						}
						else{
							i3=0;
							while(MdiInfo[i].MdiRadInfo->SelectingItem[i3]!=-1){
								//ACeg̒
								PointAndSize.pos=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos;
								PointAndSize.size=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size;
								Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[i3],(DWORD)&PointAndSize);
								pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.x=RadInfo.DraggingRect[i3].left-MdiInfo[i].MdiRadInfo->ClientPos.x;
								pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.y=RadInfo.DraggingRect[i3].top-MdiInfo[i].MdiRadInfo->ClientPos.y;
								pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size.cx=RadInfo.DraggingRect[i3].right-RadInfo.DraggingRect[i3].left;
								pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size.cy=RadInfo.DraggingRect[i3].bottom-RadInfo.DraggingRect[i3].top;
								DrawRadWindow(i,pWindowInfo);
								i3++;
							}
						}

						SetStatusText(NULL);

						//T|[g_CAO̓eZbg
						SetSupportDlgData(i,i2);
					}
				}
				else if(RadInfo.NowDragging==ITEM_MAKING){
					if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_BUTTON){
						//{^ Rg[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=44;
							RadInfo.DraggingRect[0].right=mouse.x+44;
							RadInfo.DraggingRect[0].top-=10;
							RadInfo.DraggingRect[0].bottom=mouse.y+11;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"CommandButton","Button",WS_CHILD|WS_VISIBLE,0,CT_BUTTON,0,0,1);
					}
					if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_CHECKBOX){
						//`FbN {bNX쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=33;
							RadInfo.DraggingRect[0].right=mouse.x+34;
							RadInfo.DraggingRect[0].top-=7;
							RadInfo.DraggingRect[0].bottom=mouse.y+8;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"CheckBox","Check",WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX,0,CT_CHECKBOX,0,0,1);
					}
					if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_COMBOBOX){
						//R{ {bNX쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=42;
							RadInfo.DraggingRect[0].right=mouse.x+42;
							RadInfo.DraggingRect[0].top-=42;
							RadInfo.DraggingRect[0].bottom=mouse.y+42;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"ComboBox","",WS_CHILD|WS_VISIBLE|CBS_DROPDOWN|CBS_SORT|WS_VSCROLL,0,CT_COMBOBOX,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_EDIT){
						//GfBbg Rg[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=35;
							RadInfo.DraggingRect[0].right=mouse.x+35;
							RadInfo.DraggingRect[0].top-=10;
							RadInfo.DraggingRect[0].bottom=mouse.y+11;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"EditBox","",WS_CHILD|WS_VISIBLE,WS_EX_CLIENTEDGE,CT_EDIT,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_GROUPBOX){
						//O[v {bNX쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=42;
							RadInfo.DraggingRect[0].right=mouse.x+42;
							RadInfo.DraggingRect[0].top-=30;
							RadInfo.DraggingRect[0].bottom=mouse.y+30;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"GroupBox","Group",WS_CHILD|WS_VISIBLE|BS_GROUPBOX,0,CT_GROUPBOX,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_HSCROLLBAR){
						//XN[o[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=35;
							RadInfo.DraggingRect[0].right=mouse.x+35;
							RadInfo.DraggingRect[0].top-=8;
							RadInfo.DraggingRect[0].bottom=mouse.y+9;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"HScrollBar","",WS_CHILD|WS_VISIBLE|SBS_HORZ,0,CT_HSCROLLBAR,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_IMAGEBOX){
						//C[W {bNX쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=16;
							RadInfo.DraggingRect[0].right=mouse.x+16;
							RadInfo.DraggingRect[0].top-=16;
							RadInfo.DraggingRect[0].bottom=mouse.y+16;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"ImageBox","",WS_CHILD|WS_VISIBLE|SS_BLACKFRAME,0,CT_IMAGEBOX,IMGTYPE_FILE,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_LISTBOX){
						//Xg {bNX쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=42;
							RadInfo.DraggingRect[0].right=mouse.x+42;
							RadInfo.DraggingRect[0].top-=30;
							RadInfo.DraggingRect[0].bottom=mouse.y+30;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"ListBox","",WS_CHILD|WS_VISIBLE|WS_VSCROLL|LBS_SORT|LBS_NOTIFY,WS_EX_CLIENTEDGE,CT_LISTBOX,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_LISTVIEW){
						//Xg r[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=52;
							RadInfo.DraggingRect[0].right=mouse.x+53;
							RadInfo.DraggingRect[0].top-=37;
							RadInfo.DraggingRect[0].bottom=mouse.y+38;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"ListView","",WS_CHILD|WS_VISIBLE,WS_EX_CLIENTEDGE,CT_LISTVIEW,0,0,1);
					}
					if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_PROGRESSBAR){
						//voX o[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=70;
							RadInfo.DraggingRect[0].right=mouse.x+70;
							RadInfo.DraggingRect[0].top-=10;
							RadInfo.DraggingRect[0].bottom=mouse.y+11;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"ProgressBar","",WS_CHILD|WS_VISIBLE,WS_EX_STATICEDGE,CT_PROGRESSBAR,0,0,1);
					}
					if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_RADIOBUTTON){
						//WI {^쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=31;
							RadInfo.DraggingRect[0].right=mouse.x+32;
							RadInfo.DraggingRect[0].top-=7;
							RadInfo.DraggingRect[0].bottom=mouse.y+8;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"RadioButton","radio",WS_CHILD|WS_VISIBLE|BS_AUTORADIOBUTTON,0,CT_RADIOBUTTON,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_STATIC){
						//X^eBbN Rg[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=25;
							RadInfo.DraggingRect[0].right=mouse.x+25;
							RadInfo.DraggingRect[0].top-=6;
							RadInfo.DraggingRect[0].bottom=mouse.y+6;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"Static","Text",WS_CHILD|WS_VISIBLE,0,CT_STATIC,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_TRACKBAR){
						//gbN o[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=87;
							RadInfo.DraggingRect[0].right=mouse.x+88;
							RadInfo.DraggingRect[0].top-=11;
							RadInfo.DraggingRect[0].bottom=mouse.y+12;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"TrackBar","",WS_CHILD|WS_VISIBLE|TBS_BOTH|TBS_NOTICKS,0,CT_TRACKBAR,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_TREEVIEW){
						//c[ r[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=52;
							RadInfo.DraggingRect[0].right=mouse.x+53;
							RadInfo.DraggingRect[0].top-=37;
							RadInfo.DraggingRect[0].bottom=mouse.y+38;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"TreeView","",WS_CHILD|WS_VISIBLE,WS_EX_CLIENTEDGE,CT_TREEVIEW,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_UPDOWN){
						//Abv _E Rg[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=8;
							RadInfo.DraggingRect[0].right=mouse.x+8;
							RadInfo.DraggingRect[0].top-=10;
							RadInfo.DraggingRect[0].bottom=mouse.y+11;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"UpDown","",WS_CHILD|WS_VISIBLE,0,CT_UPDOWN,0,0,1);
					}
					else if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_VSCROLLBAR){
						//XN[o[쐬
						if(RadInfo.DraggingRect[0].left==mouse.x&&RadInfo.DraggingRect[0].top==mouse.y){
							RadInfo.DraggingRect[0].left-=9;
							RadInfo.DraggingRect[0].right=mouse.x+9;
							RadInfo.DraggingRect[0].top-=30;
							RadInfo.DraggingRect[0].bottom=mouse.y+30;
						}
						else{
							RadInfo.DraggingRect[0].right=mouse.x;
							RadInfo.DraggingRect[0].bottom=mouse.y;
						}
						RectNaturalFormat(&RadInfo.DraggingRect[0],&rect);
						pos.x=rect.left-MdiInfo[i].MdiRadInfo->ClientPos.x;
						pos.y=rect.top-MdiInfo[i].MdiRadInfo->ClientPos.y;
						size.cx=rect.right-rect.left;
						size.cy=rect.bottom-rect.top;
						MdiInfo[i].MdiRadInfo->SelectingItem[0]=InsertDlgItem(i,i2,-1,&pos,&size,"VScrollBar","",WS_CHILD|WS_VISIBLE|SBS_VERT,0,CT_VSCROLLBAR,0,0,1);
					}
					SendMessage(GetWindow(MdiInfo[i].MdiRadInfo->hTools,GW_CHILD),WM_COMMAND,IDC_TOOL_MOUSE,0);
					SendMessage(GetWindow(GetWindow(MdiInfo[i].MdiRadInfo->hTools,GW_CHILD),GW_CHILD),TB_CHECKBUTTON,IDC_TOOL_MOUSE,TRUE);
					ChangePropertyWindow(i,i2);

					//I
					MdiInfo[i].MdiRadInfo->SelectingItem[1]=-1;
				}

				RadInfo.NowDragging=0;

				ResetState_EditMenu();
				return 0;
			}
		case WM_MOUSEMOVE:
			mouse.x=(int)(short)LOWORD(lParam);
			mouse.y=(int)(short)HIWORD(lParam);
			CursorPos_LocalToGlobal(hwnd,&mouse.x,&mouse.y);

			hParent=GetParent(hwnd);
			i=GetWndNum(hParent);
			i2 = GetWndInfoNum(MdiInfo[i].path);

			if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_MOUSE){
				if(wParam&MK_LBUTTON&&RadInfo.NowDragging){
					////////////////////////////////////////////////
					// hbȌꍇiRg[̃TCYύXj

					if(RadInfo.NowDragging==FRAME_UPPER_LEFT){
						if(RadInfo.DraggingRect[0].right-MIN_ITEM_X<=(mouse.x+LEVER_THICK))
							RadInfo.DraggingRect[0].left=RadInfo.DraggingRect[0].right-MIN_ITEM_X;
						else if(mouse.x+LEVER_THICK<MdiInfo[i].MdiRadInfo->ClientPos.x)
							RadInfo.DraggingRect[0].left=MdiInfo[i].MdiRadInfo->ClientPos.x;
						else RadInfo.DraggingRect[0].left=mouse.x+LEVER_THICK;

						if(RadInfo.DraggingRect[0].bottom-MIN_ITEM_Y<=(mouse.y+LEVER_THICK))
							RadInfo.DraggingRect[0].top=RadInfo.DraggingRect[0].bottom-MIN_ITEM_Y;
						else if(mouse.y+LEVER_THICK<MdiInfo[i].MdiRadInfo->ClientPos.y)
							RadInfo.DraggingRect[0].top=MdiInfo[i].MdiRadInfo->ClientPos.y;
						else RadInfo.DraggingRect[0].top=mouse.y+LEVER_THICK;
						DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
					}
					else if(RadInfo.NowDragging==FRAME_UPPER_RIGHT){
						if(mouse.x-LEVER_THICK-MIN_ITEM_X<=RadInfo.DraggingRect[0].left)
							RadInfo.DraggingRect[0].right=RadInfo.DraggingRect[0].left+MIN_ITEM_X;
						else if(mouse.x>MdiInfo[i].MdiRadInfo->ClientPos.x+MdiInfo[i].MdiRadInfo->ClientSize.cx)
							RadInfo.DraggingRect[0].right=MdiInfo[i].MdiRadInfo->ClientPos.x+MdiInfo[i].MdiRadInfo->ClientSize.cx;
						else RadInfo.DraggingRect[0].right=mouse.x-LEVER_THICK;

						if(RadInfo.DraggingRect[0].bottom-MIN_ITEM_Y<=(mouse.y+LEVER_THICK)) RadInfo.DraggingRect[0].top=RadInfo.DraggingRect[0].bottom-MIN_ITEM_Y;
						else if(mouse.y+LEVER_THICK<MdiInfo[i].MdiRadInfo->ClientPos.y)
							RadInfo.DraggingRect[0].top=MdiInfo[i].MdiRadInfo->ClientPos.y;
						else RadInfo.DraggingRect[0].top=mouse.y+LEVER_THICK;
						DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
					}
					else if(RadInfo.NowDragging==FRAME_LOWER_LEFT){
						if(RadInfo.DraggingRect[0].right-MIN_ITEM_X<=(mouse.x+LEVER_THICK))
							RadInfo.DraggingRect[0].left=RadInfo.DraggingRect[0].right-MIN_ITEM_X;
						else if(mouse.x+LEVER_THICK<MdiInfo[i].MdiRadInfo->ClientPos.x)
							RadInfo.DraggingRect[0].left=MdiInfo[i].MdiRadInfo->ClientPos.x;
						else RadInfo.DraggingRect[0].left=mouse.x+LEVER_THICK;

						if(mouse.y-LEVER_THICK-MIN_ITEM_Y<=RadInfo.DraggingRect[0].top)
							RadInfo.DraggingRect[0].bottom=RadInfo.DraggingRect[0].top+MIN_ITEM_Y;
						else if(mouse.y>MdiInfo[i].MdiRadInfo->ClientPos.y+MdiInfo[i].MdiRadInfo->ClientSize.cy)
							RadInfo.DraggingRect[0].bottom=MdiInfo[i].MdiRadInfo->ClientPos.y+MdiInfo[i].MdiRadInfo->ClientSize.cy;
						else RadInfo.DraggingRect[0].bottom=mouse.y-LEVER_THICK;
						DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
					}
					else if(RadInfo.NowDragging==FRAME_LOWER_RIGHT){
						if(mouse.x-LEVER_THICK-MIN_ITEM_X<=RadInfo.DraggingRect[0].left)
							RadInfo.DraggingRect[0].right=RadInfo.DraggingRect[0].left+MIN_ITEM_X;
						else if((mouse.x>MdiInfo[i].MdiRadInfo->ClientPos.x+MdiInfo[i].MdiRadInfo->ClientSize.cx)&&MdiInfo[i].MdiRadInfo->SelectingItem[0]!=SELECT_WINDOW)
							RadInfo.DraggingRect[0].right=MdiInfo[i].MdiRadInfo->ClientPos.x+MdiInfo[i].MdiRadInfo->ClientSize.cx;
						else RadInfo.DraggingRect[0].right=mouse.x-LEVER_THICK;

						if(mouse.y-LEVER_THICK-MIN_ITEM_Y<=RadInfo.DraggingRect[0].top)
							RadInfo.DraggingRect[0].bottom=RadInfo.DraggingRect[0].top+MIN_ITEM_Y;
						else if((mouse.y>MdiInfo[i].MdiRadInfo->ClientPos.y+MdiInfo[i].MdiRadInfo->ClientSize.cy)&&MdiInfo[i].MdiRadInfo->SelectingItem[0]!=SELECT_WINDOW)
							RadInfo.DraggingRect[0].bottom=MdiInfo[i].MdiRadInfo->ClientPos.y+MdiInfo[i].MdiRadInfo->ClientSize.cy;
						else RadInfo.DraggingRect[0].bottom=mouse.y-LEVER_THICK;
						DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
					}
					else if(RadInfo.NowDragging==FRAME_LEFT){
						if(RadInfo.DraggingRect[0].right-MIN_ITEM_X<=(mouse.x+LEVER_THICK))
							RadInfo.DraggingRect[0].left=RadInfo.DraggingRect[0].right-MIN_ITEM_X;
						else if(mouse.x+LEVER_THICK<MdiInfo[i].MdiRadInfo->ClientPos.x)
							RadInfo.DraggingRect[0].left=MdiInfo[i].MdiRadInfo->ClientPos.x;
						else RadInfo.DraggingRect[0].left=mouse.x+LEVER_THICK;
						DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
					}
					else if(RadInfo.NowDragging==FRAME_RIGHT){
						if(mouse.x-LEVER_THICK-MIN_ITEM_X<=RadInfo.DraggingRect[0].left)
							RadInfo.DraggingRect[0].right=RadInfo.DraggingRect[0].left+MIN_ITEM_X;
						else if((mouse.x>MdiInfo[i].MdiRadInfo->ClientPos.x+MdiInfo[i].MdiRadInfo->ClientSize.cx)&&MdiInfo[i].MdiRadInfo->SelectingItem[0]!=SELECT_WINDOW)
							RadInfo.DraggingRect[0].right=MdiInfo[i].MdiRadInfo->ClientPos.x+MdiInfo[i].MdiRadInfo->ClientSize.cx;
						else RadInfo.DraggingRect[0].right=mouse.x-LEVER_THICK;
						DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
					}
					else if(RadInfo.NowDragging==FRAME_UPPER){
						if(RadInfo.DraggingRect[0].bottom-MIN_ITEM_Y<=(mouse.y+LEVER_THICK))
							RadInfo.DraggingRect[0].top=RadInfo.DraggingRect[0].bottom-MIN_ITEM_Y;
						else if(mouse.y+LEVER_THICK<MdiInfo[i].MdiRadInfo->ClientPos.y)
							RadInfo.DraggingRect[0].top=MdiInfo[i].MdiRadInfo->ClientPos.y;
						else RadInfo.DraggingRect[0].top=mouse.y+LEVER_THICK;
						DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
					}
					else if(RadInfo.NowDragging==FRAME_LOWER){
						if(mouse.y-LEVER_THICK-MIN_ITEM_Y<=RadInfo.DraggingRect[0].top) 
							RadInfo.DraggingRect[0].bottom=RadInfo.DraggingRect[0].top+MIN_ITEM_Y;
						else if((mouse.y>MdiInfo[i].MdiRadInfo->ClientPos.y+MdiInfo[i].MdiRadInfo->ClientSize.cy)&&MdiInfo[i].MdiRadInfo->SelectingItem[0]!=SELECT_WINDOW)
							RadInfo.DraggingRect[0].bottom=MdiInfo[i].MdiRadInfo->ClientPos.y+MdiInfo[i].MdiRadInfo->ClientSize.cy;
						else RadInfo.DraggingRect[0].bottom=mouse.y-LEVER_THICK;
						DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
					}
					else if(RadInfo.NowDragging==FRAME_INSIDE){
						i3=0;
						while(MdiInfo[i].MdiRadInfo->SelectingItem[i3]!=-1){
							i4=RadInfo.DragStartRect[i3].left+mouse.x-RadInfo.DragStartPos.x;

							if(i4>MdiInfo[i].MdiRadInfo->ClientPos.x){
								i4=RadInfo.DragStartRect[i3].right+mouse.x-RadInfo.DragStartPos.x;
								if(i4<MdiInfo[i].MdiRadInfo->ClientPos.x+MdiInfo[i].MdiRadInfo->ClientSize.cx) i4=0;
								else i4-=MdiInfo[i].MdiRadInfo->ClientPos.x+MdiInfo[i].MdiRadInfo->ClientSize.cx;
							}
							else i4-=MdiInfo[i].MdiRadInfo->ClientPos.x;
							//i4͘gOɏoƂ̃|C^ƕǂɂRg[Ƃ̍
							RadInfo.DraggingRect[i3].left=RadInfo.DragStartRect[i3].left+mouse.x-RadInfo.DragStartPos.x-i4;
							RadInfo.DraggingRect[i3].right=RadInfo.DragStartRect[i3].right+mouse.x-RadInfo.DragStartPos.x-i4;

							i4=RadInfo.DragStartRect[i3].top+mouse.y-RadInfo.DragStartPos.y;
							if(i4>MdiInfo[i].MdiRadInfo->ClientPos.y){
								i4=RadInfo.DragStartRect[i3].bottom+mouse.y-RadInfo.DragStartPos.y;
								if(i4<MdiInfo[i].MdiRadInfo->ClientPos.y+MdiInfo[i].MdiRadInfo->ClientSize.cy) i4=0;
								else i4-=MdiInfo[i].MdiRadInfo->ClientPos.y+MdiInfo[i].MdiRadInfo->ClientSize.cy;
							}
							else i4-=MdiInfo[i].MdiRadInfo->ClientPos.y;
							RadInfo.DraggingRect[i3].top=RadInfo.DragStartRect[i3].top+mouse.y-RadInfo.DragStartPos.y-i4;
							RadInfo.DraggingRect[i3].bottom=RadInfo.DragStartRect[i3].bottom+mouse.y-RadInfo.DragStartPos.y-i4;

							if(MdiInfo[i].MdiRadInfo->SelectingItem[1]==-1) i4=1;
							else i4=0;
							DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[i3],&RadInfo.OldDraggingRect[i3],i4);
							i3++;
						}
					}
					else if(RadInfo.NowDragging==SELECTING_FRAME){
						RadInfo.DraggingRect[0].left=RadInfo.DragStartPos.x;
						RadInfo.DraggingRect[0].top=RadInfo.DragStartPos.y;
						RadInfo.DraggingRect[0].right=mouse.x;
						RadInfo.DraggingRect[0].bottom=mouse.y;
						DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
					}
					SetCursorByState(RadInfo.NowDragging);

					SetStatusText(NULL);

					//T|[g_CAO̓eZbg
					SetSupportDlgData(i,i2);
				}
				else{
					//hbOłȂƂ
					SetCursorByState(GetStateOfDraggingFrame(i,i2,mouse.x,mouse.y));
				}
			}
			else{
				//ACeiqEBhE쐬j
				if(wParam&MK_LBUTTON&&RadInfo.NowDragging==ITEM_MAKING){
					//hbȌꍇ

					RadInfo.DraggingRect[0].right=mouse.x;
					RadInfo.DraggingRect[0].bottom=mouse.y;
					DrawFrame(hwnd,i,i2,&RadInfo.DraggingRect[0],&RadInfo.OldDraggingRect[0],0);
				}
			}
			return 0;
		case WM_LBUTTONDBLCLK:
			{
				mouse.x=LOWORD(lParam);
				mouse.y=HIWORD(lParam);
				CursorPos_LocalToGlobal(hwnd,&mouse.x,&mouse.y);

				hParent=GetParent(hwnd);
				i=GetWndNum(hParent);
				i2=GetWndInfoNum(MdiInfo[i].path);
				WINDOW_INFO *pWindowInfo = GetWndInfo(MdiInfo[i].path);
				if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_MOUSE){
					if(MdiInfo[i].MdiRadInfo->SelectingItem[0]!=SELECT_WINDOW){
						temp2[0]=0;
						if(pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_BUTTON||
							pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_CHECKBOX||
							pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_IMAGEBOX||
							pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_RADIOBUTTON||
							pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_STATIC){
							sprintf(temporary,"%s_%s_Click",pWindowInfo->name,pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
						}
						else if(pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_COMBOBOX)
							sprintf(temporary,"%s_%s_EditChange",pWindowInfo->name,pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
						else if(pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_EDIT)
							sprintf(temporary,"%s_%s_Change",pWindowInfo->name,pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
						else if(pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_LISTBOX)
							sprintf(temporary,"%s_%s_SelChange",pWindowInfo->name,pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
						else temporary[0]=0;
						if(temporary[0]) SelectProcedureOfMessageCall(i2,temporary,temp2);
					}
				}
				return 0;
			}
		case WM_KEYDOWN:
			{
				hParent=GetParent(hwnd);
				i=GetWndNum(hParent);
				i2=GetWndInfoNum(MdiInfo[i].path);
				WINDOW_INFO *pWindowInfo = GetWndInfo(MdiInfo[i].path);
				if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_MOUSE){
					if(MdiInfo[i].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW){
						PointAndSize.pos=pWindowInfo->pos;
						PointAndSize.size=pWindowInfo->size;
						if(GetKeyState(VK_SHIFT)&0x8000){
							if(wParam==VK_RIGHT||wParam==VK_LEFT||wParam==VK_DOWN||wParam==VK_UP)
								Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&PointAndSize);

							if(wParam==VK_RIGHT)
								pWindowInfo->size.cx++;
							else if(wParam==VK_LEFT)
								pWindowInfo->size.cx--;
							else if(wParam==VK_DOWN)
								pWindowInfo->size.cy++;
							else if(wParam==VK_UP)
								pWindowInfo->size.cy--;

							if(wParam==VK_RIGHT||wParam==VK_LEFT||wParam==VK_DOWN||wParam==VK_UP){
								DrawRadWindow(i,pWindowInfo);

								SetStatusText(NULL);

								//T|[g_CAO̓eZbg
								SetSupportDlgData(i,i2);
							}
						}
					}
					else{
						PointAndSize.pos=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].pos;
						PointAndSize.size=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size;
						if(wParam==VK_RIGHT){
							if(GetKeyState(VK_SHIFT)&0x8000){
								Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&PointAndSize);
								pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cx++;
							}
							else{
								for(i3=0;;i3++){
									if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
									PointAndSize.pos=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos;
									PointAndSize.size=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size;
									Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[i3],(DWORD)&PointAndSize);

									pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.x++;
								}
							}
							DrawRadWindow(i,pWindowInfo);
							SetStatusText(NULL);

							//T|[g_CAO̓eZbg
							SetSupportDlgData(i,i2);
						}
						else if(wParam==VK_LEFT){
							if(GetKeyState(VK_SHIFT)&0x8000){
								Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&PointAndSize);
								pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cx--;
							}
							else{
								for(i3=0;;i3++){
									if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
									PointAndSize.pos=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos;
									PointAndSize.size=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size;
									Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[i3],(DWORD)&PointAndSize);

									pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.x--;
								}
							}
							DrawRadWindow(i,pWindowInfo);
							SetStatusText(NULL);

							//T|[g_CAO̓eZbg
							SetSupportDlgData(i,i2);
						}
						else if(wParam==VK_UP){
							if(GetKeyState(VK_SHIFT)&0x8000){
								Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&PointAndSize);
								pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cy--;
							}
							else{
								for(i3=0;;i3++){
									if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
									PointAndSize.pos=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos;
									PointAndSize.size=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size;
									Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[i3],(DWORD)&PointAndSize);

									pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.y--;
								}
							}
							DrawRadWindow(i,pWindowInfo);
							SetStatusText(NULL);

							//T|[g_CAO̓eZbg
							SetSupportDlgData(i,i2);
						}
						else if(wParam==VK_DOWN){
							if(GetKeyState(VK_SHIFT)&0x8000){
								Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&PointAndSize);
								pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cy++;
							}
							else{
								for(i3=0;;i3++){
									if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
									PointAndSize.pos=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos;
									PointAndSize.size=pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].size;
									Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[i3],(DWORD)&PointAndSize);

									pWindowInfo->pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[i3]].pos.y++;
								}
							}
							DrawRadWindow(i,pWindowInfo);
							SetStatusText(NULL);

							//T|[g_CAO̓eZbg
							SetSupportDlgData(i,i2);
						}
						else if(wParam==VK_DELETE)
							SendMessage(hwnd,WM_COMMAND,IDM_RAD_ITEM_DELETE,0);
					}
				}
				return 0;
			}
		case WM_SETFOCUS:
			i=GetWndNum(GetParent(hwnd));
			if(MdiInfo[i].MdiRadInfo->ButtonSelect==NON_TOOL)
				MdiInfo[i].MdiRadInfo->ButtonSelect=IDC_TOOL_MOUSE;
			InvalidateRect(hwnd,NULL,0);
			return 0;
		case WM_KILLFOCUS:
			i=GetWndNum(GetParent(hwnd));
			if(i==-1) return 0;	//EBhEjꂽꍇ
			if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_MOUSE)
				MdiInfo[i].MdiRadInfo->ButtonSelect=NON_TOOL;
			InvalidateRect(hwnd,NULL,0);
			return 0;
		case WM_PAINT:
			i=GetWndNum(GetParent(hwnd));
			if(i==-1) return 0;	//EBhEԂ̏ꍇ
			i2=GetWndInfoNum(MdiInfo[i].path);

			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_RANGE|SIF_POS;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			si2.cbSize=sizeof(SCROLLINFO);
			si2.fMask=SIF_RANGE|SIF_POS;
			GetScrollInfo(hwnd,SB_HORZ,&si2);

			hdc=BeginPaint(hwnd,&ps);
			BitBlt(hdc,0,0,ScreenX*2,ScreenY*2,
				MdiInfo[i].MdiRadInfo->hMemDC,si2.nPos,ScrollInfo.nPos,SRCCOPY);
			EndPaint(hwnd,&ps);

			if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_MOUSE||MdiInfo[i].MdiRadInfo->ButtonSelect==NON_TOOL)
				DrawSelectingRect(hwnd,i,i2,MdiInfo[i].MdiRadInfo->ButtonSelect);
			return 0;
		case WM_CONTEXTMENU:
			if(RadInfo.NowDragging) return 0;

			hParent=GetParent(hwnd);
			BringWindowToTop(hParent);
			SetFocus(hwnd);
			i=GetWndNum(hParent);
			i2=GetWndInfoNum(MdiInfo[i].path);

			if(MdiInfo[i].MdiRadInfo->ButtonSelect==IDC_TOOL_MOUSE){
				mouse.x=LOWORD(lParam);
				mouse.y=HIWORD(lParam);
				ScreenToClient(hwnd,&mouse);
				CursorPos_LocalToGlobal(hwnd,&mouse.x,&mouse.y);
				SelectItemNumOnMouse(i,i2,mouse.x,mouse.y);
				InvalidateRect(hwnd,NULL,0);
				extern HMENU hRadMenuBase;
				if(MdiInfo[i].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
					TrackPopupMenu(GetSubMenu(hRadMenuBase,0),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
				else TrackPopupMenu(GetSubMenu(hRadMenuBase,1),TPM_LEFTALIGN,LOWORD(lParam),HIWORD(lParam),0,hwnd,0);
			}
			return 0;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDM_RAD_WINDOW_EVENTCODE:
					i=GetWndNum(GetParent(hwnd));
					DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_RAD_EVENTCODE),hwnd,(DLGPROC)DlgEventCode,0);
					break;
				case IDM_RAD_WINDOW_MENUEVENTCODE:
					i=GetWndNum(GetParent(hwnd));
					DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_RAD_EVENTCODE),hwnd,(DLGPROC)DlgEventCode,1);
					break;
				case IDM_RAD_ITEM_DELETE:
					hParent=GetParent(hwnd);
					i=GetWndNum(hParent);
					i2=GetWndInfoNum(MdiInfo[i].path);

					//폜lȂ΂ȂȂ̂ŁAou\[gs
					int i5,i6;
					for(i5=0;;i5++){
						if(MdiInfo[i].MdiRadInfo->SelectingItem[i5]==-1) break;
					}
					for(i3=0;i3<i5-1;i3++){
						for(i4=i5-1;i4>i3;i4--){
							if(MdiInfo[i].MdiRadInfo->SelectingItem[i4] >
								MdiInfo[i].MdiRadInfo->SelectingItem[i4-1]){
								i6=MdiInfo[i].MdiRadInfo->SelectingItem[i4];
								MdiInfo[i].MdiRadInfo->SelectingItem[i4]=
									MdiInfo[i].MdiRadInfo->SelectingItem[i4-1];
								MdiInfo[i].MdiRadInfo->SelectingItem[i4-1]=i6;
							}
						}
					}


					for(i3=0;;i3++){
						if(MdiInfo[i].MdiRadInfo->SelectingItem[i3]==-1) break;
						DeleteDlgItem(i,i2,MdiInfo[i].MdiRadInfo->SelectingItem[i3],1);
					}
					for(i3=0;i3<MAX_RAD_SELITEM;i3++) MdiInfo[i].MdiRadInfo->SelectingItem[i3]=-1;

					ResetState_EditMenu();
					break;
			}
			return 0;
		case WM_VSCROLL:
			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			if(LOWORD(wParam)==SB_LINEUP) i=-20;
			else if(LOWORD(wParam)==SB_LINEDOWN) i=20;
			else if(LOWORD(wParam)==SB_PAGEUP) i=-(signed int)ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_PAGEDOWN) i=ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_THUMBTRACK) i=HIWORD(wParam)-ScrollInfo.nPos;
			else i=0;
			GetClientRect(hwnd,&rect);
			i=max(-ScrollInfo.nPos,min(i,ScrollInfo.nMax-rect.bottom-ScrollInfo.nPos));
			if(i!=0){
				ScrollInfo.nPos+=i;
				SetScrollInfo(hwnd,SB_VERT,&ScrollInfo,1);
				ScrollWindow(hwnd,0,-i,NULL,NULL);
				UpdateWindow(hwnd);
			}
			return 0;
		case WM_HSCROLL:
			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;
			GetScrollInfo(hwnd,SB_HORZ,&ScrollInfo);
			if(LOWORD(wParam)==SB_LINEUP) i=-20;
			else if(LOWORD(wParam)==SB_LINEDOWN) i=20;
			else if(LOWORD(wParam)==SB_PAGEUP) i=-(signed int)ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_PAGEDOWN) i=ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_THUMBTRACK) i=HIWORD(wParam)-ScrollInfo.nPos;
			else i=0;
			GetClientRect(hwnd,&rect);
			i=max(-ScrollInfo.nPos,min(i,ScrollInfo.nMax-rect.right-ScrollInfo.nPos));
			if(i!=0){
				ScrollInfo.nPos+=i;
				SetScrollInfo(hwnd,SB_HORZ,&ScrollInfo,1);
				ScrollWindow(hwnd,-i,0,NULL,NULL);
				UpdateWindow(hwnd);
			}
			return 0;
		case WM_SIZE:
			i=GetWndNum(GetParent(hwnd));
			if(i==-1) break;	//EBhEԂ̏ꍇ
			ResetScrollbarOfRadEditor(i,LOWORD(lParam),HIWORD(lParam));
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}
void ResizeToRadToolWindows(int WndNum,int weight,int height){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2;
	RECT rect;

	if(height<200){
		i=100;
		i2=100;
	}
	else{
		//c[{^EBhE(Ai)
		GetClientRect(GetWindow(MdiInfo[WndNum].MdiRadInfo->hTools,GW_CHILD),&rect);
		if(height>rect.bottom+1) i=rect.bottom+1;
		else i=height;

		//vpeBEBhE(Ai2)
		GetClientRect(GetWindow(MdiInfo[WndNum].MdiRadInfo->hProperty,GW_CHILD),&rect);
		i2=height-i;

		if(i2<100){
			i=height-100;
			i2=100;
		}
	}
	MoveWindow(MdiInfo[WndNum].MdiRadInfo->hTools,weight-172,0,172,i,1);
	MoveWindow(MdiInfo[WndNum].MdiRadInfo->hProperty,weight-172,i,172,i2,1);

	GetWindowRect(MdiInfo[WndNum].MdiRadInfo->hSupport,&rect);
	rect.right-=rect.left;
	rect.bottom-=rect.top;

	//RADEBhE
	MoveWindow(MdiInfo[WndNum].MdiRadInfo->hRad,0,0,weight-172,height-rect.bottom,1);

	//T|[gEBhE
	MoveWindow(MdiInfo[WndNum].MdiRadInfo->hSupport,0,height-rect.bottom,weight-172,rect.bottom,1);
}
LRESULT CALLBACK MDIClientWindow_Rad(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HWND hDocCombo;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,WndNum;

	switch(message){
		case WM_CREATE:
			extern HICON hWindowDocumentIcon;
			SendMessage(hwnd,WM_SETICON,ICON_SMALL,(long)hWindowDocumentIcon);
			break;
		case WM_MDIACTIVATE:
			if(!lParam) return 0;
			i=GetWndNum((HWND)lParam);
			if(i==-1) return 0;	//EBhEԂ̏ꍇ

			i=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[i].title);
			SendMessage(hDocCombo,CB_SETCURSEL,i,0);
			SetStatusText(NULL);
			ResetState_EditMenu();
			return 0;
		case WM_SIZE:
			WndNum=GetWndNum(hwnd);
			if(WndNum==-1) break;
			ResizeToRadToolWindows(WndNum,LOWORD(lParam),HIWORD(lParam));
			break;
		case WM_CLOSE:
			CloseDocWindow(GetWndNum(hwnd));
			pobj_nv->bMDIZoomed=IsZoomed(hwnd);
			i=DefMDIChildProc(hwnd,message,wParam,lParam);

			//j[Ԃݒ
			ResetState_DocMenu();

			return i;
	}
	return DefMDIChildProc(hwnd,message,wParam,lParam);
}
