#pragma once

class Compiler
{
	// rh̃tO
	bool isBuildSuccessful;

	// W[
	std::string moduleName;

	// W[ ^Cv
	ActiveBasic::Common::TargetModuleType::EnumType targetModuleType;

	// fobO rhǂ
	bool isDebug;

	// UnicodeΉW[ǂ
	bool isUnicode;

	// OԃT|[g
	NamespaceSupporter namespaceSupporter;

	// RpCUserProc/CClass
	const UserProc *pCompilingUserProc;
	const CClass *pCompilingClass;

	// IuWFNgW[
	ObjectModule *pObjectModule;
	ObjectModule *pNowObjectModule;

public:

	Compiler()
		: isBuildSuccessful( false )
		, pObjectModule( new ObjectModule )
		, targetModuleType( ActiveBasic::Common::TargetModuleType::Exe )
		, isDebug( false )
		, isUnicode( false )
		, isCore( false )
	{
		SelectObjectModule( *pObjectModule );
		Symbol::RegistNamespaceSupporter( &namespaceSupporter );
	}
	~Compiler()
	{
		delete pObjectModule;
		Clear();
	}
	void Clear()
	{
		BOOST_FOREACH( ObjectModule *pStaticLibrary, staticLibraries )
		{
			delete pStaticLibrary;
		}
		staticLibraries.clear();
	}

	void StaticLink( ObjectModules &staticLibraries );

	// rh̃tO
	bool IsBuildSuccessful() const
	{
		return isBuildSuccessful;
	}
	void BuildSuccessful()
	{
		isBuildSuccessful = true;
	}

	// W[
	void SetModuleName( const std::string &moduleName )
	{
		this->moduleName = moduleName;
	}
	const std::string &GetModuleName() const
	{
		return moduleName;
	}

	// OԃT|[g
	NamespaceSupporter &GetNamespaceSupporter()
	{
		return namespaceSupporter;
	}

	// bZW[
	Messenger messenger;
	ErrorMessenger errorMessenger;

	// R[h@\
	CodeGenerator codeGenerator;

	// J
	Linker linker;

	// ÓINIuWFNgt@C
	std::vector<std::string> staticLibraryFilePaths;

	// ÓINIuWFNgW[
	ObjectModules staticLibraries;

	// IuWFNgW[
	ObjectModule &GetObjectModule()
	{
		return *pNowObjectModule;
	}
	void SelectObjectModule( ObjectModule &objectModule )
	{
		pNowObjectModule = &objectModule;

		namespaceSupporter.RegistAllNamespaceScopesCollection( &GetObjectModule().meta.GetNamespaces() );
	}

	bool IsExe() const
	{
		if( targetModuleType == ActiveBasic::Common::TargetModuleType::Exe )
		{
			return true;
		}
		return false;
	}
	bool IsDll() const
	{
		if( targetModuleType == ActiveBasic::Common::TargetModuleType::Dll )
		{
			return true;
		}
		return false;
	}

	// X^eBbN N CurhH
	bool IsSll() const
	{
		if( targetModuleType == ActiveBasic::Common::TargetModuleType::Sll )
		{
			return true;
		}
		return false;
	}

	void SetTargetModuleType( ActiveBasic::Common::TargetModuleType::EnumType targetModuleType )
	{
		this->targetModuleType = targetModuleType;
	}

	void SetDebugMark( bool isDebug )
	{
		this->isDebug = isDebug;
	}
	bool IsDebug() const
	{
		return isDebug;
	}

	void SetUnicodeMark( bool isUnicode )
	{
		this->isUnicode = isUnicode;
	}
	bool IsUnicode()
	{
		return isUnicode;
	}


	// RAW[ǂ
	bool isCore;
	void SetCoreMark( bool isCore )
	{
		this->isCore = isCore;
	}
	bool IsCore() const
	{
		return isCore;
	}

	// O[oGAu֐
	std::string globalAreaProcName;

	// 񋓌^
	EnumInfoCollection enumInfoCollection;


	bool StringToType( const std::string &typeName, Type &type );
	const std::string TypeToString( const Type &type );

	void ClearCompilingUserProcAndClass();
	void StartGlobalAreaCompile();
	void FinishGlobalAreaCompile();
	void SetCompilingClass( const CClass *pClass );
	void SetCompilingUserProc( const UserProc *pUserProc );
	void StartProcedureCompile( const UserProc *pUserProc );
	void FinishProcedureCompile();

	bool IsGlobalAreaCompiling();
	bool IsLocalAreaCompiling();
	const UserProc &GetCompilingUserProc();
	bool IsCompilingClass();
	const CClass &GetCompilingClass();
};

extern Compiler compiler;
