#pragma once

class ObjectModule
{
public:
	// ^
	Meta meta;

	// O[ö̃lCeBuR[h
	NativeCode globalNativeCode;

	// f[^e[u
	DataTable dataTable;

private:
	// \[XR[h
	int currentSourceIndex;
	BasicSources sources;

	// XMLVACYp
private:
	virtual const char *RootTagName() const
	{
		return "objectModule";
	}
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - objectModule" );

		ar & BOOST_SERIALIZATION_NVP( meta );
		ar & BOOST_SERIALIZATION_NVP( globalNativeCode );
		ar & BOOST_SERIALIZATION_NVP( dataTable );
		ar & BOOST_SERIALIZATION_NVP( currentSourceIndex );
		ar & BOOST_SERIALIZATION_NVP( sources );
	}

public:
	void StaticLink( ObjectModule &objectModule );

	int GetCurrentSourceIndex() const
	{
		return currentSourceIndex;
	}
	const BasicSource &GetCurrentSource() const
	{
		return sources[currentSourceIndex];
	}
	BasicSource &GetCurrentSource()
	{
		return sources[currentSourceIndex];
	}
	void SetCurrentSourceIndex( int currentSourceIndex )
	{
		this->currentSourceIndex = currentSourceIndex;
	}
	const BasicSource &GetSource( int sourceIndex ) const
	{
		return sources[sourceIndex];
	}
	BasicSources &GetSources()
	{
		return sources;
	}

	bool Read( const std::string &filePath );
	bool Write( const std::string &filePath ) const;
	bool ReadString( const std::string &str );
	bool WriteString( std::string &str ) const;
};
typedef std::vector<ObjectModule *> ObjectModules;
