#include "stdafx.h"

bool Parameter::Equals( const Parameter &param, bool isContravariant ) const
{
	if( Type::Equals( param ) )
	{
		return true;
	}
	else
	{
		if( this->isRef && this->GetBasicType() == DEF_ANY &&
			param.isRef == false && param.IsPointer()
			||
			this->isRef == false && this->IsPointer() &&
			param.isRef && param.GetBasicType() == DEF_ANY )
		{
			/* ByRef var As Any
					
				var As VoidPtr
				͓
			*/
			return true;
		}
	}

	if( isContravariant )
	{
		// ψ
		if( this->IsContravariant( param ) )
		{
			// ψƂ
			return true;
		}
	}

	return false;
}
bool Parameter::Equals( const Types &actualTypeParametersForThisProc, const Parameter &param, bool isContravariant ) const
{
	if( Equals( param, isContravariant ) )
	{
		return true;
	}
	
	if( this->IsTypeParameter() )
	{
		// ^p[^Ƃ
		if( actualTypeParametersForThisProc[this->GetFormalTypeIndex()].Equals( param ) )
		{
			// ߂l
			return true;
		}
	}

	return false;
}

bool Parameters::Equals( const Parameters &params, bool isContravariant ) const
{
	if( this->size() != params.size() ){
		return false;
	}

	int max = (int)this->size();
	for( int i=0; i<max; i++ ){
		if( !(*this)[i]->Equals( *params[i], isContravariant ) ){
			return false;
		}
	}

	return true;
}
bool Parameters::Equals( const Types &actualTypeParametersForThisProc, const Parameters &params, bool isContravariant ) const
{
	if( this->size() != params.size() ){
		return false;
	}

	int max = (int)this->size();
	for( int i=0; i<max; i++ ){
		if( !(*this)[i]->Equals( actualTypeParametersForThisProc, *params[i], isContravariant ) ){
			return false;
		}
	}

	return true;
}
