#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

using namespace ActiveBasic::Compiler;

void NewStringObject(int reg, const char *str){
	///////////////////////////////////////////////////////
	// lpszTextStringIuWFNg𐶐A
	// IuWFNg|C^regɊi[
	///////////////////////////////////////////////////////


	//////////////////////////////////////////////////////
	/////    WX^̃obNAbv
	{	BACKUP_REGISTER_RESOURCE
	//////////////////////////////////////////////////////

		char *parameter = (char *)malloc( lstrlen( str ) + 32 );
		sprintf( parameter, "%s%c%c*Char", str, 1, ESC_AS );

		Operator_New( *compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr(), "", parameter, Type( DEF_OBJECT, *compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr() ) );

		free( parameter );

		//mov reg,rax
		compiler.codeGenerator.op_mov_RR( reg, REG_RAX );

	/////////////////////////////////////////////
	//////   WX^𕜌
		RESTORE_REGISTER_RESOURCE
	}////////////////////////////////////////////
}

void SetUseRegFromRax(int type,int UseReg,int XmmReg){
	if(IsRealNumberType(type)){
		//^
		if(XmmReg==REG_XMM4){
			if(type==DEF_DOUBLE){
				//movsd qword ptr[rsp+offset],xmm0	X^bNt[𗘗p
				pobj_sf->push(REG_XMM0,sizeof(double));
			}
			if(type==DEF_SINGLE){
				//movss dword ptr[rsp+offset],xmm0	X^bNt[𗘗p
				pobj_sf->push(REG_XMM0,sizeof(float));
			}
		}
		else{
			if(type==DEF_DOUBLE){
				//movsd xmm_reg,xmm0
				compiler.codeGenerator.op_movsd_RR(XmmReg,REG_XMM0);
			}
			else if(type==DEF_SINGLE){
				//movss xmm_reg,xmm0
				compiler.codeGenerator.op_movss_RR(XmmReg,REG_XMM0);
			}
		}
	}
	else{
		//^
		if(UseReg==REG_R14){
			//mov qword ptr[rsp+offset],rax     X^bNt[𗘗p
			pobj_sf->push(REG_RAX);
		}
		else{
			//mov reg,rax
			compiler.codeGenerator.op_mov_RR(UseReg,REG_RAX);
		}
	}
}

void ExtendRegToBigType( int reg, int bigBasicType, int baseBasicType ){
	switch( Type::GetBasicSize( bigBasicType ) ){
		case sizeof(_int64):
			ExtendTypeTo64(baseBasicType,reg);
			break;
		case sizeof(long):
			ExtendTypeTo32(baseBasicType,reg);
			break;
		case sizeof(short):
			ExtendTypeTo16(baseBasicType,reg);
			break;
	}
}


bool VarToReg( RELATIVE_VAR &relativeVar, const Type &baseType, Type &resultType ){
	int UseReg=pobj_reg->GetNextReg();
	int XmmReg=pobj_reg->GetNextXmmReg();

	//傫Ȍ^ւ̈Öق̕ϊ
	int bigType = AutoBigCast(baseType.GetBasicType(),resultType.GetBasicType());

	if(resultType.GetBasicType()&FLAG_PTR){
		//z|C^
		resultType.SetBasicType( GetPtrType(resultType.GetBasicType()^FLAG_PTR) );

		SetVarPtrToReg(UseReg,&relativeVar);
	}
	else if(resultType.IsReal()){
		//^
		if( resultType.IsDouble() )
			SetXmmReg_DoubleVariable(&relativeVar,XmmReg);
		if( resultType.IsSingle() )
			SetXmmReg_SingleVariable(&relativeVar,XmmReg);
	}
	else if( resultType.IsWhole() || resultType.IsObject()){
		//^
		SetReg_WholeVariable(resultType,&relativeVar,UseReg);
	}
	else if( resultType.IsStruct() ){
		//\̃|C^UseReg֊i[i\̂͒l^j
		SetVarPtrToReg(UseReg,&relativeVar);
	}
	else{
		return false;
	}

	if( resultType.GetBasicType() != bigType ){
		// 傫Ȍ^֕ϊꂽꍇ
		// WX^̒lLXg
		ExtendRegToBigType( UseReg, bigType, resultType.GetBasicType() );

		resultType.SetBasicType( bigType );
	}

	return true;
}
bool TermMemberOpe( const Type &leftType, bool &isNeedHeapFreeStructure, const Type &baseType, Type &resultType, const char *termFull, const char *termLeft, const char *member, bool &isVariable, RELATIVE_VAR &relativeVar )
{
	const CClass &objClass = leftType.GetClass();

	const int useReg=pobj_reg->GetNextReg();
	const int xmmReg=pobj_reg->GetNextXmmReg();


	////////////////////////////////
	// CfNTigetANZTj
	////////////////////////////////
	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(member,VarName,ArrayElements);
	if(ArrayElements[0]){
		Type classType;
		if( VarName[0] == '\0' )
		{
			classType = leftType;

			if( classType.IsObject() )
			{
				// useRegɃIuWFNg|C^i[ĂAɑ΂CfNTĂяoꍇ
				// uvpeBlƂĕԂĂIuWFNgCX^X̃CfNTĂяovꍇɂɂ

				// IuWFNgõ|C^͊raxɓĂ
			}
		}
		else
		{
			GetMemberType( leftType, VarName, classType, 0, false );

			if( classType.IsObject() )
			{
				//IuWFNg|C^r11ɃRs[
				compiler.codeGenerator.op_mov_RR( REG_R11, useReg );

				RELATIVE_VAR tempRelativeVar;
				tempRelativeVar.dwKind=VAR_DIRECTMEM;

				if( !_member_offset(
					true,	//G[\
					false,	//ǂݍݐp
					leftType,
					VarName,&tempRelativeVar,classType,0)){
						return false;
				}

				// IuWFNgõ|C^raxɃRs[
				if( !VarToReg( tempRelativeVar, baseType, resultType ) ){
					compiler.errorMessenger.Output(11,termFull,cp);
				}
			}
		}

		if( classType.IsObject() )
		{
			//////////////////////////////////////////////////////
			/////    WX^̃obNAbv
			{	BACKUP_REGISTER_RESOURCE
			//////////////////////////////////////////////////////

				//IuWFNg|C^X^bNɓĂ
				//mov qword ptr[rsp+offset],reg     X^bNt[𗘗p
				pobj_sf->push( useReg );

				char objectFullName[VN_SIZE], dummyArrayElements[VN_SIZE];
				GetArrayElement(termFull,objectFullName,dummyArrayElements);

				CallIndexerGetterProc(useReg,classType,objectFullName, ArrayElements,resultType, PROCFLAG_NEW );

				pobj_sf->pop();

			/////////////////////////////////////////////
			//////   WX^𕜌
				RESTORE_REGISTER_RESOURCE
			}////////////////////////////////////////////

			return true;
		}
	}


	///////////////////////////////////////////////////////////////////
	// o
	///////////////////////////////////////////////////////////////////
	if( GetMemberType( leftType, member, resultType, 0, false ) ){
		// oƂ

		if( isNeedHeapFreeStructure )
		{
			if( !leftType.IsStruct() )
			{
				compiler.errorMessenger.OutputFatalError();
			}

			pobj_reg->LockReg();

			// eƂȂ\̂ꎞɑ݂ĂꍇAقǉKv
			compiler.codeGenerator.op_AddNeedFreeTempStructure( useReg );
			isNeedHeapFreeStructure = false;

			pobj_reg->UnlockReg();
		}

		//IuWFNg|C^r11ɃRs[
		compiler.codeGenerator.op_mov_RR( REG_R11, useReg );

		relativeVar.dwKind=VAR_DIRECTMEM;

		if( !_member_offset(
			true,	//G[\
			false,	//ǂݍݐp
			leftType,
			member,&relativeVar,resultType,0)){
				return false;
		}

		// ϐƂĈ
		isVariable = true;

		return true;
	}


	///////////////////////////////////////////////////////////////////
	// I\bh
	///////////////////////////////////////////////////////////////////
	std::vector<const UserProc *> userProcs;

	char methodName[VN_SIZE], lpPtrOffset[VN_SIZE], parameter[VN_SIZE], dummy[1];
	ReferenceKind refType;
	PareOrBracket pareOrBracket = None;
	lstrcpy( methodName, member );
	GetVarFormatString( methodName, parameter, lpPtrOffset, dummy, refType, &pareOrBracket );

	objClass.EnumDynamicMethodsOrInterfaceMethods( methodName, userProcs );
	if(userProcs.size()){
		//I[o[[h
		const UserProc *pUserProc = OverloadSolutionWithStrParam(termFull,userProcs,parameter,termLeft);

		if( pUserProc )
		{
			if(
				pUserProc->Params().size() == 0				// ̌0
				&& parameter[0]								// 1ȏ
				&& pUserProc->ReturnType().IsObject()		// ߂lNX^̏ꍇ
				&& pareOrBracket == Bracket )				// []ň͂܂Ă
			{
				// vpeBlƂĕԂĂIuWFNgCX^X̃CfNTĂяo

				// ܂̓vpeBl擾
				bool dummyIsVariable;
				RELATIVE_VAR dummyRelativeVar;
				TermMemberOpe( leftType, isNeedHeapFreeStructure, baseType, resultType, termFull, termLeft, methodName, dummyIsVariable, dummyRelativeVar );

				// ߂l̃IuWFNgCX^X̃CfNTĂяo
				char temporary[VN_SIZE], temp2[VN_SIZE];
				sprintf( temporary, "[%s]", parameter );
				sprintf( temp2, "%s.%s", termLeft, methodName );
				Type classType = resultType;
				return TermMemberOpe( classType, isNeedHeapFreeStructure, baseType, resultType, termFull, temp2, temporary, isVariable, relativeVar );
			}

			resultType = pUserProc->ReturnType();


			//////////////////////////////////////////////////////
			/////    WX^̃obNAbv
			{	BACKUP_REGISTER_RESOURCE
			//////////////////////////////////////////////////////

				//IuWFNg|C^X^bNɓĂ
				//mov qword ptr[rsp+offset],reg     X^bNt[𗘗p
				pobj_sf->push( useReg );

				if( !Opcode_CallProc(parameter,pUserProc,PROCFLAG_NEW,termLeft ) ){
					//WX^𕜌
					RESTORE_REGISTER_RESOURCE

					return false;
				}

				pobj_sf->pop();

				/////////////////////
				// ߂l̏
				/////////////////////

				//傫Ȍ^ւ̈Öق̕ϊ
				int bigType = AutoBigCast(baseType.GetBasicType(), resultType.GetBasicType() );

				if( resultType.GetBasicType() != bigType ){
					// 傫Ȍ^֕ϊꂽꍇ
					// WX^̒lLXg
					ExtendRegToBigType( REG_RAX, bigType, resultType.GetBasicType() );

					resultType.SetBasicType( bigType );
				}

				SetUseRegFromRax(resultType.GetBasicType(),useReg,xmmReg);

				// ^p[^
				ResolveFormalGenericTypeParameter( resultType, leftType, pUserProc );


			/////////////////////////////////////////////
			//////   WX^𕜌
				RESTORE_REGISTER_RESOURCE
			}////////////////////////////////////////////
			
			return true;
		}
	}
	else if( pareOrBracket == Pare )
	{
		// ֐|C^
		compiler.errorMessenger.OutputFatalError();

		///////////////////////////////////////////////////////////////////
		// o
		///////////////////////////////////////////////////////////////////
		if( GetMemberType( leftType, methodName, resultType, 0, false ) ){
			// oƂ
		}
	}

	compiler.errorMessenger.OutputFatalError();

	return false;
}
bool _TermOpe( const char *term, const Type &baseType, Type &resultType, bool &isLiteral, bool &isNeedHeapFreeStructure, bool *pIsClassName, bool isProcedureCallOnly, bool &isVariable, RELATIVE_VAR &relativeVar, bool isWriteAccess )
{
	char parameter[VN_SIZE];

	// With
	char termFull[VN_SIZE];
	if(term[0]=='.'){
		GetWithName(termFull);
		lstrcat(termFull,term);
	}
	else lstrcpy(termFull,term);

	char termLeft[VN_SIZE];
	lstrcpy(termLeft,termFull);

	// p[X
	char member[VN_SIZE];
	ReferenceKind refType;
	if( SplitMemberName( termFull, termLeft, member, refType ) ){
		///////////////////////////////////////////////////////////////////
		// IuWFNgƃoɕłƂ
		// termLeft.member
		///////////////////////////////////////////////////////////////////

		isLiteral = false;

		// IuWFNǧ^擾
		bool isClassName = false;
		Type leftType;
		if( GetTermType( termLeft, Type(), leftType, isLiteral, &isClassName ) ){
			if( isClassName == false && compiler.GetObjectModule().meta.GetBlittableTypes().IsExist( leftType ) ){
				// ̃IuWFNgBlittable^̂Ƃ

				char temporary[VN_SIZE];
				lstrcpy( temporary, termLeft );
				sprintf( termLeft, "%s(%s)",
					compiler.GetObjectModule().meta.GetBlittableTypes().Find( leftType ).GetCreateStaticMethodFullName().c_str(),
					temporary );
			}
		}

		if( !TermOpe( termLeft, baseType, leftType, isLiteral, isNeedHeapFreeStructure, &isClassName ) ){
			goto globalArea;
		}

		if( isClassName ){
			// ÓIo/\bh̏ꍇ
			goto globalArea;
		}

		if( !leftType.HasMember() ){
			// oȂ^̏ꍇ
			if( isProcedureCallOnly )
			{
				compiler.errorMessenger.Output(1,NULL,cp);
			}
			return false;
		}

		return TermMemberOpe( leftType, isNeedHeapFreeStructure, baseType, resultType, termFull, termLeft, member, isVariable, relativeVar );
	}
globalArea:

	//////////////////////////////////////////////
	// NXǂ`FbNiÓIopj
	//////////////////////////////////////////////

	if( pIsClassName ){
		if( compiler.GetObjectModule().meta.FindClassSupportedTypeDef( LexicalAnalyzer::FullNameToSymbol( termFull ) ) ){
			*pIsClassName = true;
			return true;
		}
	}


	/////////////////////////////////////////////////////////////////
	// O[oGA
	/////////////////////////////////////////////////////////////////

	int UseReg=pobj_reg->GetNextReg();
	int XmmReg=pobj_reg->GetNextXmmReg();


	if(lstrcmpi(termFull,"This")==0 && isProcedureCallOnly == false ){
		if( !compiler.IsCompilingClass() )
		{
			compiler.errorMessenger.Output(142,NULL,cp);
			return false;
		}

		//ThisIuWFNg
		resultType.SetType( DEF_OBJECT, &compiler.GetCompilingClass() );

		SetThisPtrToReg( UseReg );

		isLiteral = false;

		return true;
	}


	//////////////////////////////////////
	// ֐iDLLA[U[`Agݍ݁j
	//////////////////////////////////////
	char procName[VN_SIZE];
	char temporary[8192];

	int i2=GetCallProcName(termFull,procName);
	if(termFull[i2]=='('){
		int i4=GetStringInPare_RemovePare(parameter,termFull+i2+1);

		void *pInfo;
		int idProc=GetProc(procName,(void **)&pInfo);

		if(idProc){
			//JbR")"ɑNULLłȂƂ
			if(termFull[i2+1+i4+1]!='\0'){
				compiler.errorMessenger.Output(42,NULL,cp);
			}


			//////////////////////////////////////////////////////
			/////    WX^̃obNAbv
			{	BACKUP_REGISTER_RESOURCE
			//////////////////////////////////////////////////////


				////////////////
				// Ăяo
				////////////////

				CallProc(idProc,pInfo,procName,parameter, baseType,resultType);


				/////////////////////
				// ߂l̏
				/////////////////////

				//傫Ȍ^ւ̈Öق̕ϊ
				int bigType = AutoBigCast(baseType.GetBasicType(), resultType.GetBasicType() );

				if( resultType.GetBasicType() != bigType ){
					// 傫Ȍ^֕ϊꂽꍇ
					// WX^̒lLXg
					ExtendRegToBigType( REG_RAX, bigType, resultType.GetBasicType() );

					resultType.SetBasicType( bigType );
				}

				SetUseRegFromRax(resultType.GetBasicType(),UseReg,XmmReg);

			/////////////////////////////////////////////
			//////   WX^𕜌
				RESTORE_REGISTER_RESOURCE
			}////////////////////////////////////////////

			if(resultType.IsStruct())
			{
				//\̂߂Ƃ̓q[v̈ɃCX^Xi[Ă
				//freeKv
				// TODO: GCɔC
				isNeedHeapFreeStructure = true;
			}

			isLiteral = false;

			return true;
		}

		ConstMacro *pConstMacro = compiler.GetObjectModule().meta.GetGlobalConstMacros().Find(
			ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( procName )
		);
		if( pConstMacro )
		{
			if( ActiveBasic::Compiler::LexicalAnalyzer::ConstMacroToExpression( *pConstMacro, parameter, temporary ) )
			{
				/////////////////////////
				// }N֐
				/////////////////////////

				//JbR")"ɑNULLłȂƂ̓G[ɂ
				if(termFull[i2+1+i4+1]!='\0') compiler.errorMessenger.Output(42,NULL,cp);

				//}N֐̏ꍇ
				NumOpe(&UseReg, temporary,Type(),resultType);

				if(!IS_LITERAL(resultType.GetIndex())){
					//elł͂ȂƂ
					isLiteral = false;
				}

				return true;
			}
		}
	}
	else if( isProcedureCallOnly ){
		// ֐ĂяoȊO͎󂯕tȂ
		return false;
	}


	////////////////////////////////
	// CfNTigetANZTj
	////////////////////////////////

	char VarName[VN_SIZE],ArrayElements[VN_SIZE];
	GetArrayElement(termFull,VarName,ArrayElements);
	if(ArrayElements[0]){
		Type classType;
		GetVarType(VarName,classType,false);
		if( classType.IsObject() )
		{
			CallIndexerGetterProc(UseReg,classType,VarName,ArrayElements,resultType);

			isLiteral = false;

			return true;
		}
	}


	////////////////////////////////
	// ϐ
	////////////////////////////////

	if(GetVarOffset(
		false,	//G[\Ȃ
		isWriteAccess,
		termFull,
		&relativeVar,resultType)){
		//////////
		// ϐ
		//////////

		// ϐƂĈ
		isVariable = true;

		isLiteral = false;

		return true;
	}

/*
	////////////////////////////////
	// ^
	////////////////////////////////

	if( compiler.StringToType( termFull, resultType ) ){
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_CAST );
		return true;
	}*/


	/////////////////////////////////
	// vpeBp̃\bh
	/////////////////////////////////

	//zvfr
	GetArrayElement(termFull,VarName,ArrayElements);

	if(GetSubHash(VarName,0)){

		//////////////////////////////////////////////////////
		/////    WX^̃obNAbv
		{	BACKUP_REGISTER_RESOURCE
		//////////////////////////////////////////////////////

			CallPropertyMethod(termFull,NULL,resultType);

			//傫Ȍ^ւ̈Öق̕ϊ
			int bigType = AutoBigCast(baseType.GetBasicType(), resultType.GetBasicType() );

			if( resultType.GetBasicType() != bigType ){
				// 傫Ȍ^֕ϊꂽꍇ
				// WX^̒lLXg
				ExtendRegToBigType( REG_RAX, bigType, resultType.GetBasicType() );

				resultType.SetBasicType( bigType );
			}

			SetUseRegFromRax(resultType.GetBasicType(),UseReg,XmmReg);

		/////////////////////////////////////////////
		//////   WX^𕜌
			RESTORE_REGISTER_RESOURCE
		}////////////////////////////////////////////

		if(resultType.IsStruct())
		{
			//\̂߂Ƃ̓q[v̈ɃCX^Xi[Ă
			//freeKv
			// TODO: GCɔC
			isNeedHeapFreeStructure = true;
		}

		isLiteral = false;

		return true;
	}

	if( isProcedureCallOnly )
	{
		compiler.errorMessenger.Output(3, termLeft, cp );
	}

	return false;
}

bool TermOpe( const char *term, const Type &baseType, Type &resultType, bool &isLiteral, bool &isNeedHeapFreeStructure, bool *pIsClassName, bool isProcedureCallOnly, bool isWriteAccess )
{
	bool isInitRegSwitch = false;
	if( !pobj_reg )
	{
		isInitRegSwitch = true;

		//ƗpWX^擾
		pobj_reg = new CRegister( REG_RAX );
	}

	//G[̕p
	CRegister objReg_Backup = *pobj_reg;


	RELATIVE_VAR relativeVar;
	bool isVariable = false;
	bool result = _TermOpe( term, baseType, resultType, isLiteral, isNeedHeapFreeStructure, pIsClassName, isProcedureCallOnly, isVariable, relativeVar, isWriteAccess );

	if( isVariable )
	{
		// ϐ̏ꍇeaxɕϐ|C^i[
		if( !VarToReg( relativeVar, baseType, resultType ) ){
			compiler.errorMessenger.Output(11,term,cp);
		}
	}


	if( !result )
	{
		*pobj_reg = objReg_Backup;
	}

	if( isInitRegSwitch ){
		//`FbNioOj
		if( result )
		{
			pobj_reg->bug_check();
		}

		//ƃWX^
		delete pobj_reg;
		pobj_reg = NULL;
	}

	return result;
}
bool TermOpeOnlyVariable( const char *term, Type &resultType, RELATIVE_VAR &relativeVar, bool isWriteAccess )
{
	if( pobj_reg )
	{
		compiler.errorMessenger.OutputFatalError();
	}

	//ƗpWX^擾
	pobj_reg = new CRegister( REG_NON );

	bool isLiteral, isVariable = false, isNeedHeapFreeStructure = false;
	bool result = _TermOpe( term, Type(), resultType, isLiteral, isNeedHeapFreeStructure, NULL, false, isVariable, relativeVar, isWriteAccess );

	if( !isVariable )
	{
		compiler.errorMessenger.OutputFatalError();
	}

	//`FbNioOj
	if( result )
	{
		pobj_reg->bug_check();
	}

	//ƃWX^
	delete pobj_reg;
	pobj_reg=0;

	return result;
}


bool _numope( int *pReg,
			const char *expression,
			const Type &baseType,
			Type &resultType,
			bool *pbIsNeedHeapFreeStructure )
{
	int i,i2,i3;
	char temporary[1024],temp2[1024];

	if(expression[0]=='\0'){
		compiler.errorMessenger.Output(1,NULL,cp);
		return false;
	}

	if( !baseType.IsNull() && expression[0] == '[' ){
		// ez̏ꍇ

		int dataTableOffset;
		if( !ActiveBasic::Compiler::DataTableGenerator::MakeLiteralArrayBuffer( compiler.GetObjectModule().dataTable, expression, baseType, dataTableOffset ) )
		{
			return false;
		}

		//mov reg,i2
		compiler.codeGenerator.op_mov_RV( sizeof(_int64), *pReg, dataTableOffset, Schedule::DataTable );

		resultType = baseType;

		return true;
	}

	bool isLiteralCalculation;
	if( NumOpe_GetType( expression, baseType, resultType, &isLiteralCalculation ) )
	{
		if( isLiteralCalculation )
		{
			//EӒll̒萔̏ꍇ
			_int64 i64data;
			StaticCalculation(true, expression,baseType.GetBasicType(),&i64data,resultType);

			if(resultType.IsReal()){
				if(baseType.IsReal()) resultType=baseType;

				int xmmReg = pobj_reg->GetNextXmmReg();
				*pReg = xmmReg;

				if(resultType.IsDouble()){
					i3 = compiler.GetObjectModule().dataTable.Add( i64data );

					//movlpd xmm_reg,qword ptr[data table offset]
					compiler.codeGenerator.op_movlpd_RM( xmmReg, 0, i3, MOD_DISP32, Schedule::DataTable );
				}
				if(resultType.IsSingle()){
					double dbl;
					memcpy(&dbl,&i64data,sizeof(_int64));

					float flt;
					int i32data;
					flt=(float)dbl;
					memcpy(&i32data,&flt,sizeof(long));

					i3 = compiler.GetObjectModule().dataTable.Add( i32data );

					//movss xmm_reg,dword ptr[data table offset]
					compiler.codeGenerator.op_movss_RM( xmmReg, 0, i3, MOD_DISP32, Schedule::DataTable );
				}
			}
			else{
				if(!resultType.Is64()){
					//iL/j

					i3=(long)i64data;

					if(resultType.GetBasicSize()==sizeof(char)) i3=i3&0x000000FF;
					if(resultType.GetBasicSize()==sizeof(short)) i3=i3&0x0000FFFF;

					i64data=(_int64)i3;
				}

				//mov reg,i64data
				compiler.codeGenerator.op_mov_RV64(*pReg,i64data);
			}
			return true;
		}
	}

	if( expression[0] == 1 )
	{
		if( expression[1]==ESC_NEW )
		{
			//NewZqiIuWFNgj

			if( pobj_BlockReg->check(REG_RAX) ){
				compiler.errorMessenger.OutputFatalError();
			}

			//////////////////////////////////////////////////////
			/////    WX^̃obNAbv
			{	BACKUP_REGISTER_RESOURCE
			//////////////////////////////////////////////////////

				if( !Operator_New( expression+2, baseType, resultType ) ){
					return false;
				}

			/////////////////////////////////////////////
			//////   WX^𕜌
				RESTORE_REGISTER_RESOURCE
			}////////////////////////////////////////////

			//mov reg,rax
			compiler.codeGenerator.op_mov_RR( *pReg, REG_RAX );

			return true;
		}
		else if( expression[1] == ESC_SYSTEM_STATIC_NEW )
		{
			// ÓÏɃIuWFNg

			// ÓÏɃIuWFNg𐶐
			int dataTableOffset;
			if( !ActiveBasic::Compiler::DataTableGenerator::MakeConstObjectToProcessStaticBuffer( compiler.GetObjectModule().dataTable, expression + 2, resultType, dataTableOffset ) )
			{
				return false;
			}

			//mov reg,i2
			compiler.codeGenerator.op_mov_RV( sizeof(_int64), *pReg, dataTableOffset, Schedule::DataTable);

			return true;
		}
	}


	/////////////////////////////////
	// vft|[hŎ擾
	/////////////////////////////////

	char *values[255];
	long calc[255];
	long stack[255];
	int pnum;
	if(!GetNumOpeElements(expression,&pnum,values,calc,stack)){
		for(i=0;i<pnum;i++){
			if(values[i]) HeapDefaultFree(values[i]);
		}
		return 0;
	}


	////////////////////////////////
	// Z̃R[hJn
	////////////////////////////////

	BOOL bError;
	bError=0;

	//el݂̂̌vZǂ𔻕ʂ邽߂̃tO
	BOOL bLiteralCalculation=1;

	double dbl;
	int sp;
	int type_stack[255];
	LONG_PTR index_stack[255];
	bool isNothing_stack[255];
	bool isNeedHeapFreeStructureStack[255];
	_int64 i64data;
	int UseReg,XmmReg;
	BOOL bXmm;
	for(i=0,sp=0;i<pnum;i++){
		int idCalc;
		idCalc=calc[i]%100;

		if(idCalc){
			if(type_stack[sp-2]==DEF_OBJECT){
				if( idCalc == CALC_AS
					&& type_stack[sp-1] == ( DEF_OBJECT | FLAG_CAST )
					&& index_stack[sp-1] == index_stack[sp-2]
					|| isNothing_stack[sp-2] ){
						// ̌^A܂Nothingɑ΂AsAsZqĂяoȂ
				}
				else if( idCalc == CALC_AS
					&& type_stack[sp-1] == ( DEF_OBJECT | FLAG_CAST )
					&& ( ((CClass *)index_stack[sp-1])->IsEqualsOrSubClass( (CClass *)index_stack[sp-2] ) || ((CClass *)index_stack[sp-2])->IsEqualsOrSubClass( (CClass *)index_stack[sp-1] )
					)){
						// _ELXg
				}
				else{
					//I[o[[hꂽIy[^Ăяo
					i2=CallOperatorProc(idCalc,baseType,type_stack,index_stack,isNeedHeapFreeStructureStack,sp);
					if(i2==0){
						if(idCalc==CALC_EQUAL) lstrcpy(temp2,"==");
						else GetCalcName(idCalc,temp2);
						sprintf(temporary,"Operator %s",temp2);
						compiler.errorMessenger.Output(27,temporary,cp);
						goto error;
					}
					else if(i2==-1) goto error;

					continue;
				}
			}

			if(!CheckCalcType(idCalc,type_stack,sp)) goto error;
		}

		switch(idCalc){
			//l
			case 0:
				index_stack[sp]=-1;
				isNothing_stack[sp] = false;
				isNeedHeapFreeStructureStack[sp] = false;

				UseReg=pobj_reg->GetNextReg();
				XmmReg=pobj_reg->GetNextXmmReg();

				bXmm=0;

				char *term;
				term=values[i];

				if( calc[i+1]%100 == CALC_AS ){
					// AsZq̉EӒl
					//^
					if( compiler.StringToType( term, resultType ) ){
						resultType.SetBasicType( resultType.GetBasicType() | FLAG_CAST );
					}
					else{
						compiler.errorMessenger.Output(3, term, cp );
						goto error;
					}

					type_stack[sp] = resultType.GetBasicType();
					index_stack[sp] = resultType.GetIndex();
					sp++;

					break;
				}

				if( (term[0]=='e'||term[0]=='E')
					&& (term[1]=='x'||term[1]=='X')
					&& term[2]=='\"'
					|| term[0] == '\"' )
				{
					bool isEx = true;
					if( term[0] == '\"' )
					{
						isEx = false;
					}

					if( isEx )
					{
						// gŃeiGXP[vV[PX\j
						if(!RemoveStringQuotes(term+2)){
							compiler.errorMessenger.Output(43,NULL,cp);
							goto error;
						}
						i3=FormatString_EscapeSequence(term+2);
						term+=2;
					}
					else
					{
						// ʏ핶
						if(!RemoveStringQuotes(term)){
							compiler.errorMessenger.Output(43,NULL,cp);
							goto error;
						}
						i3=lstrlen(term);
					}

					if( !baseType.IsPointer() )
					{
						//v^CvIuWFNgA܂͖̂Ƃ

						//String^IuWFNg𐶐
						i2 = ActiveBasic::Compiler::DataTableGenerator::MakeConstStringObjectToProcessStaticBuffer( compiler.GetObjectModule().dataTable, term );

						//mov reg,i2
						compiler.codeGenerator.op_mov_RV(sizeof(_int64),UseReg,i2, Schedule::DataTable);

						type_stack[sp]=DEF_OBJECT;
						index_stack[sp]=(LONG_PTR)compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr();
						bLiteralCalculation=0;

						if(bXmm) pobj_reg->LockXmmReg();
						else pobj_reg->LockReg();

						sp++;
						break;
					}

StrLiteral:

					type_stack[sp]=typeOfPtrChar;
					bLiteralCalculation=0;

					if( compiler.IsUnicode() )
					{
						i2 = compiler.GetObjectModule().dataTable.AddWString( Jenga::Common::ToWString( std::string( term, i3 ) ) );
					}
					else
					{
						i2 = compiler.GetObjectModule().dataTable.AddString( std::string( term, i3 ) );
					}

					//mov reg,i2
					compiler.codeGenerator.op_mov_RV(sizeof(_int64),UseReg,i2, Schedule::DataTable);

					if(UseReg==REG_R14){
						//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
						pobj_sf->push(REG_R14);
					}
				}
				else if(IsVariableTopChar(term[0])||
					term[0]=='*'||
					(term[0]=='.'&&IsVariableTopChar(term[1])))
				{
					//////////////////
					// 炩̎ʎq

					bool isLiteral;
					if( TermOpe( term, baseType, resultType, isLiteral, isNeedHeapFreeStructureStack[sp] ) ){
						if(resultType.IsNull()){
							//߂l݂ȂƂ
							for(i2=0;;i2++){
								if(term[i2]=='('||term[i2]=='\0'){
									term[i2]=0;
									break;
								}
							}
							compiler.errorMessenger.Output(38,term,cp);

							goto error;
						}

						type_stack[sp] = resultType.GetBasicType();
						index_stack[sp] = resultType.GetIndex();

						if( !isLiteral ){
							bLiteralCalculation=0;
						}

						if( resultType.GetBasicType() & FLAG_CAST ){
							// ^̂
							compiler.errorMessenger.OutputFatalError();
						}
						else{
							if( resultType.IsReal() == false && UseReg==REG_R14 ){
								//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
								pobj_sf->push(REG_R14);
							}
							if( resultType.IsReal() && XmmReg==REG_XMM4 ){
								if(resultType.IsDouble()){
									//movsd qword ptr[rsp+offset],xmm4	X^bNt[𗘗p
									pobj_sf->push(REG_XMM4,sizeof(double));
								}
								if(resultType.IsSingle()){
									//movss dword ptr[rsp+offset],xmm4	X^bNt[𗘗p
									pobj_sf->push(REG_XMM4,sizeof(float));
								}
							}

							if( resultType.IsReal() ){
								pobj_reg->LockXmmReg();
							}
							else{
								pobj_reg->LockReg();
							}
						}

						sp++;
						break;
					}


					// Nothing
					if( lstrcmp( term, "Nothing" ) == 0 ){
						isNothing_stack[sp] = true;

						type_stack[sp] = DEF_OBJECT;
						if( baseType.IsObject() ){
							index_stack[sp] = baseType.GetIndex();
						}
						else{
							index_stack[sp] = (LONG_PTR)compiler.GetObjectModule().meta.GetClasses().GetObjectClassPtr();
						}

						bLiteralCalculation = 0;

						//xor reg,reg
						compiler.codeGenerator.op_zero_reg( UseReg );

						if(UseReg==REG_R14){
							//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
							pobj_sf->push(REG_R14);
						}

						pobj_reg->LockReg();
						sp++;
						break;
					}


					//////////////
					// 萔̏ꍇ
					//////////////

					i3 = compiler.GetObjectModule().meta.GetGlobalConsts().GetBasicType(
						ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( term )
					);
					if(i3){
						if( compiler.GetObjectModule().meta.GetGlobalConsts().IsStringPtr( ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( term ), compiler.IsUnicode() ) ){
							//e

							if( baseType.IsObject() || baseType.IsNull() )
							{
								//v^CvIuWFNgA܂͖̂Ƃ

								//String^IuWFNg𐶐
								NewStringObject(UseReg,term);

								type_stack[sp]=DEF_OBJECT;
								index_stack[sp]=(LONG_PTR)compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr();
								bLiteralCalculation=0;

								if(bXmm) pobj_reg->LockXmmReg();
								else pobj_reg->LockReg();

								sp++;
								break;
							}

							double dbl = compiler.GetObjectModule().meta.GetGlobalConsts().GetDoubleData(
								ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( term )
							);
							memcpy(&i64data,&dbl,sizeof(double));

							//oCg
							i3=lstrlen((char *)i64data);

							memcpy(term,(char *)i64data,i3);
							term[i3]=0;
							goto StrLiteral;
						}

						type_stack[sp] = i3;
						if(IsRealNumberType(i3)){
							//
							double dbl = compiler.GetObjectModule().meta.GetGlobalConsts().GetDoubleData(
								ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( term )
							);
							memcpy(&i64data,&dbl,sizeof(double));
							goto Literal;
						}
						else if(IsWholeNumberType(i3)){
							//
							i64data = compiler.GetObjectModule().meta.GetGlobalConsts().GetWholeData(
								ActiveBasic::Compiler::LexicalAnalyzer::FullNameToSymbol( term )
							);
							goto Literal;
						}
						else{
							compiler.errorMessenger.Output(1,NULL,0);
							goto error;
						}
					}


					//Y鎯ʎqȂƂ̓G[ɂ
					bError=1;
					compiler.errorMessenger.Output(3,term,cp);
					type_stack[sp]=DEF_DOUBLE;
				}
				else{
					//el
					type_stack[sp]=GetLiteralValue(term,&i64data,baseType.GetBasicType());
Literal:
					if(type_stack[sp]==DEF_DOUBLE){
						//64rbg^
						bXmm=1;

						if(XmmReg==REG_XMM4){
							//mov r14,i64data
							compiler.codeGenerator.op_mov_RV64(REG_R14,i64data);


							//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
							pobj_sf->push(REG_R14);
						}
						else{
							i3 = compiler.GetObjectModule().dataTable.Add( i64data );

							//movlpd xmm_reg,qword ptr[data table offset]
							compiler.codeGenerator.op_movlpd_RM( XmmReg, 0, i3, MOD_DISP32, Schedule::DataTable );
						}
					}
					else if(type_stack[sp]==DEF_SINGLE){
						//32rbg^
						bXmm=1;

						float flt;
						int i32data;
						memcpy(&dbl,&i64data,sizeof(double));
						flt=(float)dbl;
						memcpy(&i32data,&flt,sizeof(long));

						if(XmmReg==REG_XMM4){
							compiler.errorMessenger.OutputFatalError();		// TODO: 
							//push term
							//compiler.codeGenerator.op_push_value(i32data);
						}
						else{
							i3=compiler.GetObjectModule().dataTable.Add( i32data );

							//movss xmm_reg,dword ptr[data table offset]
							compiler.codeGenerator.op_movss_RM( XmmReg, 0, i3, MOD_DISP32, Schedule::DataTable );
						}
					}
					else{
						//

						index_stack[sp]=GetLiteralIndex(i64data);

						//mov reg,i64data
						compiler.codeGenerator.op_mov_RV64(UseReg,i64data);

						if(UseReg==REG_R14){
							//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
							pobj_sf->push(REG_R14);
						}
					}
				}

				if(bXmm) pobj_reg->LockXmmReg();
				else pobj_reg->LockReg();

				sp++;
				break;

			//_Zq
			case CALC_XOR:
			case CALC_OR:
			case CALC_AND:
				if(!CalcTwoTerm_Logical(idCalc,type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_NOT:
				//value[sp-1]=Not value[sp-1]
				//NOTZq
				if(!Calc_Not(type_stack,sp)) goto error;
				break;

			//rZq
			case CALC_PE:		//value[sp-2] <= value[sp-1]
			case CALC_QE:		//value[sp-2] >= value[sp-1]
			case CALC_P:		//value[sp-2] <  value[sp-1]
			case CALC_Q:		//value[sp-2] >  value[sp-1]
			case CALC_NOTEQUAL:	//value[sp-2] <> value[sp-1]
			case CALC_EQUAL:	//value[sp-2] =  value[sp-1]				
				if(!CalcTwoTerm_Relational(idCalc,type_stack,index_stack,&sp)) goto error;
				break;

			//rbgVtg
			case CALC_SHL:	//value[sp-2] << value[sp-1]
			case CALC_SHR:	//value[sp-2] >> value[sp-1]
				if(!Calc_Shift(idCalc,type_stack,&sp)) goto error;
				break;

			//ZpZ
			case CALC_ADDITION:
			case CALC_SUBTRACTION:
			case CALC_PRODUCT:
				if(!CalcTwoTerm_Arithmetic(idCalc,type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_MOD:
				//value[sp-2]%=value[sp-1]
				//]Z
				if(!Calc_Mod(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_QUOTIENT:
				//value[sp-2]/=value[sp-1];
				//Z
				if(!Calc_Divide(type_stack,&sp,baseType.GetBasicType())) goto error;
				break;
			case CALC_INTQUOTIENT:
				//value[sp-2]/=value[sp-1]
				//Z
				if(!Calc_IntDivide(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_MINUSMARK:
				//value[sp-1]=-value[sp-1]
				//]
				if(!Calc_MinusMark(type_stack,sp)) goto error;
				break;
			case CALC_POWER:
				//ׂ扉Zi_Ẑ݁j
				if(!Calc_Power(type_stack,&sp)) goto error;
				break;
			case CALC_AS:
				//LXg
				if(!Calc_Cast(type_stack,index_stack,&sp)) goto error;
				break;
			case CALC_BYVAL:
				//|C^^Qƌ^
				if( PTR_LEVEL( type_stack[sp-1] ) <= 0 ){
					//|C^^ł͂ȂƂ
					compiler.errorMessenger.Output( 3, NULL, cp );
					goto error;
				}

				type_stack[sp-1] = PTR_LEVEL_DOWN( type_stack[sp-1] );

				break;

			default:
				compiler.errorMessenger.Output(300,NULL,cp);
				goto error;
		}
	}

	if(bError) goto error;

	if(sp!=1){
		compiler.errorMessenger.Output(1,NULL,cp);
		goto error;
	}

	if(bLiteralCalculation){
		compiler.errorMessenger.OutputFatalError();
	}
	else{
		//EӒll̒萔ł͂ȂƂ
		if(IS_LITERAL(index_stack[0])) index_stack[0]=-1;
	}

	if( pbIsNeedHeapFreeStructure )
	{
		*pbIsNeedHeapFreeStructure = isNeedHeapFreeStructureStack[0];
	}

	if(IsRealNumberType(type_stack[0]))
		*pReg=pobj_reg->UnlockXmmReg();
	else
		*pReg=pobj_reg->UnlockReg();


	resultType.SetType( type_stack[0], index_stack[0] );

	bool isSuccessful = true;
	goto finish;



	//////////////////
	// G[
	//////////////////

error:

	isSuccessful = false;
	goto finish;




finish:

	for(i=0;i<pnum;i++){
		if(values[i]) HeapDefaultFree(values[i]);
	}

	return isSuccessful;
}

bool NumOpe( int *pReg,
			const char *expression,
			const Type &baseType,
			Type &resultType,
			bool *pbIsNeedHeapFreeStructure )
{
	bool isInitRegSwitch = false;
	if( !pobj_reg )
	{
		isInitRegSwitch = true;

		//ƗpWX^擾
		pobj_reg = new CRegister( *pReg );
	}

	//G[̕p
	CRegister objReg_Backup = *pobj_reg;

	*pReg = pobj_reg->GetNextReg();


	bool result = _numope( pReg, expression, baseType, resultType, pbIsNeedHeapFreeStructure );


	if( !result )
	{
		*pobj_reg = objReg_Backup;
	}

	if( isInitRegSwitch ){
		//`FbNioOj
		if( result )
		{
			pobj_reg->bug_check();
		}

		//ƃWX^
		delete pobj_reg;
		pobj_reg = NULL;
	}

	return result;
}
