#include "stdafx.h"

TypeDef::TypeDef( const NamespaceScopes &namespaceScopes, const std::string &name, const std::string &baseName, const Type &baseType )
	: Symbol( namespaceScopes, name )
	, baseName( baseName )
	, baseType( baseType )
{
}

TypeDefCollection::TypeDefCollection(){
}
TypeDefCollection::~TypeDefCollection(){
}
void TypeDefCollection::Add( const NamespaceScopes &namespaceScopes, const std::string &name, const std::string &baseName, int nowLine ){
	TypeDef typeDef( namespaceScopes, name, baseName, nowLine );
	this->push_back( typeDef );
}

int TypeDefCollection::GetIndex( const Symbol &symbol ) const{
	int max = (int)(*this).size();
	for( int i=0; i<max; i++ ){
		if( (*this)[i].IsEqualSymbol( symbol ) ){
			return i;
		}
	}
	return -1;
}
