#include "stdafx.h"

TypeDef::TypeDef( const NamespaceScopes &namespaceScopes, const std::string &name, const std::string &baseName, const Type &baseType )
	: Symbol( namespaceScopes, name )
	, baseName( baseName )
	, baseType( baseType )
{
}

TypeDefCollection::TypeDefCollection(){
}
TypeDefCollection::~TypeDefCollection(){
}
void TypeDefCollection::Add( const NamespaceScopes &namespaceScopes, const std::string &name, const std::string &baseName, int nowLine ){
	TypeDef typeDef( namespaceScopes, name, baseName, nowLine );
	this->push_back( typeDef );
}

int TypeDefCollection::GetIndex( const NamespaceScopes &namespaceScopes, const std::string &name ) const{
	int max = (int)(*this).size();
	for( int i=0; i<max; i++ ){
		if( (*this)[i].IsEqualSymbol( namespaceScopes, name ) ){
			return i;
		}
	}
	return -1;
}
int TypeDefCollection::GetIndex( const std::string &fullName ) const{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), AreaName, NestName );

	return GetIndex( NamespaceScopes( AreaName ), NestName );
}
