#include "stdafx.h"

using namespace ActiveBasic::Compiler;

int DataTableGenerator::lastMadeConstObjectDataTableOffset = 0;

bool DataTableGenerator::MakeConstObjectToProcessStaticBuffer( DataTable &dataTable, const CClass &objClass, const Jenga::Common::Strings &initMemberValues, int &dataTableOffset )
{
	// NXɕKvȃobt@TCY擾
	int size = objClass.GetSize();

	// NX̃obt@C[W쐬
	BYTE *buffer = (BYTE *)calloc( size, 1 );

	// NX̃obt@C[Wf[^̈֒ǉ
	dataTableOffset = dataTable.AddBinary( buffer, size );

	DataTableGenerator::lastMadeConstObjectDataTableOffset = dataTableOffset;

	// com_vtblXPW[
	dataTable.schedules.push_back( Schedule( Schedule::ComVtbl, &objClass, dataTableOffset ) );

	// vtblXPW[
	dataTable.schedules.push_back( Schedule( Schedule::Vtbl, &objClass, dataTableOffset + PTR_SIZE ) );

	// TypeInfoXPW[
	int offsetForTypeInfo = objClass.GetMemberOffset( "_system_object_member_typeInfo" );
	//dataTable.schedules.push_back( Schedule( Schedule::TypeInfo, &objClass, dataTableOffset + offsetForTypeInfo ) );

	BOOST_FOREACH( const std::string &initMemberValue, initMemberValues )
	{
		int i = 0;

		// o
		char memberName[VN_SIZE];
		for( i=0; ; i++ )
		{
			if( initMemberValue[i] == '\0' )
			{
				// G[
				compiler.errorMessenger.OutputFatalError();
				return false;
			}
			if( initMemberValue[i] == '=' )
			{
				memberName[i] = 0;
				break;
			}
			memberName[i] = initMemberValue[i];
		}

		// l
		const char *initValue = initMemberValue.c_str() + i + 1;

		// o擾
		const Member *member = objClass.FindDynamicMember( memberName );

		// oItZbg擾
		int memberOffset = objClass.GetMemberOffset( member->GetName().c_str() );

		if( member->GetType().IsPointer() && initValue[0] == '[' )
		{
			// |C^^Ńobt@ŵƂ
			int memberDataTableOffset;
			if( !MakeLiteralArrayBuffer( dataTable, initValue, member->GetType(),memberDataTableOffset ) )
			{
				return false;
			}

			dataTable.Overwrite( dataTableOffset + memberOffset, memberDataTableOffset );
			dataTable.schedules.push_back( Schedule( Schedule::DataTable, dataTableOffset + memberOffset ) );
		}
		else if( member->GetType().IsWhole() )
		{
			// 
			Type resultType;
			_int64 i64data;
			if( !StaticCalculation( true, initValue, member->GetType().GetBasicType(), &i64data, resultType ) ){
				return false;
			}

			dataTable.Overwrite( dataTableOffset + memberOffset, static_cast<long>(i64data) );
		}
		else if( member->GetType().IsStringClass() )
		{
			// ^
			char temporary[VN_SIZE];
			lstrcpy( temporary, initValue );
			RemoveStringQuotes( temporary );
			int memberDataTableOffset = MakeConstStringObjectToProcessStaticBuffer( dataTable, temporary );
			dataTable.Overwrite( dataTableOffset + memberOffset, memberDataTableOffset );
			dataTable.schedules.push_back( Schedule( Schedule::DataTable, dataTableOffset + memberOffset ) );
		}
	}

	return true;
}
bool DataTableGenerator::MakeConstObjectToProcessStaticBuffer( DataTable &dataTable, const char *expression, Type &resultType, int &dataTableOffset )
{
	char CreateParameter[VN_SIZE];
	int i,i2;

	i=0;

	// NX擾
	char typeName[VN_SIZE];
	for(i2=0;;i++,i2++){
		if(expression[i]=='['){
			typeName[i2]=0;

			// ȍl擾
			i2=GetStringInBracket(CreateParameter,expression+i);
			RemoveStringBracket(CreateParameter);
			i+=i2;
			if(expression[i]!='\0'){
				compiler.errorMessenger.Output(42,NULL,cp);
				return false;
			}
			break;
		}
		typeName[i2]=expression[i];
		if(expression[i]=='\0'){
			CreateParameter[0]=0;
			break;
		}
	}

	// p[^擾
	Jenga::Common::Strings initMemberValues;
	SplitParameter( CreateParameter, initMemberValues );

	if( !compiler.StringToType( typeName, resultType ) ){
		compiler.errorMessenger.Output(3,typeName,cp);
		return false;
	}

	if( !resultType.IsObject() ){
		////////////////////////
		// ʏ̃f[^^̏ꍇ
		////////////////////////

		compiler.errorMessenger.Output(121,NULL,cp);
		return false;
	}

	return MakeConstObjectToProcessStaticBuffer( dataTable, resultType.GetClass(), initMemberValues, dataTableOffset );
}

int DataTableGenerator::MakeConstStringObjectToProcessStaticBuffer( DataTable &dataTable, const char *str )
{
	const CClass &strClass = *compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr();
	const CClass &objClass = strClass.GetSuperClass();

	// NXɕKvȃobt@TCY擾
	int size = strClass.GetSize();

	// oʒu擾
	int offsetForTypeInfo = strClass.GetMemberOffset( "_system_object_member_typeInfo" );
	int offsetForLength = strClass.GetMemberOffset( "m_Length" );
	int offsetForChars = strClass.GetMemberOffset( "Chars" );

	// ݂̃f[^̈̃wb_ʒu擾
	int headOffset = dataTable.GetSize();

	// NX̃obt@C[W쐬
	BYTE *buffer = (BYTE *)calloc( size, 1 );
	*(long *)(buffer + offsetForLength) = lstrlen( str );
	*(LONG_PTR *)(buffer + offsetForChars) = headOffset + size;

	// NX̃obt@C[Wf[^̈֒ǉ
	int dataTableOffset = dataTable.AddBinary( buffer, size );

	// XPW[O
	dataTable.schedules.push_back( Schedule( Schedule::ComVtbl, &strClass, headOffset ) );
	dataTable.schedules.push_back( Schedule( Schedule::Vtbl, &strClass, headOffset + PTR_SIZE ) );
	dataTable.schedules.push_back( Schedule( Schedule::TypeInfo, &strClass, headOffset + offsetForTypeInfo ) );
	dataTable.schedules.push_back( Schedule( Schedule::DataTable, headOffset + offsetForChars ) );

	// obt@f[^̈֒ǉ
	if( compiler.IsUnicode() )
	{
		dataTable.AddWString( Jenga::Common::ToWString( str ) );
	}
	else
	{
		dataTable.AddString( str );
	}

	return dataTableOffset;
}

bool DataTableGenerator::MakeLiteralArrayBuffer( DataTable &dataTable, const char *expression, const Type &baseType, int &dataTableOffset )
{
	if( !baseType.IsPointer() ){
		compiler.errorMessenger.Output(1,NULL,cp);
		return false;
	}
	Type tempBaseType( baseType );
	tempBaseType.PtrLevelDown();

	char *buffer = (char *)malloc( lstrlen( expression ) + 1 );
	lstrcpy( buffer, expression );
	RemoveStringBracket( buffer );

	Jenga::Common::Strings parameters;
	SplitParameter( buffer, parameters );

	// ACg
	dataTable.AddAlignment( tempBaseType.GetSize() );

	// f[^e[uɋԂm
	dataTableOffset = dataTable.AddSpace( static_cast<int>(tempBaseType.GetSize() * parameters.size()) );

	bool isSuccessful = true;
	int i = 0;
	BOOST_FOREACH( const std::string &paramStr, parameters )
	{
		if( paramStr.size() == 0 )
		{
			throw;
		}
		if( paramStr[0] == '\"' )
		{
			// 
			std::string tempParamStr = paramStr;
			if( !RemoveStringQuotes( tempParamStr ) )
			{
				compiler.errorMessenger.OutputFatalError();
			}

			// ǉ
			_int64 strOffset;
			if( tempBaseType.IsStringClass() )
			{
				// StringNX
				strOffset = MakeConstStringObjectToProcessStaticBuffer( dataTable, tempParamStr.c_str() );
			}
			else
			{
				// Char|C^
				if( compiler.IsUnicode() )
				{
					strOffset = dataTable.AddWString( Jenga::Common::ToWString( tempParamStr ) );
				}
				else
				{
					strOffset = dataTable.AddString( tempParamStr );
				}
			}

			// |C^l㏑
			int tempOffset = dataTableOffset + i * tempBaseType.GetSize();
			dataTable.OverwriteBinary( tempOffset, &strOffset, tempBaseType.GetSize() );

			// DataTableXPW[
			dataTable.schedules.push_back( Schedule( Schedule::DataTable, tempOffset  ) );
		}
		else
		{
			// l
			Type resultType;
			_int64 i64data;
			if( !StaticCalculation( true, paramStr.c_str(), tempBaseType.GetBasicType(), &i64data, resultType ) ){
				isSuccessful = false;
				break;
			}
			if( !resultType.IsWhole() ){
				// TODO: ɖΉ
				compiler.errorMessenger.OutputFatalError();
				isSuccessful = false;
				break;
			}

			// ㏑
			dataTable.OverwriteBinary( dataTableOffset + i * tempBaseType.GetSize(), &i64data, tempBaseType.GetSize() );
		}

		i++;
	}

	free( buffer );

	return isSuccessful;
}
