#include "stdafx.h"

bool Jenga::Common::IsExistString( const Jenga::Common::Strings &strings, const std::string &findStr )
{
	BOOST_FOREACH( const std::string &str, strings )
	{
		if( str == findStr )
		{
			return true;
		}
	}
	return false;
}

std::string& Jenga::Common::StringReplace( std::string& str, const std::string sb, const std::string sa )
{
	std::string::size_type n, nb = 0;
	
	while ((n = str.find(sb,nb)) != std::string::npos)
	{
		str.replace(n,sb.size(),sa);
		nb = n + sa.size();
	}
	
	return str;
}

std::wstring Jenga::Common::ToWString( const std::string &str )
{
	int size = MultiByteToWideChar(
		CP_ACP,
		0,
		str.c_str(), static_cast<int>(str.size()) + 1,
		NULL, 0 ) * 2;

	LPWSTR pwstr = (LPWSTR)malloc( size );

	MultiByteToWideChar(
		CP_ACP,
		0,
		str.c_str(), static_cast<int>(str.size()) + 1,
		pwstr, static_cast<int>(str.size()) + 1 );

	std::wstring wstr( pwstr, str.size() );

	free( pwstr );

	return wstr;
}
