#include "stdafx.h"

int DataTable::AddBinary( const void *buffer, int size ){
	int retSize = this->size;

	Realloc( this->size + size );
	memcpy( (char *)this->buffer + retSize, buffer, size );

	return retSize;
}
int DataTable::Add( _int64 i64data ){
	int retSize = size;
	AddBinary( &i64data, sizeof( _int64 ) );
	return retSize;
}
int DataTable::Add( int i32data ){
	int retSize = size;
	AddBinary( &i32data, sizeof( int ) );
	return retSize;
}
int DataTable::Add( double dbl ){
	int retSize = size;
	AddBinary( &dbl, sizeof( double ) );
	return retSize;
}
int DataTable::Add( float flt ){
	int retSize = size;
	AddBinary( &flt, sizeof( float ) );
	return retSize;
}
int DataTable::AddString( const char *str, int length ){
	int retSize = size;

	if( compiler.IsUnicode() ){
		//Shift-JIS  Unicode
		int size = MultiByteToWideChar(
			CP_ACP,
			0,
			str, length + 1,
			NULL, 0 ) * 2;

		LPWSTR pwstr = (LPWSTR)malloc( size );

		MultiByteToWideChar(
			CP_ACP,
			0,
			str, length + 1,
			pwstr, length + 1 );

		AddBinary( pwstr, size );

		free( pwstr );
	}
	else{
		AddBinary( str, length + 1 );
	}

	return retSize;
}
int DataTable::AddString( const char *str )
{
	return AddString( str, lstrlen( str ) );
}
int DataTable::AddString( const std::string &str )
{
	return AddString( str.c_str(), static_cast<int>(str.length()) );
}
int DataTable::AddSpace( int size )
{
	int retSize = this->size;
	Realloc( this->size + size );
	return retSize;
}
void DataTable::AddAlignment( int size )
{
	if( this->size % size == 0 )
	{
		// ɋÊƂ
		return;
	}
	Realloc( this->size + ( size - (int)(this->size%size) ) );
}

void DataTable::ResetDataSectionBaseOffset( long dataSectionBaseOffset )
{
	BOOST_FOREACH( const Schedule &schedule, schedules )
	{
		if( schedule.GetType() == Schedule::DataTable )
		{
#ifdef _WIN64
			OverwriteInt64(
				schedule.GetOffset(),
				GetInt64( schedule.GetOffset() ) + dataSectionBaseOffset
			);
#else
			Overwrite(
				schedule.GetOffset(),
				GetLong( schedule.GetOffset() ) + dataSectionBaseOffset
			);
#endif
		}
	}
}
