#include "stdafx.h"

using namespace ActiveBasic::Compiler;

int VtblGenerator::GenerateVTablePart( const Methods &methods )
{
	const UserProc **ppsi = (const UserProc **)malloc(methods.GetVtblNum()*sizeof(UserProc *));

	//֐e[uɒlZbg
	int i2 = 0;
	BOOST_FOREACH( const CMethod *pMethod, methods )
	{
		if(pMethod->IsVirtual()){
			if( !pMethod->GetUserProc().IsUsing() )
			{
				//ts((char *)pMethod->GetUserProc().GetFullName().c_str());
			}
			pMethod->GetUserProc().Using();

			if(pMethod->IsAbstract())
			{
				throw;
			}

			ppsi[i2]=&pMethod->GetUserProc();

			i2++;
		}
	}

	int vtableDataTableOffset = compiler.GetObjectModule().nativeSection.dataTable.AddBinary( (void *)ppsi, methods.GetVtblNum()*sizeof(LONG_PTR) );

	for( int i=0; i < methods.GetVtblNum(); i++ )
	{
		pobj_Reloc->AddSchedule_DataSection(static_cast<DWORD>(vtableDataTableOffset+i*sizeof(LONG_PTR)));
	}

	free(ppsi);

	return vtableDataTableOffset;
}

void VtblGenerator::GenerateFullVTables( CClass &_class )
{
	if( _class.IsAbstract() )
	{
		// ۃNX͖
		return;
	}
	if( !_class.IsUsing() )
	{
		// gĂȂNX͖
		return;
	}

	// vtbl}X^[Xǧf[^ɕsvȃf[^܂܂ĂG[
	if( _class.vtblMasterList.size() )
	{
		throw;
	}

	// g̃NXvtbl𐶐
	int thisClassVtblOffset = GenerateVTablePart( _class.GetDynamicMethods() );
	_class.SetVtblOffset( thisClassVtblOffset );
	_class.vtblMasterList.push_back( thisClassVtblOffset );

	// C^[tFCXvtbl𐶐
	BOOST_FOREACH( const ::Interface *pInterface, _class.GetInterfaces() )
	{
		int tempVtblOffset = GenerateVTablePart( pInterface->GetDynamicMethods() );
		_class.vtblMasterList.push_back( tempVtblOffset );

		pInterface->SetVtblOffset( tempVtblOffset );

		if( pInterface->GetClass().IsComInterface() )
		{
			if( _class.GetComVtblOffset() )
			{
				throw;
			}
			_class.SetComVtblOffset( tempVtblOffset );
		}
	}

	// vtbl}X^[Xg𐶐
	int offset = compiler.GetObjectModule().nativeSection.dataTable.AddBinary(
		(void *)&_class.vtblMasterList[0],
		static_cast<int>(_class.vtblMasterList.size()*sizeof(LONG_PTR))
	);
	_class.SetVtblMasterListOffset( offset );
}

void VtblGenerator::GenerateVTablesForAllClasses( Classes &classes )
{
	classes.Iterator_Reset();
	while( classes.Iterator_HasNext() )
	{
		GenerateFullVTables( *classes.Iterator_GetNext() );
	}
}

void VtblGenerator::ActionVtblSchedule( CClass &_class, LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection, LONG_PTR MemPos_DataSection )
{
	if( _class.IsAbstract() )
	{
		// ۃNX͖
		return;
	}
	if( !_class.IsUsing() )
	{
		// gĂȂNX͖
		return;
	}
	if( _class.GetVtblOffset() == -1 )
	{
		return;
	}

	// g̃NXvtbl
	{
		LONG_PTR *pVtbl = (LONG_PTR *)((char *)compiler.GetObjectModule().nativeSection.dataTable.GetPtr() + _class.GetVtblOffset());

		for( int i=0; i<_class.GetVtblNum(); i++ ){
			const UserProc *pUserProc = (UserProc *)pVtbl[i];
			if(!pUserProc) continue;

			if( pUserProc->GetBeginOpAddress() == 0
				&& pUserProc->GetEndOpAddress() == 0 )
			{
				Jenga::Throw( "̉z֐݂" );
			}

			pVtbl[i] = pUserProc->GetBeginOpAddress() + ImageBase + MemPos_CodeSection;
		}
	}

	// C^[tFCXvtbl
	BOOST_FOREACH( const ::Interface *pInterface, _class.GetInterfaces() )
	{
		LONG_PTR *pVtbl = (LONG_PTR *)((char *)compiler.GetObjectModule().nativeSection.dataTable.GetPtr() + pInterface->GetVtblOffset());

		for( int i=0; i<pInterface->GetClass().GetVtblNum(); i++ ){
			const UserProc *pUserProc = (UserProc *)pVtbl[i];
			if(!pUserProc) continue;

			if( pUserProc->GetBeginOpAddress() == 0
				&& pUserProc->GetEndOpAddress() == 0 )
			{
				Jenga::Throw( "̉z֐݂" );
			}

			pVtbl[i] = pUserProc->GetBeginOpAddress() + ImageBase + MemPos_CodeSection;
		}
	}

	// vtbl}X^[Xg
	LONG_PTR *pVtblMasterList = (LONG_PTR *)((char *)compiler.GetObjectModule().nativeSection.dataTable.GetPtr() + _class.GetVtblMasterListOffset() );
	for( int i=0; i<static_cast<int>(_class.vtblMasterList.size()); i++ )
	{
		pVtblMasterList[i] = _class.vtblMasterList[i] + ImageBase + MemPos_DataSection;
	}
}

void VtblGenerator::ActionVtblScheduleForAllClasses( Classes &classes, LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection, LONG_PTR MemPos_DataSection )
{
	classes.Iterator_Reset();
	while( classes.Iterator_HasNext() )
	{
		ActionVtblSchedule( *classes.Iterator_GetNext(), ImageBase, MemPos_CodeSection, MemPos_DataSection );
	}
}
