#pragma once

//萔
class CConst : public Symbol, public Jenga::Common::ObjectInHashmap<CConst>
{
	Type type;
	_int64 i64data;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - CConst" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Symbol );
		ar & BOOST_SERIALIZATION_NVP( type );
		ar & BOOST_SERIALIZATION_NVP( i64data );
	}

public:
	CConst( const NamespaceScopes &namespaceScopes, const std::string &name, const Type &newType, _int64 i64data)
		: Symbol( namespaceScopes, name )
		, type( newType )
		, i64data( i64data )
	{
	}
	CConst( const NamespaceScopes &namespaceScopes, const std::string &name, int value)
		: Symbol( namespaceScopes, name )
		, type( Type(DEF_LONG) )
		, i64data( value )
	{
	}
	CConst()
	{
	}
	~CConst()
	{
	}

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}

	Type GetType()
	{
		return type;
	}
	_int64 GetWholeData()
	{
		return i64data;
	}
	double GetDoubleData();
};
class Consts : public Jenga::Common::Hashmap<CConst>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Consts" );

		ar & boost::serialization::make_nvp("Hashmap_CConst",
			boost::serialization::base_object<Jenga::Common::Hashmap<CConst>>(*this));
	}

public:

	void Add( const NamespaceScopes &namespaceScopes, const std::string &name, const char *Expression);
	void Add( const NamespaceScopes &namespaceScopes, const std::string &name, int value);

private:
	CConst *GetObjectPtr( const Symbol &symbol );
public:

	int GetBasicType( const Symbol &symbol );
	_int64 GetWholeData( const Symbol &symbol );
	double GetDoubleData( const Symbol &symbol );
	bool IsStringPtr( const Symbol &symbol );
};

//萔}N
class ConstMacro : public Symbol, public Jenga::Common::ObjectInHashmap<ConstMacro>
{
	std::vector<std::string> parameters;
	std::string expression;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - ConstMacro" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Symbol );
		ar & BOOST_SERIALIZATION_NVP( parameters );
		ar & BOOST_SERIALIZATION_NVP( expression );
	}

public:
	ConstMacro( const NamespaceScopes &namespaceScopes, const std::string &name, const std::vector<std::string> &parameters, const std::string &expression )
		: Symbol( namespaceScopes, name )
		, parameters( parameters )
		, expression( expression )
	{
	}
	ConstMacro()
	{
	}
	~ConstMacro()
	{
	}

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}

	const std::vector<std::string> &GetParameters() const
	{
		return parameters;
	}
	const std::string &GetExpression() const
	{
		return expression;
	}
};
class ConstMacros : public Jenga::Common::Hashmap<ConstMacro>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - ConstMacros" );

		ar & boost::serialization::make_nvp("Hashmap_ConstMacro",
			boost::serialization::base_object<Jenga::Common::Hashmap<ConstMacro>>(*this));
	}

public:
	bool Add( const NamespaceScopes &namespaceScopes, const std::string &name, const char *parameterStr );
	ConstMacro *Find( const Symbol &name );
};
