#include "stdafx.h"

#include <Compiler.h>
#include <Procedure.h>

#include "../common.h"
#ifdef _AMD64_
#include "../../compiler_x64/opcode.h"
#else
#include "../../compiler_x86/opcode.h"
#endif

using namespace ActiveBasic::Compiler;


bool UserProc::IsEqualForOverride( const Types &actualTypeParametersForThisProc, const UserProc *pUserProc ) const
{
	if( this->GetName() == pUserProc->GetName()						// OԋyіO
		&& this->Params().Equals( actualTypeParametersForThisProc, pUserProc->Params() ) )			// p[^
	{
		if( this->returnType.Equals( pUserProc->returnType ) )
		{
			// ߂l
			return true;
		}
		else if( this->returnType.IsCovariant( pUserProc->returnType ) )
		{
			// ߂l
			return true;
		}
		else if( this->returnType.IsTypeParameter() )
		{
			// ^p[^Ƃ

			if( actualTypeParametersForThisProc[this->returnType.GetFormalTypeIndex()].Equals( pUserProc->returnType ) )
			{
				// ߂l
				return true;
			}
			else if( actualTypeParametersForThisProc[this->returnType.GetFormalTypeIndex()].IsCovariant( pUserProc->returnType ) )
			{
				// ߂l
				return true;
			}
		}
	}
	return false;
}
	

std::string UserProc::GetFullName() const
{
	if( HasParentClass() ){
		return GetParentClass().GetName() + "." + GetName();
	}

	return GetName();
}
bool UserProc::IsCastOperator() const
{
	if( GetName()[0] == 1 && GetName()[1] == ESC_OPERATOR && GetName()[2] == CALC_AS )
	{
		return true;
	}
	return false;
}
const NamespaceScopes &UserProc::GetNamespaceScopes() const
{
	if( HasParentClass() ){
		return GetParentClassPtr()->GetNamespaceScopes();
	}
	return Symbol::GetNamespaceScopes();
}
const NamespaceScopesCollection &UserProc::GetImportedNamespaces() const
{
	if( pParentClass )
	{
		return pParentClass->GetImportedNamespaces();
	}
	return importedNamespaces;
}
bool UserProc::IsVirtual() const
{
	if( pMethod == NULL ){
		return false;
	}
	return ( pMethod->IsVirtual() != 0 );
}
const CMethod &UserProc::GetMethod() const
{
	if( !HasParentClass() )
	{
		Jenga::Throw( "O[o֐ɑ΂UserProc::GetMethod\bhĂ΂ꂽ" );
	}
	return *pMethod;
}

const UserProc *UserProc::pGlobalProc = NULL;


void UserProcs::EnumGlobalProcs( const char *simpleName, const char *localName, std::vector<const UserProc *> &subs )
{
	///////////////////////////
	// O[o֐
	///////////////////////////

	// nbVl擾
	UserProc *pUserProc = GetHashArrayElement( simpleName );
	while(pUserProc){
		if( pUserProc->IsGlobalProcedure() ){
			if( pUserProc->IsEqualSymbol( LexicalAnalyzer::FullNameToSymbol( localName ) ) ){
				subs.push_back( pUserProc );
			}
		}

		pUserProc=pUserProc->GetChainNext();
	}
}

void ProcPointers::Clear()
{
	ProcPointers &procPointers = *this;
	BOOST_FOREACH( ProcPointer *pProcPointer, procPointers ){
		delete pProcPointer;
	}
	this->clear();
}
