#include "stdafx.h"

using namespace ActiveBasic::Compiler;

bool LexicalAnalyzer::AnalyzeParameter( Parameters &params, const Jenga::Common::Strings &parameterStrings, int nowLine )
{
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//p[^
	BOOST_FOREACH( const std::string &paramStr, parameterStrings )
	{
		int i = 0;

		if( paramStr[i] == '\0' )
		{
			break;
		}

		//ByRef
		bool isRef;
		if(paramStr[i]==1&&paramStr[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(paramStr[i]==1&&paramStr[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		Subscripts subscripts;
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(paramStr[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,paramStr.c_str()+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(paramStr[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,paramStr.c_str()+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(paramStr[i])){
				name[i2]=0;
				break;
			}
			name[i2]=paramStr[i];
		}
		if(sw){
			//zp[^
			if( isRef == false )
			{
				compiler.errorMessenger.Output(29,NULL,nowLine);
			}
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']'))
			{
				subscripts.push_back( LONG_MAX );

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subscripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		Type type( DEF_NON );
		char initValue[8192] = "";
		if( paramStr[i] == '=' ){
			i++;
			i = GetOneParameter( paramStr.c_str(), i, initValue );

			// TODO: G[p fix me!!!
			//cp = nowLine;

			NumOpe_GetType( initValue, GetStringTypeInfo(), type );
			
			if( IS_LITERAL(type.GetIndex()) )
			{
				type.SetIndex( -1 );
			}
		}
		else if(paramStr[i]==1&&paramStr[i+1]==ESC_AS){
			// Asw
			i+=2;

			i2=0;
			while(paramStr[i]=='*'){
				temporary[i2]=paramStr[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(paramStr[i])){
					if(paramStr[i]==1&&(paramStr[i+1]==ESC_FUNCTION||paramStr[i+1]==ESC_SUB)){
						temporary[i2++]=paramStr[i++];
						temporary[i2]=paramStr[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=paramStr[i];
			}

			compiler.StringToType( temporary, type );

			if( type.IsNull() ){
				compiler.errorMessenger.Output(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}

			if( type.IsObject() ){
				if( type.GetClass().IsBlittableType() ){
					// Blittable^̂Ƃ͊{^ƂĈ
					type = type.GetClass().GetBlittableType();
				}
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			compiler.errorMessenger.Output(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef, initValue );
		if( isArray ){
			pParam->SetArray( subscripts );
		}

		//p[^ǉ
		params.push_back( pParam );
	}

	return true;
}

UserProc* LexicalAnalyzer::ParseUserProc( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, char *buffer,int nowLine,bool isVirtual,CClass *pobj_c, bool isStatic, char *interfaceName )
{
	int i2,i3;
	char temporary[8192];

	int i=1;

	Procedure::Kind kind = Procedure::Sub;
	bool isMacro = false;
	if(buffer[i]==ESC_FUNCTION) kind = Procedure::Function;
	if(buffer[i]==ESC_MACRO){
		isMacro = true;
	}

	i++;

	bool isCdecl = false;
	bool isExport = false;
	while(1){
		if(buffer[i]==1&&buffer[i+1]==ESC_CDECL&& isCdecl == false ){
			isCdecl = true;

			i+=2;
		}
		else if(buffer[i]==1&&buffer[i+1]==ESC_EXPORT&& isExport == false ){
			isExport = true;

			i+=2;
		}
		else break;
	}

	i2=0;
	if(buffer[i]==1&&buffer[i+1]==ESC_OPERATOR){
		if(!pobj_c){
			compiler.errorMessenger.Output(126,NULL,nowLine);
			return 0;
		}

		//Iy[^̏ꍇ
		temporary[i2++]=buffer[i++];
		temporary[i2++]=buffer[i++];

		int iCalcId;
		if(buffer[i]=='='&&buffer[i+1]=='='){
			iCalcId=CALC_EQUAL;
			i3=2;
		}
		else if(buffer[i]=='='){
			iCalcId=CALC_SUBSITUATION;
			i3=1;
		}
		else if(buffer[i]=='('){
			iCalcId=CALC_AS;
			i3=0;
		}
		else if(buffer[i]=='['&&buffer[i+1]==']'&&buffer[i+2]=='='){
			iCalcId=CALC_ARRAY_SET;
			i3=3;
		}
		else if(buffer[i]=='['&&buffer[i+1]==']'){
			iCalcId=CALC_ARRAY_GET;
			i3=2;
		}
		else{
			iCalcId=GetCalcId(buffer+i,&i3);
			i3++;
		}
		if(!iCalcId){
			compiler.errorMessenger.Output(1,NULL,nowLine);
			return 0;
		}
		temporary[i2++]=iCalcId;
		temporary[i2]=0;

		i+=i3;
	}
	else{
		if(pobj_c){
			//NXȍꍇAfXgN^ɂ~tƂl
			if(buffer[i]=='~'){
				temporary[i2]='~';
				i++;
				i2++;
			}
		}

		for(;;i++,i2++){
			if(!IsVariableChar(buffer[i])){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}

		char parentName[VN_SIZE], memberName[VN_SIZE];
		ReferenceKind refKind;
		if( SplitMemberName( temporary, parentName, memberName, refKind ) )
		{
			if( pobj_c )
			{
				if( interfaceName )
				{
					lstrcpy( interfaceName, parentName );
				}
				else
				{
					compiler.errorMessenger.OutputFatalError();
					return NULL;
				}

				char dummyMemberName[VN_SIZE];
				if( SplitMemberName( memberName, parentName, dummyMemberName, refKind ) )
				{
					compiler.errorMessenger.Output(69,temporary,nowLine);
					return NULL;
				}
			}
			else
			{
				compiler.errorMessenger.Output(68,temporary,nowLine);
				return NULL;
			}

			lstrcpy( temporary, memberName );
		}
	}

	if( isMacro ){
		//啶ɕϊ
		CharUpper(temporary);
	}

	if(!pobj_c){
		//NXoȊȌꍇ̂
		//d`FbN

		if(GetDeclareHash(temporary)){
			compiler.errorMessenger.Output(15,temporary,nowLine);
			return 0;
		}
	}

	UserProc *pUserProc = new UserProc( namespaceScopes, importedNamespaces, temporary, kind, isMacro, isCdecl, isExport );
	pUserProc->SetParentClass( pobj_c );

	// eC^[tFCXZbg
	if( interfaceName && interfaceName[0] )
	{
		::Interface *pTargetInterface = NULL;
		BOOST_FOREACH( ::Interface *pInterface, pobj_c->GetInterfaces() )
		{
			if( pInterface->GetClass().GetName() == interfaceName )
			{
				pTargetInterface = pInterface;
				break;
			}
		}
		pUserProc->SetInterface( pTargetInterface );
	}

	if(isExport){
		pUserProc->Using();
	}

	// p[^
	// 1p[^ɂɎw肷f[^̗F"( s As String ) As String"
	pUserProc->SetParamsAndReturnType( buffer + i, nowLine, isStatic );

	pUserProc->_paramStr = buffer + i;

	return pUserProc;
}

void LexicalAnalyzer::CollectProcedures( const char *source, UserProcs &userProcs, DllProcs &dllProcs )
{
	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[8192];

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection &importedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	importedNamespaces.clear();

	i=-1;
	while(1){
		i++;

		if(source[i]==1&&(source[i+1]==ESC_CLASS||source[i+1]==ESC_INTERFACE)){
			/*	Class ` End Class
				Interface ` End Interface
				щz			*/
			i3=GetEndXXXCommand(source[i+1]);
			for(i+=2,i2=0;;i++,i2++){
				if(source[i]=='\0') break;
				if(source[i]==1&&source[i+1]==(char)i3){
					i++;
					break;
				}
			}
			if(source[i]=='\0') break;
			continue;
		}

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				compiler.errorMessenger.Output(64,temporary,cp );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			importedNamespaces.clear();
			continue;
		}

		if(source[i]==1&&source[i+1]==ESC_DECLARE){
			for(i+=2,i2=0;;i2++,i++){
				if(source[i]=='\n'){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
				if(source[i]=='\0') break;
			}
			dllProcs.Add(namespaceScopes,temporary,i);

			continue;
		}
		if(source[i]==1&&(source[i+1]==ESC_SUB||source[i+1]==ESC_FUNCTION||source[i+1]==ESC_MACRO)){
			char statementChar = source[i+1];

			for(i2=0;;i2++,i++){
				if(IsCommandDelimitation(source[i])){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
				if(source[i]=='\0') break;
			}

			UserProc *pUserProc = ParseUserProc( namespaceScopes, importedNamespaces, temporary, i, false, NULL, false );
			userProcs.Insert( pUserProc, i );

			/*	Sub ` End Sub
				Function ` End Function
				Macro ` End Macro
				щz			*/
			char endStatementChar = GetEndXXXCommand( statementChar );
			for(i2=0;;i++,i2++){
				if( source[i] == '\0' ) break;
				if( source[i] == 1 && source[i+1] == endStatementChar ){
					i++;
					break;
				}
			}
			if(source[i]=='\0') break;
			continue;
		}

		//̍s
		for(;;i++){
			if(IsCommandDelimitation(source[i])) break;
		}
		if(source[i]=='\0') break;
	}

	////////////
	// ֐
	////////////
	namespaceScopes.clear();
	importedNamespaces.clear();

	compiler.globalAreaProcName = "_System_GlobalArea_" + compiler.GetModuleName();
	sprintf(temporary,"%c%c%s()",1,ESC_SUB,compiler.globalAreaProcName.c_str());
	UserProc *pUserProc = ParseUserProc( namespaceScopes, importedNamespaces, temporary, 0, false, NULL, false );
	userProcs.Insert( pUserProc, i );
}
