#include "stdafx.h"

#include <Source.h>
#include <Class.h>
#include <Compiler.h>

#include "../common.h"
#ifdef _AMD64_
#include "../../compiler_x64/opcode.h"
#else
#include "../../compiler_x86/opcode.h"
#endif

using namespace ActiveBasic::Compiler;

void CClass::Using() const
{
	if( this->IsUsing() )
	{
		// Ɏgp邱ƂɂȂĂ
		return;
	}

	Prototype::Using();

	// z֐ɂȂ郁\bhɎgp`FbN
	const CClass &objThis = *this;
	BOOST_FOREACH( const CMethod *pMethod, objThis.GetDynamicMethods() )
	{
		if( pMethod->IsVirtual() )
		{
			pMethod->GetUserProc().Using();
		}
	}
}

bool CClass::IsClass() const
{
	return classType == CClass::Class;
}
bool CClass::IsInterface() const
{
	return classType == CClass::Interface;
}
bool CClass::IsComInterface() const
{
	return classType == CClass::ComInterface;
}
bool CClass::IsEnum() const
{
	return classType == CClass::Enum;
}
bool CClass::IsDelegate() const
{
	return classType == CClass::Delegate;
}
bool CClass::IsStructure() const
{
	return classType == CClass::Structure;
}


// RXgN^̃RpCJn
void CClass::NotifyStartConstructorCompile() const
{
	isCompilingConstructor = true;
}

//RXgN^̃RpCI
void CClass::NotifyFinishConstructorCompile() const
{
	isCompilingConstructor = false;
}

//RXgN^RpCǂ𔻕
bool CClass::IsCompilingConstructor() const
{
	return isCompilingConstructor;
}

//fXgN^̃RpCJn
void CClass::NotifyStartDestructorCompile() const{
	isCompilingDestructor = true;
}

//fXgN^̃RpCI
void CClass::NotifyFinishDestructorCompile() const{
	isCompilingDestructor = false;
}

//fXgN^RpCǂ𔻕
bool CClass::IsCompilingDestructor() const
{
	return isCompilingDestructor;
}

//g̔hNXǂmF
bool CClass::IsSubClass( const CClass *pSubClass ) const
{
	if( !pSubClass->HasSuperClass() )
	{
		return false;
	}

	const CClass *pTempClass = &pSubClass->GetSuperClass();
	while( pTempClass ){
		if( this == pTempClass ) return true;
		pTempClass = &pTempClass->GetSuperClass();
	}
	return false;
}

//gƓ܂͔hNXǂmF
bool CClass::IsEqualsOrSubClass( const CClass *pSubClass ) const
{
	if( IsEquals( pSubClass ) ) return true;
	return IsSubClass( pSubClass );
}

// gƓ܂͔hNXANXǂmF
bool CClass::IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const
{
	if( IsEquals( &objClass ) ) return true;
	if( IsSubClass( &objClass ) ) return true;
	if( objClass.IsSubClass( this ) ) return true;
	return false;
}

bool CClass::IsInheritsInterface( const CClass *pInterfaceClass ) const
{
	BOOST_FOREACH( const ::Interface *pInterface, interfaces ){
		if( pInterfaceClass == &pInterface->GetClass() ){
			return true;
		}
	}
	return false;
}

bool CClass::InheritsClass( const CClass &inheritsClass, const Types &actualTypeParameters, int nowLine )
{
	//\bhRs[
	BOOST_FOREACH( const CMethod *pBaseMethod, inheritsClass.GetDynamicMethods() ){
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( &inheritsClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		GetDynamicMethods().push_back( pMethod );
	}

	//z֐̐
	AddVtblNum( inheritsClass.GetVtblNum() );

	//p̃NXoƂĕێ
	SetSuperClass( &inheritsClass );
	SetSuperClassActualTypeParameters( actualTypeParameters );

	// C^[tFCXp
	BOOST_FOREACH( ::Interface *pInterface, inheritsClass.GetInterfaces() )
	{
		interfaces.push_back( new ::Interface( *pInterface ) );
	}

	if( this->IsInterface() && inheritsClass.IsComInterface() )
	{
		// COMC^[tFCXpꍇCOMC^[tFCXɂ
		this->SetClassType( CClass::ComInterface );
	}

	return true;
}

void CClass::AddDynamicMember( Member *pMember )
{
	dynamicMembers.push_back( pMember );
}
void CClass::AddStaticMember( Member *pMember )
{
	staticMembers.push_back( pMember );
}

bool CClass::DupliCheckAll(const char *name) const
{
	//d`FbN

	//o
	if(DupliCheckMember(name)) return 1;

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if( lstrcmp( name, pMethod->GetUserProc().GetName().c_str() ) == 0 ){
			return 1;
		}
	}

	return 0;
}
bool CClass::DupliCheckMember(const char *name) const
{
	//d`FbN

	if( this->HasSuperClass() )
	{
		if( this->GetSuperClass().DupliCheckMember( name ) )
		{
			// NXŏdꂽ
			return true;
		}
	}

	// Io
	BOOST_FOREACH( Member *pMember, dynamicMembers )
	{
		if( GetName() == pMember->GetName() )
		{
			return true;
		}
	}

	// ÓIo
	BOOST_FOREACH( Member *pMember, staticMembers ){
		if( GetName() == pMember->GetName() ){
			return true;
		}
	}

	return false;
}

const Member *CClass::FindDynamicMember( const char *memberName ) const
{
	if( this->HasSuperClass() )
	{
		// NXŌ
		const Member *result = this->GetSuperClass().FindDynamicMember( memberName );
		if( result )
		{
			return result;
		}
	}

	BOOST_FOREACH( Member *pMember, GetDynamicMembers() )
	{
		if( pMember->GetName() == memberName )
		{
			return pMember;
		}
	}
	return NULL;
}

void CClass::EnumDynamicMethodsOrInterfaceMethods( const char *methodName, std::vector<const UserProc *> &subs ) const
{
	// I\bh
	GetDynamicMethods().Enum( methodName, subs );

	// C^[tFCX \bh
	BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
	{
		pInterface->GetDynamicMethods().Enum( methodName, subs );
	}
}
const CMethod *CClass::GetDynamicMethodOrInterfaceMethod( const UserProc *pUserProc ) const
{
	// I\bh
	const CMethod *result = GetDynamicMethods().GetMethodPtr( pUserProc );

	if( !result )
	{
		// C^[tFCX \bh
		BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
		{
			result = pInterface->GetDynamicMethods().GetMethodPtr( pUserProc );
			if( result )
			{
				return result;
			}
		}
	}

	return result;
}

//TCY擾
int CClass::GetSize() const
{
	int resultSize = 0;

	int alignment = 1;
	if( this->IsStructure() )
	{
		// \̂̂Ƃ

		if( this->GetFixedAlignment() )
		{
			// ACǧŒlw肳Ăꍇ͂擾
			alignment = this->GetFixedAlignment();
		}
	}
	else
	{
		// ȊO

		if( this->HasSuperClass() )
		{
			// NX̃TCYǉ
			resultSize += this->GetSuperClass().GetSize();

			// NX̃ACg擾
			alignment = this->GetSuperClass().GetAlignment();
		}
		else
		{
			// NX݂ȂƂ

			// z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
			resultSize += IsExistVirtualFunctions() ? PTR_SIZE*2 : 0;
		}
	}

	BOOST_FOREACH( Member *pMember, dynamicMembers )
	{
		// oTCY
		int tempMemberSize = pMember->GetType().GetSize();

		// ꎞACgZo
		int tempAlignment = tempMemberSize;
		if( pMember->GetType().IsStruct() )
		{
			// o\̂̏ꍇ́AõACg擾
			tempAlignment = pMember->GetType().GetClass().GetAlignment();
		}

		// ACglăpfBOǉ
		if( GetFixedAlignment() && alignment < tempAlignment )
		{
			if( resultSize % alignment )
			{
				resultSize += alignment - ( resultSize % alignment );
			}
		}
		else
		{
			if( alignment < tempAlignment )
			{
				// őACgXV
				alignment = tempAlignment;
			}

			if( tempMemberSize == 0 )
			{
				if( !pMember->GetType().IsStruct() )
				{
					throw;
				}

				//oȂ\
				//ȂiItZbǧvZȂj
			}
			else{
				if( resultSize % tempAlignment )
				{
					resultSize += tempAlignment - ( resultSize % tempAlignment );
				}
			}
		}

		// oTCYZizlj
		resultSize += tempMemberSize * Variable::GetSubScriptCounts( pMember->GetSubscripts() );
	}

	if( alignment )
	{
		// ACglăpfBOǉ
		if( resultSize % alignment )
		{
			resultSize += alignment - ( resultSize % alignment );
		}
	}

	return resultSize;
}

//õItZbg擾
int CClass::GetMemberOffset( const char *memberName ) const
{
	int resultSize = 0;

	int alignment = 1;
	if( this->IsStructure() )
	{
		// \̂̂Ƃ

		if( this->GetFixedAlignment() )
		{
			// ACǧŒlw肳Ăꍇ͂擾
			alignment = this->GetFixedAlignment();
		}
	}
	else
	{
		// ȊO

		if( this->HasSuperClass() )
		{
			if( this->GetSuperClass().HasDynamicMember( memberName ) )
			{
				// NX̃o擾
				return this->GetSuperClass().GetMemberOffset( memberName );
			}

			// NX̃TCYǉ
			resultSize += this->GetSuperClass().GetSize();

			// NX̃ACg擾
			alignment = this->GetSuperClass().GetAlignment();
		}
		else
		{
			// NX݂ȂƂ

			// z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
			resultSize += IsExistVirtualFunctions() ? PTR_SIZE*2 : 0;
		}
	}

	BOOST_FOREACH( Member *pMember, dynamicMembers )
	{
		// oTCY
		int tempMemberSize = pMember->GetType().GetSize();

		// ꎞACgZo
		int tempAlignment = tempMemberSize;
		if( pMember->GetType().IsStruct() )
		{
			// o\̂̏ꍇ́AõACg擾
			tempAlignment = pMember->GetType().GetClass().GetAlignment();
		}

		// ACglăpfBOǉ
		if( GetFixedAlignment() && alignment < tempAlignment )
		{
			if( resultSize % alignment )
			{
				resultSize += alignment - ( resultSize % alignment );
			}
		}
		else
		{
			if( alignment < tempAlignment )
			{
				// őACgXV
				alignment = tempAlignment;
			}

			if( tempMemberSize == 0 )
			{
				if( !pMember->GetType().IsStruct() )
				{
					throw;
				}

				//oȂ\
				//ȂiItZbǧvZȂj
			}
			else{
				if( resultSize % tempAlignment )
				{
					resultSize += tempAlignment - ( resultSize % tempAlignment );
				}
			}
		}

		if(memberName){
			//ow肪ꍇ́AItZbgԂ
			if( pMember->GetName() == memberName )
			{
				return resultSize;
			}
		}

		// oTCYZizlj
		resultSize += tempMemberSize * Variable::GetSubScriptCounts( pMember->GetSubscripts() );
	}

	if( alignment )
	{
		// ACglăpfBOǉ
		if( resultSize % alignment )
		{
			resultSize += alignment - ( resultSize % alignment );
		}
	}

	return resultSize;
}
int CClass::GetAlignment() const
{
	int alignment = 1;
	if( this->IsStructure() )
	{
		// \̂̂Ƃ

		if( this->GetFixedAlignment() )
		{
			// ACǧŒlw肳Ăꍇ͂擾
			return this->GetFixedAlignment();
		}
	}
	else
	{
		// ȊO

		if( this->HasSuperClass() )
		{
			// NX̃ACg擾
			alignment = this->GetSuperClass().GetAlignment();
		}
		else
		{
			// NX݂ȂƂ

			// z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
			alignment = PTR_SIZE;
		}
	}

	BOOST_FOREACH( Member *pMember, dynamicMembers )
	{
		int tempAlignment = pMember->GetType().GetSize();
		if( pMember->GetType().IsStruct() )
		{
			// o\̂̏ꍇ́AõACg擾
			tempAlignment = pMember->GetType().GetClass().GetAlignment();
		}

		if( alignment < tempAlignment )
		{
			// őACgXV
			alignment = tempAlignment;
		}
	}

	return alignment;
}

void CClass::GetVtblMasterListIndexAndVtblIndex( const UserProc *pUserProc, int &vtblMasterListIndex, int &vtblIndex ) const
{
	vtblMasterListIndex = 0;

	vtblIndex = 0;
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if( &pMethod->GetUserProc() == pUserProc )
		{
			return;
		}

		if( pMethod->IsVirtual() )
		{
			vtblIndex++;
		}
	}

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		vtblMasterListIndex++;

		vtblIndex = 0;
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if( &pMethod->GetUserProc() == pUserProc )
			{
				return;
			}

			if( pMethod->IsVirtual() )
			{
				vtblIndex++;
			}
		}
	}

	throw;
}
int CClass::GetVtblMasterListIndex( const CClass *pClass ) const
{
	int result = 0;

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		result++;
		
		if( &pInterface->GetClass() == pClass )
		{
			return result;
		}
	}

	throw;
}
long CClass::GetVtblMasterListOffset() const
{
	if( vtblMasterListOffset == -1 )
	{
		throw;
	}

	return vtblMasterListOffset;
}
bool CClass::IsAbstract() const
{
	// (abstract)̉z֐ꍇtrueԂ

	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if(pMethod->IsVirtual()){
			if(pMethod->IsAbstract()){
				return true;
			}
		}
	}

	// C^[tFCXvtbl
	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if(pMethod->IsVirtual()){
				if(pMethod->IsAbstract()){
					return true;
				}
			}
		}
	}

	return false;
}

const CClass *Classes::FindEx( const NamespaceScopes &namespaceScopes, const std::string &name ) const
{
	if( namespaceScopes.size() == 0 && name == "Object" )
	{
		return GetObjectClassPtr();
	}
	else if( namespaceScopes.size() == 0 && name == "String" )
	{
		return GetStringClassPtr();
	}

	std::vector<const CClass *> classes;
	const CClass *pClass = GetHashArrayElement( name.c_str() );
	while( pClass )
	{
		if( pClass->IsEqualSymbol( namespaceScopes, name ) ){
			//OԂƃNXv
			classes.push_back( pClass );
		}
		pClass = pClass->GetChainNext();
	}
	if( classes.size() > 0 )
	{
		// ̖OԂ̒ɓ̃NX݂ꍇ̂ŁAANZX\ŏKwԐ[̂`CX
		pClass = classes.front();

		BOOST_FOREACH( const CClass *pTempClass, classes )
		{
			if( pClass->GetNamespaceScopes().size() < pTempClass->GetNamespaceScopes().size() )
			{
				pClass = pTempClass;
			}
		}

		return pClass;
	}

	return NULL;
}
const CClass *Classes::FindEx( const std::string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), AreaName, NestName );

	return FindEx( NamespaceScopes( AreaName ), NestName );
}

const CClass *Classes::GetStringClassPtr() const
{
	if( !pStringClass )
	{
		// LbVĂ
		pStringClass = this->FindEx( NamespaceScopes( "System" ), "String" );
	}
	return pStringClass;
}
const CClass *Classes::GetObjectClassPtr() const
{
	if( !pObjectClass )
	{
		// LbVĂ
		pObjectClass = this->FindEx( NamespaceScopes( "System" ), "Object" );
	}
	return pObjectClass;
}
const CClass *Classes::GetInterfaceInfoClassPtr() const
{
	if( !pInterfaceInfo )
	{
		// LbVĂ
		pInterfaceInfo = this->FindEx( "ActiveBasic.Core.InterfaceInfo" );
	}
	return pInterfaceInfo;
}

std::string CClass::GetStaticDefiningStringAsMemberNames() const
{
	std::string result;

	BOOST_FOREACH( const Member *pMember, dynamicMembers )
	{
		if( result.size() )
		{
			result += ",";
		}

		result += "\"" + pMember->GetName() + "\"";
	}

	return result;
}
std::string CClass::GetStaticDefiningStringAsMemberOffsets() const
{
	std::string result;

	BOOST_FOREACH( const Member *pMember, dynamicMembers )
	{
		if( result.size() )
		{
			result += ",";
		}

		int offset = this->GetMemberOffset( pMember->GetName().c_str() );

		char temporary[255];
		itoa( offset, temporary, 16 );

		result += (std::string)"&H" + temporary;
	}

	return result;
}

void CClass::GetReferenceOffsetsInitializeBuffer( std::string &referenceOffsetsBuffer, int &numOfReference, int baseOffset ) const
{
	const CClass &thisClass = *this;
	BOOST_FOREACH( const Member *pMember, thisClass.GetDynamicMembers() )
	{
		if( pMember->GetType().IsObject() || pMember->GetType().IsPointer() )
		{
			if( referenceOffsetsBuffer.size() )
			{
				referenceOffsetsBuffer += ",";
			}

			char temp[255];
			sprintf( temp, "%d", baseOffset + thisClass.GetMemberOffset( pMember->GetName().c_str() ) );
			referenceOffsetsBuffer += temp;

			numOfReference++;
		}
		if( pMember->GetType().IsStruct() && !pMember->GetType().IsPointer() )
		{
			// \̂̎̂oɎƂ
			int baseOffset = thisClass.GetMemberOffset( pMember->GetName().c_str() );

			// \̃oGCɂ`FbNKvȎQƈʒuǉ
			pMember->GetType().GetClass().GetReferenceOffsetsInitializeBuffer( referenceOffsetsBuffer, numOfReference, baseOffset );
		}
	}
}
