#include "stdafx.h"

#include <Compiler.h>

void Meta::Clear()
{
	// O
	namespaceScopesCollection.clear();

	// ֐E\bh
	userProcs.Clear();

	// DLL֐
	dllProcs.Clear();

	// NX
	classesImpl.Clear();

	// O[oϐ
	globalVars.Clear();

	// O[o萔
	globalConsts.Clear();

	// O[o萔}N
	globalConstMacros.Clear();

	// blittable^
	blittableTypes.clear();

	// TypeDef
	typeDefs.clear();

	// ֐|C^
	procPointers.Clear();
}

void Meta::StaticLink( Meta &meta, long dataSectionBaseOffset, int sourceIndexBase )
{
	// O
	BOOST_FOREACH( NamespaceScopes &namespaceScopes, meta.namespaceScopesCollection )
	{
		if( !this->namespaceScopesCollection.IsExist( namespaceScopes ) )
		{
			this->namespaceScopesCollection.push_back( namespaceScopes );
		}
	}

	// ֐E\bh
	meta.GetUserProcs().Iterator_Reset();
	while( meta.GetUserProcs().Iterator_HasNext() )
	{
		UserProc *pUserProc = meta.GetUserProcs().Iterator_GetNext();
		pUserProc->isTargetObjectModule = false;

		pUserProc->GetNativeCode().ResetDataSectionBaseOffset( dataSectionBaseOffset );
		pUserProc->GetNativeCode().ResetSourceIndexes( sourceIndexBase );

		this->userProcs.Put( pUserProc );
	}
	meta.GetUserProcs().PullOutAll();

	// DLL֐
	meta.GetDllProcs().Iterator_Reset();
	while( meta.GetDllProcs().Iterator_HasNext() )
	{
		DllProc *pDllProc = meta.GetDllProcs().Iterator_GetNext();
		pDllProc->isTargetObjectModule = false;
		this->dllProcs.Put( pDllProc );
	}
	meta.GetDllProcs().PullOutAll();

	// NX
	meta.GetClasses().Iterator_Reset();
	while( meta.GetClasses().Iterator_HasNext() )
	{
		CClass *pClass = meta.GetClasses().Iterator_GetNext();
		pClass->isTargetObjectModule = false;
		this->GetClasses().Put( pClass );
	}
	meta.GetClasses().PullOutAll();

	// O[oϐ
	long initAreaBaseOffset = this->globalVars.initAreaBuffer.GetSize();
	BOOST_FOREACH( Variable *pVar, meta.globalVars )
	{
		// XR[vx̃O[oϐ̐lIɂ
		if( pVar->GetScopeLevel() == 0 )
		{
			pVar->isLiving = true;
		}

		bool isResetOffsetAddress = true;
		if( pVar->HasInitData() )
		{
			// obt@Ƃ̓f[^e[uItZbgKp
			pVar->SetOffsetAddress( pVar->GetOffsetAddress() + initAreaBaseOffset );

			isResetOffsetAddress = false;
		}

		pVar->isTargetObjectModule = false;
		this->globalVars.Add( pVar, isResetOffsetAddress );
	}
	meta.globalVars.PullOutAll();
	this->globalVars.initAreaBuffer.Put(
		meta.globalVars.initAreaBuffer.GetBuffer(),
		meta.globalVars.initAreaBuffer.GetSize()
	);

	// O[o萔
	meta.GetGlobalConsts().Iterator_Reset();
	while( meta.GetGlobalConsts().Iterator_HasNext() )
	{
		CConst *pConst = meta.GetGlobalConsts().Iterator_GetNext();
		pConst->isTargetObjectModule = false;
		this->GetGlobalConsts().Put( pConst );
	}
	meta.GetGlobalConsts().PullOutAll();

	// O[o萔}N
	meta.GetGlobalConstMacros().Iterator_Reset();
	while( meta.GetGlobalConstMacros().Iterator_HasNext() )
	{
		ConstMacro *pConstMacro = meta.GetGlobalConstMacros().Iterator_GetNext();
		pConstMacro->isTargetObjectModule = false;
		this->GetGlobalConstMacros().Put( pConstMacro );
	}
	meta.GetGlobalConstMacros().PullOutAll();

	// blittable^
	BOOST_FOREACH( BlittableType &blittableType, meta.blittableTypes )
	{
		blittableType.isTargetObjectModule = false;
		this->blittableTypes.push_back( blittableType );
	}
	meta.blittableTypes.clear();

	// TypeDef
	BOOST_FOREACH( TypeDef &typeDef, meta.typeDefs )
	{
		typeDef.isTargetObjectModule = false;
		this->typeDefs.push_back( typeDef );
	}
	meta.typeDefs.clear();

	// ֐|C^
	BOOST_FOREACH( ProcPointer *pProcPointer, meta.procPointers )
	{
		pProcPointer->isTargetObjectModule = false;
		this->procPointers.push_back( pProcPointer );
	}
	meta.procPointers.PullOutAll();

	// fQ[g
	meta.GetDelegates().Iterator_Reset();
	while( meta.GetDelegates().Iterator_HasNext() )
	{
		Delegate *pDelegate = meta.GetDelegates().Iterator_GetNext();
		pDelegate->isTargetObjectModule = false;
		this->GetDelegates().Put( pDelegate );
	}
	meta.GetDelegates().PullOutAll();
}

const ::Delegate &Meta::ToDelegate( const CClass &_class )
{
	const ::Delegate *dg = this->GetDelegates().GetHashArrayElement( _class.GetName().c_str() );
	while( dg )
	{
		if( dg->IsEqualSymbol( _class.GetNamespaceScopes(), _class.GetName() ) ){
			//OԂƃNXv
			return *dg;
		}
		dg = dg->GetChainNext();
	}

	throw;
}
