#include "stdafx.h"

#include <Source.h>
#include <Class.h>
#include <Compiler.h>

#include "../common.h"
#ifdef _AMD64_
#include "../../compiler_x64/opcode.h"
#else
#include "../../compiler_x86/opcode.h"
#endif

using namespace ActiveBasic::Compiler;

void CClass::Using() const
{
	if( this->IsUsing() )
	{
		// Ɏgp邱ƂɂȂĂ
		return;
	}

	Prototype::Using();

	// z֐ɂȂ郁\bhɎgp`FbN
	const CClass &objThis = *this;
	BOOST_FOREACH( const CMethod *pMethod, objThis.GetDynamicMethods() )
	{
		if( pMethod->IsVirtual() )
		{
			pMethod->GetUserProc().Using();
		}
	}
}

bool CClass::IsClass() const
{
	return classType == CClass::Class;
}
bool CClass::IsInterface() const
{
	return classType == CClass::Interface;
}
bool CClass::IsComInterface() const
{
	return classType == CClass::ComInterface;
}
bool CClass::IsEnum() const
{
	return classType == CClass::Enum;
}
bool CClass::IsDelegate() const
{
	return classType == CClass::Delegate;
}
bool CClass::IsStructure() const
{
	return classType == CClass::Structure;
}


// RXgN^̃RpCJn
void CClass::NotifyStartConstructorCompile() const
{
	isCompilingConstructor = true;
}

//RXgN^̃RpCI
void CClass::NotifyFinishConstructorCompile() const
{
	isCompilingConstructor = false;
}

//RXgN^RpCǂ𔻕
bool CClass::IsCompilingConstructor() const
{
	return isCompilingConstructor;
}

//fXgN^̃RpCJn
void CClass::NotifyStartDestructorCompile() const{
	isCompilingDestructor = true;
}

//fXgN^̃RpCI
void CClass::NotifyFinishDestructorCompile() const{
	isCompilingDestructor = false;
}

//fXgN^RpCǂ𔻕
bool CClass::IsCompilingDestructor() const
{
	return isCompilingDestructor;
}

//g̔hNXǂmF
bool CClass::IsSubClass( const CClass *pSubClass ) const
{
	if( !pSubClass->HasSuperClass() )
	{
		return false;
	}

	const CClass *pTempClass = &pSubClass->GetSuperClass();
	while( pTempClass ){
		if( this == pTempClass ) return true;
		pTempClass = &pTempClass->GetSuperClass();
	}
	return false;
}

//gƓ܂͔hNXǂmF
bool CClass::IsEqualsOrSubClass( const CClass *pSubClass ) const
{
	if( IsEquals( pSubClass ) ) return true;
	return IsSubClass( pSubClass );
}

// gƓ܂͔hNXANXǂmF
bool CClass::IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const
{
	if( IsEquals( &objClass ) ) return true;
	if( IsSubClass( &objClass ) ) return true;
	if( objClass.IsSubClass( this ) ) return true;
	return false;
}

bool CClass::IsInheritsInterface( const CClass *pInterfaceClass ) const
{
	BOOST_FOREACH( const ::Interface *pInterface, interfaces ){
		if( pInterfaceClass == &pInterface->GetClass() ){
			return true;
		}
	}
	return false;
}

bool CClass::InheritsClass( const CClass &inheritsClass, const Types &actualTypeParameters, int nowLine )
{
	//\bhRs[
	BOOST_FOREACH( const CMethod *pBaseMethod, inheritsClass.GetDynamicMethods() ){
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( &inheritsClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		GetDynamicMethods().push_back( pMethod );
	}

	//z֐̐
	AddVtblNum( inheritsClass.GetVtblNum() );

	//p̃NXoƂĕێ
	SetSuperClass( &inheritsClass );
	SetSuperClassActualTypeParameters( actualTypeParameters );

	// C^[tFCXp
	BOOST_FOREACH( ::Interface *pInterface, inheritsClass.GetInterfaces() )
	{
		interfaces.push_back( new ::Interface( *pInterface ) );
	}

	if( this->IsInterface() && inheritsClass.IsComInterface() )
	{
		// COMC^[tFCXpꍇCOMC^[tFCXɂ
		this->SetClassType( CClass::ComInterface );
	}

	return true;
}

CMember *CClass::CreateMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine )
{
	extern int cp;

	//\
	char VarName[VN_SIZE];
	char initBuffer[VN_SIZE];
	char lpszConstructParameter[VN_SIZE];
	Subscripts subscripts;
	Type type;
	GetDimentionFormat(buffer,VarName,subscripts,type,initBuffer,lpszConstructParameter);

	//d`FbN
	if(this->DupliCheckAll(VarName)){
		compiler.errorMessenger.Output(15,VarName,cp);
	}

	CMember *pMember = new CMember( accessibility, VarName, type, isConst, subscripts, initBuffer, lpszConstructParameter );
	pMember->source_code_address = nowLine;
	return pMember;
}
void CClass::AddMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine ){
	dynamicMembers.push_back(
		CreateMember( accessibility, isConst, isRef, buffer, nowLine )
	);
}
void CClass::AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine ){
	staticMembers.push_back(
		CreateMember( accessibility, isConst, isRef, buffer, nowLine )
	);
}

bool CClass::DupliCheckAll(const char *name) const
{
	//d`FbN

	//o
	if(DupliCheckMember(name)) return 1;

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if( lstrcmp( name, pMethod->GetUserProc().GetName().c_str() ) == 0 ){
			return 1;
		}
	}

	return 0;
}
bool CClass::DupliCheckMember(const char *name) const
{
	//d`FbN

	if( this->HasSuperClass() )
	{
		if( this->GetSuperClass().DupliCheckMember( name ) )
		{
			// NXŏdꂽ
			return true;
		}
	}

	// Io
	BOOST_FOREACH( CMember *pMember, dynamicMembers )
	{
		if( GetName() == pMember->GetName() )
		{
			return true;
		}
	}

	// ÓIo
	BOOST_FOREACH( CMember *pMember, staticMembers ){
		if( GetName() == pMember->GetName() ){
			return true;
		}
	}

	return false;
}

const CMember *CClass::FindDynamicMember( const char *memberName ) const
{
	if( this->HasSuperClass() )
	{
		// NXŌ
		const CMember *result = this->GetSuperClass().FindDynamicMember( memberName );
		if( result )
		{
			return result;
		}
	}

	BOOST_FOREACH( CMember *pMember, GetDynamicMembers() )
	{
		if( pMember->GetName() == memberName )
		{
			return pMember;
		}
	}
	return NULL;
}

void CClass::EnumDynamicMethodsOrInterfaceMethods( const char *methodName, std::vector<const UserProc *> &subs ) const
{
	// I\bh
	GetDynamicMethods().Enum( methodName, subs );

	// C^[tFCX \bh
	BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
	{
		pInterface->GetDynamicMethods().Enum( methodName, subs );
	}
}
const CMethod *CClass::GetDynamicMethodOrInterfaceMethod( const UserProc *pUserProc ) const
{
	// I\bh
	const CMethod *result = GetDynamicMethods().GetMethodPtr( pUserProc );

	if( !result )
	{
		// C^[tFCX \bh
		BOOST_FOREACH( ::Interface *pInterface, GetInterfaces() )
		{
			result = pInterface->GetDynamicMethods().GetMethodPtr( pUserProc );
			if( result )
			{
				return result;
			}
		}
	}

	return result;
}

const ::Delegate &CClass::GetDelegate() const
{
	const ::Delegate *dg = compiler.GetObjectModule().meta.GetDelegates().GetHashArrayElement( GetName().c_str() );
	while( dg )
	{
		if( dg->IsEqualSymbol( GetNamespaceScopes(), GetName() ) ){
			//OԂƃNXv
			return *dg;
		}
		dg = dg->GetChainNext();
	}

	Jenga::Throw( "CClass::GetDelegate\bhɎs" );
	static ::Delegate dummy;
	return dummy;
}

//TCY擾
int CClass::GetSize() const
{
	int resultSize = 0;

	int alignment = 1;
	if( this->IsStructure() )
	{
		// \̂̂Ƃ

		if( this->GetFixedAlignment() )
		{
			// ACǧŒlw肳Ăꍇ͂擾
			alignment = this->GetFixedAlignment();
		}
	}
	else
	{
		// ȊO

		if( this->HasSuperClass() )
		{
			// NX̃TCYǉ
			resultSize += this->GetSuperClass().GetSize();

			// NX̃ACg擾
			alignment = this->GetSuperClass().GetAlignment();
		}
		else
		{
			// NX݂ȂƂ

			// z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
			resultSize += IsExistVirtualFunctions() ? PTR_SIZE*2 : 0;
		}
	}

	BOOST_FOREACH( CMember *pMember, dynamicMembers )
	{
		// oTCY
		int tempMemberSize = pMember->GetType().GetSize();

		// ꎞACgZo
		int tempAlignment = tempMemberSize;
		if( pMember->GetType().IsStruct() )
		{
			// o\̂̏ꍇ́AõACg擾
			tempAlignment = pMember->GetType().GetClass().GetAlignment();
		}

		// ACglăpfBOǉ
		if( GetFixedAlignment() && alignment < tempAlignment )
		{
			if( resultSize % alignment )
			{
				resultSize += alignment - ( resultSize % alignment );
			}
		}
		else
		{
			if( alignment < tempAlignment )
			{
				// őACgXV
				alignment = tempAlignment;
			}

			if( tempMemberSize == 0 )
			{
				if( !pMember->GetType().IsStruct() )
				{
					compiler.errorMessenger.OutputFatalError();
				}

				//oȂ\
				//ȂiItZbǧvZȂj
			}
			else{
				if( resultSize % tempAlignment )
				{
					resultSize += tempAlignment - ( resultSize % tempAlignment );
				}
			}
		}

		// oTCYZizlj
		resultSize += tempMemberSize * Variable::GetSubScriptCounts( pMember->GetSubscripts() );
	}

	if( alignment )
	{
		// ACglăpfBOǉ
		if( resultSize % alignment )
		{
			resultSize += alignment - ( resultSize % alignment );
		}
	}

	return resultSize;
}

//õItZbg擾
int CClass::GetMemberOffset( const char *memberName ) const
{
	int resultSize = 0;

	int alignment = 1;
	if( this->IsStructure() )
	{
		// \̂̂Ƃ

		if( this->GetFixedAlignment() )
		{
			// ACǧŒlw肳Ăꍇ͂擾
			alignment = this->GetFixedAlignment();
		}
	}
	else
	{
		// ȊO

		if( this->HasSuperClass() )
		{
			if( this->GetSuperClass().HasDynamicMember( memberName ) )
			{
				// NX̃o擾
				return this->GetSuperClass().GetMemberOffset( memberName );
			}

			// NX̃TCYǉ
			resultSize += this->GetSuperClass().GetSize();

			// NX̃ACg擾
			alignment = this->GetSuperClass().GetAlignment();
		}
		else
		{
			// NX݂ȂƂ

			// z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
			resultSize += IsExistVirtualFunctions() ? PTR_SIZE*2 : 0;
		}
	}

	BOOST_FOREACH( CMember *pMember, dynamicMembers )
	{
		// oTCY
		int tempMemberSize = pMember->GetType().GetSize();

		// ꎞACgZo
		int tempAlignment = tempMemberSize;
		if( pMember->GetType().IsStruct() )
		{
			// o\̂̏ꍇ́AõACg擾
			tempAlignment = pMember->GetType().GetClass().GetAlignment();
		}

		// ACglăpfBOǉ
		if( GetFixedAlignment() && alignment < tempAlignment )
		{
			if( resultSize % alignment )
			{
				resultSize += alignment - ( resultSize % alignment );
			}
		}
		else
		{
			if( alignment < tempAlignment )
			{
				// őACgXV
				alignment = tempAlignment;
			}

			if( tempMemberSize == 0 )
			{
				if( !pMember->GetType().IsStruct() )
				{
					compiler.errorMessenger.OutputFatalError();
				}

				//oȂ\
				//ȂiItZbǧvZȂj
			}
			else{
				if( resultSize % tempAlignment )
				{
					resultSize += tempAlignment - ( resultSize % tempAlignment );
				}
			}
		}

		if(memberName){
			//ow肪ꍇ́AItZbgԂ
			if( pMember->GetName() == memberName )
			{
				return resultSize;
			}
		}

		// oTCYZizlj
		resultSize += tempMemberSize * Variable::GetSubScriptCounts( pMember->GetSubscripts() );
	}

	if( alignment )
	{
		// ACglăpfBOǉ
		if( resultSize % alignment )
		{
			resultSize += alignment - ( resultSize % alignment );
		}
	}

	return resultSize;
}
int CClass::GetAlignment() const
{
	int alignment = 1;
	if( this->IsStructure() )
	{
		// \̂̂Ƃ

		if( this->GetFixedAlignment() )
		{
			// ACǧŒlw肳Ăꍇ͂擾
			return this->GetFixedAlignment();
		}
	}
	else
	{
		// ȊO

		if( this->HasSuperClass() )
		{
			// NX̃ACg擾
			alignment = this->GetSuperClass().GetAlignment();
		}
		else
		{
			// NX݂ȂƂ

			// z֐݂ꍇvtblyvtblMasterListւ̃|C^̃TCYǉ
			alignment = PTR_SIZE;
		}
	}

	BOOST_FOREACH( CMember *pMember, dynamicMembers )
	{
		int tempAlignment = pMember->GetType().GetSize();
		if( pMember->GetType().IsStruct() )
		{
			// o\̂̏ꍇ́AõACg擾
			tempAlignment = pMember->GetType().GetClass().GetAlignment();
		}

		if( alignment < tempAlignment )
		{
			// őACgXV
			alignment = tempAlignment;
		}
	}

	return alignment;
}

void CClass::GetVtblMasterListIndexAndVtblIndex( const UserProc *pUserProc, int &vtblMasterListIndex, int &vtblIndex ) const
{
	vtblMasterListIndex = 0;

	vtblIndex = 0;
	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if( &pMethod->GetUserProc() == pUserProc )
		{
			return;
		}

		if( pMethod->IsVirtual() )
		{
			vtblIndex++;
		}
	}

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		vtblMasterListIndex++;

		vtblIndex = 0;
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if( &pMethod->GetUserProc() == pUserProc )
			{
				return;
			}

			if( pMethod->IsVirtual() )
			{
				vtblIndex++;
			}
		}
	}

	compiler.errorMessenger.OutputFatalError();
	return;
}
int CClass::GetVtblMasterListIndex( const CClass *pClass ) const
{
	int result = 0;

	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		result++;
		
		if( &pInterface->GetClass() == pClass )
		{
			return result;
		}
	}

	compiler.errorMessenger.OutputFatalError();
	return 0;
}
long CClass::GetVtblMasterListOffset() const
{
	//ɑ݂ꍇ͂Ԃ
	if( vtblMasterListOffset == -1 )
	{
		compiler.errorMessenger.OutputFatalError();
	}

	return vtblMasterListOffset;
}
bool CClass::IsAbstract() const
{
	// (abstract)̉z֐ꍇtrueԂ

	BOOST_FOREACH( const CMethod *pMethod, GetDynamicMethods() ){
		if(pMethod->IsVirtual()){
			if(pMethod->IsAbstract()){
				return true;
			}
		}
	}

	// C^[tFCXvtbl
	BOOST_FOREACH( const ::Interface *pInterface, interfaces )
	{
		BOOST_FOREACH( const CMethod *pMethod, pInterface->GetDynamicMethods() ){
			if(pMethod->IsVirtual()){
				if(pMethod->IsAbstract()){
					return true;
				}
			}
		}
	}

	return false;
}

CClass *Classes::Create( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name){
	return new CClass(namespaceScopes, importedNamespaces, name);
}
bool Classes::Insert( CClass *pClass, int nowLine )
{
	/////////////////////////////////
	// nbVf[^ɒǉ
	/////////////////////////////////

	if( !Put( pClass ) )
	{
		compiler.errorMessenger.Output(15,pClass->GetName(), nowLine);
		return false;
	}
	return true;
}
CClass *Classes::Add( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine){
	//////////////////////////////////////////////////////////////////////////
	// NXǉ
	// Ô݂o^B̑̏SetClass\bhŁI
	//////////////////////////////////////////////////////////////////////////

	CClass *pClass = Create(namespaceScopes, importedNamespaces, name);

	if( !Insert( pClass, nowLine ) )
	{
		return NULL;
	}

	return pClass;	
}


void Classes::InitStaticMember(){
	//ÓIoO[öɍ쐬

	//Ce[^Zbg

	extern int cp;
	int back_cp=cp;

	this->Iterator_Reset();
	while(this->Iterator_HasNext()){
		CClass &objClass = *this->Iterator_GetNext();
		if( objClass.isTargetObjectModule == false )
		{
			// ÓINCȕꍇ͔΂iɃCX^X`ς݂ł邽߁j
			continue;
		}

		// OԂZbg
		compiler.GetNamespaceSupporter().GetLivingNamespaceScopes() = objClass.GetNamespaceScopes();

		DWORD dwFlags = 0;
		if( objClass.GetName() == "_System_TypeBase" )
		{
			// _System_TypeBaseNX̓O[oAX^eBbN̈邽߂̃NXȂ̂łł̏͏O
			dwFlags |= DIMFLAG_NONCALL_CONSTRACTOR;
		}

		// RpCNXƂăZbg
		compiler.SetCompilingClass( &objClass );

		const EnumInfo *pEnumInfo = NULL;
		if( objClass.IsEnum() )
		{
			pEnumInfo = compiler.enumInfoCollection.Find( objClass );
		}

		int i=0;
		BOOST_FOREACH( CMember *member, objClass.GetStaticMembers() )
		{
			if( pEnumInfo )
			{
				cp = pEnumInfo->GetEnumMember( member->GetName() ).GetSourceIndex();
			}

			char temporary[VN_SIZE];
			sprintf(temporary,"%s.%s",objClass.GetName().c_str(),member->GetName().c_str());
			dim(
				temporary,
				member->GetSubscripts(),
				member->GetType(),
				member->GetInitializeExpression().c_str(),
				member->GetConstructParameter().c_str(),
				dwFlags);

			i++;
		}

		compiler.SetCompilingClass( NULL );
	}

	compiler.GetNamespaceSupporter().GetLivingNamespaceScopes().clear();

	cp=back_cp;
}

void Classes::Compile_System_InitializeUserTypes(){
	char temporary[VN_SIZE];

	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		const CClass &objClass = *Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}

		std::string referenceOffsetsBuffer;
		int numOfReference = 0;
		objClass.GetReferenceOffsetsInitializeBuffer( referenceOffsetsBuffer, numOfReference );

		sprintf( temporary
			, "Add(%c%c_System_TypeForClass[strNamespace=\"%s\",name=\"%s\",fullName=\"%s\",referenceOffsets=[%s],numOfReference=%d])"
			, 1
			, ESC_SYSTEM_STATIC_NEW
			, objClass.GetNamespaceScopes().ToString().c_str()		// O
			, objClass.GetName().c_str()							// NX
			, objClass.GetFullName().c_str()						// tl[
			, referenceOffsetsBuffer.c_str()						// QƃoItZbgz
			, numOfReference										// Qƃǒ
			);

		// RpC
		ChangeOpcode( temporary );

		objClass.SetTypeInfoDataTableOffset(
			compiler.GetObjectModule().dataTable.GetLastMadeConstObjectDataTableOffset()
		);
	}
}
void Classes::Compile_System_InitializeUserTypesForBaseType()
{
	extern int cp;
	cp = -1;
	////////////////////////////////////////////////////////////////////
	// NXo^
	////////////////////////////////////////////////////////////////////

	char temporary[8192];
	sprintf(temporary, "%c%ctempType=Nothing%c%c_System_TypeForClass"
		, HIBYTE( COM_DIM )
		, LOBYTE( COM_DIM )
		, 1
		, ESC_AS
		);
	ChangeOpcode( temporary );

	// Ce[^Zbg
	Iterator_Reset();

	while( Iterator_HasNext() ){
		const CClass &objClass = *Iterator_GetNext();

		if( !objClass.IsUsing() ){
			// gp̃NX͖
			continue;
		}

		if( objClass.HasSuperClass() || objClass.GetDynamicMembers().size() ){
			sprintf( temporary
				, "tempType=Search(\"%s\") As ActiveBasic.Core._System_TypeForClass"
				, objClass.GetFullName().c_str()
			);

			// RpC
			MakeMiddleCode( temporary );
			ChangeOpcode( temporary );

			sprintf( temporary
				, "tempType.SetClassInfo(%d,_System_GetComVtbl(%s),_System_GetVtblList(%s),_System_GetDefaultConstructor(%s),_System_GetDestructor(%s))"
				, objClass.GetSize()
				, objClass.GetFullName().c_str()
				, objClass.GetFullName().c_str()
				, objClass.GetFullName().c_str()
				, objClass.GetFullName().c_str()
				, objClass.GetName().c_str()
			);

			// RpC
			ChangeOpcode( temporary );

			if( objClass.HasSuperClass() )
			{
				sprintf( temporary
					, "tempType.SetBaseType(Search(\"%s\"))"
					, objClass.GetSuperClass().GetFullName().c_str()
				);

				// RpC
				ChangeOpcode( temporary );
			}

			if( objClass.GetDynamicMembers().size() )
			{
				// ǒ^TypeInfoIuWFNgւDataOffsetz̐ÓIf[^`擾
				sprintf(
					temporary,
					"tempType.SetMembers([%s],[%s],[%s],%d)",
					objClass.GetStaticDefiningStringAsMemberNames().c_str(),
					objClass.GetStaticDefiningStringAsMemberTypeInfoNames().c_str(),
					objClass.GetStaticDefiningStringAsMemberOffsets().c_str(),
					objClass.GetDynamicMembers().size()
				);
				ChangeOpcode( temporary );
			}
		}
	}
}

const CClass *Classes::Find( const NamespaceScopes &namespaceScopes, const std::string &name ) const
{
	if( namespaceScopes.size() == 0 && name == "Object" ){
		return GetObjectClassPtr();
	}
	else if( namespaceScopes.size() == 0 && name == "String" ){
		return GetStringClassPtr();
	}

	std::vector<const CClass *> classes;
	const CClass *pClass = GetHashArrayElement( name.c_str() );
	while( pClass )
	{
		if( pClass->IsEqualSymbol( namespaceScopes, name ) ){
			//OԂƃNXv
			classes.push_back( pClass );
		}
		pClass = pClass->GetChainNext();
	}
	if( classes.size() > 0 )
	{
		// ̖OԂ̒ɓ̃NX݂ꍇ̂ŁAANZX\ŏKwԐ[̂`CX
		pClass = classes.front();

		BOOST_FOREACH( const CClass *pTempClass, classes )
		{
			if( pClass->GetNamespaceScopes().size() < pTempClass->GetNamespaceScopes().size() )
			{
				pClass = pTempClass;
			}
		}

		return pClass;
	}

	// TypeDef
	int index = compiler.GetObjectModule().meta.GetTypeDefs().GetIndex( namespaceScopes, name );
	if( index != -1 ){
		Type type = compiler.GetObjectModule().meta.GetTypeDefs()[index].GetBaseType();
		if( type.IsObject() ){
			return &type.GetClass();
		}
	}

	return NULL;
}
const CClass *Classes::Find( const std::string &fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName.c_str(), AreaName, NestName );

	return Find( NamespaceScopes( AreaName ), NestName );
}

const CClass *Classes::GetStringClassPtr() const
{
	if( !pStringClass ){
		// LbVĂ
		pStringClass = this->Find( NamespaceScopes( "System" ), "String" );

		if( !pStringClass )
		{
			compiler.errorMessenger.Output(400, "System.String", cp);
			static CClass dummy;
			return &dummy;
		}
		return pStringClass;
	}
	return pStringClass;
}
const CClass *Classes::GetObjectClassPtr() const
{
	if( !pObjectClass ){
		// LbVĂ
		pObjectClass = this->Find( NamespaceScopes( "System" ), "Object" );

		if( !pObjectClass )
		{
			compiler.errorMessenger.Output(400, "System.Object", cp);
			static CClass dummy;
			return &dummy;
		}
		return pObjectClass;
	}
	return pObjectClass;
}
const CClass *Classes::GetInterfaceInfoClassPtr() const
{
	if( !pInterfaceInfo ){
		// LbVĂ
		pInterfaceInfo = this->Find( "ActiveBasic.Core.InterfaceInfo" );

		if( !pInterfaceInfo )
		{
			compiler.errorMessenger.Output(400, "ActiveBasic.Core.InterfaceInfo", cp);
			static CClass dummy;
			return &dummy;
		}
		return pInterfaceInfo;
	}
	return pInterfaceInfo;
}

std::string CClass::GetStaticDefiningStringAsMemberNames() const
{
	std::string result;

	BOOST_FOREACH( const CMember *pMember, dynamicMembers )
	{
		if( result.size() )
		{
			result += ",";
		}

		result += "\"" + pMember->GetName() + "\"";
	}

	return result;
}
std::string CClass::GetStaticDefiningStringAsMemberTypeInfoNames() const
{
	std::string result;

	BOOST_FOREACH( const CMember *pMember, dynamicMembers )
	{
		if( result.size() )
		{
			result += ",";
		}

		result += "\"" + compiler.TypeToString( pMember->GetType() ) + "\"";
	}

	return result;
}
std::string CClass::GetStaticDefiningStringAsMemberOffsets() const
{
	std::string result;

	BOOST_FOREACH( const CMember *pMember, dynamicMembers )
	{
		if( result.size() )
		{
			result += ",";
		}

		int offset = this->GetMemberOffset( pMember->GetName().c_str() );

		char temporary[255];
		itoa( offset, temporary, 16 );

		result += (std::string)"&H" + temporary;
	}

	return result;
}

void CClass::GetReferenceOffsetsInitializeBuffer( std::string &referenceOffsetsBuffer, int &numOfReference, int baseOffset ) const
{
	const CClass &thisClass = *this;
	BOOST_FOREACH( const CMember *pMember, thisClass.GetDynamicMembers() )
	{
		if( pMember->GetType().IsObject() || pMember->GetType().IsPointer() )
		{
			if( referenceOffsetsBuffer.size() )
			{
				referenceOffsetsBuffer += ",";
			}

			char temp[255];
			sprintf( temp, "%d", baseOffset + thisClass.GetMemberOffset( pMember->GetName().c_str() ) );
			referenceOffsetsBuffer += temp;

			numOfReference++;
		}
		if( pMember->GetType().IsStruct() && !pMember->GetType().IsPointer() )
		{
			// \̂̎̂oɎƂ
			int baseOffset = thisClass.GetMemberOffset( pMember->GetName().c_str() );

			// \̃oGCɂ`FbNKvȎQƈʒuǉ
			pMember->GetType().GetClass().GetReferenceOffsetsInitializeBuffer( referenceOffsetsBuffer, numOfReference, baseOffset );
		}
	}
}
