#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

//ϐ
VARIABLE *GlobalVar;
int MaxGlobalVarNum;
int AllGlobalVarSize;
int AllInitGlobalVarSize;
VARIABLE *LocalVar;
int MaxLocalVarNum;
int AllLocalVarSize;

void SetRelativeOffset(int *pType,LONG_PTR lpIndex,RELATIVE_VAR *pRelativeVar,char *lpPtrOffset){
	int i2;

	PushLongVariable(pRelativeVar);

	i2=NumOpe(lpPtrOffset,0,0,0);
	ChangeTypeToLong(i2);

	//pop ebx
	op_pop(REG_EBX);

	if(PTR_LEVEL(*pType)){
		*pType=MAKE_PTR_TYPE(NATURAL_TYPE(*pType),PTR_LEVEL(*pType)-1);
		if((*pType)==DEF_OBJECT){
			//imul ebx,objsize
			OpBuffer[obp++]=(char)0x69;
			OpBuffer[obp++]=(char)0xDB;
			*((long *)(OpBuffer+obp))=GetSizeOfClassMember((CClass *)lpIndex,NULL,NULL);
			obp+=sizeof(long);
		}
		else{
			i2=GetTypeSize(*pType,-1);
			if(i2>=2){
				//imul ebx,i2
				OpBuffer[obp++]=(char)0x6B;
				OpBuffer[obp++]=(char)0xDB;
				OpBuffer[obp++]=(char)i2;
			}
		}
	}
	else{
		//G[
		SetError(1,NULL,cp);
		return;
	}

	//pop ecx
	op_pop(REG_ECX);

	//add ecx,ebx
	OpBuffer[obp++]=(char)0x03;
	OpBuffer[obp++]=(char)0xCB;
}
BOOL GetArrayOffset(int *SubScripts,char *array,int type,LONG_PTR lpIndex){
	extern HANDLE hHeap;
	int i,i2,i3,i4,TypeSize;
	char temporary[VN_SIZE],*pParm[MAX_PARMS];

	for(i=0,i2=0,i3=0;;i++,i2++){
		if(array[i]=='('){
			i4=GetStringInPare(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]=='['){
			i4=GetStringInBracket(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]==','||array[i]=='\0'){
			if(SubScripts[i3]==-1){
				for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
				return 0;
			}

			temporary[i2]=0;

			pParm[i3]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(pParm[i3],temporary);

			i3++;

			if(array[i]=='\0'){
				if(SubScripts[i3]!=-1){
					for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
					return 0;
				}
				break;
			}

			i2=-1;
			continue;
		}
		temporary[i2]=array[i];
	}

	//push ecx
	op_push(REG_ECX);

	//push 0
	op_push_value(0);

	for(i=i3-1;i>=0;i--){
		TYPEINFO TypeInfo;
		BOOL bUseHeap;
		TypeInfo.type=NumOpe(pParm[i],DEF_LONG,-1,&TypeInfo.u.lpIndex,&bUseHeap);
		if(TypeInfo.type==DEF_OBJECT){
			//LXgZq̃I[o[[hɑΉ
			CallCastOperatorProc(
				TypeInfo.type,TypeInfo.u.lpIndex,
				bUseHeap,DEF_LONG,-1);
			TypeInfo.type=DEF_LONG;
		}
		ChangeTypeToLong(TypeInfo.type);

		//pop eax
		op_pop(REG_EAX);

		for(i2=i+1,i4=1;i2<i3;i2++) i4*=SubScripts[i2]+1;

		//imul eax,i4
		OpBuffer[obp++]=(char)0x69;
		OpBuffer[obp++]=(char)0xC0;
		*((long *)(OpBuffer+obp))=i4;
		obp+=sizeof(long);

		//add dword ptr[esp],eax
		OpBuffer[obp++]=(char)0x01;
		OpBuffer[obp++]=(char)0x04;
		OpBuffer[obp++]=(char)0x24;

		HeapDefaultFree(pParm[i]);
	}

	//pop eax
	op_pop(REG_EAX);

	TypeSize=GetTypeSize(type,lpIndex);

	//imul eax,TypeSize
	OpBuffer[obp++]=(char)0x69;
	OpBuffer[obp++]=(char)0xC0;
	*((long *)(OpBuffer+obp))=TypeSize;
	obp+=sizeof(long);

	//pop ecx
	op_pop(REG_ECX);

	//add ecx,eax
	OpBuffer[obp++]=(char)0x03;
	OpBuffer[obp++]=(char)0xC8;

	return 1;
}
BOOL GetMemberOffset(bool isErrorEnabled, bool isWriteAccess, CClass *pobj_c, char *member, int *pType, RELATIVE_VAR *pRelativeVar, LONG_PTR *plpNestIndex, BOOL bPrivateAccess){
	int i,offset;

	//NXAz̍\vf͂
	char VarName[VN_SIZE];		//ϐ
	char array[VN_SIZE];		//1z
	char lpPtrOffset[VN_SIZE];	//2z
	char NestMember[VN_SIZE];	//qo
	int RefType;				//"."QƂ̂Ƃ0A"->"QƂ̂Ƃ1
	lstrcpy(VarName,member);
	if(!GetVarFormatString(VarName,array,lpPtrOffset,NestMember,&RefType)) return 0;

	////////////////////////////
	// oItZbg擾
	////////////////////////////

	offset=GetSizeOfClassMember(pobj_c,VarName,&i);
	if(i==pobj_c->iMemberNum){
		if(isErrorEnabled) SetError(103,VarName,cp);
		return 0;
	}

	CMember *pMember=pobj_c->ppobj_Member[i];

	//ANZVreB`FbN
	if(pobj_c==pobj_CompilingClass){
		//NXIuWFNg̏ꍇ̓vCx[gANZXeF
		if(pMember->dwAccess==ACCESS_NON){
			if(isErrorEnabled) SetError(107,VarName,cp);
			return 0;
		}
	}
	else{
		if((bPrivateAccess==0&&pMember->dwAccess==ACCESS_PRIVATE)||
			pMember->dwAccess==ACCESS_NON){
			if(isErrorEnabled) SetError(107,VarName,cp);
			return 0;
		}
		else if(bPrivateAccess==0&&pMember->dwAccess==ACCESS_PROTECTED){
			if(isErrorEnabled) SetError(108,VarName,cp);
			return 0;
		}
	}

	//Const`̏ꍇ͏݃ANZX𐧌
	//RXgN^RpC̏ꍇ͗OIɋ
	if( pMember->IsConst() &&		//萔oł
		isWriteAccess &&							//݃ANZXvĂ
		pobj_c->IsCompilingConstructor() == false	//RXgN^ RpC
		){
			//Const`̕ϐɏ݃ANZX悤Ƃꍇ
			SetError(61,VarName,cp);
	}

	*pType=pMember->TypeInfo.type;
	*plpNestIndex=pMember->TypeInfo.u.lpIndex;

	//|C^ϐ̏ꍇ
	if(IsPtrType(*pType)){
		if(pMember->SubScripts[0]==-1){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]){
			if(isErrorEnabled) SetError(16,member,cp);
			return 0;
		}
	}

	if(offset){
		//add ecx,offset
		OpBuffer[obp++]=(char)0x81;
		OpBuffer[obp++]=(char)0xC1;
		*((long *)(OpBuffer+obp))=offset;
		obp+=sizeof(long);
	}

	if(array[0]){
		//zItZbg
		if(!GetArrayOffset(pMember->SubScripts,array,*pType,pMember->TypeInfo.u.lpIndex))
			if(isErrorEnabled) SetError(14,member,cp);
	}
	else if(pMember->SubScripts[0]!=-1){
		*pType|=FLAG_PTR;
	}

	if(NestMember[0]){
		//q\̏ꍇ

		if(*pType==DEF_OBJECT){
			if(RefType!=DEF_OBJECT){
				if(isErrorEnabled) SetError(104,member,cp);
				return 0;
			}
		}
		else if(*pType==DEF_PTR_OBJECT){
			//\̃|C^^oϐ

			if(lpPtrOffset[0]){
				//pObj[n].member
				if(RefType!=DEF_OBJECT){
					if(isErrorEnabled) SetError(104,member,cp);
					return 0;
				}

				//ڎQƂɐ؂ւ
				SetRelativeOffset(pType,*plpNestIndex,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				lpPtrOffset[0]=0;
			}
			else{
				//pObj->member
				if(RefType!=DEF_PTR_OBJECT){
					if(isErrorEnabled) SetError(104,member,cp);
					return 0;
				}

				if(pRelativeVar->dwKind==VAR_DIRECTMEM){
					//mov ecx,dword ptr[ecx]
					OpBuffer[obp++]=(char)0x8B;
					OpBuffer[obp++]=(char)0x09;
				}
				else{
					//ڎQƂɐ؂ւ
					SetVarPtrToEax(pRelativeVar);
					pRelativeVar->dwKind=VAR_DIRECTMEM;

					//mov ecx,dword ptr[eax]
					OpBuffer[obp++]=(char)0x8B;
					OpBuffer[obp++]=(char)0x08;
				}
			}
		}
		else if(*pType==MAKE_PTR_TYPE(DEF_OBJECT,2)){
			//\̃|C^̃|C^^oϐ

			if(lpPtrOffset[0]){
				//ppObj[n]->member
				if(RefType!=DEF_PTR_OBJECT){
					if(isErrorEnabled) SetError(104,member,cp);
					return 0;
				}

				//ڎQƂɐ؂ւ
				SetRelativeOffset(pType,*plpNestIndex,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				lpPtrOffset[0]=0;

				//mov ecx,dword ptr[ecx]
				OpBuffer[obp++]=(char)0x8B;
				OpBuffer[obp++]=(char)0x09;
			}
			else{
				if(isErrorEnabled) SetError(104,member,cp);
				return 0;
			}
		}

		if(!GetMemberOffset(
			isErrorEnabled,
			isWriteAccess,
			pMember->TypeInfo.u.pobj_Class,
			NestMember,
			pType,
			pRelativeVar,
			plpNestIndex,
			0)) return 0;
	}

	if(lpPtrOffset[0]){
		SetRelativeOffset(pType,*plpNestIndex,pRelativeVar,lpPtrOffset);
		pRelativeVar->dwKind=VAR_DIRECTMEM;
	}

	return 1;
}
void GetWithName(char *buffer){
	extern WITHINFO WithInfo;
	int i;

	buffer[0]=0;
	for(i=0;i<WithInfo.num;i++)
		lstrcat(buffer,WithInfo.ppName[i]);
}

int LocalVar_ThisPtrOffset;
void SetThisPtrToReg(int reg){
	//g̃IuWFNgThis|C^regɃRs[

	extern VARIABLE *LocalVar;
	RELATIVE_VAR RelativeVar;
	RelativeVar.dwKind=VAR_LOCAL;
	RelativeVar.bOffsetOffset=0;
	RelativeVar.offset=-LocalVar_ThisPtrOffset;

	SetReg_WholeVariable(DEF_PTR_VOID,&RelativeVar,reg);
}

BOOL GetVarOffset(bool isErrorEnabled, bool isWriteAccess, const char *NameBuffer, int *pType, RELATIVE_VAR *pRelativeVar, LONG_PTR *plpIndex, int *pss){
	extern BOOL bCompilingGlobal;
	int i,RefType;
	LONG_PTR lpIndex;
	char variable[VN_SIZE],member[VN_SIZE],VarName[VN_SIZE],array[VN_SIZE],lpPtrOffset[VN_SIZE];

	if(NameBuffer[0]=='.'){
		GetWithName(variable);
		lstrcat(variable,NameBuffer);
	}
	else lstrcpy(variable,NameBuffer);


	if( FormatUseProcReturnObject( variable, VarName, array, RefType, member ) ){
		// ߂lIuWFNg̃o𒼐ڎQƂĂƂ
		//: func().member

		void *pInfo;
		int idProc=GetProc(VarName,&pInfo);

		if(idProc){
			pRelativeVar->dwKind=VAR_DIRECTMEM;


			////////////////
			// Ăяo
			////////////////

			*pType=CallProc(idProc,pInfo,VarName,array,&lpIndex);

			//߂lecxɃRs[
			op_mov_RR( REG_ECX, REG_EAX );


			LONG_PTR lp2;
			if(!GetMemberOffset(
				isErrorEnabled,
				isWriteAccess,
				(CClass *)lpIndex,
				member,pType,pRelativeVar,&lp2,0)) return 0;
			if(plpIndex) *plpIndex=lp2;

			return 1;
		}
	}


	lstrcpy(VarName,variable);
	GetVarFormatString(VarName,array,lpPtrOffset,member,&RefType);

	int *pSubScripts;
	bool bConst;

	if(bCompilingGlobal==0){
		////////////////////
		// [Jϐ
		////////////////////

		for(i=MaxLocalVarNum-1;i>=0;i--){	//LVJXR[vlăobNT[`
			if( LocalVar[i].bLiving											//݂̃XR[vŗLȂ
				&& LocalVar[i].ScopeLevel <= obj_LexScopes.GetNowLevel()	//݂̃XR[vx𒴂Ȃ́iReturnɂlj
				){
					if(lstrcmp(VarName,LocalVar[i].name)==0) break;
			}
		}
		if(i>=0){
			//|C^ϐ̏ꍇ
			if(IsPtrType(LocalVar[i].type)){
				if(LocalVar[i].SubScripts[0]==-1){
					lstrcpy(lpPtrOffset,array);
					array[0]=0;
				}
			}
			else{
				if(lpPtrOffset[0]){
					SetError(16,variable,cp);
					pRelativeVar->dwKind=NON_VAR;
					return 0;
				}
			}

			pRelativeVar->offset=-LocalVar[i].offset;
			pRelativeVar->bOffsetOffset=0;
			if(LocalVar[i].fRef) pRelativeVar->dwKind=VAR_REFLOCAL;
			else pRelativeVar->dwKind=VAR_LOCAL;
			*pType=LocalVar[i].type;
			lpIndex=LocalVar[i].u.index;
			if(plpIndex) *plpIndex=lpIndex;
			pSubScripts=LocalVar[i].SubScripts;
			bConst = LocalVar[i].bConst;

			goto ok;
		}
	}

	if(pobj_CompilingClass){
		//////////////////////
		// NXo̎Q
		//////////////////////

		if(lstrcmpi(variable,"This")==0){
			//ThisIuWFNg

			//This|C^ecxɃRs[
			SetThisPtrToReg(REG_ECX);

			*pType=DEF_OBJECT;
			pRelativeVar->dwKind=VAR_DIRECTMEM;

			if(plpIndex) *plpIndex=(LONG_PTR)pobj_CompilingClass;
			return 1;
		}

		if(_memicmp(variable,"This.",5)==0){
			//ThisIuWFNg̃oQƂƂ
			SlideString(variable+5,-5);
			lstrcpy(VarName,variable);
		}
		else{
			//NXoQƂƂiʏj

			for(i=0;i<pobj_CompilingClass->iMemberNum;i++){
				if(lstrcmp(VarName,pobj_CompilingClass->ppobj_Member[i]->name)==0) break;
			}
			if(i==pobj_CompilingClass->iMemberNum) goto NonClassMember;
		}

		//ConstCq̃\bhŃo݃ANZXƂ
		//iRXgN^AfXgN^j
		CMethod *pMethod = pobj_DBClass->GetNowCompilingMethodInfo();
		if( isWriteAccess &&
			pMethod->isConst &&
			pobj_CompilingClass->IsCompilingConstructor() == false &&
			pobj_CompilingClass->IsCompilingDestructor() == false
			){
				SetError(131, NULL, cp );
		}

		/////////////////////////////
		// this|C^ecxɃZbg

		//This|C^ecxɃRs[
		SetThisPtrToReg(REG_ECX);

		pRelativeVar->dwKind=VAR_DIRECTMEM;
		if(!GetMemberOffset(
			isErrorEnabled,
			isWriteAccess,
			pobj_CompilingClass,
			variable,
			pType,
			pRelativeVar,
			&lpIndex,1)) return 0;
		if(plpIndex) *plpIndex=lpIndex;
		return 1;
	}

NonClassMember:

	//////////////////////////
	// ÓI[Jϐ
	// "Static.Object.Method.Variable"
	//////////////////////////

	char temporary[VN_SIZE];
	extern SUBINFO *pCompilingSubInfo;
	if(pCompilingSubInfo){
		GetNowStaticVarFullName(VarName,temporary);

		for(i=0;i<MaxGlobalVarNum;i++){
			if(lstrcmp(temporary,GlobalVar[i].name)==0) break;
		}
		if(i!=MaxGlobalVarNum){
			goto GlobalOk;
		}
	}


	//////////////////////////
	// NX̐ÓIo
	//////////////////////////

	if(member[0]){
		lstrcpy(temporary,member);
		char tempMember[VN_SIZE];
		char tempArray[VN_SIZE];
		GetVarFormatString(temporary,tempArray,lpPtrOffset,tempMember,&i);

		char temp2[VN_SIZE];
		sprintf(temp2,"%s.%s",VarName,temporary);
		for(i=0;i<MaxGlobalVarNum;i++){
			if(lstrcmp(temp2,GlobalVar[i].name)==0) break;
		}

		if(i!=MaxGlobalVarNum){
			lstrcpy(member,tempMember);
			lstrcpy(array,tempArray);
			goto GlobalOk;
		}
	}

	if(pobj_CompilingClass){
		//g̃NXÓIoQƂꍇ
		char temp2[VN_SIZE];
		sprintf(temp2,"%s.%s",pobj_CompilingClass->name,VarName);
		for(i=0;i<MaxGlobalVarNum;i++){
			if(lstrcmp(temp2,GlobalVar[i].name)==0) break;
		}

		if(i!=MaxGlobalVarNum){
			goto GlobalOk;
		}
	}


	////////////////////
	// O[oϐ
	////////////////////

	for(i=MaxGlobalVarNum-1;i>=0;i--){	//LVJXR[vlăobNT[`
		if( GlobalVar[i].bLiving										//݂̃XR[vŗLȂ
			&& GlobalVar[i].ScopeLevel <= obj_LexScopes.GetNowLevel()	//݂̃XR[vx𒴂Ȃ́iReturnɂlj
			){
				if(lstrcmp(VarName,GlobalVar[i].name)==0) break;
		}
	}
	if(i>=0){
		goto GlobalOk;
	}


	if(isErrorEnabled) SetError(3,variable,cp);
	pRelativeVar->dwKind=NON_VAR;
	return 0;


GlobalOk:

	//|C^ϐ̏ꍇ
	if(IsPtrType(GlobalVar[i].type)){
		if(GlobalVar[i].SubScripts[0]==-1){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]){
			SetError(16,variable,cp);
			pRelativeVar->dwKind=NON_VAR;
			return 0;
		}
	}

	pRelativeVar->offset=GlobalVar[i].offset;
	pRelativeVar->bOffsetOffset=0;
	pRelativeVar->dwKind=VAR_GLOBAL;
	*pType=GlobalVar[i].type;
	lpIndex=GlobalVar[i].u.index;
	if(plpIndex) *plpIndex=lpIndex;
	pSubScripts=GlobalVar[i].SubScripts;
	bConst = GlobalVar[i].bConst;


ok:

	if( bConst && isWriteAccess ){
		//Const`̕ϐɏ݃ANZX悤Ƃꍇ
		if( *pType == DEF_OBJECT ){
			//IuWFNg萔
			SetError(130, VarName, cp );
		}
		else{
			//ʂConstϐ
			SetError(61,VarName,cp);
		}
	}

	if(array[0]==0&&pSubScripts[0]!=-1){
		//z̐擪|C^ꍇ
		*pType|=FLAG_PTR;
		if(pss) memcpy(pss,pSubScripts,MAX_ARRAYDIM);
		return 1;
	}

	if(array[0]||member[0]){
		//xor ecx,ecxiecx0ɏj
		//ecx͕ϐx[XAhX̑΃ItZbg
		op_zero_reg(REG_ECX);

		pRelativeVar->bOffsetOffset=1;
	}
	if(array[0]){
		if(!GetArrayOffset(pSubScripts,array,*pType,lpIndex)){
			SetError(14,variable,cp);
			pRelativeVar->dwKind=NON_VAR;
			return 0;
		}
	}
	if(member[0]){
		if(*pType==DEF_OBJECT){
			//ԃIuWFNg̃oQƁiobj.memberj
			if(RefType!=DEF_OBJECT){
				SetError(104,VarName,cp);
				pRelativeVar->dwKind=NON_VAR;
				return 0;
			}
		}
		else if(*pType==DEF_PTR_OBJECT){
			//|C^IuWFNgoQ
			if(lpPtrOffset[0]){
				//pObj[n].member
				if(RefType!=DEF_OBJECT){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return 0;
				}
				SetRelativeOffset(pType,lpIndex,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;
			}
			else{
				//pObj->member
				if(RefType!=DEF_PTR_OBJECT){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return 0;
				}

				SetVarPtrToEax(pRelativeVar);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				//mov ecx,dword ptr[eax]
				OpBuffer[obp++]=(char)0x8B;
				OpBuffer[obp++]=(char)0x08;
			}
		}
		else if(*pType==MAKE_PTR_TYPE(DEF_OBJECT,2)){
			//|C^IuWFNgoQ
			if(lpPtrOffset[0]){
				//ppObj[n]->member
				if(RefType!=DEF_PTR_OBJECT){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return 0;
				}

				SetRelativeOffset(pType,lpIndex,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;


				SetVarPtrToEax(pRelativeVar);

				//mov ecx,dword ptr[eax]
				OpBuffer[obp++]=(char)0x8B;
				OpBuffer[obp++]=(char)0x08;
			}
			else{
				SetError(104,VarName,cp);
				pRelativeVar->dwKind=NON_VAR;
				return 0;
			}
		}
		else{
			SetError(102,VarName,cp);
			pRelativeVar->dwKind=NON_VAR;
			return 0;
		}

		LONG_PTR lp2;
		if(!GetMemberOffset(
			isErrorEnabled,
			isWriteAccess,
			(CClass *)lpIndex,
			member,pType,pRelativeVar,&lp2,0)) return 0;
		if(plpIndex) *plpIndex=lp2;

		return 1;
	}

	if(lpPtrOffset[0]){
		SetRelativeOffset(pType,lpIndex,pRelativeVar,lpPtrOffset);
		pRelativeVar->dwKind=VAR_DIRECTMEM;
	}

	return 1;
}

BOOL SetInitGlobalData(int offset,int type,LONG_PTR lpIndex,int *SubScripts,char *InitBuf){
	extern BYTE *initGlobalBuf;
	int i,i2,i3,TypeSize;
	char temporary[VN_SIZE];

	if(InitBuf[0]=='['){
		SlideString(InitBuf+1,-1);
		InitBuf[lstrlen(InitBuf)-1]=0;

		TypeSize=GetTypeSize(type,lpIndex);

		if(SubScripts[0]!=-1){
			TypeSize*=JumpSubScripts(SubScripts+1);
			i=0;
			i2=0;
			while(1){
				if(SubScripts[0]<i2){
					SetError(41,0,cp);
					return 0;
				}
				i=GetOneParameter(InitBuf,i,temporary);
				if(!SetInitGlobalData(
					offset+i2*TypeSize,
					type,
					lpIndex,
					SubScripts+1,
					temporary)) return 0;
				i2++;
				if(InitBuf[i]=='\0') break;
			}
			return -1;
		}

		if(type==DEF_OBJECT){
			CClass *pobj_c;
			pobj_c=(CClass *)lpIndex;

			for(i=0,i2=0;i2<pobj_c->iMemberNum;i2++){
				i=GetOneParameter(InitBuf,i,temporary);

				i3=GetSizeOfClassMember(pobj_c,pobj_c->ppobj_Member[i2]->name,NULL);

				if(!SetInitGlobalData(offset+i3,
					pobj_c->ppobj_Member[i2]->TypeInfo.type,
					pobj_c->ppobj_Member[i2]->TypeInfo.u.lpIndex,
					pobj_c->ppobj_Member[i2]->SubScripts,
					temporary)) return 0;

				if(InitBuf[i]=='\0') break;
			}
			if(i2+1!=pobj_c->iMemberNum){
				SetError(41,0,cp);
				return 0;
			}
			return 1;
		}

		SetError(41,0,cp);
		return 0;
	}


	///////////////////////////////////////
	// Pi[]ň͂܂ĂȂj
	///////////////////////////////////////

	if( type == DEF_OBJECT){
		//IuWFNg̏ꍇ͂肦Ȃ
		SetError(300,NULL,cp);
		return 0;
	}

	if(SubScripts[0]!=-1){
		SetError(41,0,cp);
		return 0;
	}

	double dbl;
	_int64 i64data;
	int CalcType;
	LONG_PTR lpCalcIndex;
	CalcType=StaticCalculation(true, InitBuf,type,&i64data,&lpCalcIndex);
	if(IsRealNumberType(CalcType)){
		memcpy(&dbl,&i64data,sizeof(double));
		i64data=(_int64)dbl;
	}
	else dbl=(double)i64data;

	//^`FbN
	CheckDifferentType(
		type,
		lpIndex,
		CalcType,
		lpCalcIndex,
		0,0);

	if(type==DEF_DOUBLE)
		*(double *)(initGlobalBuf+offset)=(double)dbl;
	else if(type==DEF_SINGLE)
		*(float *)(initGlobalBuf+offset)=(float)dbl;
	else if(type==DEF_INT64||type==DEF_QWORD)
		*(_int64 *)(initGlobalBuf+offset)=i64data;
	else if(type==DEF_LONG||type==DEF_DWORD||IsPtrType(type)){
		if(type==DEF_PTR_BYTE&&lpCalcIndex==LITERAL_STRING){
			//萔̂Ƃ

			char *temp;
			temp=(char *)i64data;
			i2=dataTable.AddString(temp,lstrlen(temp));
			HeapDefaultFree(temp);

			//mov eax,DataPos
			OpBuffer[obp++]=(char)0xB8;
			*((long *)(OpBuffer+obp))=(long)i2;
			pobj_DataTableSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[offset],eax
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			*(DWORD *)(initGlobalBuf+offset)=(DWORD)i64data;
		}
	}
	else if(type==DEF_INTEGER||type==DEF_WORD || (isUnicode&&type==DEF_CHAR))
		*(WORD *)(initGlobalBuf+offset)=(WORD)i64data;
	else if(type==DEF_SBYTE||type==DEF_BYTE||type==DEF_BOOLEAN || (isUnicode==false&&type==DEF_CHAR))
		*(BYTE *)(initGlobalBuf+offset)=(BYTE)i64data;
	//String^
	return 1;
}
BOOL InitLocalVar(int offset,int type,LONG_PTR lpIndex,int *SubScripts,char *InitBuf){
	int i,i2,i3,TypeSize;
	char temporary[VN_SIZE];

	if(InitBuf[0]=='['){
		SlideString(InitBuf+1,-1);
		InitBuf[lstrlen(InitBuf)-1]=0;

		TypeSize=GetTypeSize(type,lpIndex);

		if(SubScripts[0]!=-1){
			TypeSize*=JumpSubScripts(SubScripts+1);
			i=0;
			i2=0;
			while(1){
				if(SubScripts[0]<i2){
					SetError(41,0,cp);
					return 0;
				}
				i=GetOneParameter(InitBuf,i,temporary);
				if(!InitLocalVar(
					offset+i2*TypeSize,
					type,
					lpIndex,
					SubScripts+1,
					temporary)) return 0;
				i2++;
				if(InitBuf[i]=='\0') break;
			}
			return -1;
		}

		if(type==DEF_OBJECT){
			CClass *pobj_c;
			pobj_c=(CClass *)lpIndex;

			for(i=0,i2=0;i2<pobj_c->iMemberNum;i2++){
				i=GetOneParameter(InitBuf,i,temporary);

				i3=GetSizeOfClassMember(pobj_c,pobj_c->ppobj_Member[i2]->name,NULL);

				if(!InitLocalVar(offset+i3,
					pobj_c->ppobj_Member[i2]->TypeInfo.type,
					pobj_c->ppobj_Member[i2]->TypeInfo.u.lpIndex,
					pobj_c->ppobj_Member[i2]->SubScripts,
					temporary)) return 0;

				if(InitBuf[i]=='\0') break;
			}
			if(i2+1!=pobj_c->iMemberNum){
				SetError(41,0,cp);
				return 0;
			}
			return 1;
		}

		SetError(41,0,cp);
		return 0;
	}


	///////////////////////////////////////
	// Pi[]ň͂܂ĂȂj
	///////////////////////////////////////

	if(SubScripts[0]!=-1){
		SetError(41,0,cp);
		return 0;
	}

	double dbl;
	_int64 i64data;
	int CalcType;
	LONG_PTR lpCalcIndex;
	CalcType=StaticCalculation(false, InitBuf,type,&i64data,&lpCalcIndex);
	if(!CalcType){
		//If[^ꍇ
		return 0;
	}
	if(IsRealNumberType(CalcType)){
		memcpy(&dbl,&i64data,sizeof(double));
		i64data=(_int64)dbl;
	}
	else dbl=(double)i64data;

	//^`FbN
	CheckDifferentType(
		type,
		lpIndex,
		CalcType,
		lpCalcIndex,
		0,0);

	if(type==DEF_DOUBLE){
		//mov eax,HILONG(dbl)
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=(long)*(long *)(((char *)(&dbl))+4);
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset+sizeof(long)],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset+sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		//mov eax,LOLONG(dbl)
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=*(long *)(&dbl);
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if(type==DEF_SINGLE){
		float flt;
		flt=(float)dbl;
		//mov eax,InitValue
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=*(long *)&flt;
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if(type==DEF_INT64||type==DEF_QWORD){
		//mov eax,HILONG(i64data)
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=(long)*(long *)(((char *)(&i64data))+4);
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset+sizeof(long)],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset+sizeof(long);
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		//mov eax,LOLONG(i64data)
		OpBuffer[obp++]=(char)0xB8;
		*((long *)(OpBuffer+obp))=*(long *)(&i64data);
		obp+=sizeof(long);

		//mov dword ptr[ebp+offset],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if(type==DEF_LONG||type==DEF_DWORD||IsPtrType(type)){
		if(type==DEF_PTR_BYTE&&lpCalcIndex==LITERAL_STRING){
			//萔̂Ƃ

			char *temp;
			temp=(char *)i64data;
			i2=dataTable.AddString(temp,lstrlen(temp));
			HeapDefaultFree(temp);

			//mov eax,DataPos
			OpBuffer[obp++]=(char)0xB8;
			*((long *)(OpBuffer+obp))=(long)i2;
			pobj_DataTableSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov eax,InitValue
			OpBuffer[obp++]=(char)0xB8;
			*((long *)(OpBuffer+obp))=(long)i64data;
			obp+=sizeof(long);
		}

		//mov dword ptr[ebp+offset],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if(type==DEF_INTEGER||type==DEF_WORD || (isUnicode&&type==DEF_CHAR)){
		//mov ax,InitValue
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0xB8;
		*((WORD *)(OpBuffer+obp))=(WORD)i64data;
		obp+=sizeof(WORD);

		//mov word ptr[ebp+offset],ax
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
	}
	else if(type==DEF_SBYTE||type==DEF_BYTE||type==DEF_BOOLEAN || (isUnicode==false&&type==DEF_CHAR)){
		//mov byte ptr[ebp+offset],InitValue
		OpBuffer[obp++]=(char)0xC6;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);
		*((BYTE *)(OpBuffer+obp))=(BYTE)i64data;
		obp+=sizeof(BYTE);
	}
	//String^
	return 1;
}

void dim(char *Parameter,DWORD dwFlags){
	extern BOOL bCompilingGlobal;
	extern HANDLE hHeap;
	int i2,i3,VarSize;
	char VarName[VN_SIZE];


	//Qƌ^ǂ
	bool isRef = false;

	i2 = 0;

	if( Parameter[i2] == 1 && Parameter[i2+1] == ESC_BYREF ){
		//Qƌ^
		isRef = true;
		Parameter += 2;
	}


	if(dwFlags & DIMFLAG_CONST){
		//////////////////////////////////
		// 萔ϐ̏ꍇl
		//////////////////////////////////
		for(;;i2++){
			if(Parameter[i2] == '=' ||
				Parameter[i2] == 1 && Parameter[i2] == ESC_AS ||
				Parameter[i2] =='('){
					VarName[i2] = 0;
					break;
			}
			VarName[i2] = Parameter[i2];
		}

		//萔ƂQd`ĂȂꍇ͔o
		if(CDBConst::obj.GetType(VarName)){
			return;
		}

		//萔}NƂĒ`Ăꍇ͔o
		if(GetConstHash(VarName)){
			return;
		}
	}


	//\
	int SubScripts[MAX_ARRAYDIM];
	TYPEINFO TypeInfo;
	char InitBuf[8192];
	char ConstractParameter[VN_SIZE];
	if(!GetDimentionFormat(Parameter, isRef, VarName,SubScripts,&TypeInfo,InitBuf,ConstractParameter))
		return;


	//萔ƂQd`ĂȂ𒲂ׂ
	if(CDBConst::obj.GetType(VarName)){
		SetError(15,VarName,cp);
		return;
	}

	//萔}NƂĒ`Ăꍇ
	if(GetConstHash(VarName)){
		SetError(15,VarName,cp);
		return;
	}


	//^CvTCY擾
	int TypeSize;
	TypeSize=GetTypeSize(TypeInfo.type,TypeInfo.u.lpIndex);

	if(dwFlags&DIMFLAG_STATIC){
		if(bCompilingGlobal){
			SetError(60,NULL,cp);
			return;
		}

		/////////////////////
		// Staticϐ
		// "Static.Object.Method.Variable"
		/////////////////////

		char temporary[VN_SIZE];
		GetNowStaticVarFullName(VarName,temporary);

		AddGlobalVariable(temporary,SubScripts,&TypeInfo,TypeSize,InitBuf,ConstractParameter,dwFlags);

		/*
		Note: ÓIϐ̃RXgN^Ăяo
			_System_InitStaticLocalVariables֐ňꊇčs
		*/
	}
	else{
		if(bCompilingGlobal){
			/////////////////////////
			// O[oϐ
			/////////////////////////

			AddGlobalVariable(VarName,SubScripts,&TypeInfo,TypeSize,InitBuf,ConstractParameter,dwFlags);
		}
		else{
			/////////////////
			// [Jϐ
			/////////////////

			for(i2=0;i2<MaxLocalVarNum;i2++){
				if(LocalVar[i2].bLiving&&obj_LexScopes.GetNowLevel()==LocalVar[i2].ScopeLevel){
					if(lstrcmp(LocalVar[i2].name,VarName)==0){
						//Qd`̃G[
						SetError(15,VarName,cp);
						return;
					}
				}
			}

			LocalVar=(VARIABLE *)HeapReAlloc(hHeap,0,LocalVar,(MaxLocalVarNum+1)*sizeof(VARIABLE));
			VARIABLE *pVar = &LocalVar[MaxLocalVarNum];
			MaxLocalVarNum++;

			if( isRef ){
				//Qƌ^
				pVar->fRef = REF_VARIABLE;
				TypeSize = PTR_SIZE;
			}
			else pVar->fRef=0;

			for(i2=1,i3=0;i3<255;i3++){
				//zvf
				pVar->SubScripts[i3]=SubScripts[i3];

				if(SubScripts[i3]==-1) break;
				i2*=SubScripts[i3]+1;
			}
			VarSize=TypeSize*i2;
			if(VarSize%4) VarSize+=4-(VarSize%4);

			//ϐf[^ǉ
			lstrcpy(pVar->name,VarName);
			if(dwFlags & DIMFLAG_CONST) pVar->bConst = true;
			else pVar->bConst = false;
			if(SubScripts[0]==-1) pVar->bArray=0;
			else pVar->bArray=1;
			pVar->type=TypeInfo.type;
			pVar->u.index=TypeInfo.u.lpIndex;
			AllLocalVarSize+=VarSize;
			pVar->offset=AllLocalVarSize;

			//LVJXR[v
			pVar->ScopeLevel=obj_LexScopes.GetNowLevel();
			pVar->ScopeStartAddress=obj_LexScopes.GetStartAddress();
			pVar->bLiving=TRUE;

			if(InitBuf[0]){
				//̂݁A݃ANZX
				bool bConstBack = pVar->bConst;
				pVar->bConst = false;

				int result = InitLocalVar(-pVar->offset,
					pVar->type,
					pVar->u.index,
					pVar->SubScripts,
					InitBuf);

				if(!result){
					if( isRef ){
						SetRefVariable( VarName, InitBuf );
					}
					else{
						char temporary[8192];
						sprintf(temporary,"%s=%s",VarName,InitBuf);
						OpcodeCalc(temporary);
					}
				}

				pVar->bConst = bConstBack;
			}
			else{
				//push 0
				op_push_value(0);

				//push VarSize
				op_push_value(VarSize);

				//mov eax,ebp
				OpBuffer[obp++]=(char)0x8B;
				OpBuffer[obp++]=(char)0xC5;

				//add eax,offset
				OpBuffer[obp++]=(char)0x05;
				*((long *)(OpBuffer+obp))=-pVar->offset;
				AddLocalVarAddrSchedule();
				obp+=sizeof(long);

				//push eax
				op_push(REG_EAX);

				//call FillMemory
				OpBuffer[obp++]=(char)0xFF;
				OpBuffer[obp++]=(char)0x15;
				DECLAREINFO *pdi;
				pdi=GetDeclareHash("FillMemory");
				pdi->bUse=1;
				pobj_ImportAddrSchedule->add(pdi);
				obp+=sizeof(long);
			}
		}

		//RXgN^Ăяo
		if(TypeInfo.type==DEF_OBJECT&&(dwFlags&DIMFLAG_NONCALL_CONSTRACTOR)==0&& isRef == false ){
			CallConstructor(VarName,SubScripts,TypeInfo,ConstractParameter);
		}
	}

	if(TypeInfo.type==DEF_OBJECT){
		if(TypeInfo.u.pobj_Class->IsAbstract()){
			//ۃNXƂ
			SetError(125,TypeInfo.u.pobj_Class->name,cp);
		}
	}
}
void OpcodeDim(char *Parameter,DWORD dwFlags){
	int i,i2,i3,IsStr=0;
	char temporary[8192];

	for(i=0,i2=0;;i++,i2++){
		if(Parameter[i]=='\"') IsStr^=1;
		if(Parameter[i]=='('&&IsStr==0){
			i3=GetStringInPare(temporary+i2,Parameter+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		if(Parameter[i]=='['&&IsStr==0){
			i3=GetStringInBracket(temporary+i2,Parameter+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		if((Parameter[i]==','&&IsStr==0)||
			Parameter[i]=='\0'){
			temporary[i2]=0;

			dim(temporary,dwFlags);

			if(Parameter[i]=='\0') break;
			i2=-1;
			continue;
		}
		temporary[i2]=Parameter[i];
	}
}

void SetVarPtrToEax(RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//lea eax,dword ptr[ecx+offset]
			OpBuffer[obp++]=(char)0x8D;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov eax,offset
			OpBuffer[obp++]=(char)0xB8;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//lea eax,dword ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0x8D;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//lea eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8D;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_REFLOCAL){
		if(pRelativeVar->bOffsetOffset){
			//mov eax,ecx
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0xC1;

			//add eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelativeVar->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
		//mov eax,ecx
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0xC1;
	}
}
