#pragma once

class IncludedFilesRelation
{
	std::vector<std::string> filePaths;
	std::vector<int> lineFileNumbers;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - IncludedFilesRelation" );

		ar & BOOST_SERIALIZATION_NVP( filePaths );
		ar & BOOST_SERIALIZATION_NVP( lineFileNumbers );
	}

public:
	IncludedFilesRelation()
	{
	}
	~IncludedFilesRelation()
	{
	}

	const int GetFileNumber( int lineNumber ) const
	{
		return lineFileNumbers[lineNumber];
	}
	const std::string &GetFilePath( int lineNumber ) const
	{
		return filePaths[GetFileNumber( lineNumber )];
	}
	const std::string &GetFilePathFromFileNumber( int fileNumber ) const
	{
		return filePaths[fileNumber];
	}
	int GetFileCounts() const
	{
		return (int)filePaths.size();
	}

	int AddFile( const std::string &filePath )
	{
		filePaths.push_back( filePath );
		return (int)filePaths.size()-1;
	}
	void AddLine( int fileNumber )
	{
		lineFileNumbers.push_back( fileNumber );
	}

	int GetLineCounts() const
	{
		return (int)lineFileNumbers.size();
	}
};

class Text{
protected:
	char *buffer;
	int length;

public:

	Text(){
		buffer = (char *)calloc( 1, 1 );
		length = 0;
	}
	Text( const Text &text )
		: length( text.length )
	{
		buffer = (char *)malloc( length + 1 );
		memcpy( buffer, text.buffer, length );
		buffer[length] = 0;
	}
	~Text(){
		free( buffer );
	}
	void Clear()
	{
		length = 0;
	}
	void Add( const std::string &str )
	{
		buffer = (char *)realloc( buffer, length + str.size() + 1 );
		lstrcpy( buffer + length, str.c_str() );
		length += (int)str.size();
	}
	void Add( const std::vector<char> &str )
	{
		buffer = (char *)realloc( buffer, length + str.size() + 1 );
		lstrcpy( buffer + length, &str[0] );
		length += (int)str.size();
	}

	bool ReadFile( const std::string &filePath );

	static void Text::SlideString(char *buffer, int slide){
		char *temp;
		temp=(char *)malloc(lstrlen(buffer)+1);
		lstrcpy(temp,buffer);
		lstrcpy(buffer+slide,temp);
		free(temp);
	}
};

class BasicSource : public Text
{
	static const std::string generateDirectiveName;

	IncludedFilesRelation includedFilesRelation;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing(load) - BasicSource" );

		std::string _buffer;
		ar & BOOST_SERIALIZATION_NVP( _buffer );
		ar & BOOST_SERIALIZATION_NVP( length );
		ar & BOOST_SERIALIZATION_NVP( includedFilesRelation );

		// ǂݍ݌̏
		Realloc( length );
		for( int i=0; i<length; i++ )
		{
			ULONG_PTR l1 = ( ( _buffer[i*3] >= 'a' ) ? ( _buffer[i*3] - 'a' + 0x0a ) : ( _buffer[i*3] - '0' ) ) * 0x10;
			ULONG_PTR l2 = ( _buffer[i*3+1] >= 'a' ) ? ( _buffer[i*3+1] - 'a' + 0x0a ) : ( _buffer[i*3+1] - '0' );
			ULONG_PTR l = l1 + l2;
			buffer[i] = static_cast<char>(l);
		}
		buffer[length] = 0;
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		trace_for_serialize( "serializing(save) - BasicSource" );

		// ۑ
		char *tempCode = (char *)calloc( (length+1) * 3, 1 );
		for( int i=0; i<length; i++ )
		{
			char temp[32];
			sprintf( temp, "%02x,", (unsigned char)buffer[i] );
			tempCode[i*3] = temp[0];
			tempCode[i*3+1] = temp[1];
			tempCode[i*3+2] = temp[2];
		}

		std::string _buffer = tempCode;
		free( tempCode );

		ar & BOOST_SERIALIZATION_NVP( _buffer );
		ar & BOOST_SERIALIZATION_NVP( length );
		ar & BOOST_SERIALIZATION_NVP( includedFilesRelation );
	}

private:
	void Realloc( int newLength )
	{
		bool isEqualBasbuf = false;
		extern char *basbuf;
		if( basbuf == buffer + 2 )
		{
			isEqualBasbuf = true;
		}

		buffer = (char *)realloc( buffer, newLength + 255 );

		length = newLength;

		if( isEqualBasbuf )
		{
			basbuf = buffer + 2;
		}
	}

	void IncludeFiles();

	void ChangeReturnLineChar();

	void RemoveComments();

	bool ReadFile_InIncludeDirective( const std::string &filePath );
	void DirectiveIncludeOrRequire();

	void RemoveReturnLineUnderbar();

	void Initialize( const std::string &source );

public:
	BasicSource(){}
	BasicSource( const BasicSource &basicSource )
		: Text( basicSource )
		, includedFilesRelation( basicSource.includedFilesRelation )
	{
	}
	BasicSource( const std::string &source )
	{
		Initialize( source );
	}
	~BasicSource(){}

	char *GetBuffer(){
		return buffer+2;
	}
	const char *GetBuffer() const
	{
		return buffer+2;
	}
	int GetLength() const
	{
		return length-2;
	}
	void _ResetLength()
	{
		length = lstrlen( buffer );
	}

	const IncludedFilesRelation &GetIncludedFilesRelation() const
	{
		return includedFilesRelation;
	}

	void SetBuffer( const char *buffer );

	bool ReadFile( const std::string &filePath );

	void Addition( const char *buffer );

	bool GetLineInfo( int sourceCodePos, int &line, std::string &fileName ) const;

	void operator = ( const BasicSource &source ){
		Realloc( source.length );
		lstrcpy( buffer, source.buffer );
	}

	char operator[]( int index ) const
	{
		if( index>GetLength() )
		{
			Jenga::Throw( "BasicSource bad access" );
		}
		return buffer[2+index];
	}
};
typedef std::vector<BasicSource> BasicSources;
