#pragma once

class EnumMember
{
	std::string name;
	std::string value;
	int sourceIndex;
public:
	EnumMember( const std::string &name, const std::string &value, int sourceIndex )
		: name( name )
		, value( value )
		, sourceIndex( sourceIndex )
	{
	}
	const std::string &GetName() const
	{
		return name;
	}
	const std::string &GetValueStr() const
	{
		return value;
	}
	int GetSourceIndex() const
	{
		return sourceIndex;
	}
};

class EnumInfo
	: public Symbol
{

	BOOL bConst;

	std::vector<EnumMember> members;
public:

	EnumInfo( const NamespaceScopes &namespaceScopes, const std::string &name )
		: Symbol( namespaceScopes, name )
	{
	}

	const std::vector<EnumMember> &GetMembers() const
	{
		return members;
	}

	const EnumMember &GetEnumMember( const std::string &memberName ) const
	{
		BOOST_FOREACH( const EnumMember &member, members )
		{
			if( member.GetName() == memberName )
			{
				return member;
			}
		}
		throw;
	}

	std::vector<EnumMember> &GetEnumMembers()
	{
		return members;
	}
};

class EnumInfoCollection
	: public std::vector<EnumInfo>
{
public:
	const EnumInfo *Find( const Symbol &symbol ) const
	{
		const EnumInfoCollection &thisEnumInfoCollection = *this;
		BOOST_FOREACH( const EnumInfo &enumInfo, thisEnumInfoCollection )
		{
			if( enumInfo.IsEqualSymbol( symbol ) )
			{
				return &enumInfo;
			}
		}
		return NULL;
	};
};
