#include "stdafx.h"

using namespace ActiveBasic::Compiler;

void LexicalAnalyzer::AddTypeDef( TypeDefCollection &typeDefs, const NamespaceScopes &namespaceScopes, const std::string &expression, int nowLine )
{
	int i;
	char temporary[VN_SIZE];

	for(i=0;;i++){
		if(expression[i]=='='||expression[i]=='\0'){
			temporary[i]=0;
			break;
		}
		temporary[i]=expression[i];
	}

	if(expression[i]!='='){
		compiler.errorMessenger.Output(10,"TypeDef",nowLine);
		return;
	}

	const char *pTemp=expression.c_str()+i+1;

	//ʕ̃G[`FbNiV^j
	i=0;
	for(;;i++){
		if(temporary[i]=='\0') break;
		if( !( IsVariableChar( temporary[i], true) ) ){
			compiler.errorMessenger.Output(10,"TypeDef",nowLine);
			return;
		}
	}

	//ʕ̃G[`FbNiRs[̌^j
	if(pTemp[0]=='*'&&pTemp[1]==1&&(pTemp[2]==ESC_FUNCTION||pTemp[2]==ESC_SUB)){
		//֐|C^
		if(pTemp[3]!='('){
			compiler.errorMessenger.Output(10,"TypeDef",nowLine);
			return;
		}
	}
	else{
		i=0;
		while(pTemp[i]=='*') i++;
		for(;;i++){
			if(pTemp[i]=='\0') break;
			if( !( IsVariableChar( pTemp[i], true) ) )
			{
				compiler.errorMessenger.Output(10,"TypeDef",nowLine);
				return;
			}
		}
	}

	//ʎqdĂꍇ̓G[ɂ
	if(lstrcmp(temporary,pTemp)==0){
		compiler.errorMessenger.Output(1,NULL,nowLine);
		return;
	}



	//////////////////////////
	// TypeDefǉ
	//////////////////////////

	Type baseType;
	if( !compiler.StringToType( pTemp, baseType ) )
	{
		compiler.errorMessenger.Output(3, pTemp, nowLine );
		return;
	}

	typeDefs.push_back(
		TypeDef(
			namespaceScopes,
			temporary,
			pTemp,
			baseType
		)
	);
}
void LexicalAnalyzer::CollectTypeDefs( const char *source, TypeDefCollection &typeDefs )
{
	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection &importedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	importedNamespaces.clear();

	int i=-1, i2;
	char temporary[VN_SIZE];
	while(1){

		i++;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				compiler.errorMessenger.Output(64,temporary,i );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			importedNamespaces.clear();
			continue;
		}

		if( source[i]==1 ){
			char temporary[VN_SIZE];
			if(source[i+1]==ESC_TYPEDEF){
				int i2 = 0;
				for(i+=2;;i2++,i++){
					if(source[i]=='\n'){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=source[i];
					if(source[i]=='\0') break;
				}
				AddTypeDef( typeDefs, namespaceScopes, temporary, i );

				continue;
			}
			else if( source[i+1] == ESC_CONST && source[i+2] == 1 && source[i+3] == ESC_ENUM ){
				int i2 = 0;
				for(i+=4;;i2++,i++){
					if(!IsVariableChar(source[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=source[i];
					if(source[i]=='\0') break;
				}

				Type baseType;
				if( !compiler.StringToType( "Long", baseType ) )
				{
					throw;
				}

				typeDefs.push_back(
					TypeDef(
						namespaceScopes,
						temporary,
						"Long",
						baseType
					)
				);
			}
		}

		//̍s
		for(;;i++){
			if(IsCommandDelimitation(source[i])) break;
		}
		if(source[i]=='\0') break;
	}
}
