#include "stdafx.h"

using namespace ActiveBasic::Compiler;

void LexicalAnalyzer::AddConstEnum( Consts &consts, const NamespaceScopes &namespaceScopes, const char *buffer )
{
	extern int cp;
	int i=0,i2;

	if(!(buffer[i]==1&&buffer[i+1]==ESC_ENUM)) return;
	i+=2;

	//񋓑̖̂O擾
	char temporary[VN_SIZE];
	for(i2=0;;i++,i2++){
		if(IsCommandDelimitation(buffer[i])){
			temporary[i2]=0;
			break;
		}
		if(!IsVariableChar(buffer[i])){
			compiler.errorMessenger.Output(1,NULL,i);
			break;
		}
		temporary[i2]=buffer[i];
	}

	if(buffer[i]=='\0'){
		compiler.errorMessenger.Output(22,"Enum",cp);
		return;
	}

	int NextValue=0;
	while(1){
		i++;

		if(buffer[i]==1&&buffer[i+1]==ESC_ENDENUM) break;

		for(i2=0;;i2++,i++){
			if(IsCommandDelimitation(buffer[i])){
				temporary[i2]=0;
				break;
			}
			if(buffer[i]=='='){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
		if(temporary[0]=='\0'){
			if(buffer[i]=='\0'){
				compiler.errorMessenger.Output(22,"Enum",cp);
				break;
			}
			continue;
		}

		if(buffer[i]!='='){
			NextValue++;
		}
		else{
			char temp2[VN_SIZE];
			for(i++,i2=0;;i2++,i++){
				if(IsCommandDelimitation(buffer[i])){
					temp2[i2]=0;
					break;
				}
				temp2[i2]=buffer[i];
			}

			_int64 i64data;
			StaticCalculation(true, temp2,DEF_LONG,&i64data,Type());
			NextValue=(int)i64data;
		}

		//萔ǉ
		consts.Add( namespaceScopes, temporary, NextValue);
	}
}

void LexicalAnalyzer::CollectConsts( const char *source, Consts &consts, ConstMacros &constMacros )
{
	////////////////////////////////////////////
	// Const߂̏擾
	////////////////////////////////////////////

	int i2;
	char temporary[1024];

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	for(int i=0;;i++){
		if( source[i] == '\0' ) break;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}

		if( source[i] == 1 ){
			if(source[i]==1&&source[i+1]==ESC_CONST){
				i+=2;

				extern int cp;
				cp=i;	//G[p


				if(source[i]==1&&source[i+1]==ESC_ENUM){
					AddConstEnum( consts, namespaceScopes, source+i);
					continue;
				}

				for(i2=0;;i++,i2++){
					if(source[i]=='\"'){
						temporary[i2]=source[i];
						for(i++,i2++;;i++,i2++){
							temporary[i2]=source[i];
							if(source[i]=='\"') break;
						}
						continue;
					}
					if(IsCommandDelimitation(source[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=source[i];
				}

				//O擾
				char name[VN_SIZE];
				for(i2=0;;i2++){
					if(temporary[i2]=='\0'){
						compiler.errorMessenger.Output(10,"Const",cp);
						return;
					}
					if(temporary[i2]=='='||temporary[i2]=='('){
						name[i2]=0;
						break;
					}
					name[i2]=temporary[i2];
				}

				//d`FbN
				if( compiler.GetObjectModule().meta.GetGlobalConstMacros().IsExist( name )
					|| compiler.GetObjectModule().meta.GetGlobalConsts().IsExist( name ) )
				{
					compiler.errorMessenger.Output(15,name,cp);
					return;
				}

				if( temporary[i2] == '=' )
				{
					// 萔
					const char *expression = temporary + i2 + 1;
					consts.Add( namespaceScopes, name, expression );
				}
				else
				{
					// 萔}N
					const char *params = temporary + i2;
					constMacros.Add( namespaceScopes, name, params );
				}

				if(source[i]=='\0') break;
			}
			else{
				int result = JumpStatement( source, i );
				if( result == -1 ){
					//G[
					return;
				}
				else if( result == 1 ){
					//Wvꍇ
					i--;
				}
			}
		}
	}

	// Ce[^
	compiler.GetObjectModule().meta.GetGlobalConsts().Iterator_Init();
	compiler.GetObjectModule().meta.GetGlobalConstMacros().Iterator_Init();
}
