#pragma once

namespace ActiveBasic{ namespace Compiler{


class LexicalAnalyzer
{
	class SourceTemplate
	{
		std::string source;
	public:
		SourceTemplate( const std::string &filePath );
		~SourceTemplate()
		{
		}

		std::string GetResult( const std::map<std::string,std::string> &values );
	};

public:

	// OԂW
	static bool CollectNamespaces( const char *source, NamespaceScopesCollection &namespaceScopesCollection );

	// tl[ʎqV{ɕϊ
	static Symbol FullNameToSymbol( const char *fullName );
	static Symbol FullNameToSymbol( const std::string &fullName );

	// NX̖OW
	static void CollectClassesForNameOnly( const char *source, Classes &classes );

	// TypeDefW
	static void AddTypeDef( TypeDefCollection &typeDefs, const NamespaceScopes &namespaceScopes, const std::string &expression, int nowLine );
	static void CollectTypeDefs( const char *source, TypeDefCollection &typeDefs );

	// 萔W
	static void AddConstEnum( Consts &consts, const NamespaceScopes &namespaceScopes, const char *buffer );
	static void CollectConsts( const char *source, Consts &consts, ConstMacros &constMacros );

	// NXW
	static void AddMethod(CClass *pobj_c, UserProc *pUserProc, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
		bool isVirtual, bool isOverride, const char *interfaceName, bool isAutoGeneration, int nowLine);
	static bool Inherits( CClass &currentClass, const char *inheritNames, int nowLine );
	static bool Implements( CClass &currentClass, const char *interfaceNames, int nowLine );
	static void LookaheadClass( const char *className, Classes &classes );
	static bool LoopRefCheck( const CClass &objClass );
	static void CollectClasses( const char *source, Classes &classes );

	// O[ovV[WW
	static UserProc* ParseUserProc( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, char *buffer,int nowLine,bool isVirtual,CClass *pobj_c, bool isStatic, char *interfaceName = NULL );
	static void CollectProcedures( const BasicSource &source, UserProcs &userProcs, DllProcs &dllProcs );

	// fQ[gW
	static void CollectDelegates( const BasicSource &source, Delegates &delegates );
	static std::string GenerateDelegatesSourceCode( const Delegates &delegates );
	static void RefleshDelegatesParameterAndReturnType( Delegates &delegates );
};


}}
