#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../compiler_x64/opcode.h"
#else
#include "../compiler_x86/opcode.h"
#endif

using namespace ActiveBasic::Compiler;

int hash_default(const char *name){
	int key;

	for(key=0;*name!='\0';name++){
		key=((key<<8)+ *name )%MAX_HASH;
	}

	return key;
}

DllProc *GetDeclareHash(const char *fullName){
	char namespaceStr[VN_SIZE];		//IuWFNgϐ
	char simpleName[VN_SIZE];	//qo
	bool isObjectMember = SplitMemberName( fullName, namespaceStr, simpleName );

	///////////////////////////
	// O[o֐
	///////////////////////////

	// nbVl擾
	DllProc *pDllProc = compiler.GetObjectModule().meta.GetDllProcs().GetHashArrayElement( simpleName );
	while(pDllProc){
		if( pDllProc->IsEqualSymbol( LexicalAnalyzer::FullNameToSymbol( fullName ) ) ){
			return pDllProc;
		}

		pDllProc=pDllProc->GetChainNext();
	}

	return NULL;
}

void GetOverloadSubHash( const char *lpszName, std::vector<const UserProc *> &subs ){
	char name[VN_SIZE];

	if(lpszName[0]=='.'){
		GetWithName(name);
		lstrcat(name,lpszName);
	}
	else lstrcpy(name,lpszName);

	char ObjName[VN_SIZE];		//IuWFNgϐ
	char NestMember[VN_SIZE];	//qo
	bool isObjectMember = SplitMemberName( name, ObjName, NestMember );

	if(isObjectMember){
		//IuWFNg̃o֐̏ꍇ

		bool isStatic = false;
		const CClass *pobj_c = NULL;
		if(lstrcmpi(ObjName,"Super")==0)
		{
			//NXo֐NX̌Ăяo
			pobj_c=&compiler.GetCompilingClass().GetSuperClass();
		}
		else
		{
			//"->"ɂăIuWFNgw肷ʏ̃o֐Ăяo
			Type type;
			if( GetTermType(ObjName,type) )
			{
				if( type.IsObject() )
				{
					pobj_c = &type.GetClass();
				}
			}

			if( !pobj_c )
			{
				pobj_c=compiler.GetObjectModule().meta.GetClasses().Find(ObjName);
				if( pobj_c ){
					isStatic = true;
				}
			}
		}

		if( pobj_c && pobj_c != (CClass *)-1 ){
			if( isStatic ){
				// ÓI\bh
				pobj_c->GetStaticMethods().Enum( NestMember, subs );
			}
			else{
				//I\bh
				pobj_c->EnumDynamicMethodsOrInterfaceMethods( NestMember, subs );
			}

			return;
		}
	}


	if( compiler.IsCompilingClass() ){
		//g̃IuWFNg̃o֐

		// ÓI\bh
		compiler.GetCompilingClass().GetStaticMethods().Enum( name, subs );

		// I\bh
		compiler.GetCompilingClass().EnumDynamicMethodsOrInterfaceMethods( name, subs );
	}


	// O[o֐
	compiler.GetObjectModule().meta.GetUserProcs().EnumGlobalProcs( NestMember, name, subs );
}

//I[o[[hĂȂ֐擾î̃RpC\[XR[hƂ̌݊ێj
const UserProc *GetSubHash(const char *lpszName,BOOL bError){
	std::vector<const UserProc *> subs;
	GetOverloadSubHash(lpszName,subs);

	//֐݂ȂƂ
	if(subs.size() == 0){
		if(bError){
			compiler.errorMessenger.Output(3,lpszName,cp);
		}
		return 0;
	}

	//ȏ̊֐݂Ƃ͓G[ifobOpj
	if(subs.size() > 1){
		if(bError) compiler.errorMessenger.Output(300,NULL,cp);
	}

	const UserProc *pUserProc = subs[0];

	return pUserProc;
}
const UserProc *GetMethodHash(const char *ObjectName,const char *MethodName,const char *Parameter,BOOL bError){
	char temporary[VN_SIZE];
	sprintf(temporary,"%s.%s",ObjectName,MethodName);

	std::vector<const UserProc *> subs;
	GetOverloadSubHash(temporary,subs);

	//֐݂ȂƂ
	if(subs.size() == 0){
		return 0;
	}

	//I[o[[h
	const UserProc *pUserProc = OverloadSolutionWithStrParam(temporary,subs,Parameter,ObjectName);

	return pUserProc;
}

const UserProc *GetClassMethod( const char *className, const char *methodName ){
	const CClass *pClass = compiler.GetObjectModule().meta.GetClasses().Find( className );
	if( pClass ){
		std::vector<const UserProc *> userProcs;
		pClass->EnumDynamicMethodsOrInterfaceMethods( methodName, userProcs );
		if( userProcs.size() == 1 ){
			return userProcs[0];
		}
	}

	char temporary[VN_SIZE];
	sprintf( temporary, "%s.%s", className, methodName );
	compiler.errorMessenger.Output(3, temporary, -1 );

	return NULL;
}
