#pragma once

class Compiler
{
public:
	// ^[Qbg
	enum TargetModuleType
	{
		Exe,
		Dll,
		StaticLibrary,
	};

private:
	// rh̃tO
	bool isBuildSuccessful;

	// W[
	std::string moduleName;

	// W[ ^Cv
	TargetModuleType targetModuleType;

	// fobO rhǂ
	bool isDebug;

	// UnicodeΉW[ǂ
	bool isUnicode;

	// OԃT|[g
	NamespaceSupporter namespaceSupporter;

	// RpCUserProc/CClass
	const UserProc *pCompilingUserProc;
	const CClass *pCompilingClass;

	// IuWFNgW[
	ObjectModule *pObjectModule;
	ObjectModule *pNowObjectModule;

public:

	Compiler()
		: isBuildSuccessful( false )
		, pObjectModule( new ObjectModule )
		, targetModuleType( Exe )
		, isDebug( false )
		, isUnicode( false )
		, isCore( false )
	{
		SelectObjectModule( *pObjectModule );
		Symbol::RegistNamespaceSupporter( &namespaceSupporter );
	}
	~Compiler()
	{
		delete pObjectModule;
		Clear();
	}
	void Clear()
	{
		BOOST_FOREACH( ObjectModule *pStaticLibrary, staticLibraries )
		{
			delete pStaticLibrary;
		}
		staticLibraries.clear();
	}

	void StaticLink( ObjectModules &staticLibraries );

	// rh̃tO
	bool IsBuildSuccessful() const
	{
		return isBuildSuccessful;
	}
	void BuildSuccessful()
	{
		isBuildSuccessful = true;
	}

	// W[
	void SetModuleName( const std::string &moduleName )
	{
		this->moduleName = moduleName;
	}
	const std::string &GetModuleName() const
	{
		return moduleName;
	}

	// OԃT|[g
	NamespaceSupporter &GetNamespaceSupporter()
	{
		return namespaceSupporter;
	}

	// bZW[
	Messenger messenger;
	ErrorMessenger errorMessenger;

	// R[h@\
	CodeGenerator codeGenerator;

	// J
	Linker linker;

	// ÓINIuWFNgt@C
	std::vector<std::string> staticLibraryFilePaths;

	// ÓINIuWFNgW[
	ObjectModules staticLibraries;

	// IuWFNgW[
	ObjectModule &GetObjectModule()
	{
		return *pNowObjectModule;
	}
	void SelectObjectModule( ObjectModule &objectModule )
	{
		pNowObjectModule = &objectModule;

		namespaceSupporter.RegistAllNamespaceScopesCollection( &GetObjectModule().meta.GetNamespaces() );
	}

	bool IsExe() const
	{
		if( targetModuleType == Exe )
		{
			return true;
		}
		return false;
	}
	bool IsDll() const
	{
		if( targetModuleType == Dll )
		{
			return true;
		}
		return false;
	}
	bool IsStaticLibrary() const
	{
		if( targetModuleType == StaticLibrary )
		{
			return true;
		}
		return false;
	}
	void SetTargetModuleType( TargetModuleType targetModuleType )
	{
		this->targetModuleType = targetModuleType;
	}

	void SetDebugMark( bool isDebug )
	{
		this->isDebug = isDebug;
	}
	bool IsDebug() const
	{
		return isDebug;
	}

	void SetUnicodeMark( bool isUnicode )
	{
		this->isUnicode = isUnicode;
	}
	bool IsUnicode()
	{
		return isUnicode;
	}


	// RAW[ǂ
	bool isCore;
	void SetCoreMark( bool isCore )
	{
		this->isCore = isCore;
	}
	bool IsCore() const
	{
		return isCore;
	}

	// O[oGAu֐
	std::string globalAreaProcName;

	// 񋓌^
	EnumInfoCollection enumInfoCollection;


	bool StringToType( const std::string &typeName, Type &type );
	const std::string TypeToString( const Type &type );

	void ClearCompilingUserProcAndClass();
	void SetCompilingClass( const CClass *pClass );
	void StartProcedureCompile( const UserProc *pUserProc );
	void FinishProcedureCompile();

	bool IsGlobalAreaCompiling();
	const UserProc &GetCompilingUserProc();
	bool IsCompilingClass();
	const CClass &GetCompilingClass();
};

extern Compiler compiler;
