#pragma once

class Variable : public Symbol
{
	Type type;
	bool isConst;
	bool isRef;
	bool isArray;
	Subscripts subscripts;

	bool isParameter;
	bool hasInitData;

	//RXgN^pp[^
	std::string paramStrForConstructor;


	/* --- ItZbg ---
		O[oϐŏobt@Ȃꍇ͍ŏʃrbg1ZbgA
		obt@̗LʂB
		ǐAXPW[sɂAۂ̔zuɕёւj*/
	int offset;


	//LVJXR[vp
	int scopeStartAddress;
	int scopeEndAddress;
	int scopeLevel;


	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Variable" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Symbol );
		ar & BOOST_SERIALIZATION_NVP( type );
		ar & BOOST_SERIALIZATION_NVP( isConst );
		ar & BOOST_SERIALIZATION_NVP( isRef );
		ar & BOOST_SERIALIZATION_NVP( isArray );
		ar & BOOST_SERIALIZATION_NVP( subscripts );
		ar & BOOST_SERIALIZATION_NVP( isParameter );
		ar & BOOST_SERIALIZATION_NVP( hasInitData );
		ar & BOOST_SERIALIZATION_NVP( paramStrForConstructor );
		ar & BOOST_SERIALIZATION_NVP( offset );
		ar & BOOST_SERIALIZATION_NVP( scopeStartAddress );
		ar & BOOST_SERIALIZATION_NVP( scopeEndAddress );
		ar & BOOST_SERIALIZATION_NVP( scopeLevel );
	}

public:
	Variable( const std::string &name, const Type &type, bool isConst, bool isRef, const std::string &paramStrForConstructor, bool hasInitData );
	Variable( const NamespaceScopes &namespaceScopes, const std::string &name, const Type &type, bool isConst, bool isRef, const std::string &paramStrForConstructor, bool hasInitData );
	Variable( const Variable &var );
	Variable();

	void SetArray( const Subscripts &subscripts ){
		isArray = true;
		this->subscripts = subscripts;
	}

	const Type &GetType() const
	{
		return type;
	}
	void ConstOff(){
		isConst = false;
	}
	void ConstOn(){
		isConst = true;
	}
	bool IsConst() const
	{
		return isConst;
	}
	bool IsRef() const
	{
		return isRef;
	}
	bool IsArray()const
	{
		return isArray;
	}
	const Subscripts &GetSubscripts() const
	{
		return subscripts;
	}

	void ThisIsParameter(){
		isParameter = true;
	}
	bool IsParameter() const
	{
		return isParameter;
	}
	bool HasInitData() const
	{
		return hasInitData;
	}


	int GetMemorySize() const
	{
		if( isRef || isParameter ){
			return PTR_SIZE;
		}

		int size = type.GetSize();

		if( isArray ){
			int num = 1;
			for( int i=0; i<(int)subscripts.size(); i++){
				num *= subscripts[i]+1;
			}
			size *= num;
		}

		if( size % PTR_SIZE ){
			size += PTR_SIZE-(size%PTR_SIZE);
		}

		return size;
	}

	int GetOffsetAddress() const
	{
		return offset;
	}
	void SetOffsetAddress( int offset )
	{
		this->offset = offset;
	}

	const std::string &GetParamStrForConstructor() const
	{
		return paramStrForConstructor;
	}

	//LVJXR[vp
	int GetScopeStartAddress() const
	{
		return scopeStartAddress;
	}
	void SetScopeStartAddress( int scopeStartAddress )
	{
		this->scopeStartAddress = scopeStartAddress;
	}
	int GetScopeEndAddress() const
	{
		return scopeEndAddress;
	}
	void SetScopeEndAddress( int scopeEndAddress )
	{
		this->scopeEndAddress = scopeEndAddress;
	}
	int GetScopeLevel() const
	{
		return scopeLevel;
	}
	void SetScopeLevel( int scopeLevel )
	{
		this->scopeLevel = scopeLevel;
	}


	bool isLiving;
	int source_code_address;


	static int GetSubScriptCounts( const Subscripts &subscripts ){
		// z̗vf擾
		int i,i2;
		for(i=0,i2=1;i<(int)subscripts.size();i++){
			i2 *= subscripts[i]+1;
		}
		return i2;
	}
};

class Variables : public std::vector<Variable *>
{
protected:
	int allSize;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Variables" );

		ar & boost::serialization::make_nvp("vector_Variable", boost::serialization::base_object<vector<Variable *>>(*this));
	}

public:
	Variables()
		: allSize( 0 )
	{
	}
	~Variables(){
		Clear();
	}

	void Clear(){
		for( int i=0; i<(int)this->size(); i++ ){
			delete (*this)[i];
		}

		allSize = 0;
		clear();
	}
	void PullOutAll()
	{
		clear();
	}

	int GetAllSize() const
	{
		return allSize;
	}

	bool DuplicateCheck( const Symbol &symbol ) const;

	const Variable *BackSearch( const Symbol &symbol ) const;
	const Variable *Find( const Symbol &symbol )const;
};

class GlobalVars : public Variables
{
public:
	Jenga::Common::Binary initAreaBuffer;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - GlobalVars" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Variables );
		ar & BOOST_SERIALIZATION_NVP( initAreaBuffer );
	}
public:
	GlobalVars()
	{
	}
	~GlobalVars()
	{
	}

	void Add( Variable *pVar, bool isResetOffsetAddress = true );
};
