#pragma once

namespace Jenga{ namespace Common{


class Binary
{
	int allocateSize;
	char *buffer;
	int size;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		std::string _buffer;
		ar & BOOST_SERIALIZATION_NVP( _buffer );
		ar & BOOST_SERIALIZATION_NVP( size );

		// ǂݍ݌̏
		Realloc( size );
		for( int i=0; i<size; i++ )
		{
			ULONG_PTR l1 = ( ( _buffer[i*3] >= 'a' ) ? ( _buffer[i*3] - 'a' + 0x0a ) : ( _buffer[i*3] - '0' ) ) * 0x10;
			ULONG_PTR l2 = ( _buffer[i*3+1] >= 'a' ) ? ( _buffer[i*3+1] - 'a' + 0x0a ) : ( _buffer[i*3+1] - '0' );
			ULONG_PTR l = l1 + l2;
			buffer[i] = static_cast<char>(l);
		}
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		// ۑ
		char *tempCode = (char *)calloc( (size+1) * 3, 1 );
		for( int i=0; i<size; i++ )
		{
			char temp[32];
			sprintf( temp, "%02x,", (unsigned char)buffer[i] );
			tempCode[i*3] = temp[0];
			tempCode[i*3+1] = temp[1];
			tempCode[i*3+2] = temp[2];
		}

		std::string _buffer = tempCode;
		free( tempCode );

		ar & BOOST_SERIALIZATION_NVP( _buffer );
		ar & BOOST_SERIALIZATION_NVP( size );
	}

	void Realloc( int newSize )
	{
		if( allocateSize < newSize + 8192 )
		{
			while( allocateSize < newSize + 8192 )
			{
				allocateSize += 8192;
			}
			buffer = (char *)realloc( buffer, allocateSize );

			// Ċmۂ0Ŗ߂
			memset( buffer + size, 0, allocateSize - size );
		}
	}

public:
	Binary()
		: allocateSize( 8192 )
		, buffer( (char *)malloc( allocateSize ) )
		, size( 0 )
	{
	}
	Binary( const char *buffer, int size )
		: allocateSize( 8192 )
		, buffer( (char *)malloc( allocateSize ) )
		, size( 0 )
	{
		Put( buffer, size );
	}
	~Binary()
	{
		free( buffer );
	}

	void Clear()
	{
		size = 0;
	}

	const char *GetBuffer() const
	{
		return buffer;
	}
	int GetSize() const
	{
		return size;
	}
	void Resize( int newSize )
	{
		Realloc( newSize );
		size = newSize;
	}

	long GetLong( int pos ) const
	{
		return *(long *)( buffer + pos );
	}

	void Overwrite( int pos, const char *buffer, int size )
	{
		memcpy( this->buffer + pos, buffer, size );
	}
	void Overwrite( int pos, char c )
	{
		buffer[pos] = c;
	}
	void Overwrite( int pos, long newLongValue )
	{
		*(long *)( buffer + pos ) = newLongValue;
	}
	void Overwrite( int pos, _int64 newInt64Value )
	{
		*(_int64 *)( buffer + pos ) = newInt64Value;
	}

	void Put( const char *buffer, int size )
	{
		Realloc( this->size + size );

		memcpy( this->buffer + this->size, buffer, size );
		this->size += size;
	}
	void Put( double dbl )
	{
		Put( (const char *)(&dbl), sizeof(double) );
	}
	void Put( float flt )
	{
		Put( (const char *)(&flt), sizeof(float) );
	}
	void Put( _int64 i64data )
	{
		Put( (const char *)(&i64data), sizeof(_int64) );
	}
	void Put( long l )
	{
		Realloc( size + sizeof(long) );
		*((long *)(buffer+size))=l;
		size += sizeof(long);
	}
	void Put( short s )
	{
		Realloc( size + sizeof(short) );
		*((short *)(buffer+size))=s;
		size += sizeof(short);
	}
	void Put( char c )
	{
		Realloc( size + 1 );
		buffer[size++] = c;
	}
};


}}
