#include "stdafx.h"

#include "../BasicCompiler_Common/common.h"

#define STRING_SYSTEM_DECLAREHANDLE "*_System_DeclareHandle_"
void DifferentTypeError( const Type &varType, const Type &calcFormalType, const int iWarning,const char *pszFuncName,const int ParmNum){
	//////////////////////////
	// LXgɊւx
	//////////////////////////
	char temporary[255];
	Type calcType( calcFormalType );

	if(IS_LITERAL(calcType.GetIndex()))
	{
		calcType.SetIndex( -1 );
	}

	if(pszFuncName)
		sprintf(temporary,"\"%s\"̑%dp[^A",pszFuncName,ParmNum+1);
	else temporary[0]=0;

	std::string varTypeName = compiler.TypeToString( varType );
	if(memcmp( varTypeName.c_str(),STRING_SYSTEM_DECLAREHANDLE,lstrlen(STRING_SYSTEM_DECLAREHANDLE))==0)
	{
		varTypeName = varTypeName.substr( lstrlen(STRING_SYSTEM_DECLAREHANDLE) );
	}

	std::string calcTypeName = compiler.TypeToString( calcType );
	if(memcmp( calcTypeName.c_str(),STRING_SYSTEM_DECLAREHANDLE,lstrlen(STRING_SYSTEM_DECLAREHANDLE))==0)
	{
		calcTypeName = calcTypeName.substr( lstrlen(STRING_SYSTEM_DECLAREHANDLE) );
	}
	sprintf(temporary+lstrlen(temporary),"%s%s",calcTypeName.c_str(),varTypeName.c_str());

	extern int cp;
	if(iWarning==1) compiler.errorMessenger.Output(-101,temporary,cp);
 	else if(iWarning==2) compiler.errorMessenger.Output(-102,temporary,cp);
 	else if(iWarning==3) compiler.errorMessenger.Output(50,temporary,cp);
}

bool CheckDifferentType( const Type &varType,const Type &calcFormalType,const char *pszFuncName,const int ParmNum)
{
	Type calcType( calcFormalType );

	if( varType.IsStruct() || calcType.IsStruct() )
	{
		//ꂩ\̏ꍇ
		if( !varType.Equals( calcType ) )
		{
			DifferentTypeError( varType, calcType,3,pszFuncName,ParmNum);
			return false;
		}
	}

	if( varType.IsObject() || calcType.IsObject() )
	{
		//ꂩIuWFNgł͂Ȃꍇ
		if( (!varType.IsObject()) || (!calcType.IsObject()) )
		{
			DifferentTypeError( varType, calcType,3,pszFuncName,ParmNum);
			return false;
		}

		if( varType.IsDelegate() && calcType.IsDelegate() )
		{
			// fQ[gm̔ȑꍇ
			// ϖ߂lyєӈT|[g邱
			if( !varType.GetClass().GetDelegate().IsSimilar( calcType.GetClass().GetDelegate() ) )
			{
				// ƌȂȂƂ
				DifferentTypeError( varType, calcType,3,pszFuncName,ParmNum);
				return false;
			}
		}
		else
		{
			// ʓIȃNX̔ȑꍇ

			if( !varType.GetClass().IsEqualsOrSubClass( &calcType.GetClass() ) )
			{
				//ȂAhNXłȂƂ
				DifferentTypeError( varType, calcType,3,pszFuncName,ParmNum);
				return false;
			}
		}
	}

	if( calcType.GetBasicType() & FLAG_PTR )
	{
		//z擪tOĂꍇ́A|C^^ƂĈ
		calcType.SetBasicType( MAKE_PTR_TYPE(NATURAL_TYPE(calcType.GetBasicType()),PTR_LEVEL(calcType.GetBasicType())+1) );
	}

	if( varType.IsPointer() || calcType.IsPointer() )
	{
		/* EӋyэӂ̂ꂩ|C^^̏ꍇ́A
			^`FbNsB
		E̎ނ̃|C^^ȊO̓G[Ƃ */

		if( varType.IsPointer() && calcType.GetIndex() == LITERAL_NULL )
		{
			//eNULLl̏ꍇ
			return true;
		}

		if( varType.IsVoidPtr() )
		{
			//ӂVoidPtr^̏ꍇ́A|C^^ׂĂ󂯓
			if( calcType.IsPointer() )
			{
				return true;
			}
		}

		if( calcType.IsVoidPtr() )
		{
			//EӂVoidPtr^̏ꍇ́A|C^^ׂĂ󂯓
			if( varType.IsPointer() )
			{
				return true;
			}
		}

		if( varType.GetBasicType() != calcType.GetBasicType() )
		{
			DifferentTypeError( varType, calcType, 2,pszFuncName,ParmNum);
			return true;
		}

		if( varType.IsObjectPtr() )
		{
			//oIuWFNg|C^^̏ꍇ
			if( varType.GetIndex() != calcType.GetIndex() )
			{
				const CClass *pobj_tempClass = &calcType.GetClass();
				while(pobj_tempClass&&(!IS_LITERAL((LONG_PTR)pobj_tempClass))){
					pobj_tempClass=&pobj_tempClass->GetSuperClass();

					if( &varType.GetClass() == pobj_tempClass )
					{
						//p悪Ƃ
						return true;
					}
				}
				DifferentTypeError( varType, calcType, 2,pszFuncName,ParmNum);
				return true;
			}
		}
	}

	if( varType.IsDouble() )
	{
		if( calcType.Is64() )
		{
			//64rbgl̏ꍇ͌xo
			DifferentTypeError( varType, calcType, 1,pszFuncName,ParmNum);
		}
	}
	else if( varType.IsSingle() )
	{
		if( calcType.Is64() || calcType.IsDouble() )
		{
			//64rbglA܂Double^̏ꍇ͌xo
			DifferentTypeError( varType, calcType, 1,pszFuncName,ParmNum);
		}
	}
	else if( varType.GetSize() == sizeof(char) )
	{
		if( calcType.GetSize() > sizeof(char)
			&& calcType.GetIndex() != LITERAL_NULL
			&& calcType.GetIndex() != LITERAL_M128_0
			&& calcType.GetIndex() != LITERAL_0_255 )
		{
			//8rbgl傫Ȍ^ŁAelłȂꍇ͌xo
			DifferentTypeError( varType, calcType, 1,pszFuncName,ParmNum);
		}
	}
	else if( varType.GetSize() == sizeof(short) )
	{
		if( calcType.GetSize() > sizeof(short)
			&& calcType.GetIndex() != LITERAL_NULL
			&& calcType.GetIndex() != LITERAL_M128_0
			&& calcType.GetIndex() != LITERAL_0_255
			&& calcType.GetIndex() != LITERAL_M32768_0
			&& calcType.GetIndex() != LITERAL_0_65535 )
		{
			//16rbgl傫Ȍ^ŁAelłȂꍇ͌xo
			DifferentTypeError( varType, calcType, 1,pszFuncName,ParmNum);
		}
	}
	else if( varType.GetSize() == sizeof(long) )
	{
		if( calcType.IsReal()
			|| ( calcType.IsWhole() && calcType.GetSize() > sizeof(long) && calcType.GetIndex() != LITERAL_NULL ) )
		{
			/* 32rbgl傫Ȍ^A܂͎A
					܂̓elłȂꍇ͌xo */
			DifferentTypeError( varType, calcType, 1,pszFuncName,ParmNum);
		}
	}
	else if( varType.GetSize() == sizeof(_int64) )
	{
		if( calcType.IsReal() )
		{
			//̏ꍇ͌xo
			DifferentTypeError( varType, calcType, 1,pszFuncName,ParmNum);
		}
	}

	return true;
}
