#include "stdafx.h"

#include <Delegate.h>

void Delegate::RefleshParameterAndReturnType()
{
	compiler.GetNamespaceSupporter().SetImportedNamespaces( this->importedNamespaces );
	compiler.GetNamespaceSupporter().SetLivingNamespaceScopes( this->GetNamespaceScopes() );

	// p[^
	params.Analyze( paramStr.c_str(), sourceIndex );

	// Ip[^
	dynamicParams = params;
	dynamicParams.insert( dynamicParams.begin(), new Parameter( "_System_LocalThis", Type( DEF_PTR_VOID ) ) );

	if( IsFunction() )
	{
		// ߂l擾
		if( !compiler.StringToType( returnTypeName, returnType ) )
		{
			compiler.errorMessenger.Output(3,returnTypeName,sourceIndex);
		}
	}
}

bool Delegate::IsSimilar( const Delegate &dgt ) const
{
	if( this->Params().Equals( dgt.Params(), true ) )			// p[^A͔
	{
		if( this->returnType.Equals( dgt.returnType ) )
		{
			// ߂l
			return true;
		}
		else if( this->returnType.IsCovariant( dgt.returnType ) )
		{
			// ߂l
			return true;
		}
	}
	return false;
}
