#pragma once

#include <string>
#include <vector>

#include <option.h>
#include <Program.h>

class CClass;

class CMember : public MemberPrototype
{
	std::string name;
	Type type;
	bool isConst;
	Subscripts subscripts;

	std::string initializeExpression;
	std::string constructParameter;

	// XMLVACYp
	// TODO: xml
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - CMember" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( MemberPrototype );
		ar & BOOST_SERIALIZATION_NVP( name );
		ar & BOOST_SERIALIZATION_NVP( type );
		ar & BOOST_SERIALIZATION_NVP( isConst );
		ar & BOOST_SERIALIZATION_NVP( subscripts );
		ar & BOOST_SERIALIZATION_NVP( initializeExpression );
		ar & BOOST_SERIALIZATION_NVP( constructParameter );
	}

public:

	int source_code_address;

	const std::string &GetName() const
	{
		return name;
	}
	void SetName( const std::string &name )
	{
		this->name = name;
	}

	const Type &GetType() const
	{
		return type;
	}
	void ResetType( const Type &type )
	{
		this->type = type;
	}

	bool IsConst() const
	{
		return isConst;
	}

	const Subscripts &GetSubscripts() const
	{
		return subscripts;
	}

	const std::string &GetInitializeExpression() const
	{
		return initializeExpression;
	}
	const std::string &GetConstructParameter() const
	{
		return constructParameter;
	}

	CMember( Prototype::Accessibility accessibility, const std::string &name, const Type &newType, bool isConst, const Subscripts &subscripts, const std::string &initializeExpression, const std::string &constructParameter )
		: MemberPrototype( accessibility )
		, name( name )
		, type( newType )
		, isConst( isConst )
		, subscripts( subscripts )
		, initializeExpression( initializeExpression )
		, constructParameter( constructParameter )
	{
	}
	CMember::CMember(CMember &member)
		: MemberPrototype( member.GetAccessibility() )
		, name( member.GetName() )
		, type( member.GetType() )
		, isConst( member.IsConst() )
		, subscripts( member.GetSubscripts() )
	{
		//\[XR[ḧʒu
		source_code_address=member.source_code_address;
	}
	CMember()
	{
	}
	~CMember()
	{
	}
};
typedef std::vector<CMember *> Members;
