#pragma once

#include <option.h>
#include <Program.h>
#include <Class.h>
#include <Procedure.h>
#include <Parameter.h>
#include <Variable.h>
#include <CodeGenerator.h>
#include <Source.h>

class CClass;
class Interface;
class CMethod;

class Procedure : public Symbol
{
public:
	// 
	enum Kind{
		Sub,
		Function,
	};

private:
	Kind kind;

	bool isCdecl;
	mutable bool isUsing;

protected:

	// p[^
	Parameters params;

	// ߂ľ^
	Type returnType;

	// \[XR[ḧʒu
	int codePos;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Procedure" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Symbol );
		ar & BOOST_SERIALIZATION_NVP( kind );
		ar & BOOST_SERIALIZATION_NVP( isCdecl );
		ar & BOOST_SERIALIZATION_NVP( isUsing );
		ar & BOOST_SERIALIZATION_NVP( params );
		ar & BOOST_SERIALIZATION_NVP( returnType );
		ar & BOOST_SERIALIZATION_NVP( codePos );
	}

public:
	Procedure( const NamespaceScopes &namespaceScopes, const std::string &name, Kind kind, bool isCdecl )
		: Symbol( namespaceScopes, name )
		, kind( kind )
		, isCdecl( isCdecl )
		, isUsing( false )
		, codePos( -1 )
	{
	}
	Procedure()
	{
	}
	~Procedure(){
		BOOST_FOREACH( Parameter *pParam, params ){
			delete pParam;
		}
	}

	bool IsSub() const
	{
		return ( kind == Sub );
	}
	bool IsFunction() const
	{
		return ( kind == Function );
	}

	bool IsCdecl() const
	{
		return isCdecl;
	}
	void Using() const
	{
		isUsing = true;
	}
	bool IsUsing() const
	{
		return isUsing;
	}

	int GetCodePos() const
	{
		return codePos;
	}

	const Parameters &Params() const
	{
		return params;
	}
	const Type &ReturnType() const
	{
		return returnType;
	}
};

class UserProc : public Procedure, public Jenga::Common::ObjectInHashmap<UserProc>
{
public:
	std::string _paramStr;

private:
	NamespaceScopesCollection importedNamespaces;

	// eNXƑΉ郁\bh
	const CClass *pParentClass;
	const Interface *pInterface;
	CMethod *pMethod;

	bool isMacro;

	// p[^̒ǉ
	int secondParmNum;
	Parameters realParams;
	int realSecondParmNum;

	// etO
	bool isExport;
	mutable bool isSystem;
	mutable bool isAutoGeneration;
	mutable bool isCompiled;

	mutable DWORD beginOpAddress;
	mutable DWORD endOpAddress;

	// [Jϐ
	mutable Variables localVars;

	// ID
	int id;

	// lCeBuR[h
	NativeCode nativeCode;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - UserProc" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );
		ar & BOOST_SERIALIZATION_NVP( _paramStr );
		ar & BOOST_SERIALIZATION_NVP( importedNamespaces );
		ar & boost::serialization::make_nvp("pParentClass", const_cast<CClass *&>(pParentClass) );
		ar & boost::serialization::make_nvp("pInterface", const_cast<Interface *&>(pInterface) );
		ar & BOOST_SERIALIZATION_NVP( pMethod );
		ar & BOOST_SERIALIZATION_NVP( isMacro );
		ar & BOOST_SERIALIZATION_NVP( secondParmNum );
		ar & BOOST_SERIALIZATION_NVP( realParams );
		ar & BOOST_SERIALIZATION_NVP( realSecondParmNum );
		ar & BOOST_SERIALIZATION_NVP( isExport );
		ar & BOOST_SERIALIZATION_NVP( isSystem );
		ar & BOOST_SERIALIZATION_NVP( isAutoGeneration );
		ar & BOOST_SERIALIZATION_NVP( isCompiled );
		ar & BOOST_SERIALIZATION_NVP( beginOpAddress );
		ar & BOOST_SERIALIZATION_NVP( endOpAddress );
		ar & BOOST_SERIALIZATION_NVP( localVars );
		ar & BOOST_SERIALIZATION_NVP( id );
		ar & BOOST_SERIALIZATION_NVP( nativeCode );
	}

public:

	UserProc( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const std::string &name, Kind kind, bool isMacro, bool isCdecl, bool isExport )
		: Procedure( namespaceScopes, name, kind, isCdecl )
		, importedNamespaces( importedNamespaces )
		, pParentClass( NULL )
		, pInterface( NULL )
		, pMethod( NULL )
		, isMacro( isMacro )
		, secondParmNum( 0 )
		, realSecondParmNum( 1 )
		, isExport( isExport )
		, isSystem( false )
		, isAutoGeneration( false )
		, isCompiled( false )
		, beginOpAddress( 0 )
		, endOpAddress( 0 )
	{
		static int id_base=0;
		id = ( id_base ++ );
	}
	UserProc()
	{
	}
	~UserProc()
	{
		BOOST_FOREACH( Parameter *pParam, realParams ){
			delete pParam;
		}
	}

	void SetReturnType( const Type &newReturnType )
	{
		returnType = newReturnType;
	}

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}

	virtual bool IsDuplication( const UserProc *pUserProc ) const
	{
		if( this->GetParentClassPtr() == pUserProc->GetParentClassPtr()	// eNX
			&& this->pInterface == pUserProc->pInterface				// C^[tFCX
			&& pUserProc->IsEqualSymbol( *this )						// OԋyіO
			&& this->Params().Equals( pUserProc->Params() )				// p[^
			&& this->returnType.Equals( pUserProc->returnType ) )		// ߂l
		{
			return true;
		}
		return false;
	}

	/*!
	@brief	I[o[ChpɊ֐mǂ`FbN
	@param	actualTypeParametersForThisProc thisIuWFNgŕۗL郁\bhΏۂƂ^p[^
			pUserProc Ƃ炵킹֐
	*/
	bool IsEqualForOverride( const Types &actualTypeParametersForThisProc, const UserProc *pUserProc ) const;

	bool IsMacro() const
	{
		return isMacro;
	}

	int GetSecondParmNum() const
	{
		return secondParmNum;
	}
	const Parameters &RealParams() const
	{
		return realParams;
	}
	void SetRealParams( const Parameters &params )
	{
		realParams = params;
	}
	int GetRealSecondParmNum() const
	{
		return realSecondParmNum;
	}

	void ExportOff(){
		isExport = false;
	}
	bool IsExport() const
	{
		return isExport;
	}
	void ThisIsSystemProc() const
	{
		isSystem = true;
	}
	bool IsSystem() const
	{
		return isSystem;
	}
	void ThisIsAutoGenerationProc() const
	{
		isAutoGeneration = true;
	}
	bool IsAutoGeneration() const
	{
		return isAutoGeneration;
	}
	void CompleteCompile() const
	{
		isCompiled = true;
	}
	void KillCompileStatus() const
	{
		isCompiled = false;
	}
	bool IsCompiled() const
	{
		return isCompiled;
	}
	bool IsDestructor() const
	{
		return ( GetName()[0] == '~' );
	}

	// oCiR[hʒuƃTCY
	DWORD GetBeginOpAddress() const
	{
		return beginOpAddress;
	}
	void SetBeginOpAddress( DWORD beginOpAddress ) const
	{
		this->beginOpAddress = beginOpAddress;
	}
	DWORD GetEndOpAddress() const
	{
		return endOpAddress;
	}
	void SetEndOpAddress( DWORD endOpAddress ) const
	{
		this->endOpAddress = endOpAddress;
	}
	int GetCodeSize() const
	{
		return endOpAddress - beginOpAddress;
	}

	virtual const NamespaceScopes &GetNamespaceScopes() const;
	const NamespaceScopesCollection &GetImportedNamespaces() const;

	Variables &GetLocalVars() const
	{
		return localVars;
	}

	int GetId() const
	{
		return id;
	}

	const NativeCode &GetNativeCode() const
	{
		return nativeCode;
	}
	NativeCode &GetNativeCode()
	{
		return nativeCode;
	}

	std::string GetFullName() const;
	bool IsCastOperator() const;

	bool IsVirtual() const;

	void SetParentClass( const CClass *pParentClass ){
		this->pParentClass = pParentClass;
	}
	const CClass *GetParentClassPtr() const
	{
		return pParentClass;
	}
	const CClass &GetParentClass() const
	{
		return *pParentClass;
	}
	bool HasParentClass() const
	{
		return ( pParentClass != NULL );
	}
	bool IsGlobalProcedure() const
	{
		return ( pParentClass == NULL );
	}
	void SetInterface( const Interface *pInterface )
	{
		this->pInterface = pInterface;
	}
	void SetMethod( CMethod *pMethod ){
		this->pMethod = pMethod;
	}
	const CMethod &GetMethod() const;

	bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine, bool isStatic );



	/////////////////////////////////////////////////////////////////
	// RpC̊֐Ǘ
	/////////////////////////////////////////////////////////////////
private:
	static const UserProc *pCompilingUserProc;
public:
	static const UserProc *pGlobalProc;
	static void CompileStartForGlobalArea(){
		pCompilingUserProc = NULL;
	}
	static void CompileStartForUserProc( const UserProc *pUserProc ){
		pCompilingUserProc = pUserProc;
	}
	static bool IsGlobalAreaCompiling(){
		return ( pCompilingUserProc == NULL );
	}
	static bool IsLocalAreaCompiling(){
		return ( pCompilingUserProc != NULL );
	}
	static const UserProc &CompilingUserProc(){
		return *pCompilingUserProc;
	}
};

class UserProcs : public Jenga::Common::Hashmap<UserProc>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - UserProcs" );

		ar & boost::serialization::make_nvp("Hashmap_UserProcImpl",
			boost::serialization::base_object<Jenga::Common::Hashmap<UserProc>>(*this));
	}


public:
	UserProcs()
	{
	}
	~UserProcs()
	{
	}

	bool Insert( UserProc *pUserProc, int nowLine );

	void EnumGlobalProcs( const char *simpleName, const char *localName, std::vector<const UserProc *> &subs );
};

class DllProc : public Procedure, public Jenga::Common::ObjectInHashmap<DllProc>
{
	std::string dllFileName;
	std::string alias;
	int lookupAddress;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - DllProc" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );
		ar & BOOST_SERIALIZATION_NVP( dllFileName );
		ar & BOOST_SERIALIZATION_NVP( alias );
		ar & BOOST_SERIALIZATION_NVP( lookupAddress );
	}

public:
	DllProc( const NamespaceScopes &namespaceScopes, const std::string &name, Kind kind, bool isCdecl, const std::string &dllFileName, const std::string &alias )
		: Procedure( namespaceScopes, name, kind, isCdecl )
		, dllFileName( dllFileName )
		, alias( alias )
		, lookupAddress( 0 )
	{
	}
	DllProc()
	{
	}
	~DllProc()
	{
	}

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}

	virtual bool IsDuplication( const DllProc *pDllProc ) const
	{
		if( pDllProc->IsEqualSymbol( *this )
			&& this->Params().Equals( pDllProc->Params() ) )
		{
			return true;
		}
		return false;
	}

	const std::string &GetDllFileName() const
	{
		return dllFileName;
	}
	const std::string &GetAlias() const
	{
		return alias;
	}

	void SetLookupAddress( int lookupAddress ){
		this->lookupAddress = lookupAddress;
	}
	int GetLookupAddress() const
	{
		return lookupAddress;
	}

	bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine );
};
class DllProcs : public Jenga::Common::Hashmap<DllProc>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - DllProcs" );

		ar & boost::serialization::make_nvp("Hashmap_DllProc",
			boost::serialization::base_object<Jenga::Common::Hashmap<DllProc>>(*this));
	}

public:
	void Add(const NamespaceScopes &namespaceScopes, char *buffer,int nowLine);
};

class ProcPointer : public Procedure
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - ProcPointer" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Procedure );
	}

public:
	ProcPointer( Kind kind )
		: Procedure( NamespaceScopes(), std::string(), kind, false )
	{
	}
	ProcPointer()
	{
	}
	~ProcPointer(){}

	virtual bool SetParamsAndReturnType( const char *sourceOfParams, int nowLine );
};

class ProcPointers : public std::vector<ProcPointer *>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - ProcPointers" );

		ar & boost::serialization::make_nvp("vector_ProcPointer",
			boost::serialization::base_object<vector<ProcPointer *>>(*this));
	}

public:
	ProcPointers()
	{
	}
	~ProcPointers()
	{
		Clear();
	}

	int Add( const std::string &typeExpression );
	void Clear();
	void PullOutAll()
	{
		clear();
	}
};
