#include <string>
#include <vector>
#include <fstream>

#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <commctrl.h>
#include <time.h>
#include <limits.h>
#include <shlobj.h>

//boost libraries
#include <boost/foreach.hpp>

#include <jenga/include/common/String.h>

#include "../common.h"
#include "../BasicFixed.h"


// ObjectModule̓eXmlŐꍇ͂̍sLɂ
//#define OBJECT_MODULE_IS_NOT_BINARY


#ifdef OBJECT_MODULE_IS_NOT_BINARY
#include <boost/archive/xml_oarchive.hpp>
#include <boost/archive/xml_iarchive.hpp>
#else
#include <boost/archive/binary_oarchive.hpp>
#include <boost/archive/binary_iarchive.hpp>
#endif
#include <boost/serialization/string.hpp>
#include <boost/serialization/access.hpp>
#include <boost/serialization/level.hpp>
#include <boost/serialization/vector.hpp>
#include <boost/serialization/map.hpp>
#include <boost/serialization/version.hpp>
#include <boost/serialization/is_abstract.hpp>

#include <BoostSerializationSupport.h>

#include <abdev/ab_common/Environment.h>
#include <abdev/ab_common/include/Namespace.h>
#include <abdev/ab_common/include/NamespaceSupporter.h>
#include <abdev/ab_common/include/Symbol.h>
#include <abdev/ab_common/include/Prototype.h>

using namespace ActiveBasic::Common::Lexical;

#include <Hashmap.h>
#include <Configuration.h>
#include <Type.h>
#include <Method.h>
#include <Interface.h>
#include <Class.h>
#include <Procedure.h>
#include <LexicalAnalyzer.h>
#include <Program.h>
#include <Compiler.h>
#include <Debugger.h>


void ObjectModule::StaticLink( ObjectModule &objectModule )
{
	long dataSectionBaseOffset = dataTable.GetSize();
	int sourceIndexBase = (int)sources.size();

	// ^
	meta.StaticLink( objectModule.meta, dataSectionBaseOffset, sourceIndexBase );

	// O[o lCeBuR[h
	objectModule.globalNativeCode.ResetDataSectionBaseOffset( dataSectionBaseOffset );
	objectModule.globalNativeCode.ResetSourceIndexes( sourceIndexBase );
	globalNativeCode.PutEx( objectModule.globalNativeCode );

	// f[^e[u
	objectModule.dataTable.ResetDataSectionBaseOffset( dataSectionBaseOffset );
	dataTable.Add( objectModule.dataTable );

	// \[XR[h
	BOOST_FOREACH( const BasicSource &source, objectModule.sources )
	{
		this->sources.push_back( source );
	}

	// TODO: basbufȂȂ
	extern char *basbuf;
	basbuf = this->sources[0].GetBuffer();
}

bool ObjectModule::Read( const std::string &filePath )
{
	// XMLƂēǂݍ
	bool isSuccessful = false;

	try{
#ifdef OBJECT_MODULE_IS_NOT_BINARY
		std::ifstream ifs( filePath.c_str() );
		boost::archive::xml_iarchive ia(ifs);
#else
		std::ifstream ifs( filePath.c_str(), ios::in | ios::binary );
		boost::archive::binary_iarchive ia(ifs);
#endif

		// t@CǍ
		ia >> boost::serialization::make_nvp( RootTagName(), *this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		MessageBox( NULL, e.what(), "XMLVACY̗O", MB_OK );
	}
	catch(...){
		MessageBox( NULL, "archive_exceptionȊO̕sȗO", "XMLVACY̗O", MB_OK );
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
bool ObjectModule::Write( const std::string &filePath ) const
{
	bool isSuccessful = false;

	try{
#ifdef OBJECT_MODULE_IS_NOT_BINARY
		std::ofstream ofs( filePath.c_str() );
		boost::archive::xml_oarchive oa(ofs);
#else
		std::ofstream ofs( filePath.c_str(), ios::out | ios::binary );
		boost::archive::binary_oarchive oa(ofs);
#endif

		// t@Cɏo
		oa << boost::serialization::make_nvp( RootTagName(), *this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		MessageBox( NULL, e.what(), "XMLVACY̗O", MB_OK );
	}
	catch(...){
		MessageBox( NULL, "archive_exceptionȊO̕sȗO", "XMLVACY̗O", MB_OK );
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
bool ObjectModule::ReadString( const std::string &str )
{
	bool isSuccessful = false;

	// ̓A[JCu̍쐬

	try{
#ifdef OBJECT_MODULE_IS_NOT_BINARY
		std::istringstream iss( str );
		boost::archive::xml_iarchive ia(iss);
#else
		std::istringstream iss( str, ios::in | ios::binary );
		boost::archive::binary_iarchive ia(iss);
#endif

		// Xg[Ǎ
		ia >> boost::serialization::make_nvp( RootTagName(), *this );

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		MessageBox( NULL, e.what(), "XMLVACY̗O", MB_OK );
	}
	catch(...){
		MessageBox( NULL, "archive_exceptionȊO̕sȗO", "XMLVACY̗O", MB_OK );
	}

	if( !isSuccessful )
	{
		return false;
	}

	return true;
}
bool ObjectModule::WriteString( std::string &str ) const
{
	// o̓A[JCu̍쐬

	bool isSuccessful = false;
	try{
#ifdef OBJECT_MODULE_IS_NOT_BINARY
		std::ostringstream oss;
		boost::archive::xml_oarchive oa(oss);
#else
		std::ostringstream oss( "", ios::out | ios::binary );
		boost::archive::binary_oarchive oa(oss);
#endif

		// Xg[ɏo
		oa << boost::serialization::make_nvp( RootTagName(), *this );

		str = oss.str();

		isSuccessful = true;
	}
	catch( boost::archive::archive_exception e )
	{
		MessageBox( NULL, e.what(), "XMLVACY̗O", MB_OK );
	}
	catch(...){
		MessageBox( NULL, "archive_exceptionȊO̕sȗO", "XMLVACY̗O", MB_OK );
	}

	return isSuccessful;
}
