#include "stdafx.h"

Interface::Interface( const CClass *pInterfaceClass, const Types &actualTypeParameters )
	: DynamicMethodsPrototype()
	, pInterfaceClass( pInterfaceClass )
	, vtblOffset( -1 )
	, actualTypeParameters( actualTypeParameters )
{
	//\bhRs[
	BOOST_FOREACH( const CMethod *pBaseMethod, pInterfaceClass->GetDynamicMethods() )
	{
		CMethod *pMethod = new DynamicMethod( *pBaseMethod );

		// ANZVreB
		if(pBaseMethod->GetAccessibility() == Prototype::Private){
			pMethod->SetAccessibility( Prototype::None );
		}
		else{
			pMethod->SetAccessibility( pBaseMethod->GetAccessibility() );
		}

		//pobj_Inherits
		// pClassIndexZbgiqplj
		if(pBaseMethod->GetInheritsClassPtr()==0){
			pMethod->SetInheritsClassPtr( pInterfaceClass );
		}
		else{
			pMethod->SetInheritsClassPtr( pBaseMethod->GetInheritsClassPtr() );
		}

		AddDynamicMethods( pMethod );
	}
}

std::string Interface::GetFullNameWithActualGenericTypeParameters() const
{
	std::string interfaceName = this->GetClass().GetFullName();
	if( actualTypeParameters.size() )
	{
		std::string actualGenericTypesName;
		BOOST_FOREACH( const Type &typeParameter, actualTypeParameters )
		{
			if( actualGenericTypesName.size() )
			{
				actualGenericTypesName += ",";
			}
			actualGenericTypesName += typeParameter.ToString();
		}

		interfaceName += "<" + actualGenericTypesName + ">";
	}
	return interfaceName;
}
