#include "stdafx.h"

#include <Source.h>
#include <Class.h>
#include <Compiler.h>

#include "../common.h"
#ifdef _AMD64_
#include "../../compiler_x64/opcode.h"
#else
#include "../../compiler_x86/opcode.h"
#endif

using namespace ActiveBasic::Compiler;


class CLoopRefCheck{
	char **names;
	int num;
	void init(){
		int i;
		for(i=0;i<num;i++){
			free(names[i]);
		}
		free(names);
	}
public:
	CLoopRefCheck()
	{
		names=(char **)malloc(1);
		num=0;
	}
	~CLoopRefCheck()
	{
		init();
	}
	void add(const char *lpszInheritsClass)
	{
		names=(char **)realloc(names,(num+1)*sizeof(char *));
		names[num]=(char *)malloc(lstrlen(lpszInheritsClass)+1);
		lstrcpy(names[num],lpszInheritsClass);
		num++;
	}
	void del(const char *lpszInheritsClass)
	{
		int i;
		for(i=0;i<num;i++){
			if(lstrcmp(names[i],lpszInheritsClass)==0){
				free(names[i]);
				break;
			}
		}
		if(i!=num){
			num--;
			for(;i<num;i++){
				names[i]=names[i+1];
			}
		}
	}
	BOOL check(const CClass &inheritsClass) const
	{
		//[vp`FbN
		int i;
		for(i=0;i<num;i++){
			if( inheritsClass.GetName() == names[i] ){
				return 1;
			}
		}
		return 0;
	}
};
CLoopRefCheck *pobj_LoopRefCheck;

bool MemberVar_LoopRefCheck(const CClass &objClass){
	if( objClass.HasSuperClass() )
	{
		// NX`FbN
		if( MemberVar_LoopRefCheck( objClass.GetSuperClass() ) == false )
		{
			return false;
		}
	}

	bool result = true;
	BOOST_FOREACH( CMember *pMember, objClass.GetDynamicMembers() ){
		if(pMember->GetType().IsStruct()){
			//zQƂłȂ`FbN
			if(pobj_LoopRefCheck->check(pMember->GetType().GetClass())){
				extern int cp;
				compiler.errorMessenger.Output(124,pMember->GetType().GetClass().GetName(),cp);
				return false;
			}

			pobj_LoopRefCheck->add(objClass.GetName().c_str());

			bool tempResult = MemberVar_LoopRefCheck(pMember->GetType().GetClass());
			if( result )
			{
				result = tempResult;
			}

			pobj_LoopRefCheck->del(objClass.GetName().c_str());
		}
	}

	return result;
}

void LexicalAnalyzer::AddMethod(CClass *pobj_c, UserProc *pUserProc, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
	bool isVirtual, bool isOverride, const char *interfaceName, bool isAutoGeneration, int nowLine)
{
	if( isAutoGeneration )
	{
		// R[h
		pUserProc->ThisIsAutoGenerationProc();
	}


	////////////////////////////////////////////////////////////
	// RXgN^AfXgN^̏ꍇ̏
	////////////////////////////////////////////////////////////
	BOOL fConstructor=0,bDestructor=0;

	if( pUserProc->GetName() == pobj_c->GetName() ){
		//RXgN^̏ꍇ

		//WRXgN^iȂj
		if(pUserProc->Params().size()==0) fConstructor=1;

		//IConstCq
		isConst = true;
	}
	else if(pUserProc->GetName()[0]=='~'){
		//fXgN^̏ꍇ̖͂O`FbNs
		if(lstrcmp(pUserProc->GetName().c_str()+1,pobj_c->GetName().c_str())!=0)
			compiler.errorMessenger.Output(117,NULL,nowLine);
		else
			bDestructor=1;
	}
	if(fConstructor||bDestructor){
		// RXgN^AfXgN^̃ANZVreB`FbN

		//IConstCq
		isConst = true;
	}

	if( fConstructor == 1 )
		pobj_c->SetConstructorMemberSubIndex( (int)pobj_c->GetDynamicMethods().size() );
	else if( bDestructor )
		pobj_c->SetDestructorMemberSubIndex( (int)pobj_c->GetDynamicMethods().size() );



	//////////////////
	// d`FbN
	//////////////////

	if(pobj_c->DupliCheckMember( pUserProc->GetName().c_str() )){
		compiler.errorMessenger.Output(15,pUserProc->GetName(),nowLine);
		return;
	}

	//\bh
	BOOST_FOREACH( const CMethod *pMethod, pobj_c->GetDynamicMethods() )
	{
		//NXƏdꍇ̓I[o[Chs
		if( pMethod->GetInheritsClassPtr() ) continue;

		if( pMethod->GetUserProc().IsEqualForOverride( pobj_c->GetSuperClassActualTypeParameters(), pUserProc ) )
		{
			//֐Ap[^A߂lvƂ
			compiler.errorMessenger.Output(15,pUserProc->GetName().c_str(),nowLine);
			return;
		}
	}

	//z֐̏ꍇ
	if( isAbstract ) pUserProc->CompleteCompile();

	// \bh̃I[o[Ch
	CMethod *pMethodForOverride = pobj_c->GetDynamicMethods().FindForOverride( pobj_c->GetSuperClassActualTypeParameters(), pUserProc );
	if( pMethodForOverride )
	{
		pMethodForOverride->Override( pUserProc, accessibility, isOverride );
		pUserProc->SetMethod( pMethodForOverride );
		return;
	}
	else
	{
		// C^[tFCX \bh̃I[o[Ch
		BOOST_FOREACH( ::Interface *pInterface, pobj_c->GetInterfaces() )
		{
			if( interfaceName[0] )
			{
				if( pInterface->GetClass().GetName() != interfaceName )
				{
					// w肳ꂽC^[tFCXƐȂƂ
					continue;
				}
			}

			if( !pInterface->GetClass().IsReady() ){
				// C^[tFCX͂̂Ƃ
				LexicalAnalyzer::LookaheadClass(
					pInterface->GetClass().GetName().c_str(),
					compiler.GetObjectModule().meta.GetClasses()
				);
			}

			CMethod *pMethodForOverride = pInterface->GetDynamicMethods().FindForOverride( pInterface->GetActualTypeParameters(), pUserProc );
			if( pMethodForOverride )
			{
				pMethodForOverride->Override( pUserProc, accessibility, isOverride );
				pUserProc->SetMethod( pMethodForOverride );
				return;
			}
		}
	}

	if( interfaceName[0] )
	{
		compiler.errorMessenger.Output(139,interfaceName,nowLine);
	}

	if( isVirtual ){
		pobj_c->AddVtblNum( 1 );
	}

	if( isOverride ){
		compiler.errorMessenger.Output(12,"Override",nowLine);
	}

	if(bStatic){
		pobj_c->GetStaticMethods().AddStatic( pUserProc, accessibility );
	}
	else{
		pobj_c->GetDynamicMethods().Add(pUserProc, accessibility, isConst, isAbstract, isVirtual);
	}
}

bool LexicalAnalyzer::Inherits( CClass &currentClass, const char *inheritNames, int nowLine ){
	int i = 0;
	bool isInheritsClass = false;
	while( true ){

		char temporary[VN_SIZE];
		for( int i2=0;; i++, i2++ ){
			if( inheritNames[i] == '\0' || inheritNames[i] == ',' ){
				temporary[i2] = 0;
				break;
			}
			temporary[i2] = inheritNames[i];
		}

		// WFlNX\𕪉
		char className[VN_SIZE];
		Jenga::Common::Strings typeParameterStrings;
		SplitGenericClassInstance( temporary, className, typeParameterStrings );

		// ^p[^񂩂^f[^擾
		Types actualTypeParameters;
		BOOST_FOREACH( const std::string &typeParameterStr, typeParameterStrings )
		{
			Type type;
			compiler.StringToType( typeParameterStr, type );
			actualTypeParameters.push_back( type );
		}

		//pNX擾
		const CClass *pInheritsClass = compiler.GetObjectModule().meta.GetClasses().Find(className);
		if( !pInheritsClass ){
			compiler.errorMessenger.Output(106,className,nowLine);
			return false;
		}

		if( pInheritsClass->IsClass() ){
			// NXp
			isInheritsClass = true;

			//[vpłȂ`FbN
			if( !LexicalAnalyzer::LoopRefCheck(*pInheritsClass) )
			{
				compiler.errorMessenger.Output(123,pInheritsClass->GetName(),nowLine);
				return false;
			}

			if( !pInheritsClass->IsReady() ){
				//p悪ǂݎĂȂƂ
				LexicalAnalyzer::LookaheadClass(
					pInheritsClass->GetName().c_str(),
					compiler.GetObjectModule().meta.GetClasses()
				);
			}

			if( !currentClass.InheritsClass( *pInheritsClass, actualTypeParameters, nowLine ) ){
				return false;
			}
		}
		else{
			compiler.errorMessenger.Output(135,pInheritsClass->GetFullName().c_str(),nowLine);
			return false;
		}

		if( inheritNames[i] == '\0' ){
			break;
		}
		i++;
	}

	if( !isInheritsClass ){
		const CClass *pObjectClass = compiler.GetObjectModule().meta.GetClasses().GetObjectClassPtr();
		//[vpłȂ`FbN
		if( !LexicalAnalyzer::LoopRefCheck( *pObjectClass ) )
		{
			compiler.errorMessenger.Output(123,pObjectClass->GetName(),nowLine);
			return false;
		}

		if( !pObjectClass->IsReady() ){
			//p悪ǂݎĂȂƂ
			LexicalAnalyzer::LookaheadClass(
				pObjectClass->GetName().c_str(),
				compiler.GetObjectModule().meta.GetClasses()
			);
		}

		// NXpĂȂƂ
		if( !currentClass.InheritsClass( *pObjectClass, Types(), nowLine ) ){
			return false;
		}
	}

	return true;
}

bool LexicalAnalyzer::Implements( CClass &currentClass, const char *interfaceNames, int nowLine )
{
	Jenga::Common::Strings paramStrs;
	SplitParameter( interfaceNames, paramStrs );
	
	BOOST_FOREACH( const std::string &paramStr, paramStrs )
	{
		char className[VN_SIZE];
		Jenga::Common::Strings typeParameterStrings;
		SplitGenericClassInstance( paramStr.c_str(), className, typeParameterStrings );

		Types actualTypeParameters;
		BOOST_FOREACH( const std::string &typeParameterStr, typeParameterStrings )
		{
			Type type;
			compiler.StringToType( typeParameterStr, type );
			actualTypeParameters.push_back( type );
		}

		//pNX擾
		const CClass *pInterfaceClass = compiler.GetObjectModule().meta.GetClasses().Find( className );
		if( !pInterfaceClass ){
			compiler.errorMessenger.Output(106,paramStr.c_str(),nowLine);
			continue;
		}

		if( !pInterfaceClass->IsReady() ){
			// C^[tFCX͂̂Ƃ
			LexicalAnalyzer::LookaheadClass(
				pInterfaceClass->GetName().c_str(),
				compiler.GetObjectModule().meta.GetClasses()
			);
		}

		// C^[tFCXp
		currentClass.Implements( *pInterfaceClass, actualTypeParameters, nowLine );
	}

	return true;
}

void GetClass_recur( const char *lpszInheritsClass, Classes &classes )
{
	extern char *basbuf;
	int i,i2,i3,sub_address,top_pos;
	char temporary[8192];

	// OԊǗ
	NamespaceScopes backupNamespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	// ImportsꂽOԂ̊Ǘ
	NamespaceScopesCollection backupImportedNamespaces = compiler.GetNamespaceSupporter().GetImportedNamespaces();
	compiler.GetNamespaceSupporter().GetImportedNamespaces().clear();

	// ĂяoŃRpC̃NX|C^obNAbv
	const CClass *pBackCompilingClass = compiler.pCompilingClass;

	for(i=0;;i++){
		if(basbuf[i]=='\0') break;


		// O
		if( basbuf[i] == 1 && basbuf[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				compiler.errorMessenger.Output(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}

		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPORTS ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( basbuf[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=basbuf[i];
			}
			if( !compiler.GetNamespaceSupporter().ImportsNamespace( temporary ) )
			{
				compiler.errorMessenger.Output(64,temporary,i );
			}

			continue;
		}
		else if( basbuf[i] == 1 && basbuf[i+1] == ESC_CLEARNAMESPACEIMPORTED ){
			compiler.GetNamespaceSupporter().GetImportedNamespaces().clear();
			continue;
		}



		if(basbuf[i]==1&&basbuf[i+1]==ESC_INTERFACE){
			//////////////////////////
			// C^[tFCX
			//////////////////////////

			top_pos=i;

			i+=2;

			//C^[tFCX擾
			GetCommandToken( temporary, basbuf, i );

			char className[VN_SIZE];
			Jenga::Common::Strings typeParameters;
			Jenga::Common::Strings typeParameterBaseClassNames;
			SplitGenericClassInstance( temporary, className, typeParameters, true, &typeParameterBaseClassNames );

			CClass *pobj_c = const_cast<CClass *>( classes.Find(namespaceScopes, className) );
			if(!pobj_c) continue;

			compiler.pCompilingClass = pobj_c;

			if(lpszInheritsClass){
				if(lstrcmp(lpszInheritsClass,pobj_c->GetName().c_str())!=0){
					//pǂݗp
					continue;
				}
			}

			if(pobj_c->IsReady()){
				//ɐǂ݂ĂƂ
				continue;
			}

			/////////////////////////////////////////////////////////
			//  WFlNXT|[g 
			for( i2=0; i2<static_cast<int>(typeParameters.size()); i2++ )
			{
				Type baseType( DEF_OBJECT, *classes.GetObjectClassPtr() );
				if( typeParameterBaseClassNames[i2].size() )
				{
					if( !compiler.StringToType( typeParameterBaseClassNames[i2], baseType ) )
					{
						compiler.errorMessenger.Output(106,typeParameterBaseClassNames[i2],i);
					}
					else if( !baseType.IsObject() )
					{
						compiler.errorMessenger.Output(106,typeParameterBaseClassNames[i2],i);
					}
				}

				pobj_c->AddFormalGenericType( GenericType( typeParameters[i2], baseType ) );
			}
			/////////////////////////////////////////////////////////

			pobj_c->Readed();

			pobj_c->SetConstructorMemberSubIndex( -1 );
			pobj_c->SetDestructorMemberSubIndex( -1 );

			if( memcmp( basbuf+i+1, "__COM", 5 ) == 0 && IsCommandDelimitation( basbuf[i+1+5] ) )
			{
				// COMC^[tFCX
				pobj_c->SetClassType( CClass::ComInterface );

				i += 6;
			}

			if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS){
				//psꍇ
				for(i+=3,i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}

				if(lstrcmpi(temporary,pobj_c->GetName().c_str())==0){
					compiler.errorMessenger.Output(105,temporary,i);
					goto Interface_InheritsError;
				}

				//pNX擾
				const CClass *pInheritsClass = classes.Find(temporary);
				if( !pInheritsClass ){
					compiler.errorMessenger.Output(106,temporary,i);
					goto Interface_InheritsError;
				}

				//[vpłȂ`FbN
				if( !LexicalAnalyzer::LoopRefCheck( *pInheritsClass ) )
				{
					compiler.errorMessenger.Output(123,pInheritsClass->GetName(),i);
					goto Interface_InheritsError;
				}

				//p
				if( !pobj_c->InheritsClass( *pInheritsClass, Types(), i ) ){
					goto Interface_InheritsError;
				}
			}
			else{
				//p
				if( &pobj_c->GetSuperClass() || pobj_c->GetVtblNum() )
				{
					// TODO: ɗȂƂ؂ł炱̕͏
					Jenga::Throw( "GetClass_recur̗O" );
				}
			}
Interface_InheritsError:

			//oϐA֐擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE||basbuf[i+1]==ESC_INTERFACE)){
					compiler.errorMessenger.Output(22,"Interface",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					compiler.errorMessenger.Output(111,NULL,i);
					break;
				}
				else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPLEMENTS )
				{
					compiler.errorMessenger.Output(137, NULL, i );
					break;
				}

				sub_address=i;

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){
						i--;
						compiler.errorMessenger.Output(22,"Interface",top_pos);
						break;
					}
					continue;
				}

				//End InterfaceLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDINTERFACE) break;

				if(!(temporary[0]==1&&(
					temporary[1]==ESC_SUB||temporary[1]==ESC_FUNCTION
					))){
					compiler.errorMessenger.Output(1,NULL,i);
					break;
				}

				//֐nbV֓o^
				char interfaceName[VN_SIZE] = "";
				UserProc *pUserProc = LexicalAnalyzer::ParseUserProc( NamespaceScopes(), NamespaceScopesCollection(), temporary,sub_address,true,pobj_c, false, interfaceName );
				if( pUserProc )
				{
					compiler.GetObjectModule().meta.GetUserProcs().Insert( pUserProc, i );

					//o֐ǉ
					LexicalAnalyzer::AddMethod(pobj_c,
						pUserProc,
						Prototype::Public,	//PublicANZX
						0,					// bStatic
						false,				// isConst
						true,				// isAbstract
						true,				// isVirtual
						false,				// isOverride
						interfaceName,
						false,				// isAutoGeneration
						sub_address
						);
				}
			}
		}

		if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
			//////////////////////////
			// NX
			//////////////////////////

			top_pos=i;

			const DWORD dwClassType=basbuf[i+1];

			i+=2;

			int iAlign=0;
			if(memicmp(basbuf+i,"Align(",6)==0){
				//ACgCq
				i+=6;
				i+=GetStringInPare_RemovePare(temporary,basbuf+i)+1;
				iAlign=atoi(temporary);

				if( dwClassType != ESC_TYPE )
				{
					compiler.errorMessenger.Output(140,NULL,i);
				}

				if(!(iAlign==1||iAlign==2||iAlign==4||iAlign==8||iAlign==16))
					compiler.errorMessenger.Output(51,NULL,i);
			}
			else if( memicmp( basbuf + i, "Blittable(", 10 ) == 0 ){
				// BlittableCq
				i+=10;
				i=JumpStringInPare(basbuf,i)+1;

				if( dwClassType != ESC_CLASS )
				{
					compiler.errorMessenger.Output(141,NULL,i);
				}
			}

			if( basbuf[i] == 1 && basbuf[i+1] == ESC_ENUM )
			{
				// 񋓌^̏ꍇ
				i += 2;
			}
			else if( basbuf[i] == 1 && basbuf[i+1] == ESC_DELEGATE )
			{
				// fQ[g̏ꍇ
				i += 2;
			}

			//NX擾
			GetCommandToken( temporary, basbuf, i );

			char className[VN_SIZE];
			Jenga::Common::Strings typeParameters;
			Jenga::Common::Strings typeParameterBaseClassNames;
			SplitGenericClassInstance( temporary, className, typeParameters, true, &typeParameterBaseClassNames );

			CClass *pobj_c =  const_cast<CClass *>( classes.Find(namespaceScopes, className) );
			if(!pobj_c) continue;

			compiler.pCompilingClass = pobj_c;

			if(lpszInheritsClass){
				if( pobj_c->GetName() != lpszInheritsClass ){
					//pǂݗp
					continue;
				}
			}

			if( lstrcmp(className,"Control")==0)
			{
				int test=0;
			}

			if(pobj_c->IsReady()){
				//ɐǂ݂ĂƂ
				continue;
			}


			/////////////////////////////////////////////////////////
			//  WFlNXT|[g 
			for( i2=0; i2<static_cast<int>(typeParameters.size()); i2++ )
			{
				Type baseType( DEF_OBJECT, *classes.GetObjectClassPtr() );
				if( typeParameterBaseClassNames[i2].size() )
				{
					if( !compiler.StringToType( typeParameterBaseClassNames[i2], baseType ) )
					{
						compiler.errorMessenger.Output(106,typeParameterBaseClassNames[i2],i);
					}
					else if( !baseType.IsObject() )
					{
						compiler.errorMessenger.Output(106,typeParameterBaseClassNames[i2],i);
					}
				}

				pobj_c->AddFormalGenericType( GenericType( typeParameters[i2], baseType ) );
			}
			/////////////////////////////////////////////////////////


			pobj_c->SetFixedAlignment( iAlign );

			pobj_c->Readed();

			pobj_c->SetConstructorMemberSubIndex( -1 );
			pobj_c->SetDestructorMemberSubIndex( -1 );

			//ANZX̏lZbg
			Prototype::Accessibility accessibility;
			if(dwClassType==ESC_CLASS){
				accessibility = Prototype::Private;
			}
			else{
				accessibility = Prototype::Public;
			}

			if( pobj_c->GetName() == "Object"
				|| dwClassType == ESC_TYPE )
			{
				// pȂ

				if( &pobj_c->GetSuperClass() || pobj_c->GetVtblNum() )
				{
					// TODO: ɗȂƂ؂ł炱̕͏
					Jenga::Throw( "GetClass_recur̗O" );
				}
			}
			else{
				if(basbuf[i+1]==1&&basbuf[i+2]==ESC_INHERITS)
				{
					// NXp悪w肳ĂƂ
					i += 3;
					GetCommandToken( temporary, basbuf, i );

					if(lstrcmpi(temporary,pobj_c->GetName().c_str())==0){
						compiler.errorMessenger.Output(105,temporary,i);
						goto InheritsError;
					}
				}
				else
				{
					// ̎wȂƂObjectNXp
					lstrcpy( temporary, "Object" );
				}
				LexicalAnalyzer::Inherits( *pobj_c, temporary, i );

				if( basbuf[i+1] == 1 && basbuf[i+2] == ESC_IMPLEMENTS )
				{
					// C^[tFCXsꍇ
					i += 3;
					GetCommandToken( temporary, basbuf, i );

					LexicalAnalyzer::Implements( *pobj_c, temporary, i );
				}
			}
InheritsError:

			//oƃ\bh擾
			while(1){
				i++;

				//G[
				if(basbuf[i]==1&&(basbuf[i+1]==ESC_CLASS||basbuf[i+1]==ESC_TYPE)){
					compiler.errorMessenger.Output(22,"Class",i);
					i--;
					break;
				}

				if(basbuf[i]==1&&basbuf[i+1]==ESC_INHERITS){
					compiler.errorMessenger.Output(111,NULL,i);
					break;
				}
				else if( basbuf[i] == 1 && basbuf[i+1] == ESC_IMPLEMENTS )
				{
					compiler.errorMessenger.Output(137, NULL, i );
					break;
				}

				//StaticCq
				BOOL bStatic;
				if(basbuf[i]==1&&basbuf[i+1]==ESC_STATIC){
					bStatic=1;
					i+=2;
				}
				else bStatic=0;

				//ConstCq
				bool isConst = false;
				if( basbuf[i] == 1 && basbuf[i + 1] == ESC_CONST ){
					isConst = true;
					i += 2;
				}

				if(basbuf[i]==1&&(
					basbuf[i+1]==ESC_ABSTRACT||basbuf[i+1]==ESC_VIRTUAL||basbuf[i+1]==ESC_OVERRIDE||
					basbuf[i+1]==ESC_SUB||basbuf[i+1]==ESC_FUNCTION
					)){
					i3=basbuf[i+1];
					sub_address=i;
				}
				else i3=0;

				bool isVirtual = false, isAbstract = false, isOverride = false;
				if(i3==ESC_ABSTRACT){
					isAbstract=1;
					isVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_VIRTUAL){
					isAbstract=0;
					isVirtual=1;
					i+=2;

					i3=basbuf[i+1];
				}
				else if(i3==ESC_OVERRIDE){
					isOverride=1;
					isVirtual=1;

					i+=2;

					i3=basbuf[i+1];
				}

				for(i2=0;;i++,i2++){
					if(IsCommandDelimitation(basbuf[i])){
						temporary[i2]=0;
						break;
					}
					temporary[i2]=basbuf[i];
				}
				if(temporary[0]=='\0'){
					if(basbuf[i]=='\0'){

						if(dwClassType==ESC_CLASS)
							compiler.errorMessenger.Output(22,"Class",top_pos);
						else
							compiler.errorMessenger.Output(22,"Type",top_pos);

						i--;
						break;
					}
					continue;
				}

				//End ClassLq̏ꍇ
				if(temporary[0]==1&&temporary[1]==ESC_ENDCLASS&&dwClassType==ESC_CLASS) break;
				if(temporary[0]==1&&temporary[1]==ESC_ENDTYPE&&dwClassType==ESC_TYPE) break;

				//ANZXύX
				if(lstrcmpi(temporary,"Private")==0){
					accessibility = Prototype::Private;
					continue;
				}
				if(lstrcmpi(temporary,"Public")==0){
					accessibility = Prototype::Public;
					continue;
				}
				if(lstrcmpi(temporary,"Protected")==0){
					accessibility = Prototype::Protected;
					continue;
				}

				extern int cp;
				if(i3==0){
					if(bStatic){
						//ÓIoǉ
						cp=i;	//G[p
						pobj_c->AddStaticMember( accessibility, isConst, false, temporary, i);
					}
					else{
						//oǉ
						cp=i;	//G[p
						pobj_c->AddMember( accessibility, isConst, false, temporary, i );


						if(pobj_c->GetDynamicMembers().back()->GetType().IsStruct()){
							if( !pobj_c->GetDynamicMembers().back()->GetType().GetClass().IsReady() ){
								//QƐ悪ǂݎĂȂƂ
								GetClass_recur( pobj_c->GetDynamicMembers().back()->GetType().GetClass().GetName().c_str(), classes );
							}
						}


						if(pobj_c->GetDynamicMembers().back()->GetType().IsStruct()){
							//zQƂ̃`FbN
							pobj_LoopRefCheck->add(pobj_c->GetName().c_str());
							if(!MemberVar_LoopRefCheck(pobj_c->GetDynamicMembers().back()->GetType().GetClass())){
								//G[
								Type &type = const_cast<Type &>(pobj_c->GetDynamicMembers().back()->GetType());
								type.SetBasicType( DEF_PTR_VOID );
							}
							pobj_LoopRefCheck->del(pobj_c->GetName().c_str());
						}
					}
				}
				else{
					//֐nbV֓o^
					char interfaceName[VN_SIZE] = "";
					UserProc *pUserProc = LexicalAnalyzer::ParseUserProc( NamespaceScopes(), NamespaceScopesCollection(), temporary,sub_address,isVirtual,pobj_c, (bStatic!=0), interfaceName );
					if( pUserProc )
					{
						compiler.GetObjectModule().meta.GetUserProcs().Insert( pUserProc, i );

						//\bhǉ
						cp=i;	//G[p
						LexicalAnalyzer::AddMethod(pobj_c,
							pUserProc,
							accessibility,
							bStatic,
							isConst,
							isAbstract,
							isVirtual,
							isOverride,
							interfaceName,
							false,
							sub_address);
					}

					if( isAbstract ) continue;

					for(;;i++){
						if(basbuf[i]=='\0'){
							i--;
							break;
						}
						if(basbuf[i-1]!='*'&&
							basbuf[i]==1&&(
							basbuf[i+1]==ESC_SUB||
							basbuf[i+1]==ESC_FUNCTION||
							basbuf[i+1]==ESC_MACRO||
							basbuf[i+1]==ESC_TYPE||
							basbuf[i+1]==ESC_CLASS||
							basbuf[i+1]==ESC_INTERFACE||
							basbuf[i+1]==ESC_ENUM)){
							GetDefaultNameFromES(i3,temporary);
							compiler.errorMessenger.Output(22,temporary,i);
						}
						if(basbuf[i]==1&&basbuf[i+1]==GetEndXXXCommand((char)i3)){
							i+=2;
							break;
						}
					}
				}
			}
		}
	}

	// ĂяoŃRpC̃NX|C^ɖ߂
	compiler.pCompilingClass = pBackCompilingClass;

	// OԂɖ߂
	compiler.GetNamespaceSupporter().GetLivingNamespaceScopes() = backupNamespaceScopes;

	// C|[gꂽOԂɖ߂
	compiler.GetNamespaceSupporter().GetImportedNamespaces() = backupImportedNamespaces;
}

void LexicalAnalyzer::LookaheadClass( const char *className, Classes &classes )
{
	pobj_LoopRefCheck->add( className );
	GetClass_recur( className, classes );
	pobj_LoopRefCheck->del( className );
}

bool LexicalAnalyzer::LoopRefCheck( const CClass &objClass )
{
	if( pobj_LoopRefCheck->check( objClass ) )
	{
		return false;
	}

	return true;
}

void LexicalAnalyzer::CollectClasses( const char *source, Classes &classes ){
	//[vp`FbNp̃NX
	pobj_LoopRefCheck=new CLoopRefCheck();

	//NX擾
	GetClass_recur( 0, classes );

	delete pobj_LoopRefCheck;
	pobj_LoopRefCheck=0;

	// Ce[^̏
	classes.Iterator_Init();
}
