#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

int hash_default(char *name){
	int key;

	for(key=0;*name!='\0';name++){
		key=((key<<8)+ *name )%MAX_HASH;
	}

	return key;
}

CONSTINFO *GetConstHash(char *name){
	//nbVl擾
	int key;
	key=hash_default(name);

	//i[ʒu擾
	extern CONSTINFO **ppConstHash;
	CONSTINFO *pci;
	pci=ppConstHash[key];
	while(pci){
		if(lstrcmp(pci->name,name)==0) break;

		pci=pci->pNextData;
	}

	return pci;
}

DECLAREINFO *GetDeclareHash(char *name){
	//nbVl擾
	int key;
	key=hash_default(name);

	//i[ʒu擾
	extern DECLAREINFO **ppDeclareHash;
	DECLAREINFO *pdi;
	pdi=ppDeclareHash[key];
	while(pdi){
		if(lstrcmp(pdi->name,name)==0) break;

		pdi=pdi->pNextData;
	}

	return pdi;
}

void GetOverloadSubHash( const char *lpszName, std::vector<SUBINFO *> &subs ){
	extern SUBINFO *pSubInfo;
	extern int SubInfoNum;
	extern int cp;

	char name[VN_SIZE];

	if(lpszName[0]=='.'){
		GetWithName(name);
		lstrcat(name,lpszName);
	}
	else lstrcpy(name,lpszName);


	char ObjName[VN_SIZE];		//IuWFNgϐ
	char NestMember[VN_SIZE];	//qo
	bool isObjectMember = SplitMemberName( name, ObjName, NestMember );
	if( !isObjectMember ) lstrcpy(ObjName,name);

	if(isObjectMember){
		//IuWFNg̃o֐̏ꍇ

		bool isStatic = false;
		CClass *pobj_c;
		if(lstrcmpi(ObjName,"Super")==0){
			//NXo֐NX̌Ăяo
			pobj_c=pobj_CompilingClass;
		}
		else{
			//"->"ɂăIuWFNgw肷ʏ̃o֐Ăяo
			int type = GetVarType(ObjName,(LONG_PTR *)&pobj_c,0);
			if(!(NATURAL_TYPE(type)==DEF_OBJECT)){
				pobj_c=pobj_DBClass->check(ObjName);
				if( pobj_c ){
					isStatic = true;
				}
				else{
					return;
				}
			}
		}

		if( isStatic ){
			// ÓI\bh
			pobj_c->EnumStaticMethod( NestMember, subs );
		}
		else{
			//I\bh
			pobj_c->EnumMethod( NestMember, subs );
		}
	}
	else{
		//IuWFNgIɎw肳ĂȂƂ

		if(pobj_CompilingClass){
			//g̃IuWFNg̃o֐

			// ÓI\bh
			pobj_CompilingClass->EnumStaticMethod( name, subs );

			// I\bh
			pobj_CompilingClass->EnumMethod( name, subs );
		}


		///////////////////////////
		// O[o֐
		///////////////////////////

		//nbVl擾
		int key;
		key=hash_default(name);

		//i[ʒu擾
		extern SUBINFO **ppSubHash;
		SUBINFO *psi;
		psi=ppSubHash[key];
		while(psi){
			if(!psi->pobj_ParentClass){
				if(lstrcmp(psi->name,name)==0){
					subs.push_back( psi );
				}
			}

			psi=psi->pNextData;
		}

	}
}

//I[o[[hĂȂ֐擾î̃RpC\[XR[hƂ̌݊ێj
SUBINFO *GetSubHash(const char *lpszName,BOOL bError){
	std::vector<SUBINFO *> subs;
	GetOverloadSubHash(lpszName,subs);

	//֐݂ȂƂ
	if(subs.size() == 0){
		return 0;
	}

	//ȏ̊֐݂Ƃ͓G[ifobOpj
	if(subs.size() > 1){
		if(bError) SetError(300,NULL,cp);
	}

	SUBINFO *psi;
	psi = subs[0];

	return psi;
}
SUBINFO *GetMethodHash(char *ObjectName,char *MethodName,char *Parameter,BOOL bError){
	char temporary[VN_SIZE];
	sprintf(temporary,"%s.%s",ObjectName,MethodName);

	std::vector<SUBINFO *> subs;
	SUBINFO *psi;
	GetOverloadSubHash(temporary,subs);

	//֐݂ȂƂ
	if(subs.size() == 0){
		return 0;
	}

	//I[o[[h
	psi=OverloadSolutionWithStrParam(temporary,subs,Parameter,ObjectName,NULL);

	return psi;
}
