#include "stdafx.h"

using namespace ActiveBasic::Common::Lexical;

const NamespaceSupporter *Symbol::namespaceSupporter = NULL;

std::string Symbol::GetFullName() const
{
	if( namespaceScopes.size() )
	{
		return namespaceScopes.ToString() + "." + name;
	}

	return name;
}

bool Symbol::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const std::string &name ) const
{
	if( GetName() != name ){
		return false;
	}

	_ASSERTE( namespaceSupporter );
	return namespaceSupporter->IsSameAreaNamespace( GetNamespaceScopes(), namespaceScopes );
}
bool Symbol::IsEqualSymbol( const Symbol &symbol ) const
{
	if( IsEqualSymbol( symbol.GetNamespaceScopes(), symbol.GetName() ) )
	{
		return true;
	}

	if( symbol.GetNamespaceScopes().size() >= 1 )
	{
		// ÓIol
		NamespaceScopes namespaceScopes( symbol.GetNamespaceScopes() );
		std::string name = namespaceScopes[namespaceScopes.size()-1] + "." + symbol.GetName();
		namespaceScopes.pop_back();

		return IsEqualSymbol( namespaceScopes, name );
	}
	return false;
}
