#pragma once

#include <string>
#include <vector>

using namespace std;

class Prototype : public Symbol
{
public:
	enum Accessibility{
		None,
		Private,
		Protected,
		Public,
	};

private:
	mutable bool isUsing;


	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Symbol );
		ar & BOOST_SERIALIZATION_NVP( isUsing );
	}


public:

	Prototype( const NamespaceScopes &namespaceScopes, const string &name )
		: Symbol( namespaceScopes, name )
		, isUsing( false )
	{
	}
	Prototype()
		: Symbol()
	{
	}
	~Prototype()
	{
	}

	//gƓǂmF
	bool IsEquals( const Prototype *prototype ) const
	{
		if( this == prototype ){
			return true;
		}
		return false;
	}

	// p
	bool IsUsing() const
	{
		return isUsing;
	}
	void Using() const
	{
		isUsing = true;
	}
};

class MemberPrototype
{
	Prototype::Accessibility accessibility;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & BOOST_SERIALIZATION_NVP( accessibility );
	}

public:
	MemberPrototype( Prototype::Accessibility accessibility )
		: accessibility( accessibility )
	{
	}
	MemberPrototype()
		: accessibility( Prototype::None )
	{
	}

	Prototype::Accessibility GetAccessibility() const
	{
		return accessibility;
	}
	void SetAccessibility( Prototype::Accessibility accessibility ){
		this->accessibility = accessibility;
	}

	bool IsNoneAccess() const
	{
		return ( accessibility == Prototype::None );
	}
	bool IsPrivate() const
	{
		return ( accessibility == Prototype::Private );
	}
	bool IsProtected() const
	{
		return ( accessibility == Prototype::Protected );
	}
	bool IsPublic() const
	{
		return ( accessibility == Prototype::Public );
	}
};
