#pragma once

namespace ActiveBasic{ namespace Common{ namespace Lexical{


class Symbol
{
	static const NamespaceSupporter *namespaceSupporter;

	NamespaceScopes namespaceScopes;
	std::string name;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		//trace_for_serialize( "serializing(load) - Symbol" );

		ar & BOOST_SERIALIZATION_NVP( namespaceScopes );

		std::string _name;
		ar & BOOST_SERIALIZATION_NVP( _name );
		this->name = Operator_NaturalStringToCalcMarkString( _name );
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		//trace_for_serialize( "serializing(save) - Symbol" );

		ar & BOOST_SERIALIZATION_NVP( namespaceScopes );

		std::string _name = Operator_CalcMarkStringToNaturalString( name );
		ar & BOOST_SERIALIZATION_NVP( _name );
	}

public:
	bool isTargetObjectModule;
	Symbol( const NamespaceScopes &namespaceScopes, const std::string &name )
		: namespaceScopes( namespaceScopes )
		, name( name )
		, isTargetObjectModule( true )
	{
	}
	Symbol( const Symbol &symbol )
		: namespaceScopes( symbol.namespaceScopes )
		, name( symbol.name )
		, isTargetObjectModule( true )
	{
	}
	Symbol()
		: isTargetObjectModule( true )
	{
	}

	static void RegistNamespaceSupporter( const NamespaceSupporter *namespaceSupporter )
	{
		Symbol::namespaceSupporter = namespaceSupporter;
	}

	virtual const NamespaceScopes &GetNamespaceScopes() const
	{
		return namespaceScopes;
	}
	const std::string &GetName() const
	{
		return name;
	}
	std::string GetFullName() const;

	// V{r
	bool IsEqualSymbol( const NamespaceScopes &namespaceScopes, const std::string &name ) const;
	bool IsEqualSymbol( const Symbol &symbol ) const;
};


}}}
