#include "stdafx.h"

#include <Compiler.h>
#include <Symbol.h>

const NamespaceSupporter *Symbol::namespaceSupporter = NULL;

std::string Symbol::GetFullName() const
{
	if( namespaceScopes.size() )
	{
		return namespaceScopes.ToString() + "." + name;
	}

	return name;
}

bool Symbol::IsEqualSymbol( const NamespaceScopes &namespaceScopes, const string &name ) const
{
	if( GetName() != name ){
		return false;
	}

	_ASSERTE( namespaceSupporter );
	return namespaceSupporter->IsSameAreaNamespace( GetNamespaceScopes(), namespaceScopes );
}
bool Symbol::IsEqualSymbol( const Symbol &symbol ) const
{
	if( IsEqualSymbol( symbol.GetNamespaceScopes(), symbol.GetName() ) )
	{
		return true;
	}

	if( symbol.GetNamespaceScopes().size() >= 1 )
	{
		// ÓIol
		NamespaceScopes namespaceScopes( symbol.GetNamespaceScopes() );
		string name = namespaceScopes[namespaceScopes.size()-1] + "." + symbol.GetName();
		namespaceScopes.pop_back();

		return IsEqualSymbol( namespaceScopes, name );
	}
	return false;
}
bool Symbol::IsEqualSymbol( const char *fullName ) const
{
	char AreaName[VN_SIZE] = "";		//IuWFNgϐ
	char NestName[VN_SIZE] = "";		//qo
	bool isNest = SplitMemberName( fullName, AreaName, NestName );

	if( IsEqualSymbol( NamespaceScopes( AreaName ), NestName ) ){
		return true;
	}

	return false;
}
