#include "stdafx.h"

#include <Namespace.h>


using namespace ActiveBasic::Common::Lexical;


NamespaceScopes::NamespaceScopes( const std::string &namespaceStr ){
	if( namespaceStr.size() == 0 ){
		return;
	}

	std::string::size_type i = 0;
	while( true ){
		std::string::size_type i2 = namespaceStr.find( '.', i );

		std::string tempName = namespaceStr.substr( i, i2-i );

		push_back( tempName );

		if( i2 == std::string::npos ){
			break;
		}

		i = i2 + 1;
	}
}

void NamespaceScopesCollection::SplitNamespace( const char *fullName, char *namespaceStr, char *simpleName ) const
{
	NamespaceScopes namespaceScopes( fullName );
	bool hasSimpleName = false;
	while( namespaceScopes.size() > 0 ){
		if( IsExist( namespaceScopes ) ){
			break;
		}
		namespaceScopes.pop_back();

		hasSimpleName = true;
	}

	lstrcpy( namespaceStr, namespaceScopes.ToString().c_str() );

	bool hasNamespace = false;
	if( namespaceStr[0] ){
		hasNamespace = true;
	}

	int dotLength = 0;
	if( hasSimpleName && hasNamespace ){
		dotLength = 1;
	}

	lstrcpy( simpleName, fullName + lstrlen( namespaceStr ) + dotLength );
}

