#pragma once

#include <vector>
#include <string>
#include <boost/foreach.hpp>


namespace ActiveBasic{ namespace Common{ namespace Lexical{


class NamespaceScopes : public std::vector<std::string>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & boost::serialization::make_nvp("vector_string", boost::serialization::base_object<vector<string>>(*this));
	}


public:
	NamespaceScopes(){}
	NamespaceScopes( const std::string &namespaceStr );
	~NamespaceScopes(){}

	std::string ToString() const
	{
		std::string namespaceStr;
		const std::vector<std::string> &me = *this;

		bool isFirst = true;
		BOOST_FOREACH( const std::string &itemStr, me ){
			if( isFirst ){
				isFirst = false;
			}
			else{
				namespaceStr += ".";
			}

			namespaceStr += itemStr;
		}
		return namespaceStr;
	}

	// `FbN
	bool IsEqual( const std::string &name ) const
	{
		if( ToString() == name ){
			return true;
		}
		return false;
	}

	// `FbN
	bool IsEqual( const NamespaceScopes &namespaceScopes ) const
	{
		if( ToString() == namespaceScopes.ToString() ){
			return true;
		}
		return false;
	}

	// Ă邩`FbN
	// :
	// baseNamespaceScopes =  "Discoversoft"
	// entryNamespaceScopes = "Discoversoft.ActiveBasic"
	// ̏ꍇAentryNamespaceScopes  baseNamespaceScopes ɏĂB
	static bool IsBelong( const NamespaceScopes &baseNamespaceScopes, const NamespaceScopes &entryNamespaceScopes )
	{
		if( baseNamespaceScopes.size() > entryNamespaceScopes.size() ){
			return false;
		}

		for( int i=0; i<(int)baseNamespaceScopes.size(); i++ ){
			if( baseNamespaceScopes[i] != entryNamespaceScopes[i] ){
				return false;
			}
		}
		return true;
	}
};

class NamespaceScopesCollection : public std::vector<NamespaceScopes>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		ar & boost::serialization::make_nvp("vector_NamespaceScopes", boost::serialization::base_object<vector<NamespaceScopes>>(*this));
	}

public:
	bool IsExist( const NamespaceScopes &namespaceScopes ) const
	{
		const NamespaceScopesCollection &namespaceScopesCollection = *this;
		BOOST_FOREACH( const NamespaceScopes &tempNamespaceScopes, namespaceScopesCollection ){
			if( tempNamespaceScopes.IsEqual( namespaceScopes ) ){
				return true;
			}
		}
		return false;
	}
	bool IsExist( const std::string &namespaceStr ) const
	{
		return IsExist( NamespaceScopes( namespaceStr ) );
	}

	bool IsImported( const NamespaceScopes &namespaceScopes ) const
	{
		const NamespaceScopesCollection &namespaceScopesCollection = *this;
		BOOST_FOREACH( const NamespaceScopes &tempNamespaceScopes, namespaceScopesCollection )
		{
			if( namespaceScopes.IsEqual( tempNamespaceScopes ) )
			{
				return true;
			}
		}
		return false;
	}

	void SplitNamespace( const char *fullName, char *namespaceStr, char *simpleName ) const;
};


}}}
