#pragma once

#include <vector>
#include <string>

#include <Type.h>
#include <Symbol.h>

using namespace std;

class TypeDefCollection;

class TypeDef : public Symbol
{
	friend TypeDefCollection;

	string baseName;
	Type baseType;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - TypeDef" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Symbol );
		ar & BOOST_SERIALIZATION_NVP( baseName );
		ar & BOOST_SERIALIZATION_NVP( baseType );
	}

public:
	TypeDef( const NamespaceScopes &namespaceScopes, const string &name, const string &baseName, int nowLine );
	TypeDef()
	{
	}
	~TypeDef()
	{
	}

	const string &GetBaseName() const
	{
		return baseName;
	}
	const Type &GetBaseType() const
	{
		return baseType;
	}
};

class TypeDefCollection : public std::vector<TypeDef>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - TypeDefCollection" );

		ar & boost::serialization::make_nvp("vector_TypeDef",
			boost::serialization::base_object<std::vector<TypeDef>>(*this));
	}

public:
	TypeDefCollection();
	~TypeDefCollection();

	void Add( const NamespaceScopes &namespaceScopes, const string &name, const string &baseName, int nowLine );
	int GetIndex( const NamespaceScopes &namespaceScopes, const string &name ) const;
	int GetIndex( const string &fullName ) const;

private:
	void Add( const NamespaceScopes &namespaceScopes, const string &expression, int nowLine );
public:
	void CollectTypeDefs();
};
