#include "stdafx.h"

using namespace ActiveBasic::IDE;
using namespace ActiveBasic::IDE::WindowComponents;

LRESULT CALLBACK WindowFunc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam);
void SetupWindow(HWND hwnd);
void ResetTextEditFont(HWND hwnd);

::LRESULT MainFrame::OnCreate( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, ::BOOL& handled )
{
	// EBhEGA}l[WɐeEBhEo^
	wam.SetParentWnd( m_hWnd );

	RECT rect;
	GetClientRect( &rect );

	// MDIx[X쐬
	mdiWindow = new MdiWindow();
	mdiWindow->Create(
		m_hWnd,
		rect,
		NULL,
		WS_CHILD
	);
	wam.AddMdiWindow( mdiWindow );





	extern HWND hOwner;
	hOwner = m_hWnd;
	extern WNDPROC oldMainFrameWndProc;
	oldMainFrameWndProc = (WNDPROC)::GetWindowLong( hOwner, GWL_WNDPROC );
	::SetWindowLong( hOwner, GWL_WNDPROC, (LONG)WindowFunc );

	SetupWindow(hOwner);

	//eLXgGfB^tHgݒ
	ResetTextEditFont(hOwner);



	return 0;
}

void MainFrame::OnSize(UINT nType, CSize size)
{
	//mdiWindow->MoveWindow( 0, 0, size.cx, size.cy );
}

::LRESULT MainFrame::OnClose( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, ::BOOL& handled )
{
	DestroyWindow();
	return 0;
}
::LRESULT MainFrame::OnDestroy( ::UINT msg, ::WPARAM wParam, ::LPARAM lParam, ::BOOL& handled )
{
	mdiWindow->DestroyWindow();
	delete mdiWindow;

	::PostQuitMessage( 0 );

	return 0;
}

void backup(void *dummy);
void MainFrame::OnTimer( UINT_PTR id )
{
	switch( id )
	{
	case ID_TIMER_BACKUP:
		_beginthread( backup, 0, 0 );
		break;

#ifndef THETEXT
	case ID_DEBUGSAFTY:
		{
			//BasicCompiler.exeIĂ邩ǂ
			extern CDebugger *pobj_Debugger;
			pobj_Debugger->SaftyCheck();
			break;
		}
#endif
	}
}

void ResetState_EditMenu(void);
void MainFrame::OnDrawClipboard()
{
	ResetState_EditMenu();
}

void MenuAdvice(WPARAM msg);
void MainFrame::OnMenuSelect( UINT nItemID, UINT nFlags, HMENU menu )
{
	MenuAdvice( nItemID );
}

void MainFrame::OnInitMenu( HMENU menu )
{
	extern CNonVolatile *pobj_nv;
	extern CSubMenuEx *pobj_FileHistoryMenu;
	pobj_nv->pobj_History->ResetFileMenu(pobj_FileHistoryMenu,1);
#ifndef THETEXT
	extern CSubMenuEx *pobj_ProjectHistoryMenu;
	pobj_nv->pobj_ProjectHistory->ResetFileMenu(pobj_ProjectHistoryMenu,0);
#endif
}

void MainFrame::OnMeasureItem( int nIDCtl, LPMEASUREITEMSTRUCT lpMI )
{
	if(lpMI->CtlType==ODT_MENU){
		SIZE size;
		CMenuItemData *pobj_MenuItemData;
		pobj_MenuItemData=(CMenuItemData *)lpMI->itemData;
		if(pobj_MenuItemData->pobj_ThisMenu->hMenu==pobj_MainMenu->hMenu){
			//Cj[̐eACe
			pobj_MainMenu->GetItemSize(pobj_MenuItemData->item_index,&size);
			lpMI->itemWidth = size.cx;
			lpMI->itemHeight = size.cy;
		}
		else{
			//Cj[ɂԂ炳Tuj[
			pobj_MenuItemData->pobj_ThisMenu->GetItemSize(pobj_MenuItemData->item_index,&size);
			lpMI->itemWidth = size.cx;
			lpMI->itemHeight = size.cy;
		}
	}
}

void MainFrame::OnDrawItem( int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct )
{
	if(lpDrawItemStruct->CtlType==ODT_MENU){
		if(!pobj_MainMenu) return;

		CMenuItemData *pobj_MenuItemData;
		pobj_MenuItemData=(CMenuItemData *)lpDrawItemStruct->itemData;
		if(pobj_MainMenu->hMenu==pobj_MenuItemData->pobj_ThisMenu->hMenu){
			//Cj[̐eACe
			pobj_MainMenu->OwnerDrawMenu(lpDrawItemStruct->hDC,
				&lpDrawItemStruct->rcItem,
				(lpDrawItemStruct->itemState&ODS_SELECTED)!=0,
				pobj_MenuItemData->item_index);
		}
		else{
			//Cj[ɂԂ炳Tuj[
			pobj_MainMenu->OwnerDrawSubMenu(pobj_MenuItemData->pobj_ThisMenu->hMenu,
				lpDrawItemStruct->hDC,
				&lpDrawItemStruct->rcItem,
				(lpDrawItemStruct->itemState&ODS_SELECTED)!=0,
				pobj_MenuItemData->item_index);
		}
	}
}

LRESULT MainFrame::OnNotify( int idCtrl, LPNMHDR pnmh )
{
	NMPGCALCSIZE *lpCalcSize;
	NMPGSCROLL *lpScroll;

	if(!pnmh) return 0;
	LPTOOLTIPTEXT TipText=(LPTOOLTIPTEXT)pnmh;
	if(TipText->hdr.code==TTN_NEEDTEXT) ShowToolTipText(TipText);

	extern HWND hStandardToolbarPager;
	extern HWND hDebuggerToolbarPager;
	if(pobj_Rebar){
		//o[IuWFNg݂Ƃ
		if(pnmh->hwndFrom==pobj_Rebar->hRebar&&pnmh->code==RBN_HEIGHTCHANGE){
			ResizeOwnerWnd();
			return 0;
		}
	}
	if(pnmh->hwndFrom==hStandardToolbarPager){
		if(pnmh->code==PGN_CALCSIZE){
			lpCalcSize=(LPNMPGCALCSIZE)pnmh;
			if(lpCalcSize->dwFlag==PGF_CALCWIDTH)
				lpCalcSize->iWidth=BMPNUM_STANDARDTOOLBAR*23+SEPNUM_STANDARDTOOLBAR*8;
		}
		else if(pnmh->code==PGN_SCROLL){
			lpScroll=(LPNMPGSCROLL)pnmh;
			lpScroll->iScroll=20;
		}
	}
	else if(pnmh->hwndFrom==hDebuggerToolbarPager){
		if(pnmh->code==PGN_CALCSIZE){
			lpCalcSize=(LPNMPGCALCSIZE)pnmh;
			if(lpCalcSize->dwFlag==PGF_CALCWIDTH)
				lpCalcSize->iWidth=BMPNUM_DEBUGGERTOOLBAR*23+SEPNUM_DEBUGGERTOOLBAR*8;
		}
		else if(pnmh->code==PGN_SCROLL){
			lpScroll=(LPNMPGSCROLL)pnmh;
			lpScroll->iScroll=20;
		}
	}

	if(pobj_MainTab){
		if(pnmh->hwndFrom==pobj_MainTab->hTab){
			if(pnmh->code==TCN_SELCHANGE)
				pobj_MainTab->SelChangeEvent();

			if(pnmh->code==NM_RCLICK){

				TCHITTESTINFO tcHitTest;
				GetCursorPos(&tcHitTest.pt);
				::ScreenToClient(pobj_MainTab->hTab,&tcHitTest.pt);
				int index = TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
				if( index == -1 ) return 0;

				TabCtrl_SetCurSel(pobj_MainTab->hTab,index);

				pobj_MainTab->SelChangeEvent();


				/////////////////////
				// j[\
				/////////////////////

				HWND hChild=::GetWindow(hClient,GW_CHILD);
				int WndNum=GetWndNum(hChild);

				//ۑR}h̕Zbg
				char temporary[1024], temp2[1024];
				MENUITEMINFO mii;
				mii.cbSize=sizeof(MENUITEMINFO);
				mii.fMask=MIIM_TYPE;
				mii.dwTypeData=temporary;
				mii.fType=MFT_STRING;
				if(MdiInfo[WndNum].path[0]){
					_splitpath(MdiInfo[WndNum].path,NULL,NULL,temporary,temp2);
					lstrcat(temporary,temp2);
					lstrcat(temporary," ۑ(&S)");
				}
				else{
					lstrcpy(temporary,"ۑ(&S)");
				}
				extern HMENU hTabMenu;
				SetMenuItemInfo(hTabMenu,IDM_SAVE,FALSE,&mii);

				/*u΃pXRs[vutH_Jvut@C폜v
												R}hꍇɂĖɂ */
				if(MdiInfo[WndNum].path[0]){
					EnableMenuItem(hTabMenu,IDM_PATH_COPY,MF_BYCOMMAND|MF_ENABLED);
					EnableMenuItem(hTabMenu,IDM_FOLDER_OPEN,MF_BYCOMMAND|MF_ENABLED);
					EnableMenuItem(hTabMenu,IDM_DELETE_FILE,MF_BYCOMMAND|MF_ENABLED);
				}
				else{
					EnableMenuItem(hTabMenu,IDM_PATH_COPY,MF_BYCOMMAND|MF_GRAYED);
					EnableMenuItem(hTabMenu,IDM_FOLDER_OPEN,MF_BYCOMMAND|MF_GRAYED);
					EnableMenuItem(hTabMenu,IDM_DELETE_FILE,MF_BYCOMMAND|MF_GRAYED);
				}

				POINT MousePos;
				GetCursorPos(&MousePos);
				TrackPopupMenu(hTabMenu,TPM_LEFTALIGN|TPM_RIGHTBUTTON,MousePos.x,MousePos.y,0,hOwner,NULL);
			}
		}
	}
	if(pobj_SideWeb){
		if(pnmh->hwndFrom==pobj_SideWeb->hTab&&pnmh->code==TCN_SELCHANGE){
			pobj_SideWeb->SelChangeEvent();
		}
	}

	return 0;
}

void MainFrame::OnCmdNew( UINT uNotifyCode, int nID, CWindow wndCtl )
{

#ifdef THETEXT
	NewTextEditWindow(NULL,WNDTYPE_TEXT);
	return;
#else
	int FileType;
	BOOL bAddToProject;
	char temporary[MAX_PATH];

	FileType=DialogBox(hResInst,MAKEINTRESOURCE(IDD_NEWFILE),hOwner,(DLGPROC)DlgNewFile);
	if(FileType==-1) return;

	if(FileType&0x00008000){
		bAddToProject=1;
		FileType&=0x0FFF;
		extern char NewFileName[MAX_PATH];
		lstrcpy(temporary,NewFileName);
		if(!strstr(temporary,".")) lstrcat(temporary,".ab");
		GetFullPath(temporary,ProjectInfo.dir);
	}
	else bAddToProject=0;

	switch(FileType){
		case FT_BASICPROGRAM:		//BasicvO
		case FT_SUBPROGRAM:
			if(bAddToProject){
				WriteBuffer(temporary,0,0);
				NewTextEditWindow(temporary,WNDTYPE_BASIC);
				Project_File_Insert(temporary);
			}
			else NewTextEditWindow(NULL,WNDTYPE_BASIC);
			break;

		case FT_PROJECT:
			DlgNewProjectWizard(hOwner);
			break;

		case FT_TEXT:
			NewTextEditWindow(NULL,WNDTYPE_TEXT);
			break;

		case FT_HTML:
			NewTextEditWindow(NULL,WNDTYPE_HTML);
			break;

		case FT_ICON:
			NewIconEditWindow(NULL);
			break;
	}
#endif
}

void MainFrame::OnCmdOpen( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//"t@Cw肵Ă"
	extern LPSTR DefFileFilter;
	char temporary[1024];
	if(!GetFilePathDialog(m_hWnd,temporary,DefFileFilter,STRING_FILEOPENTITLE_DEFAULT,TRUE)) return;

	OpenFileWithExtension( temporary );
}

void MainFrame::OnCmdClose( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(::IsWindow(hChild)) SendMessage(hChild,WM_CLOSE,0,0);
}

void MainFrame::OnCmdProjectOpen( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//"vWFNg t@Cw肵ĉ"
	extern LPSTR ProjectFileFilter;
	char temporary[1024];
	if(!GetFilePathDialog(m_hWnd,temporary,ProjectFileFilter,STRING_FILEOPENTITLE_PROJECT,TRUE))
	{
		return;
	}

	OpenProject(temporary);
}

void MainFrame::OnCmdProjectSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	SaveProject();
}

void MainFrame::OnCmdProjectClose( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	CloseProject();
}

void MainFrame::OnCmdProjectFolderOpen( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	ShellExecute(m_hWnd,"explore",ProjectInfo.dir,NULL,NULL,SW_SHOWNORMAL);
}

void MainFrame::OnCmdSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	SaveDocument(::GetWindow(hClient,GW_CHILD),NULL);
}

void MainFrame::OnCmdNewSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//"ۑ̃t@Cw肵Ă"
	extern LPSTR DefFileFilter;
	char temporary[1024];
	if(!GetFilePathDialog(m_hWnd,temporary,DefFileFilter,STRING_FILESAVETITLE_DEFAULT,FALSE)) return;

	SaveDocument(::GetWindow(hClient,GW_CHILD),temporary);
}

void MainFrame::OnCmdCodeSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//R[hw肵ĕۑ
	DialogBox(hResInst,MAKEINTRESOURCE(IDD_CODE_SAVE),m_hWnd,(DLGPROC)nkfDlgCodeSave);
}

void MainFrame::OnCmdAllSave( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	for( int i=0;i<MAX_WNDNUM;i++){
		if(MdiInfo[i].hwnd) SaveDocument(MdiInfo[i].hwnd,NULL);
	}
	if(ProjectInfo.name[0]) SaveProject();
}

void MainFrame::OnCmdPageSet( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//y[Wݒ
	obj_Page.SetupDlg();
}

void MainFrame::OnCmdPreview( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//vr[iProł̂݁j
	Preview();
}

void MainFrame::OnCmdPrintOut( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	//
	Printout();
}

void MainFrame::OnCmdExit( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	SendMessage(WM_CLOSE);
}

void MainFrame::OnCmdUndo( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(!hChild) return;
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType))
		TextEdit_UndoCommand(WndNum);
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD)
		Rad_UndoCommand(WndNum);
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT)
		IconEdit_UndoCommand(WndNum);
}

void MainFrame::OnCmdRedo( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(!hChild) return;
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType))
		TextEdit_RedoCommand(WndNum);
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD)
		Rad_RedoCommand(WndNum);
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT)
		IconEdit_RedoCommand(WndNum);
}

void MainFrame::OnCmdCut( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		HWND hEdit=::GetWindow(hChild,GW_CHILD);

		CHARRANGE CharRange;
		TextEdit_GetSel(WndNum,&CharRange);

		HGLOBAL hGlobal=(char *)GlobalAlloc(GMEM_MOVEABLE,CharRange.cpMax-CharRange.cpMin+1);
		char *pTemp=(char *)GlobalLock(hGlobal);
		memcpy(pTemp,MdiInfo[WndNum].pMdiTextEdit->buffer+CharRange.cpMin,CharRange.cpMax-CharRange.cpMin);
		pTemp[CharRange.cpMax-CharRange.cpMin]=0;
		GlobalUnlock(hGlobal);

		//Nbv{[hɕۑ
		OpenClipboard();
		EmptyClipboard();
		SetClipboardData(CF_TEXT,hGlobal);
		CloseClipboard();

		//I𕶎
		SendMessage(hEdit,WM_KEYDOWN,VK_DELETE,0);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
		int indexOfWndInfo = GetWndInfoNum(MdiInfo[WndNum].path);

		//Nbv{[hɊi[邽߂̃f[^pӂ
		ProjectInfo.pWindowInfo[indexOfWndInfo].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.x-=17;
		ProjectInfo.pWindowInfo[indexOfWndInfo].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.y-=10;
		HGLOBAL hGlobal=Rad_GetChildInfoClipboardData(WndNum,indexOfWndInfo);
		ProjectInfo.pWindowInfo[indexOfWndInfo].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.x+=17;
		ProjectInfo.pWindowInfo[indexOfWndInfo].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.y+=10;

		OpenClipboard();
		EmptyClipboard();
		extern DWORD dwRadClipboardID;
		SetClipboardData(dwRadClipboardID,hGlobal);
		CloseClipboard();

		SendMessage(MdiInfo[WndNum].MdiRadInfo->hRad,WM_COMMAND,IDM_RAD_ITEM_DELETE,0);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
		//Nbv{[hɊi[邽߂̃f[^pӂ
		HGLOBAL hGlobal=IconEdit_GetChildInfoClipboardData(WndNum);
		if(hGlobal==0) return;

		OpenClipboard();
		EmptyClipboard();
		SetClipboardData(CF_BITMAP,hGlobal);
		CloseClipboard();

		DeleteObject(MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp);
		MdiInfo[WndNum].MdiIconEditInfo->SelectLevel=0;

		IconEdit_EraseRect(WndNum,&MdiInfo[WndNum].MdiIconEditInfo->DraggingRect);
	}
}

void MainFrame::OnCmdCopy( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		HWND hEdit = ::GetWindow(hChild,GW_CHILD);

		CHARRANGE CharRange;
		TextEdit_GetSel(WndNum,&CharRange);

		HGLOBAL hGlobal=(char *)GlobalAlloc(GMEM_MOVEABLE,CharRange.cpMax-CharRange.cpMin+1);
		char *pTemp=(char *)GlobalLock(hGlobal);
		memcpy(pTemp,MdiInfo[WndNum].pMdiTextEdit->buffer+CharRange.cpMin,CharRange.cpMax-CharRange.cpMin);
		pTemp[CharRange.cpMax-CharRange.cpMin]=0;
		GlobalUnlock(hGlobal);

		//Nbv{[hɕۑ
		OpenClipboard();
		EmptyClipboard();
		SetClipboardData(CF_TEXT,hGlobal);
		CloseClipboard();
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
		int indexOfWndInfo = GetWndInfoNum(MdiInfo[WndNum].path);

		//Nbv{[hɊi[邽߂̃f[^pӂ
		HGLOBAL hGlobal=Rad_GetChildInfoClipboardData(WndNum,indexOfWndInfo);

		OpenClipboard();
		EmptyClipboard();
		extern DWORD dwRadClipboardID;
		SetClipboardData(dwRadClipboardID,hGlobal);
		CloseClipboard();
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
		//Nbv{[hɊi[邽߂̃f[^pӂ
		HGLOBAL hGlobal=IconEdit_GetChildInfoClipboardData(WndNum);

		OpenClipboard();
		EmptyClipboard();
		SetClipboardData(CF_BITMAP,hGlobal);
		CloseClipboard();
	}
}

void MainFrame::OnCmdPaste( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		HWND hEdit=::GetWindow(hChild,GW_CHILD);

		//Nbv{[hJ
		OpenClipboard();
		HGLOBAL hGlobal=GetClipboardData(CF_TEXT);
		if(!hGlobal){
			CloseClipboard();
			return;
		}


		char *pTemp;
		if(pobj_nv->bPasteIndent){
			//Cfg`
			pTemp=CodeFormatter((char *)GlobalLock(hGlobal));
			GlobalUnlock(hGlobal);
		}
		else pTemp=(char *)GlobalLock(hGlobal);


		//eLXgGfB^̕vCX
		TextEdit_ReplaceUpdateUndoData(WndNum,
			pTemp,
			1,
			1);

		if(pobj_nv->bPasteIndent)
			HeapDefaultFree(pTemp);
		else
			GlobalUnlock(hGlobal);

		//Nbv{[h
		CloseClipboard();


		//Lbgʒu܂ŃXN[
		TextEdit_ScrollCaret(WndNum,0);
		ResetCaretPos(WndNum);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
		OpenClipboard();
		extern DWORD dwRadClipboardID;
		HGLOBAL hGlobal=GetClipboardData(dwRadClipboardID);
		if(!hGlobal){
			CloseClipboard();
			return;
		}
		Rad_PasteChildInfoClipboardData(WndNum,hGlobal);
		CloseClipboard();
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
		OpenClipboard();
		HGLOBAL hGlobal=GetClipboardData(CF_BITMAP);
		if(!hGlobal){
			CloseClipboard();
			return;
		}
		IconEdit_PasteChildInfoClipboardData(WndNum,(HBITMAP)hGlobal);
		CloseClipboard();
	}
}

void MainFrame::OnCmdDelete( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		HWND hEdit=::GetWindow(hChild,GW_CHILD);
		TextEdit_ReplaceUpdateUndoData(WndNum,"",0,1);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD)
		SendMessage(MdiInfo[WndNum].MdiRadInfo->hRad,WM_COMMAND,IDM_RAD_ITEM_DELETE,0);
}

void MainFrame::OnCmdAllSelect( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	HWND hChild=::GetWindow(hClient,GW_CHILD);
	int WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		HWND hEdit=::GetWindow(hChild,GW_CHILD);

		MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.x=0;
		MdiInfo[WndNum].pMdiTextEdit->StartCaretPos.y=0;

		GetCaretPosFromBufferIndex(
			MdiInfo[WndNum].pMdiTextEdit->buffer,
			lstrlen(MdiInfo[WndNum].pMdiTextEdit->buffer),
			&MdiInfo[WndNum].pMdiTextEdit->EndCaretPos);

		::InvalidateRect(hEdit,NULL,0);

		ResetState_EditMenu();
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
		int i2=GetWndInfoNum(MdiInfo[WndNum].path);
		for(int i3=0;i3<ProjectInfo.pWindowInfo[i2].NumberOfChildWindows;i3++){
			MdiInfo[WndNum].MdiRadInfo->SelectingItem[i3]=i3;
		}
		DrawRadWindow(WndNum,&ProjectInfo.pWindowInfo[i2]);
	}
}

void MainFrame::OnCmdFind( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DialogBox(hResInst,MAKEINTRESOURCE(IDD_FIND),m_hWnd,(DLGPROC)DlgFind);
}

void MainFrame::OnCmdPermutation( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DialogBox(hResInst,MAKEINTRESOURCE(IDD_PERMUTATION),m_hWnd,(DLGPROC)DlgPermutation);
}

void MainFrame::OnCmdConvertX( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	TextEdit_Convert( nID );
}

#ifdef THETEXT
void MainFrame::OnCmdStringCount( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_STRING_COUNT),m_hWnd,(DLGPROC)DlgStringCount,0);
}

void MainFrame::OnCmdSelStringCount( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_STRING_COUNT),m_hWnd,(DLGPROC)DlgStringCount,1);
}
#endif

void MainFrame::OnCmdProjectView( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	extern HWND hProjectView;
	bool isCheck = false;
	if(pobj_nv->bClipProjectView){
		if(::IsWindowVisible(hProjectView)){
			::ShowWindow(hProjectView,SW_HIDE);
		}
		else{
			::ShowWindow(hProjectView,SW_SHOW);
			isCheck = true;
		}
	}
	else{
		extern HWND hProjectView_ToolWindow;
		if(::IsWindowVisible(hProjectView_ToolWindow)){
			::ShowWindow(hProjectView_ToolWindow,SW_HIDE);
		}
		else{
			::ShowWindow(hProjectView_ToolWindow,SW_SHOW);
			::ShowWindow(hProjectView,SW_SHOW);
			isCheck = true;
		}
	}
	pobj_MainMenu->CheckMenu(IDM_PROJECTVIEW,isCheck);

	//Ĕzu
	ResizeOwnerWnd();

	::ShowWindow(hClient,SW_SHOW);
}

void MainFrame::OnCmdProjectOption( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DlgProjectOptionSetting( m_hWnd );
}

void MainFrame::OnCmdTopMost( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	if(pobj_MainMenu->IsCheck(IDM_TOPMOST)){
		SetWindowPos( HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
		pobj_MainMenu->CheckMenu(IDM_TOPMOST,0);
	}
	else{
		SetWindowPos( HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
		pobj_MainMenu->CheckMenu(IDM_TOPMOST,1);
	}
}

void ResetState_ViewMenu(void);
void MainFrame::OnCmdRightTurn( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	pobj_nv->bRightTurn^=1;
	ResetState_ViewMenu();

	//gbṽEBhEĕ`
	RedrawAllWindow();
}

void MainFrame::OnCmdSet( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	DlgOptionSetting( m_hWnd );
}

void CreateProcessWithStdHandle( const std::string &appPath, const std::string &cmdLine)
{
	std::string argsStr = (std::string)"\"" + appPath + "\" " + cmdLine;
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	memset(&si,0,sizeof(STARTUPINFO));
	si.cb=sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
	si.wShowWindow = SW_HIDE;
	si.hStdOutput = GetStdHandle(STD_OUTPUT_HANDLE);
	si.hStdInput = GetStdHandle(STD_INPUT_HANDLE);
	si.hStdError = GetStdHandle(STD_ERROR_HANDLE);
	
	char args[8192];
	lstrcpy( args, argsStr.c_str() );

	CreateProcess( NULL, args, NULL, NULL, FALSE, NORMAL_PRIORITY_CLASS, NULL, NULL, &si, &pi );
}

void MainFrame::OnCmdDebug( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024], temp3[1024];
	if(pobj_Debugger->IsDebugging()){
		pobj_Debugger->DebugContinue();
		return;
	}

	HWND hChild = ::GetWindow(hClient,GW_CHILD);
	if(ProjectInfo.name[0]){
		//vWFNgJĂꍇ
		if(!SetProjectToRun()) return;

		//fobOp̃R}hCyюs\t@CiDLL̂݁j
		sprintf(temporary,"%s\r\n%s",ProjectInfo.szExePath,ProjectInfo.szCmdLine);
		sprintf(temp2,"%spgm.tmp",pj_editor_Dir);
		HANDLE hFile=CreateFile(temp2,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE|FILE_ATTRIBUTE_HIDDEN|FILE_ATTRIBUTE_TEMPORARY,NULL);
		DWORD dwAccessBytes;
		WriteFile(hFile,temporary,lstrlen(temporary),&dwAccessBytes,NULL);
		CloseHandle(hFile);

		//\[Xt@Ctemp2
		ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[0]->GetFullPath(temp2);

		//o̓t@Ctemp3
		lstrcpy(temp3,ProjectInfo.lpszOutput_Debug);
		GetFullPath(temp3,ProjectInfo.dir);

		if(IsNeedCompileForProject(1))
			sprintf(temporary,"\"%s\" \"%s\" /debug /run /wnd:%08x",temp2,temp3,m_hWnd);
		else
			sprintf(temporary,"\"%s\" \"%s\" /run /wnd:%08x",temp2,temp3,m_hWnd);

		//DLLIvV
		if(ProjectInfo.dwModuleType==MT_DLL) lstrcat(temporary," /dll");

		//UnicodeIvV
		if(ProjectInfo.dwOption & PJ_OP_UNICODE) lstrcat(temporary," /unicode");

		//u[N|CgZ[u
		ProjectInfo.pobj_DBBreakPoint->SaveToTempFile();
	}
	else{
		//Pƃ\[XR[h
		if(!SetRunning(hChild)) return;
		if(IsNeedCompile(MdiInfo[GetWndNum(hChild)].path,1))
			sprintf(temporary,"\"%s\" /debug /run /wnd:%08x",MdiInfo[GetWndNum(hChild)].path,m_hWnd);
		else
			sprintf(temporary,"\"%s\" /run /wnd:%08x",MdiInfo[GetWndNum(hChild)].path,m_hWnd);

		//u[N|CgZ[u
		extern CDBBreakPoint *pobj_DBBreakPoint;
		pobj_DBBreakPoint->SaveToTempFile();
	}

	//RpCr[Nbv邩ǂ
	extern BOOL bClipCompileView;
	if(bClipCompileView){
		lstrcat(temporary," /clip_compile_view");

		//RpCr[
		extern HWND hCompileView;
		if(hCompileView==(HWND)-1) return;
		if(hCompileView){
			hChild=hCompileView;
			hCompileView=(HWND)-1;
			SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
		}

		//dNh~̂
		hCompileView=(HWND)-1;
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	CreateProcessWithStdHandle( ActiveBasic::Common::Environment::GetCompilerExePath( selectingPlatform ), temporary );
}

void MainFrame::OnCmdDebugCompile( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024], temp3[1024];

	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(ProjectInfo.name[0]){
		//vWFNgJĂꍇ
		if(!SetProjectToRun()) return;

		//\[Xt@Ctemp2
		ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[0]->GetFullPath(temp2);

		//o̓t@Ctemp3
		lstrcpy(temp3,ProjectInfo.lpszOutput_Debug);
		GetFullPath(temp3,ProjectInfo.dir);

		sprintf(temporary,"\"%s\" \"%s\" /debug /wnd:%08x",temp2,temp3,m_hWnd);

		//DLLIvV
		if(ProjectInfo.dwModuleType==MT_DLL) lstrcat(temporary," /dll");

		//UnicodeIvV
		if(ProjectInfo.dwOption & PJ_OP_UNICODE) lstrcat(temporary," /unicode");
	}
	else{
		//Pƃ\[XR[h
		if(!SetRunning(hChild)) return;
		sprintf(temporary,"\"%s\" /debug /wnd:%08x",MdiInfo[GetWndNum(hChild)].path,m_hWnd);
	}

	//RpCr[Nbv邩ǂ
	extern BOOL bClipCompileView;
	if(bClipCompileView){
		lstrcat(temporary," /clip_compile_view");

		//RpCr[
		extern HWND hCompileView;
		if(hCompileView==(HWND)-1) return;
		if(hCompileView){
			hChild=hCompileView;
			hCompileView=(HWND)-1;
			SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
		}

		//dNh~̂
		hCompileView=(HWND)-1;	
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	CreateProcessWithStdHandle( ActiveBasic::Common::Environment::GetCompilerExePath( selectingPlatform ), temporary );

}

void MainFrame::OnCmdAttach( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024];

	int idProcess;
	DWORD dwPlatform;
	idProcess=DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_ATTACH),m_hWnd,(DLGPROC)DlgAttach,(LPARAM)&dwPlatform);
	if(idProcess==0) return;

	sprintf(temporary,"/attach:%08x /wnd:%08x",idProcess,m_hWnd);

	//RpCr[Nbv邩ǂ
	extern BOOL bClipCompileView;
	if(bClipCompileView){
		lstrcat(temporary," /clip_compile_view");

		//RpCr[
		extern HWND hCompileView;
		if(hCompileView==(HWND)-1) return;
		if(hCompileView){
			HWND hChild=hCompileView;
			hCompileView=(HWND)-1;
			SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
		}

		//dNh~̂
		hCompileView=(HWND)-1;
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	ActiveBasic::Common::Platform::EnumType platform;
	if(dwPlatform==IMAGE_FILE_MACHINE_I386)
	{
		platform = ActiveBasic::Common::Platform::X86;
	}
	else if(dwPlatform==IMAGE_FILE_MACHINE_AMD64)
	{
		platform = ActiveBasic::Common::Platform::X64;
	}
	else
	{
		throw;
	}

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	CreateProcessWithStdHandle( ActiveBasic::Common::Environment::GetCompilerExePath( platform ), temporary );
}

void MainFrame::OnCmdReleaseCompile( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024], temp3[1024];

	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(ProjectInfo.name[0]){
		//vWFNgJĂꍇ
		if(!SetProjectToRun()) return;

		//\[Xt@Ctemp2
		ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[0]->GetFullPath(temp2);

		//o̓t@Ctemp3
		lstrcpy(temp3,ProjectInfo.lpszOutput_Release);
		GetFullPath(temp3,ProjectInfo.dir);

		sprintf(temporary,"\"%s\" \"%s\" /wnd:%08x",temp2,temp3,m_hWnd);

		//DLLIvV
		if(ProjectInfo.dwModuleType==MT_DLL) lstrcat(temporary," /dll");

		//UnicodeIvV
		if(ProjectInfo.dwOption & PJ_OP_UNICODE) lstrcat(temporary," /unicode");
	}
	else{
		//Pƃ\[XR[h
		if(!SetRunning(hChild)) return;
		sprintf(temporary,"\"%s\" /wnd:%08x",MdiInfo[GetWndNum(hChild)].path,m_hWnd);
	}

	//RpCr[Nbv邩ǂ
	extern BOOL bClipCompileView;
	if(bClipCompileView){
		lstrcat(temporary," /clip_compile_view");

		//RpCr[
		extern HWND hCompileView;
		if(hCompileView==(HWND)-1) return;
		if(hCompileView){
			hChild=hCompileView;
			hCompileView=(HWND)-1;
			SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
		}

		//dNh~̂
		hCompileView=(HWND)-1;
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	extern ActiveBasic::Common::Platform::EnumType selectingPlatform;
	CreateProcessWithStdHandle( ActiveBasic::Common::Environment::GetCompilerExePath( selectingPlatform ), temporary );
}

void MainFrame::OnCmdReleaseRun( UINT uNotifyCode, int nID, CWindow wndCtl )
{
	char temporary[1024], temp2[1024], temp3[1024];

	HWND hChild=::GetWindow(hClient,GW_CHILD);
	if(ProjectInfo.name[0]){
/*						//vWFNgJĂꍇ
		if(!SetProjectToRun()) return;

		//Kvł΃[XRpC
		if(IsNeedCompileForProject(0))
			SendMessage(WM_COMMAND,IDM_RELEASECOMPILE,0);*/

		if(ProjectInfo.dwModuleType==MT_DLL){
			lstrcpy(temporary,ProjectInfo.szExePath);
		}
		else{
			lstrcpy(temporary,ProjectInfo.lpszOutput_Debug);
			GetFullPath(temporary,ProjectInfo.dir);
		}
	}
	else{
/*						//Kvł΃[XRpC
		if(!SetRunning(hChild)) return;

		if(IsNeedCompile(MdiInfo[GetWndNum(hChild)].path,0))
			SendMessage(WM_COMMAND,IDM_RELEASECOMPILE,0);*/

		//Pƃ\[XR[h
		_splitpath(MdiInfo[GetWndNum(hChild)].path,temporary,temp2,temp3,NULL);
		lstrcat(temporary,temp2);
		lstrcat(temporary,temp3);
		lstrcat(temporary,".exe");
	}

	//CN[hfBNg
	sprintf(temp2," /include_dir:\"%s\"",pobj_nv->GetIncludeDirFullPath().c_str());
	lstrcat(temporary,temp2);

	ShellExecute(m_hWnd,"open",temporary,NULL,NULL,SW_SHOWNORMAL);
}
