#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

#define MDLFILE_VER	0x70000003


void SetLpIndex_DebugFile(char *buffer,int *p,int type,LONG_PTR lpIndex){
	if(NATURAL_TYPE(type)==DEF_OBJECT){
		lstrcpy(buffer+(*p),((CClass *)lpIndex)->name);
		(*p)+=lstrlen(buffer+(*p))+1;
	}
	else{
		*(LONG_PTR *)(buffer+(*p))=lpIndex;
		(*p)+=sizeof(LONG_PTR);
	}
}


void GetLpIndex_DebugFile(char *buffer,int *p,int type,LONG_PTR *plpIndex){
	if(NATURAL_TYPE(type)==DEF_OBJECT){
		char szClassName[VN_SIZE];
		lstrcpy(szClassName,buffer+(*p));
		(*p)+=lstrlen(buffer+(*p))+1;

		*plpIndex=(LONG_PTR)pobj_DBClass->check(szClassName);
	}
	else{
		*plpIndex=*(LONG_PTR *)(buffer+(*p));
		(*p)+=sizeof(LONG_PTR);
	}
}



CDebugSection::CDebugSection(){
	memset(this,0,sizeof(CDebugSection));
}
CDebugSection::~CDebugSection(){
	if(pobj_DBClass) DeleteDebugInfo();
	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}
}
void CDebugSection::make(void){
	extern VARIABLE *GlobalVar;
	extern int MaxGlobalVarNum;
	extern INCLUDEFILEINFO IncludeFileInfo;
	int i2,i3,i4,i5,BufferSize;

	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}

	i2=0;

	extern char *basbuf;
	i3=lstrlen(basbuf);

	BufferSize=lstrlen(basbuf)+65535;
	buffer=(char *)HeapAlloc(hHeap,0,BufferSize);

	//fobOpt@C̃o[W
	*(long *)(buffer+i2)=MDLFILE_VER;
	i2+=sizeof(long);

	//vbgtH[̃rbg
	*(long *)(buffer+i2)=PLATFORM;
	i2+=sizeof(long);

	//CN[h
	*(long *)(buffer+i2)=IncludeFileInfo.FilesNum;
	i2+=sizeof(long);
	for(i3=0;i3<IncludeFileInfo.FilesNum;i3++){
		lstrcpy(buffer+i2,IncludeFileInfo.ppFileNames[i3]);
		i2+=lstrlen(buffer+i2)+1;
	}
	buffer[i2++]=0;
	for(i3=0;;i3++){
		buffer[i2++]=(char)IncludeFileInfo.LineOfFile[i3];
		if(IncludeFileInfo.LineOfFile[i3]==-1) break;
	}

	//\[XR[h
	lstrcpy(buffer+i2,basbuf);
	i2+=lstrlen(buffer+i2)+1;


	////////////////////////
	// R[hƍsԍ̊֌W
	////////////////////////
	extern int MaxLineInfoNum;
	extern LINEINFO *pLineInfo;

	//obt@Ȃꍇ͍Ċm
	if(MaxLineInfoNum*sizeof(LINEINFO)<32768) i3=32768;
	else i3=MaxLineInfoNum*sizeof(LINEINFO)+32768;
	if(BufferSize<i2+i3){
		BufferSize+=i3;
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
	}

	*(long *)(buffer+i2)=MaxLineInfoNum;
	i2+=sizeof(long);
	memcpy(buffer+i2,pLineInfo,MaxLineInfoNum*sizeof(LINEINFO));
	i2+=MaxLineInfoNum*sizeof(LINEINFO);



	////////////////////////////////////////////
	// NXiÔ݁Bڍׂ͌ŕۑj
	////////////////////////////////////////////

	//Ce[^Zbg
	extern CDBClass *pobj_DBClass;
	pobj_DBClass->Iterator_Reset();

	//
	*(long *)(buffer+i2)=pobj_DBClass->Iterator_GetMaxCount();
	i2+=sizeof(long);

	while(pobj_DBClass->Iterator_HasNext()){
		CClass *pobj_c;
		pobj_c=pobj_DBClass->Iterator_GetNext();

		//NX
		lstrcpy(buffer+i2,pobj_c->name);
		i2+=lstrlen(buffer+i2)+1;
	}



	//////////////////
	// TypeDef
	//////////////////

	extern CDBTypeDef *pobj_DBTypeDef;
	*(long *)(buffer+i2)=pobj_DBTypeDef->iNum;
	i2+=sizeof(long);
	for(i3=0;i3<pobj_DBTypeDef->iNum;i3++){
		lstrcpy(buffer+i2,pobj_DBTypeDef->ppobj_TypeDef[i3]->lpszName);
		i2+=lstrlen(buffer+i2)+1;

		lstrcpy(buffer+i2,pobj_DBTypeDef->ppobj_TypeDef[i3]->lpszBaseName);
		i2+=lstrlen(buffer+i2)+1;

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}


	//O[oϐ
	*(long *)(buffer+i2)=MaxGlobalVarNum;
	i2+=sizeof(long);
	for(i3=0;i3<MaxGlobalVarNum;i3++){
		VARIABLE *pVar=&GlobalVar[i3];

		//ϐ
		lstrcpy(buffer+i2,pVar->name);
		i2+=lstrlen(buffer+i2)+1;

		//^
		*(long *)(buffer+i2)=pVar->type;
		i2+=sizeof(long);

		//^̊g
		SetLpIndex_DebugFile(buffer,&i2,pVar->type,pVar->u.index);

		buffer[i2++]=(char)pVar->fRef;

		buffer[i2++]=(char)pVar->bArray;

		if(pVar->bArray){
			for(i4=0;;i4++){
				*(long *)(buffer+i2)=pVar->SubScripts[i4];
				i2+=sizeof(long);
				if(pVar->SubScripts[i4]==-1) break;
			}
		}

		//LVJXR[v
		*(long *)(buffer+i2)=pVar->ScopeStartAddress;
		i2+=sizeof(long);
		*(long *)(buffer+i2)=pVar->ScopeEndAddress;
		i2+=sizeof(long);
		*(long *)(buffer+i2)=pVar->ScopeLevel;
		i2+=sizeof(long);

		//ʒu
		*(long *)(buffer+i2)=pVar->offset;
		i2+=sizeof(long);

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}

	//O[os̈̃TCY
	extern int GlobalOpBufferSize;
	*(long *)(buffer+i2)=GlobalOpBufferSize;
	i2+=sizeof(long);

	//vV[W
	extern SUBINFO **ppSubHash;
	extern int SubNum;
	SUBINFO *psi;
	*(long *)(buffer+i2)=SubNum;
	i2+=sizeof(long);
	for(i3=0;i3<MAX_HASH;i3++){
		psi=ppSubHash[i3];
		while(psi){
			if(psi->pobj_ParentClass){
				lstrcpy(buffer+i2,psi->pobj_ParentClass->name);
				i2+=lstrlen(buffer+i2)+1;
			}
			else{
				lstrcpy(buffer+i2,"");
				i2+=lstrlen(buffer+i2)+1;
			}

			//ID
			*(long *)(buffer+i2)=psi->id;
			i2+=sizeof(long);

			//֐
			lstrcpy(buffer+i2,psi->name);
			i2+=lstrlen(buffer+i2)+1;

			*(long *)(buffer+i2)=psi->CompileAddress;
			i2+=sizeof(long);
			*(long *)(buffer+i2)=psi->EndOpAddr;
			i2+=sizeof(long);

			*(long *)(buffer+i2)=psi->bVirtual;
			i2+=sizeof(long);

			//[Jϐ
			*(long *)(buffer+i2)=psi->VarNum;
			i2+=sizeof(long);

			//obt@Ȃꍇ͍Ċm
			if(BufferSize<i2+32768){
				BufferSize+=32768;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
			}

			for(i4=0;i4<psi->VarNum;i4++){
				VARIABLE *pVar=&psi->pVar[i4];
				lstrcpy(buffer+i2,pVar->name);
				i2+=lstrlen(buffer+i2)+1;

				//^
				*(long *)(buffer+i2)=pVar->type;
				i2+=sizeof(long);

				//^̊g
				SetLpIndex_DebugFile(buffer,&i2,pVar->type,pVar->u.index);

				//Qƌ^p[^ǂ
				buffer[i2++]=(char)pVar->fRef;

				//z񂩂ǂ
				buffer[i2++]=(char)pVar->bArray;

				//zvf
				if(pVar->bArray){
					for(i5=0;;i5++){
						*(long *)(buffer+i2)=pVar->SubScripts[i5];
						i2+=sizeof(long);
						if(pVar->SubScripts[i5]==-1) break;
					}
				}
				else pVar->SubScripts[0]=-1;

				//LVJXR[v
				*(long *)(buffer+i2)=pVar->ScopeStartAddress;
				i2+=sizeof(long);
				*(long *)(buffer+i2)=pVar->ScopeEndAddress;
				i2+=sizeof(long);
				*(long *)(buffer+i2)=pVar->ScopeLevel;
				i2+=sizeof(long);

				//ʒu
				*(long *)(buffer+i2)=pVar->offset;
				i2+=sizeof(long);




				//obt@Ȃꍇ͍Ċm
				if(BufferSize<i2+32768){
					BufferSize+=32768;
					buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
				}
			}

			psi=psi->pNextData;
		}
	}



	///////////////////
	// NX
	///////////////////

	//Ce[^Zbg
	pobj_DBClass->Iterator_Reset();

	while(pobj_DBClass->Iterator_HasNext()){
		CClass *pobj_c;
		pobj_c=pobj_DBClass->Iterator_GetNext();


		//NX
		lstrcpy(buffer+i2,pobj_c->name);
		i2+=lstrlen(buffer+i2)+1;

		//z֐̐
		*(long *)(buffer+i2)=pobj_c->vtbl_num;
		i2+=sizeof(long);

		//ACg
		*(long *)(buffer+i2)=pobj_c->iAlign;
		i2+=sizeof(long);

		//o
		*(long *)(buffer+i2)=pobj_c->iMemberNum;
		i2+=sizeof(long);
		for(i4=0;i4<pobj_c->iMemberNum;i4++){
			lstrcpy(buffer+i2,pobj_c->ppobj_Member[i4]->name);
			i2+=lstrlen(buffer+i2)+1;

			memcpy(buffer+i2,pobj_c->ppobj_Member[i4]->SubScripts,sizeof(int)*MAX_ARRAYDIM);
			i2+=sizeof(int)*MAX_ARRAYDIM;

			//^
			*(long *)(buffer+i2)=pobj_c->ppobj_Member[i4]->TypeInfo.type;
			i2+=sizeof(long);

			//^̊g
			SetLpIndex_DebugFile(buffer,&i2,pobj_c->ppobj_Member[i4]->TypeInfo.type,pobj_c->ppobj_Member[i4]->TypeInfo.u.lpIndex);

			*(long *)(buffer+i2)=pobj_c->ppobj_Member[i4]->dwAccess;
			i2+=sizeof(long);

			//obt@Ȃꍇ͍Ċm
			if(BufferSize<i2+32768){
				BufferSize+=32768;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
			}
		}

		//\bh
		*(long *)(buffer+i2)=pobj_c->iMethodNum;
		i2+=sizeof(long);
		for(i4=0;i4<pobj_c->iMethodNum;i4++){
			*(long *)(buffer+i2)=pobj_c->ppobj_Method[i4]->dwAccess;
			i2+=sizeof(long);
			if(pobj_c->ppobj_Method[i4]->pobj_InheritsClass){
				lstrcpy(buffer+i2,pobj_c->ppobj_Method[i4]->pobj_InheritsClass->name);
				i2+=lstrlen(buffer+i2)+1;
			}
			else{
				lstrcpy(buffer+i2,"");
				i2+=lstrlen(buffer+i2)+1;
			}
			lstrcpy(buffer+i2,pobj_c->ppobj_Method[i4]->psi->name);
			i2+=lstrlen(buffer+i2)+1;
		}

		//ÓIo
		*(long *)(buffer+i2)=pobj_c->iStaticMemberNum;
		i2+=sizeof(long);
		for(i4=0;i4<pobj_c->iStaticMemberNum;i4++){
			lstrcpy(buffer+i2,pobj_c->ppobj_StaticMember[i4]->name);
			i2+=lstrlen(buffer+i2)+1;

			memcpy(buffer+i2,pobj_c->ppobj_StaticMember[i4]->SubScripts,sizeof(int)*MAX_ARRAYDIM);
			i2+=sizeof(int)*MAX_ARRAYDIM;

			//^
			*(long *)(buffer+i2)=pobj_c->ppobj_StaticMember[i4]->TypeInfo.type;
			i2+=sizeof(long);

			//^̊g
			SetLpIndex_DebugFile(buffer,&i2,pobj_c->ppobj_StaticMember[i4]->TypeInfo.type,pobj_c->ppobj_StaticMember[i4]->TypeInfo.u.lpIndex);

			*(long *)(buffer+i2)=pobj_c->ppobj_StaticMember[i4]->dwAccess;
			i2+=sizeof(long);

			//obt@Ȃꍇ͍Ċm
			if(BufferSize<i2+32768){
				BufferSize+=32768;
				buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
			}
		}

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}

	length=i2;
}

char *CDebugSection::MakeSingleStepCode(void){
	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,SizeOf_CodeSection);

	memcpy(buffer,OpBuffer,SizeOf_CodeSection);

	int i2;
	for(i2=0;i2<MaxLineInfoNum;i2++){
		if(!(
			pLineInfo[i2].dwCodeType&CODETYPE_SYSTEMPROC||
			pLineInfo[i2].dwCodeType&CODETYPE_DEBUGPROC
			)){
			//int 3
			buffer[pLineInfo[i2].TopObp]=(char)0xCC;
		}
	}

	return buffer;
}
BOOL CDebugSection::__load(void){
	int i2,i3,i4,i5,num;
	char temp2[MAX_PATH],*temp5;

	i2=0;

	//fobOpt@C̃o[W`FbN
	if(*(long *)(buffer+i2)<MDLFILE_VER){
		HeapDefaultFree(buffer);
		return 0;
	}
	i2+=sizeof(long);

	//vbgtH[̃rbg`FbN
	if(*(long *)(buffer+i2)!=PLATFORM){
		HeapDefaultFree(buffer);
		return 0;
	}
	i2+=sizeof(long);

	//CN[h
	IncludeFileInfo.FilesNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	IncludeFileInfo.ppFileNames=(char **)HeapAlloc(hHeap,0,IncludeFileInfo.FilesNum*sizeof(char *));
	for(i3=0;i3<IncludeFileInfo.FilesNum;i3++){
		if(buffer[i2]=='\0') break;
		IncludeFileInfo.ppFileNames[i3]=(char *)HeapAlloc(hHeap,0,lstrlen(buffer+i2)+1);
		lstrcpy(IncludeFileInfo.ppFileNames[i3],buffer+i2);
		i2+=lstrlen(buffer+i2)+1;
	}
	for(i2++,i3=0;;i2++,i3++){
		IncludeFileInfo.LineOfFile[i3]=(long)buffer[i2];
		if(IncludeFileInfo.LineOfFile[i3]==-1) break;
	}

	//\[XR[h
	i2++;
	pBaseBuffer=(char *)HeapAlloc(hHeap,0,lstrlen(buffer+i2)+3);
	basbuf=pBaseBuffer+2;
	lstrcpy(basbuf,buffer+i2);
	i2+=lstrlen(buffer+i2)+1;
	extern char *basbuf;
	basbuf=this->basbuf;

	//R[hƍsԍ̊֌W
	MaxLineInfoNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	pLineInfo=(LINEINFO *)HeapAlloc(hHeap,0,MaxLineInfoNum*sizeof(LINEINFO)+1);
	memcpy(pLineInfo,buffer+i2,MaxLineInfoNum*sizeof(LINEINFO));
	i2+=MaxLineInfoNum*sizeof(LINEINFO);


	///////////////////////////////////////////
	// NXiÔ݁Bڍׂ͌Ŏ擾j
	///////////////////////////////////////////

	this->pobj_DBClass=new CDBClass();

	int iMaxClassCount;
	iMaxClassCount=*(long *)(buffer+i2);
	i2+=sizeof(long);
	for(i3=0;i3<iMaxClassCount;i3++){
		//NX
		pobj_DBClass->AddClass(buffer+i2,0);
		i2+=lstrlen(buffer+i2)+1;
	}

	extern CDBClass *pobj_DBClass;
	pobj_DBClass=this->pobj_DBClass;


	//////////////////
	// TypeDef
	//////////////////

	//
	pobj_DBTypeDef=new CDBTypeDef;

	//擾
	num=*(long *)(buffer+i2);
	i2+=sizeof(long);
	for(i3=0;i3<num;i3++){
		temp5=buffer+i2;
		i2+=lstrlen(buffer+i2)+1;

		pobj_DBTypeDef->add(temp5,buffer+i2);

		i2+=lstrlen(buffer+i2)+1;
	}

	extern CDBTypeDef *pobj_DBTypeDef;
	pobj_DBTypeDef=this->pobj_DBTypeDef;

	//萔擾
	GetConstInfo();
	extern CONSTINFO **ppConstHash;
	this->ppConstHash=ppConstHash;


	//O[oϐ
	MaxGlobalVarNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	GlobalVar=(VARIABLE *)HeapAlloc(hHeap,0,MaxGlobalVarNum*sizeof(VARIABLE)+1);
	for(i3=0;i3<MaxGlobalVarNum;i3++){
		VARIABLE *pVar=&GlobalVar[i3];

		//ϐ
		lstrcpy(pVar->name,buffer+i2);
		i2+=lstrlen(buffer+i2)+1;

		pVar->type=*(long *)(buffer+i2);
		i2+=sizeof(long);

		GetLpIndex_DebugFile(buffer,&i2,pVar->type,&pVar->u.index);

		pVar->fRef=(long)buffer[i2++];

		pVar->bArray=(long)buffer[i2++];
		if(pVar->bArray){
			for(i4=0;;i4++){
				pVar->SubScripts[i4]=*(long *)(buffer+i2);
				i2+=sizeof(long);

				if(pVar->SubScripts[i4]==-1) break;
			}
		}

		//LVJXR[v
		pVar->ScopeStartAddress=*(long *)(buffer+i2);
		i2+=sizeof(long);
		pVar->ScopeEndAddress=*(long *)(buffer+i2);
		i2+=sizeof(long);
		pVar->ScopeLevel=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//ʒu
		pVar->offset=*(long *)(buffer+i2);
		i2+=sizeof(long);
	}

	//O[os̈̃TCY
	GlobalOpBufferSize=*(long *)(buffer+i2);
	i2+=sizeof(long);

	//vV[W
	SUBINFO *psi;
	SubNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	ppSubHash=(SUBINFO **)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,MAX_HASH*sizeof(SUBINFO *));
	for(i3=0;i3<SubNum;i3++){
		psi=(SUBINFO *)HeapAlloc(hHeap,0,sizeof(SUBINFO));
		psi->pNextData=0;

		char szParentClassName[VN_SIZE];
		lstrcpy(szParentClassName,buffer+i2);
		i2+=lstrlen(buffer+i2)+1;

		if(szParentClassName[0])
			psi->pobj_ParentClass=pobj_DBClass->check(szParentClassName);
		else psi->pobj_ParentClass=0;

		//ID
		psi->id=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//O
		psi->name=(char *)HeapAlloc(hHeap,0,lstrlen(buffer+i2)+1);
		lstrcpy(psi->name,buffer+i2);
		i2+=lstrlen(buffer+i2)+1;

		psi->CompileAddress=*(long *)(buffer+i2);
		i2+=sizeof(long);
		psi->EndOpAddr=*(long *)(buffer+i2);
		i2+=sizeof(long);

		psi->bVirtual=*(long *)(buffer+i2);
		i2+=sizeof(long);

		psi->ParmNum=0;
		psi->pParmInfo=0;
		psi->RealParmNum=0;
		psi->pRealParmInfo=0;
		psi->bCompile=1;

		//[Jϐ
		psi->VarNum=*(long *)(buffer+i2);
		i2+=sizeof(long);
		psi->pVar=(VARIABLE *)HeapAlloc(hHeap,0,psi->VarNum*sizeof(VARIABLE)+1);
		for(i4=0;i4<psi->VarNum;i4++){
			VARIABLE *pVar=&psi->pVar[i4];

			//[Jϐ
			lstrcpy(pVar->name,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			//^
			pVar->type=*(long *)(buffer+i2);
			i2+=sizeof(long);

			//^̊g
			GetLpIndex_DebugFile(buffer,&i2,pVar->type,&pVar->u.index);

			//Qƌ^p[^ǂ
			pVar->fRef=(long)buffer[i2++];

			//z񂩂ǂ
			pVar->bArray=(long)buffer[i2++];
			if(pVar->bArray){
				for(i5=0;;i5++){
					//zvf
					pVar->SubScripts[i5]=*(long *)(buffer+i2);
					i2+=sizeof(long);

					if(pVar->SubScripts[i5]==-1) break;
				}
			}

			//LVJXR[v
			pVar->ScopeStartAddress=*(long *)(buffer+i2);
			i2+=sizeof(long);
			pVar->ScopeEndAddress=*(long *)(buffer+i2);
			i2+=sizeof(long);
			pVar->ScopeLevel=*(long *)(buffer+i2);
			i2+=sizeof(long);

			//̈ʒu
			pVar->offset=*(long *)(buffer+i2);
			i2+=sizeof(long);
		}


		/////////////////////////////////
		// i[ʒuvZpsiZbg
		/////////////////////////////////

		i4=hash_default(psi->name);

		SUBINFO *psi2;
		if(ppSubHash[i4]){
			psi2=ppSubHash[i4];
			while(1){
				if(psi2->pNextData==0){
					psi2->pNextData=psi;
					break;
				}
				psi2=psi2->pNextData;
			}
		}
		else{
			ppSubHash[i4]=psi;
		}
	}

	//NX
	CClass *pobj_c;
	for(i3=0;i3<iMaxClassCount;i3++){
		//NX
		char szClassName[VN_SIZE];
		lstrcpy(szClassName,buffer+i2);
		i2+=lstrlen(buffer+i2)+1;

		pobj_c=pobj_DBClass->check(szClassName);

		//z֐̐
		pobj_c->vtbl_num=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//ACg
		pobj_c->iAlign=*(long *)(buffer+i2);
		i2+=sizeof(long);

		//o
		pobj_c->iMemberNum=*(long *)(buffer+i2);
		i2+=sizeof(long);
		pobj_c->ppobj_Member=
			(CMember **)HeapAlloc(hHeap,0,pobj_c->iMemberNum*sizeof(CMember *));
		for(i4=0;i4<pobj_c->iMemberNum;i4++){
			pobj_c->ppobj_Member[i4]=new CMember();

			pobj_c->ppobj_Member[i4]->name=(char *)HeapAlloc(hHeap,0,lstrlen(buffer+i2)+1);
			lstrcpy(pobj_c->ppobj_Member[i4]->name,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			memcpy(pobj_c->ppobj_Member[i4]->SubScripts,buffer+i2,sizeof(int)*MAX_ARRAYDIM);
			i2+=sizeof(int)*MAX_ARRAYDIM;

			//^
			pobj_c->ppobj_Member[i4]->TypeInfo.type=*(long *)(buffer+i2);
			i2+=sizeof(long);

			//^̊g
			GetLpIndex_DebugFile(buffer,&i2,pobj_c->ppobj_Member[i4]->TypeInfo.type,&pobj_c->ppobj_Member[i4]->TypeInfo.u.lpIndex);

			pobj_c->ppobj_Member[i4]->dwAccess=*(long *)(buffer+i2);
			i2+=sizeof(long);
		}

		//\bh
		pobj_c->iMethodNum=*(long *)(buffer+i2);
		i2+=sizeof(long);
		pobj_c->ppobj_Method=
			(CMethod **)HeapAlloc(hHeap,0,pobj_c->iMethodNum*sizeof(CMethod *));
		for(i4=0;i4<pobj_c->iMethodNum;i4++){
			pobj_c->ppobj_Method[i4]=new CMethod();

			pobj_c->ppobj_Method[i4]->dwAccess=*(long *)(buffer+i2);
			i2+=sizeof(long);

			char szInherits[VN_SIZE];
			lstrcpy(szInherits,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			if(szInherits[0])
				pobj_c->ppobj_Method[i4]->pobj_InheritsClass=pobj_DBClass->check(szInherits);
			else pobj_c->ppobj_Method[i4]->pobj_InheritsClass=0;

			lstrcpy(temp2,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			CClass *pobj_temp_c;
			pobj_temp_c=pobj_c->ppobj_Method[i4]->pobj_InheritsClass;
			if(pobj_temp_c==0) pobj_temp_c=pobj_c;
			i5=hash_default(temp2);
			psi=ppSubHash[i5];
			while(1){
				if(lstrcmp(psi->name,temp2)==0&&psi->pobj_ParentClass==pobj_temp_c) break;
				psi=psi->pNextData;
			}
			pobj_c->ppobj_Method[i4]->psi=psi;
		}

		//ÓIo
		pobj_c->iStaticMemberNum=*(long *)(buffer+i2);
		i2+=sizeof(long);
		pobj_c->ppobj_StaticMember=
			(CMember **)HeapAlloc(hHeap,0,pobj_c->iStaticMemberNum*sizeof(CMember *));
		for(i4=0;i4<pobj_c->iStaticMemberNum;i4++){
			pobj_c->ppobj_StaticMember[i4]=new CMember();

			pobj_c->ppobj_StaticMember[i4]->name=(char *)HeapAlloc(hHeap,0,lstrlen(buffer+i2)+1);
			lstrcpy(pobj_c->ppobj_StaticMember[i4]->name,buffer+i2);
			i2+=lstrlen(buffer+i2)+1;

			memcpy(pobj_c->ppobj_StaticMember[i4]->SubScripts,buffer+i2,sizeof(int)*MAX_ARRAYDIM);
			i2+=sizeof(int)*MAX_ARRAYDIM;

			//^
			pobj_c->ppobj_StaticMember[i4]->TypeInfo.type=*(long *)(buffer+i2);
			i2+=sizeof(long);

			//^̊g
			GetLpIndex_DebugFile(buffer,&i2,pobj_c->ppobj_StaticMember[i4]->TypeInfo.type,&pobj_c->ppobj_StaticMember[i4]->TypeInfo.u.lpIndex);

			pobj_c->ppobj_StaticMember[i4]->dwAccess=*(long *)(buffer+i2);
			i2+=sizeof(long);
		}
	}

	HeapDefaultFree(buffer);
	buffer=0;




	extern SUBINFO **ppSubHash;
	ppSubHash=this->ppSubHash;
	pSub_DebugSys_EndProc=GetSubHash("_DebugSys_EndProc");


	SingleStepCodeBuffer=MakeSingleStepCode();


	/////////////////////////////
	// u[N|CgKp
	/////////////////////////////

	//CN[h
	extern INCLUDEFILEINFO IncludeFileInfo;
	IncludeFileInfo=this->IncludeFileInfo;

	//R[hƍsԍ̊֌W
	extern int MaxLineInfoNum;
	extern LINEINFO *pLineInfo;
	MaxLineInfoNum=this->MaxLineInfoNum;
	pLineInfo=this->pLineInfo;

	BreakStepCodeBuffer=pobj_DBBreakPoint->update(OpBuffer,SizeOf_CodeSection);

	//vZXɃRs[
	extern HANDLE hDebugProcess;
	SIZE_T stAccBytes;
	WriteProcessMemory(hDebugProcess,(void *)(ULONG_PTR)(dwImageBase+dwRVA_CodeSection),
		BreakStepCodeBuffer,
		SizeOf_CodeSection,&stAccBytes);


	return 1;
}

BOOL CDebugSection::load(HMODULE hModule){
	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}


	extern HANDLE hDebugProcess;
	SIZE_T stAccBytes;
	IMAGE_DOS_HEADER ImageDosHeader;
	ReadProcessMemory(hDebugProcess,hModule,&ImageDosHeader,sizeof(IMAGE_DOS_HEADER),&stAccBytes);

	int pe_size;
#ifdef _AMD64_
	IMAGE_NT_HEADERS64 pe_hdr;
	pe_size=sizeof(IMAGE_NT_HEADERS64);
#else
	IMAGE_NT_HEADERS pe_hdr;
	pe_size=sizeof(IMAGE_NT_HEADERS);
#endif
	ReadProcessMemory(hDebugProcess,(void *)(((ULONG_PTR)hModule)+ImageDosHeader.e_lfanew),&pe_hdr,pe_size,&stAccBytes);

	IMAGE_SECTION_HEADER *pSectionHdr;
	pSectionHdr=(IMAGE_SECTION_HEADER *)HeapAlloc(hHeap,0,pe_hdr.FileHeader.NumberOfSections*sizeof(IMAGE_SECTION_HEADER));
	ReadProcessMemory(hDebugProcess,
		(void *)(((ULONG_PTR)hModule)+ImageDosHeader.e_lfanew+pe_size),
		pSectionHdr,
		pe_hdr.FileHeader.NumberOfSections*sizeof(IMAGE_SECTION_HEADER),
		&stAccBytes);

	int i;
	for(i=0;i<pe_hdr.FileHeader.NumberOfSections;i++){

		//C^uZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".data")==0){
			dwRVA_RWSection=pSectionHdr[i].VirtualAddress;
		}

		//R[hZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".text")==0){
			dwRVA_CodeSection=pSectionHdr[i].VirtualAddress;
			SizeOf_CodeSection=pSectionHdr[i].SizeOfRawData;
		}

		//fobOZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".debug")==0){
			length=pSectionHdr[i].Misc.VirtualSize;
			buffer=(char *)HeapAlloc(hHeap,0,length+1);

			ReadProcessMemory(hDebugProcess,
				(void *)(((ULONG_PTR)hModule)+pSectionHdr[i].VirtualAddress),
				buffer,
				length,
				&stAccBytes);
			buffer[length]=0;
		}

	}
	HeapDefaultFree(pSectionHdr);

	if(!buffer) return 0;


	dwImageBase=(DWORD)(ULONG_PTR)hModule;



	if(OpBuffer) HeapDefaultFree(OpBuffer);
	OpBuffer=(char *)HeapAlloc(hHeap,0,SizeOf_CodeSection);

	ReadProcessMemory(hDebugProcess,
		(void *)(ULONG_PTR)(dwImageBase+dwRVA_CodeSection),OpBuffer,
		SizeOf_CodeSection,&stAccBytes);


	return __load();
}

void CDebugSection::choice(void){
	//C[Wx[X
	extern DWORD ImageBase;
	ImageBase=this->dwImageBase;

	//C^uZNVRVA
	extern int MemPos_RWSection;
	MemPos_RWSection=this->dwRVA_RWSection;

	//R[hZNVRVAƃTCY
	extern int MemPos_CodeSection;
	extern int FileSize_CodeSection;
	MemPos_CodeSection=this->dwRVA_CodeSection;
	FileSize_CodeSection=this->SizeOf_CodeSection;

	//CN[h
	extern INCLUDEFILEINFO IncludeFileInfo;
	IncludeFileInfo=this->IncludeFileInfo;

	//\[XR[h
	extern char *pBaseBuffer;
	extern char *basbuf;
	pBaseBuffer=this->pBaseBuffer;
	basbuf=this->basbuf;

	//R[hƍsԍ̊֌W
	extern int MaxLineInfoNum;
	extern LINEINFO *pLineInfo;
	MaxLineInfoNum=this->MaxLineInfoNum;
	pLineInfo=this->pLineInfo;

	// NX
	extern CDBClass *pobj_DBClass;
	pobj_DBClass=this->pobj_DBClass;

	// TypeDef
	extern CDBTypeDef *pobj_DBTypeDef;
	pobj_DBTypeDef=this->pobj_DBTypeDef;

	//萔擾
	extern CONSTINFO **ppConstHash;
	ppConstHash=this->ppConstHash;

	//O[oϐɊւ
	extern VARIABLE *GlobalVar;
	extern int MaxGlobalVarNum;
	GlobalVar=this->GlobalVar;
	MaxGlobalVarNum=this->MaxGlobalVarNum;

	//O[os̈̃TCY
	extern int GlobalOpBufferSize;
	GlobalOpBufferSize=this->GlobalOpBufferSize;

	//vV[W
	extern char **ppMacroNames;
	ppMacroNames=0;
	extern SUBINFO **ppSubHash;
	extern int SubNum;
	ppSubHash=this->ppSubHash;
	SubNum=this->SubNum;

	extern SUBINFO *pSub_DebugSys_EndProc;
	pSub_DebugSys_EndProc=this->pSub_DebugSys_EndProc;

	//lCeBuR[hobt@
	extern char *OpBuffer;
	OpBuffer=this->OpBuffer;
}

void CDebugSection::DeleteDebugInfo(void){
	int i2;

	//CN[h
	for(i2=0;i2<IncludeFileInfo.FilesNum;i2++)
		HeapDefaultFree(IncludeFileInfo.ppFileNames[i2]);
	HeapDefaultFree(IncludeFileInfo.ppFileNames);

	//O[oϐɊւ
	HeapDefaultFree(GlobalVar);

	//[JϐɊւ
	SUBINFO *psi;
	for(i2=0;i2<MAX_HASH;i2++){
		psi=ppSubHash[i2];
		while(psi){
			if(psi->bCompile)
				HeapDefaultFree(psi->pVar);

			psi=psi->pNextData;
		}
	}

	//NXɊւ郁
	delete pobj_DBClass;
	pobj_DBClass=0;

	//Tu[`̃
	DeleteSubInfo(ppSubHash,0,0);

	//萔Ɋւ
	DeleteConstInfo(ppConstHash);

	//\[XR[h
	HeapDefaultFree(pBaseBuffer);

	//R[hƍsԍ̊֌W
	HeapDefaultFree(pLineInfo);

	//R[hobt@
	HeapDefaultFree(OpBuffer);
	OpBuffer=0;

	HeapDefaultFree(SingleStepCodeBuffer);
	SingleStepCodeBuffer=0;

	HeapDefaultFree(BreakStepCodeBuffer);
	BreakStepCodeBuffer=0;
}



CDBDebugSection::CDBDebugSection(){
	ppobj_ds=(CDebugSection **)HeapAlloc(hHeap,0,1);
	num=0;
}
CDBDebugSection::~CDBDebugSection(){
	int i;
	for(i=0;i<num;i++){
		delete ppobj_ds[i];
	}
	HeapDefaultFree(ppobj_ds);
}

BOOL CDBDebugSection::add(HMODULE hModule){
	CDebugSection *pobj_d;
	pobj_d=new CDebugSection();
	if(!pobj_d->load(hModule)){
		//fobO񂪑݂ȂƂ
		delete pobj_d;
		return 0;
	}

	ppobj_ds=(CDebugSection **)HeapReAlloc(hHeap,0,ppobj_ds,(num+1)*sizeof(CDebugSection *));
	ppobj_ds[num]=pobj_d;
	num++;

	return 1;
}

void CDBDebugSection::del(HMODULE hModule){
	int i;
	for(i=0;i<num;i++){
		if((HMODULE)(ULONG_PTR)ppobj_ds[i]->dwImageBase==hModule){
			delete ppobj_ds[i];

			num--;
			for(;i<num;i++){
				ppobj_ds[i]=ppobj_ds[i+1];
			}
			break;
		}
	}
}

void CDBDebugSection::choice(int index){
	pobj_now=ppobj_ds[index];
	pobj_now->choice();
}



CDBDebugSection *pobj_DBDebugSection;
